/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;

public class OperationDisNameUtil {
    public static synchronized String getDisplayableOperationType(int operationType, IDeviceTypeConfigModel oDeviceXMLConfigModel) {
        String strOperation = "";
        if (operationType > 51) {
            strOperation = ResourceManager.getInstance().getResString("LOG_INFO_UNKNOWN");
        } else {
            switch (operationType) {
                case 8: {
                    strOperation = OperationDisNameUtil.getOpDisName(8, 6, 1, oDeviceXMLConfigModel);
                    break;
                }
                case 6: {
                    strOperation = OperationDisNameUtil.getOpDisName(6, 7, 1, oDeviceXMLConfigModel);
                    break;
                }
                case 16: {
                    strOperation = OperationDisNameUtil.getOpDisName(16, 5, 1, oDeviceXMLConfigModel);
                    break;
                }
                case 7: {
                    strOperation = OperationDisNameUtil.getOpDisName(7, 9, 1, oDeviceXMLConfigModel);
                    break;
                }
                case 20: {
                    strOperation = OperationDisNameUtil.getOpDisName(20, 18, 1, oDeviceXMLConfigModel);
                    break;
                }
                case 21: {
                    strOperation = OperationDisNameUtil.getOpDisName(21, 19, 1, oDeviceXMLConfigModel);
                    break;
                }
                case -2: {
                    strOperation = "";
                    break;
                }
                default: {
                    strOperation = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + operationType);
                }
            }
        }
        return strOperation;
    }

    private static String getOpDisName(int iLogOPId, int iTaskOpId, int iOpType, IDeviceTypeConfigModel oDeviceXMLConfigModel) {
        String strOpDisplayName = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + iLogOPId);
        if (null != oDeviceXMLConfigModel) {
            IOperation operationObj = null;
            switch (iOpType) {
                case 1: {
                    operationObj = oDeviceXMLConfigModel.getOperationObj(1, iTaskOpId);
                    break;
                }
                case 0: {
                    operationObj = oDeviceXMLConfigModel.getOperationObj(0, iTaskOpId);
                    break;
                }
                case 2: {
                    operationObj = oDeviceXMLConfigModel.getOperationObj(2, iTaskOpId);
                    break;
                }
                case 3: {
                    operationObj = oDeviceXMLConfigModel.getCheckOperObj(iTaskOpId);
                    break;
                }
                case 5: {
                    operationObj = oDeviceXMLConfigModel.getOperationObj(5, iTaskOpId);
                    break;
                }
                default: {
                    DCDebugTracer.trace("switch ( iOpType )");
                }
            }
            if (null != operationObj) {
                strOpDisplayName = operationObj.getOperationName();
            }
        }
        return strOpDisplayName;
    }
}

