/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility;

import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.OperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.OtherOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.ActivationDataBaseOperation;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualBackupOperation;
import com.huawei.dc.devicemanagement.deviceoperation.backup.TaskBackupOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckOperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PostcheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PrecheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.commit.CommitOperation;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.CustomOperationInfo;
import com.huawei.dc.devicemanagement.deviceoperation.deletedb.DeleteDBOperation;
import com.huawei.dc.devicemanagement.deviceoperation.dispense.DispenseOperation;
import com.huawei.dc.devicemanagement.deviceoperation.issucheck.TaskISSUCheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loaddata.LoadDataOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.deviceoperation.patchoperation.DeactivateOperation;
import com.huawei.dc.devicemanagement.deviceoperation.patchoperation.PatchActivateOperation;
import com.huawei.dc.devicemanagement.deviceoperation.patchoperation.PatchConfirmOperation;
import com.huawei.dc.devicemanagement.deviceoperation.patchoperation.PatchDeleteOperation;
import com.huawei.dc.devicemanagement.deviceoperation.patchoperation.PatchOperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.patchoperation.PatchUnloadOperation;
import com.huawei.dc.devicemanagement.deviceoperation.patchoperation.PatchUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RecoverOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBOperation;
import com.huawei.dc.devicemanagement.deviceoperation.save.ManualSaveOperation;
import com.huawei.dc.devicemanagement.deviceoperation.save.TaskSaveOperation;
import com.huawei.dc.devicemanagement.deviceoperation.updatedata.UpdateDataOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradefeasibility.UpgradeFeasibilityOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PostUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeswitch.SetWorkModeOperation;

public class DeviceOpViewFactory {
    public static IOperation createOperationObj(int iOperationType, int iOperationID) {
        IOperation oOpInstance = null;
        switch (iOperationType) {
            case 0: {
                oOpInstance = DeviceOpViewFactory.getDeviceOperation(iOperationID);
                break;
            }
            case 1: {
                oOpInstance = DeviceOpViewFactory.getTaskOperation(iOperationID);
                break;
            }
            case 5: {
                oOpInstance = DeviceOpViewFactory.getOtherOperation(iOperationID);
                break;
            }
            case 2: {
                oOpInstance = DeviceOpViewFactory.getPatchOperation(iOperationID);
                break;
            }
            case 4: {
                oOpInstance = DeviceOpViewFactory.getCustomOperation(iOperationID);
                break;
            }
            case 6: {
                oOpInstance = DeviceOpViewFactory.getUpgradeOperation(iOperationID);
                break;
            }
        }
        return oOpInstance;
    }

    private static IOperation getUpgradeOperation(int iOperationID) {
        IUpgradeOperation oTaskOpInstance = null;
        switch (iOperationID) {
            case 32: {
                oTaskOpInstance = new PrepareUpgradeOperation();
                break;
            }
            case 33: {
                oTaskOpInstance = new PostUpgradeOperation();
                break;
            }
            default: {
                oTaskOpInstance = null;
            }
        }
        return oTaskOpInstance;
    }

    public static IOperation getCheckOperation(int iOperationID) {
        CheckOperationAdapter oTaskOpInstance = null;
        switch (iOperationID) {
            case 4: {
                oTaskOpInstance = new PrecheckOperation();
                break;
            }
            case 16: {
                oTaskOpInstance = new PostcheckOperation();
                break;
            }
            default: {
                oTaskOpInstance = null;
            }
        }
        return oTaskOpInstance;
    }

    private static IOperation getPatchOperation(int iOperationId) {
        PatchOperationAdapter oPatchOpInstance = null;
        switch (iOperationId) {
            case 10: {
                oPatchOpInstance = new PatchActivateOperation();
                break;
            }
            case 14: {
                oPatchOpInstance = new DeactivateOperation();
                break;
            }
            case 11: {
                oPatchOpInstance = new PatchConfirmOperation();
                break;
            }
            case 15: {
                oPatchOpInstance = new PatchDeleteOperation();
                break;
            }
        }
        return oPatchOpInstance;
    }

    private static IOperation getTaskOperation(int iOperationID) {
        OperationAdapter oTaskOpInstance = null;
        switch (iOperationID) {
            case 1: {
                oTaskOpInstance = new TaskSaveOperation();
                break;
            }
            case 2: {
                oTaskOpInstance = new TaskBackupOperation();
                break;
            }
            case 5: {
                oTaskOpInstance = new UpdateDataOperation();
                break;
            }
            case 6: {
                oTaskOpInstance = new LoadSoftwareOperation();
                break;
            }
            case 7: {
                oTaskOpInstance = new LoadDataOperation();
                break;
            }
            case 8: {
                oTaskOpInstance = new ActivationOperation();
                break;
            }
            case 9: {
                oTaskOpInstance = new LoadPatchOperation();
                break;
            }
            case 18: {
                oTaskOpInstance = new DispenseOperation();
                break;
            }
            case 19: {
                oTaskOpInstance = new CommitOperation();
                break;
            }
            case 22: {
                oTaskOpInstance = new SetWorkModeOperation();
                break;
            }
            case 23: {
                oTaskOpInstance = new LoadDataOperation();
                break;
            }
            case 28: {
                oTaskOpInstance = new UpgradeFeasibilityOperation();
                break;
            }
            case 29: {
                TaskISSUCheckOperation check = new TaskISSUCheckOperation();
                check.setEnabled(false);
                oTaskOpInstance = check;
                break;
            }
            case 30: {
                oTaskOpInstance = new DeleteDBOperation();
                break;
            }
            case 3: {
                oTaskOpInstance = new RecoverDBOperation();
                break;
            }
            case 44: {
                oTaskOpInstance = new PatchUnloadOperation();
                break;
            }
            case 45: {
                oTaskOpInstance = new PatchUpgradeOperation();
                break;
            }
            default: {
                oTaskOpInstance = null;
            }
        }
        return oTaskOpInstance;
    }

    private static IOperation getDeviceOperation(int iOperationID) {
        OperationAdapter oDeviceOpInstance = null;
        switch (iOperationID) {
            case 1: {
                oDeviceOpInstance = new ManualSaveOperation();
                break;
            }
            case 2: {
                oDeviceOpInstance = new ManualBackupOperation();
                break;
            }
            case 3: {
                oDeviceOpInstance = new RecoverOperation();
                break;
            }
            case 20: {
                oDeviceOpInstance = new ActivationDataBaseOperation();
                break;
            }
        }
        return oDeviceOpInstance;
    }

    private static IOperation getOtherOperation(int iOperationID) {
        return new OtherOperation();
    }

    private static IOperation getCustomOperation(int iOperationID) {
        CustomOperationInfo customOperationInfo = new CustomOperationInfo();
        customOperationInfo.setOperationId(iOperationID);
        return customOperationInfo;
    }
}

