/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.IDCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import java.util.ArrayList;
import java.util.List;

public final class DCObjectDestructor
implements IDCObjectDestructor,
IDCObjectDeallocator {
    private static IDCObjectDestructor m_oDCSingletonObjectDestructor = null;
    private List<IDCObjectDeallocator> m_oObjectList = new ArrayList<IDCObjectDeallocator>(32);

    private DCObjectDestructor() {
    }

    public static synchronized IDCObjectDestructor getInstance() {
        if (null == m_oDCSingletonObjectDestructor) {
            m_oDCSingletonObjectDestructor = new DCObjectDestructor();
        }
        return m_oDCSingletonObjectDestructor;
    }

    @Override
    public void setToNULL() {
        DCDebugTracer.traceWarning("[DC-EXIT] DCObjectDestructor#setToNULL start");
        int iSize = this.m_oObjectList.size();
        DCDebugTracer.traceWarning("[DC-EXIT] DCObjectDestructor#setToNULL iSize : " + iSize);
        int iCountHavingSetToNull = 0;
        for (int index = iSize - 1; index >= 0; --index) {
            try {
                IDCObjectDeallocator obj = this.m_oObjectList.get(index);
                if (obj instanceof IDCObjectDeallocator) {
                    DCDebugTracer.traceWarning("[DC-EXIT] DCObjectDestructor#setToNULL : " + obj.getClass().getName());
                    obj.setToNULL();
                    ++iCountHavingSetToNull;
                    continue;
                }
                DCDebugTracer.traceWarning("[DC-EXIT] obj is null");
                continue;
            }
            catch (Exception oException) {
                DCDebugTracer.trace(oException);
            }
        }
        DCDebugTracer.traceWarning("[DC-EXIT] DCObjectDestructor#setToNULL iCountHavingSetToNull : " + iCountHavingSetToNull);
        this.m_oObjectList.clear();
        DCDebugTracer.traceWarning("[DC-EXIT] DCObjectDestructor#setToNULL end..");
    }

    public static void setDestructorObjectToNull() {
        m_oDCSingletonObjectDestructor = null;
    }

    @Override
    public synchronized void addObjectForDestructor(IDCObjectDeallocator singletonObject) {
        DCDebugTracer.traceWarning("DCObjectDestructor#addObjectForDestructor start");
        if (null != singletonObject) {
            DCDebugTracer.traceWarning("DCObjectDestructor#addObjectForDestructor : " + singletonObject.getClass().getName());
            this.m_oObjectList.add(singletonObject);
        } else {
            DCDebugTracer.traceStack();
            DCDebugTracer.traceWarning("DCObjectDestructor#addObjectForDestructor singletonObject is null");
        }
        DCDebugTracer.traceWarning("DCObjectDestructor#addObjectForDestructor end..");
    }

    public synchronized void removeObjectForDestructor(IDCObjectDeallocator singletonObject) {
        DCDebugTracer.traceWarning("DCObjectDestructor#removeObjectForDestructor start");
        if (null != singletonObject && null != this.m_oObjectList && this.m_oObjectList.contains(singletonObject)) {
            DCDebugTracer.traceWarning("DCObjectDestructor#removeObjectForDestructor : " + singletonObject.getClass().getName());
            this.m_oObjectList.remove(singletonObject);
            singletonObject.setToNULL();
        }
        DCDebugTracer.traceWarning("DCObjectDestructor#removeObjectForDestructor end..");
    }
}

