/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.IOStreamClose;
import com.swimap.iview.util.DebugTracer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigurationInfo
implements IDCObjectDeallocator {
    private String m_strProductStyleDir;
    private String m_strAbsoluteBaseDirectory;
    private String m_strBaseDirectory;
    private String m_strLocaleBaseDirectory;
    private Locale m_oSystemLocale;
    private boolean m_bConfigFilesInJar = false;
    private static ConfigurationInfo m_oConfInfoInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationInfo() {
        String defaultStyledir;
        this.m_strProductStyleDir = defaultStyledir = "style/productstyle/";
        InputStream fileInputStream = null;
        try {
            String baseDirectory;
            File currentDir = new File(".");
            this.m_strAbsoluteBaseDirectory = baseDirectory = currentDir.getAbsolutePath();
            this.setIfConfigFilesExistInJar();
            DCDebugTracer.trace("Files loaded from jar: " + this.m_bConfigFilesInJar);
            if (!this.m_bConfigFilesInJar) {
                this.m_strProductStyleDir = baseDirectory + File.separator + this.m_strProductStyleDir;
            }
            this.m_oSystemLocale = Locale.getDefault();
            String language = this.m_oSystemLocale.getLanguage();
            String country = this.m_oSystemLocale.getCountry();
            DCDebugTracer.trace("DC:: locale = " + language + "_" + country);
            this.m_strBaseDirectory = this.m_strProductStyleDir + "conf/dc/";
            this.m_strLocaleBaseDirectory = this.m_strProductStyleDir + "locale/" + language + "_" + country + "/dc/";
            DCDebugTracer.trace("m_strBaseDirectory: " + this.m_strBaseDirectory);
            DCDebugTracer.trace("m_strAbsoluteBaseDirectory: " + this.m_strAbsoluteBaseDirectory);
            DCDebugTracer.trace("m_strProductStyleDir: " + this.m_strProductStyleDir);
        }
        catch (Exception ex) {
            DCDebugTracer.trace("ConfigurationInfo init failed, please check the style folder.");
            DCDebugTracer.trace(ex);
        }
        finally {
            IOStreamClose.closeInputStream(fileInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIfConfigFilesExistInJar() {
        JarFile jarFile = null;
        try {
            jarFile = this.getDCJarFile();
            if (null == jarFile) {
                this.m_bConfigFilesInJar = false;
                return;
            }
            Enumeration<JarEntry> filesEnum = jarFile.entries();
            JarEntry entry = null;
            String fileName = "";
            while (filesEnum.hasMoreElements()) {
                entry = filesEnum.nextElement();
                fileName = entry.getName();
                if (null == fileName || !fileName.startsWith("style")) continue;
                this.m_bConfigFilesInJar = true;
                return;
            }
            this.m_bConfigFilesInJar = false;
        }
        catch (Exception e) {
            DebugTracer.trace((Exception)e);
        }
        finally {
            if (null != jarFile) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    DebugTracer.trace((Exception)e);
                }
            }
        }
    }

    public static synchronized ConfigurationInfo getInstance() {
        if (null == m_oConfInfoInstance) {
            m_oConfInfoInstance = new ConfigurationInfo();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oConfInfoInstance);
        }
        return m_oConfInfoInstance;
    }

    @Override
    public void setToNULL() {
        m_oConfInfoInstance = null;
    }

    public String getLocaleSpecficDirectory() {
        return this.m_strLocaleBaseDirectory;
    }

    public String getStyleDirectory() {
        return this.m_strBaseDirectory;
    }

    String getImageDirectory() {
        if (this.m_bConfigFilesInJar) {
            return "/" + this.m_strLocaleBaseDirectory + "images" + "/";
        }
        return this.m_strLocaleBaseDirectory + File.separatorChar + "images" + File.separatorChar;
    }

    String getDevTypeImageDirectory(int iDevDomain) {
        String sDomainName = this.getDomainImagePathName(iDevDomain);
        if (this.m_bConfigFilesInJar) {
            return "/" + this.m_strLocaleBaseDirectory + "images" + "/" + sDomainName + "/";
        }
        return this.m_strLocaleBaseDirectory + File.separatorChar + "images" + File.separatorChar + sDomainName + File.separatorChar;
    }

    private String getDomainImagePathName(int iDevDomain) {
        switch (iDevDomain) {
            case 1: {
                return "bms";
            }
            case 2: {
                return "dms";
            }
            case 4: {
                return "t2000";
            }
        }
        return "";
    }

    public Locale getLocale() {
        return this.m_oSystemLocale;
    }

    public String getProductStyleDir() {
        return this.m_strProductStyleDir;
    }

    public Date getZonalDate(Date oDateObj) {
        GregorianCalendar testTime = new GregorianCalendar();
        long lMSec = oDateObj.getTime() - (long)testTime.get(15);
        oDateObj.setTime(lMSec);
        return oDateObj;
    }

    public Date getZonalDateOffset(Date oDateObj) {
        GregorianCalendar testTime = new GregorianCalendar();
        long lMSec = oDateObj.getTime() - (long)testTime.get(15);
        oDateObj.setTime(lMSec + 5000L);
        return oDateObj;
    }

    public String getAbsoluteBaseDirectory() {
        return this.m_strAbsoluteBaseDirectory;
    }

    public boolean isConfigFilesInJar() {
        return this.m_bConfigFilesInJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document loadDocumentFromFile(String strPath) {
        if (null == strPath || "".equals(strPath)) {
            return null;
        }
        DocumentBuilderFactory oDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document oDocument = null;
        InputStream inputStream = null;
        try {
            DocumentBuilder oDocumentBuilder = oDocumentBuilderFactory.newDocumentBuilder();
            if (ConfigurationInfo.getInstance().isConfigFilesInJar()) {
                ClassLoader Loader = this.getClass().getClassLoader();
                if (null != Loader) {
                    inputStream = Loader.getResourceAsStream(strPath);
                    oDocument = oDocumentBuilder.parse(inputStream);
                }
            } else {
                oDocument = oDocumentBuilder.parse(new File(strPath));
            }
        }
        catch (SAXException oSAXException) {
            DCDebugTracer.trace(oSAXException);
        }
        catch (IOException oIOException) {
            DCDebugTracer.trace(oIOException);
        }
        catch (ParserConfigurationException oPCException) {
            DCDebugTracer.trace(oPCException);
        }
        finally {
            IOStreamClose.closeInputStream(inputStream);
        }
        return oDocument;
    }

    public JarFile getDCJarFile() {
        JarFile dcJarFile = null;
        String filePath = "";
        filePath = DCFrameWorkUtil.getInstallMode() == 0 ? this.m_strAbsoluteBaseDirectory + File.separator + "lib" + File.separator + "dc.jar" : this.m_strAbsoluteBaseDirectory + File.separator + "productlib" + File.separator + "dc" + File.separator + "dc.jar";
        try {
            dcJarFile = new JarFile(filePath);
        }
        catch (IOException e) {
            DCDebugTracer.trace("ConfigurationInfo : failed to read dc.jar ");
            return null;
        }
        return dcJarFile;
    }
}

