/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.system;

import com.huawei.dc.common.asndatacenter.AsnBackupPurgeInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCBackupPurgeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceProtocolInfo;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyDayEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyPeriodEnum;
import com.huawei.dc.common.asndatacenter.AsnDCProtocolInfoList;
import com.huawei.dc.common.asndatacenter.AsnDeviceProtocolInfoReq;
import com.huawei.dc.common.asndatacenter.AsnFTSInfo;
import com.huawei.dc.common.asndatacenter.AsnFTSInfoReq;
import com.huawei.dc.common.asndatacenter.AsnFTSParam;
import com.huawei.dc.common.asndatacenter.AsnHAServerSetting;
import com.huawei.dc.common.asndatacenter.AsnHAServerSettingReq;
import com.huawei.dc.common.asndatacenter.AsnIPAddressInfo;
import com.huawei.dc.common.asndatacenter.AsnIPAddressInfoList;
import com.huawei.dc.common.asndatacenter.AsnProtocolEnum;
import com.huawei.dc.common.asndatacenter.AsnSystemIPInfoReq;
import com.huawei.dc.common.asndatacenter.AsnSystemSettingInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnThirdPartyFTPServerSetting;
import com.huawei.dc.common.asndatacenter.AsnThirdPartyFTPServerSettingInfo;
import com.huawei.dc.common.asndatacenter.AsnThirdPartyFTPServerSettingLst;
import com.huawei.dc.common.asndatacenter.AsnThirdPartyFTPServerSettingReq;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.system.DevcieProtocolSettingInfo;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.configuration.system.HAServerInfo;
import com.huawei.dc.configuration.system.IPConfigInfo;
import com.huawei.dc.configuration.system.PurgeInfo;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;

public class SystemSettingUtil
implements Serializable {
    private static final long serialVersionUID = 4213254318182402856L;

    public DevcieProtocolSettingInfo[] getDeviceProtocolConfigInfo(AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp) {
        int iNoOfDevice = oAsnSystemSettingInfoRsp.oDeviceProtocolInfoList.size();
        DevcieProtocolSettingInfo[] oDevProtocolSettingInfo = new DevcieProtocolSettingInfo[iNoOfDevice];
        AsnDCProtocolInfoList oAsnDCProtocolInfoList = oAsnSystemSettingInfoRsp.oDeviceProtocolInfoList;
        AsnDCDeviceProtocolInfo oAsnDCDeviceProtocolInfo = null;
        for (int iDeviceIndex = 0; iDeviceIndex < iNoOfDevice; ++iDeviceIndex) {
            oAsnDCDeviceProtocolInfo = (AsnDCDeviceProtocolInfo)oAsnDCProtocolInfoList.get(iDeviceIndex);
            oDevProtocolSettingInfo[iDeviceIndex] = new DevcieProtocolSettingInfo();
            oDevProtocolSettingInfo[iDeviceIndex].setDeviceTypeId(oAsnDCDeviceProtocolInfo.iDeviceTypeId.intValue());
            oDevProtocolSettingInfo[iDeviceIndex].setDeviceVersion(oAsnDCDeviceProtocolInfo.iDeviceVersionId.intValue());
            oDevProtocolSettingInfo[iDeviceIndex].setProtocolList((Vector)oAsnDCDeviceProtocolInfo.oSupportedProtocols);
            oDevProtocolSettingInfo[iDeviceIndex].setProtocolType(oAsnDCDeviceProtocolInfo.enProtocolType.value);
        }
        return oDevProtocolSettingInfo;
    }

    public ArrayList getIPConfigInfo(AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp) {
        AsnIPAddressInfoList oAsnDCIPAddressInfoList = oAsnSystemSettingInfoRsp.oIpAddressInfoList;
        int size = oAsnDCIPAddressInfoList.size();
        ArrayList<IPConfigInfo> ipConfigList = new ArrayList<IPConfigInfo>(size);
        for (int i = 0; i < size; ++i) {
            AsnIPAddressInfo oAsnIPAddressInfo = (AsnIPAddressInfo)oAsnDCIPAddressInfoList.elementAt(i);
            String strNEIP = new String(oAsnIPAddressInfo.strNeSegementIP);
            String strServerIP = new String(oAsnIPAddressInfo.strServerIP);
            boolean isIP = StringUtils.isIPV4(strServerIP);
            if (!isIP) continue;
            String strNatIP = new String(oAsnIPAddressInfo.strNatIP);
            int iProperty = oAsnIPAddressInfo.iProperty.intValue();
            IPConfigInfo oIPConfigInfo = new IPConfigInfo(strServerIP, strNEIP, strNatIP, iProperty);
            if (ipConfigList == null) continue;
            ipConfigList.add(oIPConfigInfo);
        }
        if (ipConfigList == null || ipConfigList.size() == 0) {
            DCDebugTracer.trace("DC::SystemSettingUtil-getIPConfigInfo:ipConfigList.size() == 0");
        }
        return ipConfigList;
    }

    public AsnSystemIPInfoReq getSystemIPConfigReq(ArrayList ipConfigList) {
        AsnSystemIPInfoReq oAsnSystemIPInfoReq = new AsnSystemIPInfoReq();
        AsnIPAddressInfo oAsnIPAddressInfo = null;
        IPConfigInfo oIPConfigInfo = null;
        int count = ipConfigList.size();
        for (int i = 0; i < count; ++i) {
            oIPConfigInfo = (IPConfigInfo)ipConfigList.get(i);
            oAsnIPAddressInfo = new AsnIPAddressInfo();
            oAsnIPAddressInfo.strServerIP = oIPConfigInfo.getStrServerIPAddress().getBytes();
            oAsnIPAddressInfo.strNeSegementIP = oIPConfigInfo.getStrNEIPAddress().getBytes();
            oAsnIPAddressInfo.strNatIP = oIPConfigInfo.getStrNatIPAddress().getBytes();
            oAsnIPAddressInfo.iProperty = new BigInteger("" + oIPConfigInfo.getProperty());
            oAsnSystemIPInfoReq.oIpAddressInfoList.add((Object)oAsnIPAddressInfo);
        }
        return oAsnSystemIPInfoReq;
    }

    public String getRootDirectory(AsnFTSInfo asnFTSInfo) {
        String strRootDir = null;
        if (null != asnFTSInfo.strServerRootDir) {
            strRootDir = new String(asnFTSInfo.strServerRootDir);
        }
        return strRootDir;
    }

    public String getServerFTPRootDirectory(AsnFTSInfo asnFTSInfo) {
        String strRootDir = null;
        if (null != asnFTSInfo.strServerRootDir) {
            strRootDir = new String(asnFTSInfo.strServerFTPRoot);
        }
        return strRootDir;
    }

    public AsnDeviceProtocolInfoReq getDeviceProtocolInfoReq(DevcieProtocolSettingInfo[] arrDeviceProtocolInfo) {
        AsnDeviceProtocolInfoReq oAsnDeviceProtocolInfoReq = new AsnDeviceProtocolInfoReq();
        int iNoOfDevice = arrDeviceProtocolInfo.length;
        oAsnDeviceProtocolInfoReq.oAsnDeviceProtocolInfoList = new AsnDCProtocolInfoList();
        for (int iDevIndex = 0; iDevIndex < iNoOfDevice; ++iDevIndex) {
            AsnDCDeviceProtocolInfo oAsnDCDeviceProtocolInfo = new AsnDCDeviceProtocolInfo();
            oAsnDCDeviceProtocolInfo.iDeviceTypeId = BigInteger.valueOf(arrDeviceProtocolInfo[iDevIndex].getDeviceTypeId());
            oAsnDCDeviceProtocolInfo.iDeviceVersionId = BigInteger.valueOf(arrDeviceProtocolInfo[iDevIndex].getDeviceVersionId());
            oAsnDCDeviceProtocolInfo.enProtocolType = new AsnProtocolEnum(arrDeviceProtocolInfo[iDevIndex].getProtocolType());
            oAsnDeviceProtocolInfoReq.oAsnDeviceProtocolInfoList.add((Object)oAsnDCDeviceProtocolInfo);
        }
        return oAsnDeviceProtocolInfoReq;
    }

    public AsnBackupPurgeInfoReq getAsnBackupPurgeInfoReq(PurgeInfo oPurgeInfo) {
        AsnBackupPurgeInfoReq oBackupPurgeInfoReq = new AsnBackupPurgeInfoReq();
        oBackupPurgeInfoReq.oAsnDCBackupPurgeInfo.bPurgeMode = oPurgeInfo.getSelectedPurgeMode().isAutomaticMode();
        oBackupPurgeInfoReq.oAsnDCBackupPurgeInfo.nNumOfBackupCopies = BigInteger.valueOf(oPurgeInfo.getNumOfBackupCopies());
        oBackupPurgeInfoReq.oAsnDCBackupPurgeInfo.nMaxNumOfBackupCopies = BigInteger.valueOf(oPurgeInfo.getMaximumBackupTimes());
        return oBackupPurgeInfoReq;
    }

    public PurgeInfo getPurgeInfo(AsnDCBackupPurgeInfo backupPurgeInfo) {
        PurgeInfo oPurgeInfo = PurgeInfo.getInstance();
        oPurgeInfo.setNumOfBackupCopies(backupPurgeInfo.nNumOfBackupCopies.intValue());
        oPurgeInfo.setSelectedPurgeMode(oPurgeInfo.getPurgeMode(backupPurgeInfo.bPurgeMode));
        oPurgeInfo.setMaximumBackupTimes(backupPurgeInfo.nMaxNumOfBackupCopies.intValue());
        return oPurgeInfo;
    }

    private byte[] getBytes(String strValue) {
        byte[] byteArray = new byte[]{};
        if (null != strValue && strValue.length() > 0) {
            byteArray = strValue.getBytes();
        }
        return byteArray;
    }

    private byte[] getBytes(char[] strValue) {
        byte[] byteArray = new byte[]{};
        if (null != strValue && strValue.length > 0) {
            byteArray = String.valueOf(strValue).getBytes();
        }
        return byteArray;
    }

    public AsnFTSInfoReq getAsnFTSInfoReq(FTSInfo oFTSInfo) {
        AsnFTSInfoReq oAsnFTSInfoReq = new AsnFTSInfoReq();
        AsnFTSInfo oAsnFTSInfo = new AsnFTSInfo();
        oAsnFTSInfo.strServerRootDir = this.getBytes(oFTSInfo.getRootDirectory());
        oAsnFTSInfo.strServerFTPRoot = this.getBytes(oFTSInfo.getRootDirectory());
        AsnFTSParam oAsnFTSParam = new AsnFTSParam();
        oAsnFTSParam.enProtocolType = new AsnProtocolEnum(1);
        oAsnFTSParam.strUserName = this.getBytes(oFTSInfo.getFTPUserName());
        oAsnFTSParam.strPassword = this.getBytes(oFTSInfo.getFTPPassword());
        oAsnFTSParam.iPortNum = BigInteger.valueOf(oFTSInfo.getFTPPortNumber());
        oAsnFTSInfo.oFTSParamList.add((Object)oAsnFTSParam);
        if (-1 != oFTSInfo.getSFTPPortNumber()) {
            AsnFTSParam oAsnSFTSParam = new AsnFTSParam();
            oAsnSFTSParam.enProtocolType = new AsnProtocolEnum(2);
            oAsnSFTSParam.strUserName = this.getBytes(oFTSInfo.getSFTPUserName());
            oAsnSFTSParam.strPassword = this.getBytes(oFTSInfo.getSFTPPassword());
            oAsnSFTSParam.iPortNum = BigInteger.valueOf(oFTSInfo.getSFTPPortNumber());
            oAsnFTSInfo.oFTSParamList.add((Object)oAsnSFTSParam);
        }
        oAsnFTSInfoReq.oAsnFTSInfo = oAsnFTSInfo;
        return oAsnFTSInfoReq;
    }

    public FTSInfo getThirdPartyFTPInfoByServerName(AsnThirdPartyFTPServerSettingLst oAsnThirdPartyFTPInfoLst, String thirdPartyServerName) {
        if (null == oAsnThirdPartyFTPInfoLst) {
            return null;
        }
        FTSInfo oFTSInfo = new FTSInfo();
        ExternalFTPInfo[] ftpThirdArr = this.getExternalFTPConfiguration(oAsnThirdPartyFTPInfoLst);
        for (int i = 0; i < ftpThirdArr.length; ++i) {
            if (!ftpThirdArr[i].getServerName().equals(thirdPartyServerName)) continue;
            oFTSInfo = new FTSInfo();
            oFTSInfo.setRootDirectory("");
            oFTSInfo.setServerIP(ftpThirdArr[i].getServerIP());
            oFTSInfo.setFTPUserName(ftpThirdArr[i].getUserName());
            oFTSInfo.setFTPPassword(ftpThirdArr[i].getPassword());
            oFTSInfo.setFTPPortNumber(ftpThirdArr[i].getPort());
            if (!ftpThirdArr[i].getType().equals("SFTP")) continue;
            oFTSInfo.setFTPType(2);
        }
        return oFTSInfo;
    }

    public FTSInfo getProtocolConfiguration(AsnFTSInfo oAsnFTSInfo) {
        FTSInfo oFTSInfo = new FTSInfo();
        oFTSInfo.setRootDirectory(new String(oAsnFTSInfo.strServerRootDir));
        int iCount = oAsnFTSInfo.oFTSParamList.size();
        block4: for (int index = 0; index < iCount; ++index) {
            AsnFTSParam oAsnFTSParam = (AsnFTSParam)oAsnFTSInfo.oFTSParamList.get(index);
            String strUserName = new String(oAsnFTSParam.strUserName);
            char[] strPassword = DCCommonUtil.convertByteArrayToChar(oAsnFTSParam.strPassword);
            if (null != oAsnFTSParam.strHAServerIP) {
                oFTSInfo.setServerIP(new String(oAsnFTSParam.strHAServerIP));
            }
            switch (oAsnFTSParam.enProtocolType.value) {
                case 1: {
                    oFTSInfo.setFTPUserName(strUserName);
                    oFTSInfo.setFTPPassword(strPassword);
                    if (null == oAsnFTSParam.iPortNum) continue block4;
                    oFTSInfo.setFTPPortNumber(oAsnFTSParam.iPortNum.intValue());
                    continue block4;
                }
                case 2: {
                    oFTSInfo.setSFTPUserName(strUserName);
                    oFTSInfo.setSFTPPassword(strPassword);
                    if (null == oAsnFTSParam.iPortNum) continue block4;
                    oFTSInfo.setSFTPPortNumber(oAsnFTSParam.iPortNum.intValue());
                    continue block4;
                }
            }
        }
        return oFTSInfo;
    }

    public HAServerInfo getHAServerConfiguration(AsnHAServerSetting oServerSetting) {
        HAServerInfo oServerInfo = new HAServerInfo();
        oServerInfo.setEnable(oServerSetting.bEnable);
        if (oServerSetting.bEnable) {
            if (null != oServerSetting.strServerName) {
                oServerInfo.setServerName(new String(oServerSetting.strServerName));
            }
            if ("".equals(oServerInfo.getServerName())) {
                oServerInfo.setEnable(false);
            }
            oServerInfo.setPolicyPeriod(oServerSetting.enPolicyPeriod.value);
            int iWeekDay = -1;
            if (oServerSetting.enPolicyPeriod.value == 0) {
                oServerInfo.setPolicyDay(oServerSetting.iPolicyDayInAMonth.intValue() - 1);
            } else if (oServerSetting.enPolicyPeriod.value == 1) {
                iWeekDay = oServerSetting.enPolicyDayInAWeek.value;
                oServerInfo.setPolicyDay(iWeekDay);
            }
            if (null != oServerSetting.strPolicyTime) {
                oServerInfo.setPolicyTime(new String(oServerSetting.strPolicyTime));
            }
        }
        return oServerInfo;
    }

    public AsnHAServerSettingReq getAsnHAServerSettingReq(HAServerInfo oHAServerInfo) {
        AsnHAServerSettingReq oAsnHAServerSettingReq = new AsnHAServerSettingReq();
        oAsnHAServerSettingReq.oAsnHAServerSetting.bEnable = oHAServerInfo.isEnable();
        if (oHAServerInfo.isEnable()) {
            oAsnHAServerSettingReq.oAsnHAServerSetting.strServerName = oHAServerInfo.getServerName().getBytes();
            int iPolicyPeriod = oHAServerInfo.getPolicyPeriod();
            oAsnHAServerSettingReq.oAsnHAServerSetting.enPolicyPeriod = new AsnDCPolicyPeriodEnum(iPolicyPeriod);
            int iWeekDay = -1;
            if (iPolicyPeriod == 0) {
                String strPolicyDayInAMonth = String.valueOf(oHAServerInfo.getPolicyDay() + 1);
                oAsnHAServerSettingReq.oAsnHAServerSetting.iPolicyDayInAMonth = new BigInteger(strPolicyDayInAMonth);
            } else if (iPolicyPeriod == 1) {
                iWeekDay = oHAServerInfo.getPolicyDay();
                oAsnHAServerSettingReq.oAsnHAServerSetting.enPolicyDayInAWeek = new AsnDCPolicyDayEnum(iWeekDay);
            }
            String strPolicyTime = oHAServerInfo.getPolicyTime();
            oAsnHAServerSettingReq.oAsnHAServerSetting.strPolicyTime = strPolicyTime.getBytes();
        }
        return oAsnHAServerSettingReq;
    }

    public ExternalFTPInfo[] getExternalFTPConfiguration(AsnThirdPartyFTPServerSettingLst oAsnExternalFTPServerInfos) {
        int iSize = oAsnExternalFTPServerInfos.size();
        ExternalFTPInfo[] oExternalFTPInfos = new ExternalFTPInfo[iSize];
        for (int i = 0; i < iSize; ++i) {
            AsnThirdPartyFTPServerSetting oAsnExternalFTPInfo = (AsnThirdPartyFTPServerSetting)oAsnExternalFTPServerInfos.get(i);
            oExternalFTPInfos[i] = new ExternalFTPInfo();
            oExternalFTPInfos[i].setServerName(new String(oAsnExternalFTPInfo.strServerName));
            oExternalFTPInfos[i].setServerIP(new String(oAsnExternalFTPInfo.strServerIP));
            int iProtocolType = oAsnExternalFTPInfo.enProtocolType.value;
            if (2 == iProtocolType) {
                oExternalFTPInfos[i].setType("SFTP");
            }
            oExternalFTPInfos[i].setPort(oAsnExternalFTPInfo.iPortNum.intValue());
            oExternalFTPInfos[i].setUserName(new String(oAsnExternalFTPInfo.strUserName));
            oExternalFTPInfos[i].setPassword(DCCommonUtil.convertByteArrayToChar(oAsnExternalFTPInfo.strPassword));
        }
        return oExternalFTPInfos;
    }

    public AsnThirdPartyFTPServerSettingReq getAsnThirdPartyFTPSettingReq(String strSelectServerName, ExternalFTPInfo ... oExternalFTPInfos) {
        AsnThirdPartyFTPServerSettingReq oAsnThirdPartyFTPSettingReq = new AsnThirdPartyFTPServerSettingReq();
        AsnThirdPartyFTPServerSettingInfo oAsnExternalFTPServerSettingInfo = oAsnThirdPartyFTPSettingReq.oAsnThirdPartyFTPSettingInfo;
        oAsnExternalFTPServerSettingInfo.strSelectedServerName = strSelectServerName.getBytes();
        for (ExternalFTPInfo oExternalFTPInfo : oExternalFTPInfos) {
            AsnThirdPartyFTPServerSetting oAsnExternalFTPInfo = new AsnThirdPartyFTPServerSetting();
            oAsnExternalFTPInfo.strServerName = oExternalFTPInfo.getServerName().getBytes();
            oAsnExternalFTPInfo.strServerIP = oExternalFTPInfo.getServerIP().getBytes();
            oAsnExternalFTPInfo.enProtocolType.value = "SFTP".equals(oExternalFTPInfo.getType()) ? 2 : 1;
            oAsnExternalFTPInfo.iPortNum = BigInteger.valueOf(oExternalFTPInfo.getPort());
            oAsnExternalFTPInfo.strUserName = oExternalFTPInfo.getUserName().getBytes();
            oAsnExternalFTPInfo.strPassword = null != oExternalFTPInfo.getPassword() ? StringUtils.convertCharsToBytes(oExternalFTPInfo.getPassword()) : "".getBytes();
            oAsnExternalFTPServerSettingInfo.oAsnThirdPartyFTPInfoLst.add((Object)oAsnExternalFTPInfo);
        }
        return oAsnThirdPartyFTPSettingReq;
    }
}

