/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.system;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnBackupPurgeInfoReq;
import com.huawei.dc.common.asndatacenter.AsnBackupPurgeInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDeleteThirdFTPReq;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDeleteThirdFTPRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetSystemConfigInfo;
import com.huawei.dc.common.asndatacenter.AsnDCImportLicenseReq;
import com.huawei.dc.common.asndatacenter.AsnDCLicenseInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCServerIPValidationReq;
import com.huawei.dc.common.asndatacenter.AsnDCTargetFileServerTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDeviceProtocolInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDeviceProtocolInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnFTSInfoReq;
import com.huawei.dc.common.asndatacenter.AsnFTSInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnGetExternalFTPServerInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnGetRootPathReq;
import com.huawei.dc.common.asndatacenter.AsnGetRootPathRsp;
import com.huawei.dc.common.asndatacenter.AsnHAFailLogInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnHAServerSettingReq;
import com.huawei.dc.common.asndatacenter.AsnHAServerSettingRsp;
import com.huawei.dc.common.asndatacenter.AsnServerRootPathRsp;
import com.huawei.dc.common.asndatacenter.AsnSystemIPInfoReq;
import com.huawei.dc.common.asndatacenter.AsnSystemSettingInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnSystemSettingRsp;
import com.huawei.dc.common.asndatacenter.AsnTestFTSProtocolReq;
import com.huawei.dc.common.asndatacenter.AsnThirdPartyFTPServerSettingReq;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemSettingUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.system.DevcieProtocolSettingInfo;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.configuration.system.HAServerInfo;
import com.huawei.dc.configuration.system.ProtocolConfigInfo;
import com.huawei.dc.configuration.system.PurgeInfo;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.view.common.ThirdPartyFTPUtil;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;

public class SystemManager
implements ISystemManager,
Serializable {
    private static final long serialVersionUID = 8388047936542886734L;
    private SystemSettingUtil m_oSystemSettingUtil = new SystemSettingUtil();

    @Override
    public AsnDCGetSystemConfigInfo getSystemProtocolStatus() throws DCException {
        int returnCode;
        final AsnDCGetSystemConfigInfo asnDCGetSystemConfigInfo = new AsnDCGetSystemConfigInfo();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43843), null, (FStruct)asnDCGetSystemConfigInfo, 600000);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCDebugTracer.trace("getSystemProtocolStatus returnCode : " + returnCode);
            throw new DCException(996147207, "ERROR");
        }
        return asnDCGetSystemConfigInfo;
    }

    @Override
    public void setIPConfigInfo(ArrayList ipConfigList) throws DCException {
        final AsnSystemSettingRsp oAsnSystemSettingRsp = new AsnSystemSettingRsp();
        final AsnSystemIPInfoReq oAsnSystemIPInfoReq = this.m_oSystemSettingUtil.getSystemIPConfigReq(ipConfigList);
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43903), (FStruct)oAsnSystemIPInfoReq, (FStruct)oAsnSystemSettingRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnSystemSettingRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    @Override
    public AsnSystemSettingInfoRsp getSystemSettingInfo() throws DCException {
        final AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = new AsnSystemSettingInfoRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43901), null, (FStruct)oAsnSystemSettingInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        TKCommonUtil.setRootPath(new String(oAsnSystemSettingInfoRsp.oFTSInfo.strServerRootDir));
        return oAsnSystemSettingInfoRsp;
    }

    @Override
    public int testProtocolSetting(ProtocolConfigInfo oProtocolConfigInfo, String strTFTPRootDir) {
        final AsnFTSInfoRsp oFTSInfoRsp = new AsnFTSInfoRsp();
        final AsnTestFTSProtocolReq oTestFTSProtocolReq = new AsnTestFTSProtocolReq();
        oTestFTSProtocolReq.strTFTPRootDir = strTFTPRootDir.getBytes();
        oTestFTSProtocolReq.oAsnTestFTSProtocol.enProtocolType = oProtocolConfigInfo.getProtocolType();
        if (null != oProtocolConfigInfo.getUserName()) {
            oTestFTSProtocolReq.oAsnTestFTSProtocol.strUserName = oProtocolConfigInfo.getUserName().getBytes();
        }
        if (null != oProtocolConfigInfo.getPassword()) {
            oTestFTSProtocolReq.oAsnTestFTSProtocol.strPassword = StringUtils.convertCharsToBytes(oProtocolConfigInfo.getPassword());
        }
        if (null != oProtocolConfigInfo.getPortNumber()) {
            oTestFTSProtocolReq.oAsnTestFTSProtocol.iPortNum = BigInteger.valueOf(oProtocolConfigInfo.getPortNumber().intValue());
        }
        if (null != oProtocolConfigInfo.getServerIP() && 0 != oProtocolConfigInfo.getServerIP().length()) {
            oTestFTSProtocolReq.oAsnTestFTSProtocol.strHAServerIP = oProtocolConfigInfo.getServerIP().getBytes();
        }
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43906), (FStruct)oTestFTSProtocolReq, (FStruct)oFTSInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode == 0) {
            iErrorCode = oFTSInfoRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        }
        return iErrorCode;
    }

    @Override
    public int setFTSInfo(FTSInfo oFTSInfo) {
        final AsnFTSInfoReq oFTSInfoReq = this.m_oSystemSettingUtil.getAsnFTSInfoReq(oFTSInfo);
        final AsnFTSInfoRsp oAsnFTSInfoRsp = new AsnFTSInfoRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43907), (FStruct)oFTSInfoReq, (FStruct)oAsnFTSInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        } else {
            DCDebugTracer.trace("DC::SYSMGR setFTSInfo result is null");
            iErrorCode = -1;
        }
        if (iErrorCode == 0) {
            iErrorCode = oAsnFTSInfoRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        }
        return iErrorCode;
    }

    @Override
    public int setDeviceProtocolInfo(DevcieProtocolSettingInfo[] arrDeviceProtocolInfo, int xftpType) throws DCException {
        final AsnDeviceProtocolInfoRsp oDeviceProtocolInfoRsp = new AsnDeviceProtocolInfoRsp();
        final AsnDeviceProtocolInfoReq oAsnDeviceProtocolInfoReq = this.m_oSystemSettingUtil.getDeviceProtocolInfoReq(arrDeviceProtocolInfo);
        oAsnDeviceProtocolInfoReq.iClientToServerProtocol = BigInteger.valueOf(xftpType);
        int iErrorCode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43908), (FStruct)oAsnDeviceProtocolInfoReq, (FStruct)oDeviceProtocolInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        return oDeviceProtocolInfoRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
    }

    @Override
    public int setPurgeInfo(PurgeInfo oPurgeInfo) throws DCException {
        final AsnBackupPurgeInfoReq oAsnBackupPurgeInfoReq = this.m_oSystemSettingUtil.getAsnBackupPurgeInfoReq(oPurgeInfo);
        final AsnBackupPurgeInfoRsp oBackupPurgeInfoRsp = new AsnBackupPurgeInfoRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43878), (FStruct)oAsnBackupPurgeInfoReq, (FStruct)oBackupPurgeInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode == 0) {
            iErrorCode = oBackupPurgeInfoRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        return iErrorCode;
    }

    @Override
    public ArrayList getIPConfigInfo() throws DCException {
        AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = this.getSystemSettingInfo();
        return this.m_oSystemSettingUtil.getIPConfigInfo(oAsnSystemSettingInfoRsp);
    }

    @Override
    public AsnSystemSettingInfoRsp getDeviceProtocolInfo() throws DCException {
        return this.getSystemSettingInfo();
    }

    @Override
    public String getSystemRootDirectory() {
        AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = null;
        try {
            oAsnSystemSettingInfoRsp = this.getSystemSettingInfo();
        }
        catch (DCException e) {
            return null;
        }
        return this.m_oSystemSettingUtil.getRootDirectory(oAsnSystemSettingInfoRsp.oFTSInfo);
    }

    @Override
    public String getSystemServerFTPRoot() {
        AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = null;
        try {
            oAsnSystemSettingInfoRsp = this.getSystemSettingInfo();
        }
        catch (DCException e) {
            return null;
        }
        return this.m_oSystemSettingUtil.getServerFTPRootDirectory(oAsnSystemSettingInfoRsp.oFTSInfo);
    }

    @Override
    public PurgeInfo getPurgeInfo() {
        AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp;
        try {
            oAsnSystemSettingInfoRsp = this.getSystemSettingInfo();
        }
        catch (DCException e) {
            return PurgeInfo.getInstance();
        }
        return this.m_oSystemSettingUtil.getPurgeInfo(oAsnSystemSettingInfoRsp.oBackupPurgeInfo);
    }

    @Override
    public FTSInfo getFTSInfo() {
        AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = null;
        try {
            oAsnSystemSettingInfoRsp = this.getSystemSettingInfo();
        }
        catch (DCException oDCException) {
            DCDebugTracer.trace(oDCException);
            return null;
        }
        return this.m_oSystemSettingUtil.getProtocolConfiguration(oAsnSystemSettingInfoRsp.oFTSInfo);
    }

    public int getServerFileTransfersProtocol() {
        DCDebugTracer.trace("[XFtp] getServerFileTransfersProtocol start");
        AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = null;
        try {
            oAsnSystemSettingInfoRsp = this.getSystemSettingInfo();
        }
        catch (DCException oDCException) {
            DCDebugTracer.trace(oDCException);
            oAsnSystemSettingInfoRsp = new AsnSystemSettingInfoRsp();
            oAsnSystemSettingInfoRsp.iClientToServerProtocol = BigInteger.valueOf(2L);
        }
        DCDebugTracer.trace("[XFtp] getServerFileTransfersProtocol iClientToServerProtocol " + oAsnSystemSettingInfoRsp.iClientToServerProtocol.intValue());
        DCDebugTracer.trace("[XFtp] getServerFileTransfersProtocol end..");
        return oAsnSystemSettingInfoRsp.iClientToServerProtocol.intValue();
    }

    @Override
    public int validateServerIP(String strServerIPAddress) {
        int returnCode;
        final AsnDCServerIPValidationReq asnServerIpValidationReq = new AsnDCServerIPValidationReq();
        asnServerIpValidationReq.strServerIP = strServerIPAddress.getBytes();
        final AsnDCOpertionRsp asnOperationRsp = new AsnDCOpertionRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43865), (FStruct)asnServerIpValidationReq, (FStruct)asnOperationRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            return returnCode;
        }
        int errorcode = asnOperationRsp.oErrorInfo.iErrorNo.intValue();
        return errorcode;
    }

    @Override
    public String getServerRootPath() throws DCException {
        String strServerPath = null;
        final AsnServerRootPathRsp oAsnServerRootPath = new AsnServerRootPathRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43915), null, (FStruct)oAsnServerRootPath);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int iReturnCode = 0;
        if (syncCommand.getResult() != null && (iReturnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            throw new DCException(iReturnCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iReturnCode)));
        }
        iReturnCode = oAsnServerRootPath.oErrorInfo.iErrorNo.intValue();
        if (0 != iReturnCode) {
            throw new DCException(iReturnCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iReturnCode)));
        }
        strServerPath = new String(oAsnServerRootPath.strRootPath);
        return strServerPath;
    }

    @Override
    public int sendLicenseInfomation(final AsnDCImportLicenseReq oAsnLicenseRequest) {
        int iReturnCode;
        final AsnDCOpertionRsp oAsnOperationRsp = new AsnDCOpertionRsp();
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43924), (FStruct)oAsnLicenseRequest, (FStruct)oAsnOperationRsp);
                return iErrorcode;
            }
        };
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != oSyncCommand.getResult() && (iReturnCode = ((Integer)oSyncCommand.getResult()).intValue()) != 0) {
            return iReturnCode;
        }
        int iErrorcode = oAsnOperationRsp.oErrorInfo.iErrorNo.intValue();
        return iErrorcode;
    }

    @Override
    public AsnDCLicenseInfoRsp getLicenseInformation() {
        int iReturnCode;
        final AsnDCLicenseInfoRsp oAsnDCLicenseInfoRsp = new AsnDCLicenseInfoRsp();
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43923), null, (FStruct)oAsnDCLicenseInfoRsp);
                return iErrorcode;
            }
        };
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (oSyncCommand.getResult() != null && (iReturnCode = ((Integer)oSyncCommand.getResult()).intValue()) != 0) {
            oAsnDCLicenseInfoRsp.oErrorNo.iErrorNo = BigInteger.valueOf(iReturnCode);
            return oAsnDCLicenseInfoRsp;
        }
        return oAsnDCLicenseInfoRsp;
    }

    @Override
    public HAServerInfo getHAServerInfo() {
        AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = null;
        try {
            oAsnSystemSettingInfoRsp = this.getSystemSettingInfo();
        }
        catch (DCException oDCException) {
            DCDebugTracer.trace(oDCException);
            return null;
        }
        return this.m_oSystemSettingUtil.getHAServerConfiguration(oAsnSystemSettingInfoRsp.oHAserverSetting);
    }

    @Override
    public int setHAServerInfo(HAServerInfo oHAServerInfo) throws DCException {
        final AsnHAServerSettingReq oAsnHAServerSettingReq = this.m_oSystemSettingUtil.getAsnHAServerSettingReq(oHAServerInfo);
        final AsnHAServerSettingRsp oAsnHAServerSettingRsp = new AsnHAServerSettingRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44011), (FStruct)oAsnHAServerSettingReq, (FStruct)oAsnHAServerSettingRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnHAServerSettingRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        return iErrorCode;
    }

    @Override
    public AsnHAFailLogInfoRsp getHAFailureInfo() throws DCException {
        final AsnHAFailLogInfoRsp oAsnHAFailLogInfoRsp = new AsnHAFailLogInfoRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44012), null, (FStruct)oAsnHAFailLogInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        return oAsnHAFailLogInfoRsp;
    }

    @Override
    public int setExternalFTPConfiguration(String strSelectServerName, ExternalFTPInfo[] oExternalFTPInfos) throws DCException {
        final AsnThirdPartyFTPServerSettingReq oAsnThirdPartyFTPSettingReq = this.m_oSystemSettingUtil.getAsnThirdPartyFTPSettingReq(strSelectServerName, oExternalFTPInfos);
        final AsnSystemSettingRsp oAsnSystemSettingRsp = new AsnSystemSettingRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44034), (FStruct)oAsnThirdPartyFTPSettingReq, (FStruct)oAsnSystemSettingRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode == 0) {
            iErrorCode = oAsnSystemSettingRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        return iErrorCode;
    }

    @Override
    public String getBrowseFileDir(int targetFileServerType, String strThirdFTPName) {
        String strBrowesDir = "";
        final AsnGetRootPathRsp oAsnGetRootPathRsp = new AsnGetRootPathRsp();
        final AsnGetRootPathReq oAsnGetRootPathReq = new AsnGetRootPathReq();
        oAsnGetRootPathReq.oTargetFileServerType = new AsnDCTargetFileServerTypeEnum(targetFileServerType);
        oAsnGetRootPathReq.ostrThirdFtpServerName = strThirdFTPName.getBytes();
        DCDebugTracer.trace("SystemManager::getBrowseFileDir::ostrThirdFtpServerName->" + strThirdFTPName);
        DCDebugTracer.trace("SystemManager::getBrowseFileDir::oTargetFileServerType->" + targetFileServerType);
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = DCFrameWorkUtil.getCommManager().sendSyncMsg(BaseCommManager.getMSGHead(44049), (FStruct)oAsnGetRootPathReq, (FStruct)oAsnGetRootPathRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int errorCode = oAsnGetRootPathRsp.oErrorInfo.iErrorNo.intValue();
        if (errorCode != 0) {
            try {
                DCOptionPane.showMessageDialog(null, oAsnGetRootPathRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        } else {
            strBrowesDir = new String(oAsnGetRootPathRsp.strWorkRootPath);
        }
        DCDebugTracer.trace("getBrowseFileDir#strBrowesDir: " + strBrowesDir);
        return strBrowesDir;
    }

    @Override
    public String getExternalFTPServerNameForUpgradeTask() {
        AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = null;
        try {
            oAsnSystemSettingInfoRsp = this.getSystemSettingInfo();
        }
        catch (DCException oDCException) {
            DCDebugTracer.trace(oDCException);
        }
        if (null == oAsnSystemSettingInfoRsp || null == oAsnSystemSettingInfoRsp.oThirdPartyFTPSetting) {
            return "";
        }
        String strServerName = new String(oAsnSystemSettingInfoRsp.oThirdPartyFTPSetting.strSelectedServerName);
        return strServerName.trim();
    }

    @Override
    public ExternalFTPInfo[] getExternalFTPInfos() throws DCException {
        final AsnGetExternalFTPServerInfoRsp oAsnGetExternalFTPServerInfoRsp = new AsnGetExternalFTPServerInfoRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44083), null, (FStruct)oAsnGetExternalFTPServerInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode == 0) {
            iErrorCode = oAsnGetExternalFTPServerInfoRsp.oErrorInfo.iErrorNo.intValue();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        SystemSettingUtil systemSettingUtil = new SystemSettingUtil();
        ExternalFTPInfo[] oExternalFTPInfos = systemSettingUtil.getExternalFTPConfiguration(oAsnGetExternalFTPServerInfoRsp.oAsnThirdPartyFTPInfoLst);
        oExternalFTPInfos = ThirdPartyFTPUtil.sortExternalFTPInfo(oExternalFTPInfos);
        return oExternalFTPInfos;
    }

    public AsnDCCheckDeleteThirdFTPRsp checkDeleteThirdFTP(ExternalFTPInfo[] oExternalFTPInfos) throws DCException {
        AsnDCCheckDeleteThirdFTPReq oReq = new AsnDCCheckDeleteThirdFTPReq();
        for (ExternalFTPInfo oFtpInfo : oExternalFTPInfos) {
            oReq.strSelectedServerNameLst.addElement((Object)oFtpInfo.getServerName().getBytes());
        }
        AsnDCCheckDeleteThirdFTPRsp oRsp = new AsnDCCheckDeleteThirdFTPRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().sendSyncMsgWithSyncCommand(44087, (FStruct)oReq, (FStruct)oRsp);
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        return oRsp;
    }

    @Override
    public int setThirdPartyFTPInfo(String strSelectedServerName, ExternalFTPInfo oThirdPartyFTPInfo) throws DCException {
        final AsnThirdPartyFTPServerSettingReq oAsnThirdPartyFTPSettingReq = this.m_oSystemSettingUtil.getAsnThirdPartyFTPSettingReq(strSelectedServerName, oThirdPartyFTPInfo);
        final AsnSystemSettingRsp oAsnSystemSettingRsp = new AsnSystemSettingRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44034), (FStruct)oAsnThirdPartyFTPSettingReq, (FStruct)oAsnSystemSettingRsp);
                return errorcode;
            }
        };
        syncCommand.startCall();
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode == 0) {
            iErrorCode = oAsnSystemSettingRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        return iErrorCode;
    }
}

