/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.system;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCGetSystemConfigInfo;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.SystemConfInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.SwingUtilities;

public class ProtocolStatus
implements IDCObjectDeallocator {
    private SystemConfInfo systemConfInfo = null;
    private static ProtocolStatus c_oProtocolStatus;
    private boolean m_bCheckingServcieStatus = false;
    private AsnDCGetSystemConfigInfo asnDCGetSystemConfigInfo;
    private ISystemManager m_oSystemMgr = new SystemManager();

    private SystemConfInfo getProtocolStatus(ISystemManager sysMgr) throws DCException {
        this.asnDCGetSystemConfigInfo = sysMgr.getSystemProtocolStatus();
        this.systemConfInfo = new SystemConfInfo();
        this.systemConfInfo.setConfig(this.asnDCGetSystemConfigInfo.isConfig);
        this.systemConfInfo.setMessaseCode(this.asnDCGetSystemConfigInfo.oErrorInfo.iErrorNo.intValue());
        return this.systemConfInfo;
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oSystemMgr) {
            this.m_oSystemMgr = null;
        }
        this.asnDCGetSystemConfigInfo = null;
        this.systemConfInfo = null;
        c_oProtocolStatus = null;
    }

    private ProtocolStatus() throws DCException {
    }

    public static synchronized ProtocolStatus getInstance() throws DCException {
        if (c_oProtocolStatus == null) {
            c_oProtocolStatus = new ProtocolStatus();
            DCObjectDestructor.getInstance().addObjectForDestructor(c_oProtocolStatus);
        }
        return c_oProtocolStatus;
    }

    public final void checkFileTransferStatus(final boolean isSetThirdFtpDuringCreateTask) throws DCException {
        if (this.m_bCheckingServcieStatus) {
            DCDebugTracer.trace("DC XFTP ignore this check request");
            return;
        }
        Thread oCheckStatusThread = new Thread(){

            @Override
            public void run() {
                try {
                    ProtocolStatus.this.m_bCheckingServcieStatus = true;
                    ProtocolStatus.this.getProtocolStatus(ProtocolStatus.this.m_oSystemMgr);
                    int imsgCode = ProtocolStatus.this.systemConfInfo.getMessaseCode();
                    if (!isSetThirdFtpDuringCreateTask) {
                        ProtocolStatus.this.fileTransferStatusResult(imsgCode);
                    }
                    ProtocolStatus.this.m_bCheckingServcieStatus = false;
                }
                catch (DCException e) {
                    DCDebugTracer.trace("DC XFTP service check failed");
                    DCDebugTracer.trace(e);
                }
            }
        };
        oCheckStatusThread.start();
    }

    public final String fileTransferStatusResult(int iMessageCode) throws DCException {
        String msg = this.checkMsgCode(iMessageCode);
        if (msg.length() > 0 && 0 != iMessageCode) {
            this.showDialog(msg);
        }
        return msg;
    }

    protected void showDialog(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(message), ResourceManager.getInstance().getResString("INFO"), 1);
            }
        });
    }

    public final SystemConfInfo getSystemConfInfo() {
        try {
            this.getProtocolStatus(this.m_oSystemMgr);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        return this.systemConfInfo;
    }

    private final String checkMsgCode(int imsgCode) {
        String message = "";
        switch (imsgCode) {
            case 0: {
                message = "FTP_SFTP_TFTP_RUNNING";
                break;
            }
            case 1: {
                message = "FTP_NOTRUNNING";
                break;
            }
            case 2: {
                message = this.getSFTPNotRunningMessage();
                break;
            }
            case 3: {
                message = this.getFTPSFTPNotRunning();
                break;
            }
            case 4: {
                message = "TFTP_NOTRUNNING";
                break;
            }
            case 5: {
                message = "FTP_TFTP_NOTRUNNING";
                break;
            }
            case 6: {
                message = this.getSFTPMessage();
                break;
            }
            case 7: {
                message = this.getSFTPTFTPNotRunningMessage();
                break;
            }
            case 8: {
                message = "FTP_SFTP_TFTP_RUNNING_FTP_USER_PASSWORD_MSG";
                break;
            }
            case 10: {
                message = "SFTP_NOTRUNNING_FTP_TFTP_RUNNING_FTP_USER_PASSWORD_MSG";
                break;
            }
            case 12: {
                message = "TFTP_NOTRUNNING_FTP_SFTP_RUNNING_FTP_USER_PASSWORD_MSG";
                break;
            }
            case 14: {
                message = "TFTP_SFTP_NOTRUNNING_FTP_RUNNING_FTP_USER_PASSWORD_MSG";
                break;
            }
            case 16: {
                message = "FTP_SFTP_TFTP_RUNNING_SFTP_USER_PASSWORD_MSG";
                break;
            }
            case 17: {
                message = "FTP_NOTRUNNING_SFTP_TFTP_RUNNING_SFTP_USER_PASSWORD_MSG";
                break;
            }
            case 20: {
                message = "TFTP_NOTRUNNING_FTP_SFTP_RUNNING_SFTP_USER_PASSWORD_MSG";
                break;
            }
            case 21: {
                message = "FTP_TFTP_NOTRUNNING_FTP_SFTP_RUNNING_SFTP_USER_PASSWORD_MSG";
                break;
            }
            case 24: {
                message = "FTP_SFTP_TFTP_RUNNING_FTP_SFTP_USER_PASSWORD_MSG";
                break;
            }
            case 28: {
                message = "TFTP_NOTRUNNING_FTP_SFTP_RUNNING_FTP_SFTP_USER_PASSWORD_MSG";
                break;
            }
            default: {
                message = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(imsgCode));
            }
        }
        if (imsgCode >= 32 && imsgCode <= 100) {
            message = "XFTP_CHECK_STATUS_" + imsgCode;
        }
        return message;
    }

    private String getFTPSFTPNotRunning() {
        String message = "FTP_SFTP_NOTRUNNING";
        if (this.systemConfInfo.getErrMessage() != null) {
            message = "FTP_NOTRUNNING_SFTP_NOT_ABLE_TO_CHECK";
        }
        return message;
    }

    private String getSFTPNotRunningMessage() {
        String message = "SFTP_NOTRUNNING";
        if (this.systemConfInfo.getErrMessage() != null) {
            message = "SFTP_NOT_ABLE_TO_CHECK";
        }
        return message;
    }

    private String getSFTPTFTPNotRunningMessage() {
        String message = "FTP_SFTP_TFTP_NOTRUNNING";
        if (this.systemConfInfo.getErrMessage() != null) {
            message = "FTP_TFTP_NOTRUNNING_SFTP_NOT_ABLE_TO_CHECK";
        }
        return message;
    }

    private String getSFTPMessage() {
        String message = "SFTP_TFTP_NOTRUNNING";
        if (this.systemConfInfo.getErrMessage() != null) {
            message = "TFTP_NOTRUNNING_SFTP_NOT_ABLE_TO_CHECK";
        }
        return message;
    }
}

