/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.dcmodule;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileOperationUtils;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFileContentDlg;
import com.huawei.dc.framework.ClientFileOperations;
import com.huawei.dc.framework.IRequest;
import com.huawei.dc.framework.XFtpFileOperationFactory;
import java.awt.Component;
import java.io.File;
import java.security.SecureRandom;
import java.util.Calendar;

public class ViewFileFromTopo {
    private int m_iRequestId = -1;
    private Object m_oSyncObj = new Object();
    private static ViewFileFromTopo m_oViewFileFrmTopo = null;
    private String m_strDestinationPath = null;
    private String m_strFileName = null;
    private String m_strRootDir = null;
    private boolean m_bClinetOpenFrmTopo = false;
    private int m_iNotifiedRequestId = -1;
    private int m_iErrorCode = -1;
    private SecureRandom random = new SecureRandom();

    private ViewFileFromTopo() {
    }

    public static ViewFileFromTopo getInstance() {
        if (null == m_oViewFileFrmTopo) {
            m_oViewFileFrmTopo = new ViewFileFromTopo();
        }
        return m_oViewFileFrmTopo;
    }

    private double getRandomNum() {
        return this.random.nextDouble();
    }

    public static void setInstanceToNull() {
        m_oViewFileFrmTopo = null;
    }

    private void generateRequestId() {
        Calendar oCal = Calendar.getInstance();
        StringBuffer strReqId = new StringBuffer();
        strReqId.append(oCal.get(10));
        strReqId.append(oCal.get(12));
        strReqId.append(oCal.get(13));
        this.m_iRequestId = Integer.parseInt(strReqId.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewFile(String strSourceFilePath, boolean bClientOpenfrmTopo) {
        this.generateRequestId();
        this.m_bClinetOpenFrmTopo = bClientOpenfrmTopo;
        this.m_strDestinationPath = this.getnerateDestinationPath();
        if (!this.checkIfFileExist(strSourceFilePath)) {
            return;
        }
        ClientFileOperations oClientFileOperation = new ClientFileOperations();
        SystemManager oSystemInfo = new SystemManager();
        this.m_strRootDir = oSystemInfo.getSystemRootDirectory();
        int iFileIndex = this.m_strRootDir.length();
        int iIndex = (strSourceFilePath = strSourceFilePath.substring(iFileIndex)).lastIndexOf("/");
        if (-1 != iIndex) {
            this.m_strFileName = strSourceFilePath.substring(iIndex + 1);
        }
        strSourceFilePath = FileUtil.getUnifyPath(strSourceFilePath);
        this.m_strDestinationPath = FileUtil.getUnifyPath(this.m_strDestinationPath);
        oClientFileOperation.getFileFromServer(strSourceFilePath, this.m_strDestinationPath, this.m_iRequestId, 7);
        Object object = this.m_oSyncObj;
        synchronized (object) {
            try {
                this.m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                this.handleOperation();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private void handleOperation() {
        DCFrameWorkUtil.defaultCursor();
        if (this.m_iRequestId != this.m_iNotifiedRequestId) {
            this.cleanup();
            return;
        }
        if (0 == this.m_iErrorCode) {
            this.displayFile();
        } else {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_iErrorCode, ResourceManager.getInstance().getResString("BACKUP_FILES_SFTP_ERROR"), 0);
            File oDeleteTempFilePath = new File(this.m_strDestinationPath);
            this.deleteTempDirectory(oDeleteTempFilePath);
        }
        this.cleanup();
    }

    private String getnerateDestinationPath() {
        String strDestinationPath = DCConstants.CLIENT_TEMP_DIRECTORY;
        strDestinationPath = strDestinationPath + "/temp";
        File oFile = new File(strDestinationPath = strDestinationPath + File.separator + this.getRandomNum());
        if (!oFile.mkdirs()) {
            DCDebugTracer.trace("DC::ViewFileFromTopo.getnerateDestinationPath(fail to make dir< " + oFile + ">)");
        }
        return strDestinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAll(int iErrorCode, int iRequestId) {
        this.m_iNotifiedRequestId = iRequestId;
        this.m_iErrorCode = iErrorCode;
        Object object = this.m_oSyncObj;
        synchronized (object) {
            this.m_oSyncObj.notifyAll();
        }
    }

    private void cleanup() {
        if (this.m_bClinetOpenFrmTopo) {
            DCFrameWorkUtil.shutDown();
        }
    }

    private void displayFile() {
        try {
            String strDisplayFilePath = this.m_strDestinationPath + File.separator + this.m_strFileName;
            strDisplayFilePath = this.checkIfFileIsZipFile(strDisplayFilePath);
            new BackupFileContentDlg(strDisplayFilePath, false, -1);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        File oDeleteTempFilePath = new File(this.m_strDestinationPath);
        this.deleteTempDirectory(oDeleteTempFilePath);
    }

    private String checkIfFileIsZipFile(String strDestinationPath) {
        if (strDestinationPath.endsWith("zip")) {
            File oFile = FileOperationUtils.unZipFile(strDestinationPath);
            strDestinationPath = oFile.toString();
        }
        return strDestinationPath;
    }

    private boolean deleteTempDirectory(File oFilepath) {
        boolean isDelete;
        block6: {
            if (oFilepath.exists()) {
                try {
                    File[] arrfiles = oFilepath.listFiles();
                    for (int i = 0; i < arrfiles.length; ++i) {
                        if (arrfiles[i].isDirectory()) {
                            this.deleteTempDirectory(arrfiles[i]);
                            continue;
                        }
                        if (arrfiles[i].delete()) continue;
                        DCDebugTracer.trace("DC::ViewFileFromTopo.deleteTempDirectory(fail to delete " + arrfiles[i] + ")");
                    }
                }
                catch (Exception e) {
                    if (oFilepath.delete()) break block6;
                    DCDebugTracer.trace("DC::ViewFileFromTopo.deleteTempDirectory(fail to delete " + oFilepath + ")");
                }
            }
        }
        if (!(isDelete = oFilepath.delete())) {
            DCDebugTracer.trace("DC::ViewFileFromTopo.deleteTempDirectory(fail to delete " + oFilepath + ")");
        }
        return isDelete;
    }

    private boolean checkIfFileExist(String strPaths) {
        ClientFileOperations oClientFileOperation = new ClientFileOperations();
        SystemManager oSystemInfo = new SystemManager();
        this.m_strRootDir = oSystemInfo.getSystemServerFTPRoot();
        int iFileIndex = this.m_strRootDir.length();
        String strPath = strPaths.substring(iFileIndex);
        if (strPath.startsWith("/")) {
            strPath = strPath.substring(1);
        }
        IRequest oGetFileRequest = XFtpFileOperationFactory.createXFtpFileOperation(8, strPaths, "", oClientFileOperation);
        oGetFileRequest.createConnect();
        int iErrCode = oGetFileRequest.checkIfFileExists(strPath);
        oGetFileRequest.closeConnect();
        if (0 != iErrCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("COMPARE_DLG_INVALID_PATH"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            return false;
        }
        return true;
    }
}

