/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.dcmodule;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCLicenseInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnNMSServiceOperationRsp;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DevInfoSynMsgHelper;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.dcmodule.CompareFileFrmTopo;
import com.huawei.dc.common.dcmodule.ViewFileFromTopo;
import com.huawei.dc.common.framework.system.ProtocolStatus;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.configuration.servicemanagement.ServiceInfo;
import com.huawei.dc.configuration.servicemanagement.ServiceUtil;
import com.huawei.dc.configuration.system.SystemConfInfo;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.DeviceCommonManualOpr;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.StandAloneInitializer;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.u2000.framework.help.HelpUtil;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.LoadModuleFailedException;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.List;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class DataCenterModuleManagerHelper {
    public void stopStandaloneHedex() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("STANDALONE_EXIT_ROMPT_MSG"), ResourceManager.getInstance().getResString("ERROR"), 0);
                try {
                    DCFrameWorkUtil.waitCursor();
                    StandAloneInitializer.getInstance().shutdownStandAloneDC();
                    DCHelpManager.getInstance().stopHedExServer();
                    FrameworkCommandProcessor.getInstance().exitInstanceDirectly();
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
                finally {
                    DCFrameWorkUtil.defaultCursor();
                }
            }
        });
        thread.start();
    }

    public List<ServiceInfo> queryServiceInfoList() throws DCException {
        final AsnNMSServiceOperationRsp asnNMSServiceOperationRsp = new AsnNMSServiceOperationRsp();
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44036), null, (FStruct)asnNMSServiceOperationRsp);
                return iErrorCode;
            }
        };
        int iErrorCode = 0;
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = asnNMSServiceOperationRsp.iErrCode.intValue();
        if (iErrorCode != 0) {
            DCDebugTracer.trace("asnNMSServiceOperationRsp.oErrorInfo.iErrorNo:" + iErrorCode);
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        List<ServiceInfo> oserviceInfoList = ServiceUtil.getServiceListFromAsn(asnNMSServiceOperationRsp.oAsnNMSServiceList);
        return oserviceInfoList;
    }

    private void controlShowSystemProtocolTime() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            boolean hasModalDialogs = DCFrameWorkUtil.hasOpenModalDialog();
            while (hasModalDialogs) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ignore) {
                    DCDebugTracer.trace(ignore);
                }
                hasModalDialogs = DCFrameWorkUtil.hasOpenModalDialog();
            }
        }
    }

    public void initSystemProtocolStatus() {
        this.controlShowSystemProtocolTime();
        try {
            final ProtocolStatus protocol = ProtocolStatus.getInstance();
            SystemConfInfo oSysConInfo = protocol.getSystemConfInfo();
            if (null != oSysConInfo) {
                DCDebugTracer.trace("FTP setting status : " + oSysConInfo.isConfig());
            }
            if (null != oSysConInfo && oSysConInfo.isConfig()) {
                protocol.fileTransferStatusResult(oSysConInfo.getMessaseCode());
            } else if (DCFrameWorkUtil.getIsSingleClient()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("MSG_CONFIRM_SYSTEMINFO"), ResourceManager.getInstance().getResString("INFO"), 1);
                        SystemSettingDlg oSystemSettingDlg = new SystemSettingDlg();
                        oSystemSettingDlg.setApplyButtonEnable(true);
                        oSystemSettingDlg.setVisible(true);
                        try {
                            protocol.checkFileTransferStatus(false);
                        }
                        catch (DCException e) {
                            DCDebugTracer.trace(e);
                        }
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SYSTEM_CONFIG_INCORRECT"), ResourceManager.getInstance().getResString("INFO"), 1);
                        SystemSettingDlg oSystemSettingDlg = new SystemSettingDlg();
                        oSystemSettingDlg.setApplyButtonEnable(true);
                        oSystemSettingDlg.setVisible(true);
                        try {
                            protocol.checkFileTransferStatus(false);
                        }
                        catch (Exception e) {
                            DCDebugTracer.trace(e);
                        }
                    }
                });
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        DCFrameWorkUtil.defaultCursor();
        final DeviceTablePanel oDeviceTablePanel = DCFrameWorkUtil.getDeviceTablePanel();
        if (null != oDeviceTablePanel) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oDeviceTablePanel.requestFocusInWindow();
                }
            });
        }
    }

    public DeviceInfo[] getDeviceInfoFromMessage(InternalLocalMsg oInternalmsg) {
        List oDevInfoLst = (List)oInternalmsg.data;
        int iSizeOfLst = oDevInfoLst.size();
        DeviceInfo[] oTempDevInfos = new DeviceInfo[iSizeOfLst];
        int[] arrDevId = new int[iSizeOfLst];
        for (int i = 0; i < iSizeOfLst; ++i) {
            oTempDevInfos[i] = new DeviceInfo();
            Object[] oDevInfo = (Object[])oDevInfoLst.get(i);
            arrDevId[i] = (Integer)oDevInfo[1];
        }
        try {
            oTempDevInfos = DevInfoSynMsgHelper.getDevInfoByAppointedDevIds(arrDevId);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        return oTempDevInfos;
    }

    public void backupOperation(InternalLocalMsg oInternalmsg) {
        DeviceInfo[] arrDeviceInfo = this.getDeviceInfoFromMessage(oInternalmsg);
        this.openBackupDlg(arrDeviceInfo);
    }

    public void openBackupDlg(DeviceInfo[] arrDeviceInfo) {
        if (null == arrDeviceInfo || 0 >= arrDeviceInfo.length) {
            return;
        }
        DeviceCommonManualOpr oDevCommonManualOpr = new DeviceCommonManualOpr(null);
        oDevCommonManualOpr.backup(arrDeviceInfo);
    }

    public void backupOperationByBlock(InternalLocalMsg oInternalmsg) {
        DeviceInfo[] arrDeviceInfo = this.getDeviceInfoFromMessage(oInternalmsg);
        this.openBackupDlgByBlock(arrDeviceInfo, oInternalmsg);
    }

    public void openBackupDlgByBlock(DeviceInfo[] arrDeviceInfo, InternalLocalMsg oInternalmsg) {
        if (null == arrDeviceInfo || 0 >= arrDeviceInfo.length) {
            return;
        }
        DeviceCommonManualOpr oDevCommonManualOpr = new DeviceCommonManualOpr(null);
        oDevCommonManualOpr.backupByBlock(arrDeviceInfo, oInternalmsg);
    }

    public void recoverOperation(InternalLocalMsg oInternalmsg) {
        DeviceInfo[] oarrDeviceInfo = this.getDeviceInfoFromMessage(oInternalmsg);
        this.openRecoverDlg(oarrDeviceInfo);
    }

    public void openRecoverDlg(DeviceInfo[] oarrDeviceInfo) {
        if (null == oarrDeviceInfo || 0 >= oarrDeviceInfo.length) {
            return;
        }
        DeviceCommonManualOpr oDevCommonManualOpr = new DeviceCommonManualOpr(null);
        oDevCommonManualOpr.recover(oarrDeviceInfo, false);
    }

    public void recoverOperationByBlock(InternalLocalMsg oInternalmsg) {
        DeviceInfo[] oarrDeviceInfo = this.getDeviceInfoFromMessage(oInternalmsg);
        this.openRecoverDlgByBlock(oarrDeviceInfo, oInternalmsg);
    }

    public void openRecoverDlgByBlock(DeviceInfo[] oarrDeviceInfo, InternalLocalMsg oInternalmsg) {
        if (null == oarrDeviceInfo || 0 >= oarrDeviceInfo.length) {
            return;
        }
        DeviceCommonManualOpr oDevCommonManualOpr = new DeviceCommonManualOpr(null);
        oDevCommonManualOpr.recoverByBlock(oarrDeviceInfo, false, oInternalmsg);
    }

    public void compareFile(final InternalLocalMsg oInternalmsg, final boolean bClientOpenFrmTopo) {
        new Thread(){

            @Override
            public void run() {
                String[] arrFilePaths = (String[])oInternalmsg.data;
                CompareFileFrmTopo.getInstance().cmpFilesFrmTopo(arrFilePaths, bClientOpenFrmTopo);
            }
        }.start();
    }

    public void viewFile(InternalLocalMsg oInternalmsg, boolean bClientOpenFrmTopo) {
        String oFilePath = (String)oInternalmsg.data;
        ViewFileFromTopo.getInstance().viewFile(oFilePath, bClientOpenFrmTopo);
    }

    public void startGetTaskListThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DeviceInfoManagerImpl.getInstance().getDeviceFromDCServerWithParent(3);
                if (!DeviceInfoManagerImpl.getInstance().isNeedToGotDeviceInfo()) {
                    TaskAsynCommController.getInstance().getTaskList();
                }
            }
        }).start();
    }

    public void initLicenseStatus() {
        SystemManager sysMgr = new SystemManager();
        AsnDCLicenseInfoRsp oAsnDCLIcense = sysMgr.getLicenseInformation();
        int iErrorCode = oAsnDCLIcense.oErrorNo.iErrorNo.intValue();
        if (0 == iErrorCode) {
            LicenseMonitor.getInstance().setiCurrStatus(1);
        } else {
            LicenseMonitor.getInstance().setiCurrStatus(0);
        }
        if (null != DCFrameWorkUtil.getTaskTableButtonPanel()) {
            DCFrameWorkUtil.getTaskTableButtonPanel().checkButtonsStatus();
        }
    }

    public boolean isDebugMode() {
        boolean bStandDebugMode = false;
        try {
            String strClientMode = ResourceManager.getInstance().getResString("DOMAIN_CONSTANT", "config");
            if (strClientMode.startsWith("SA")) {
                Object oDebugMode = DCFrameWorkUtil.getSystemProperty("DCStandaloneDebugMode");
                if (Boolean.TRUE.equals(oDebugMode)) {
                    bStandDebugMode = true;
                }
                FrameworkUtilities.getTerminalManager().removeTerminalSetting();
            }
        }
        catch (Exception oException) {
            throw new LoadModuleFailedException(ResourceManager.getInstance().getResString("DATACENTER_LOADING_FAILED"), ResourceManager.getInstance().getResString("DEVICE_TREE_PAN_ERROR"));
        }
        return bStandDebugMode;
    }

    public void initHedEx(boolean isStandalone, boolean isDebugMode) {
        if (isStandalone) {
            DCHelpManager oDCHelpManager = DCHelpManager.getInstance();
            if (!isDebugMode) {
                try {
                    oDCHelpManager.startHedExServer();
                    oDCHelpManager.setSystemProperty();
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            } else {
                try {
                    oDCHelpManager.setSystemProperty();
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
        } else if (DCFrameWorkUtil.isPluginMode()) {
            try {
                HelpUtil.initWebrenderer();
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }
    }
}

