/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.dcmodule;

import com.huawei.dc.common.dcmodule.DataCenterModuleForAppModule;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.onlineboard.DeviceBoardConfigEventReceiver;
import com.huawei.dc.toolkit.integration.TEToolkitModule;
import com.huawei.dfw.util.ThreadPool;
import com.huawei.u2000.framework.adaptive.AdaptiveUtil;
import com.huawei.u2000.framework.module.AbstractProductBaseModule;
import com.huawei.u2000.inf.unitedmgr.commissionguide.UMCommissionGuideInf;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import java.io.File;

public class DataCenterModuleForU2000
extends AbstractProductBaseModule {
    private DataCenterModuleManager m_oModuleManager = new DataCenterModuleManager((BaseModule)this);

    public DataCenterModuleForU2000(ModuleManager oModuleManager) {
        super(oModuleManager);
    }

    protected String getLicenseMappingFile() {
        DCDebugTracer.trace("[DC]getLicenseMappingFile " + System.currentTimeMillis());
        return null;
    }

    public void initializeProduct() {
        DCFrameWorkUtil.setInstallMode(1);
        long beginTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initializeStatusBar" + beginTime);
        long endTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initializeStatusBar Cost :" + (endTime - beginTime));
        this.m_oModuleManager.initializeDC(false);
    }

    public void showDeviceInfoPan() {
        if (DataCenterModuleForAppModule.getInstance().isComponentDisable("dc", 1)) {
            return;
        }
        DCDebugTracer.trace("Open showDeviceInfoPan");
        this.m_oModuleManager.showDeviceInfoPan();
    }

    public void taskManagement() {
        DCDebugTracer.trace("Open taskManagement");
        this.m_oModuleManager.taskManagement();
    }

    public void softwareArchiveManagement() {
        DCDebugTracer.trace("Open softwareArchiveManagement");
        this.m_oModuleManager.softwareArchiveManagement();
    }

    public void policyManagement() {
        DCDebugTracer.trace("Open policyManagement");
        this.m_oModuleManager.policyManagement();
    }

    public void displayOnlineBoard() {
        DCDebugTracer.trace("Open displayOnlineBoard");
        this.m_oModuleManager.displayOnlineBoard();
    }

    public void browseLog() {
        DCDebugTracer.trace("Open browseLog");
        this.m_oModuleManager.browseLog();
    }

    public void configureMXUUpgradePolicy() {
        DCDebugTracer.trace("Open configureMXUUpgradePolicy");
        this.m_oModuleManager.configureMXUUpgradePolicy(2);
    }

    public void systemSetting() {
        DCDebugTracer.trace("Open systemSetting");
        this.m_oModuleManager.systemSetting();
    }

    public void showFtpFrame() {
        DCDebugTracer.trace("Open showFtpFrame");
        this.m_oModuleManager.showFtpFrame();
    }

    public void importLicenseFile() {
        DCDebugTracer.trace("Open importLicenseFile");
        this.m_oModuleManager.importLicenseFile();
    }

    public void loadBoardSoft() {
        DCDebugTracer.trace("Open loadBoardSoft");
        this.m_oModuleManager.loadBoardSoft();
    }

    public void loadBoardPatch() {
        DCDebugTracer.trace("Open loadBoardPatch");
        this.m_oModuleManager.loadBoardPatch();
    }

    public void tkLicenseManage() {
        DCDebugTracer.trace("Open tkLicenseManage");
        this.m_oModuleManager.tkLicenseManage();
    }

    public void tkLogManage() {
        DCDebugTracer.trace("Open tkLogManage");
        this.m_oModuleManager.tkLogManage();
    }

    public void licenseInfo() {
        DCDebugTracer.trace("Open licenseInfo");
        this.m_oModuleManager.licenseInfo();
    }

    public void showTL1Frame() {
        DCDebugTracer.trace("Open showTL1Frame");
        this.m_oModuleManager.showTL1Frame();
    }

    public void refreshTree() {
        DCDebugTracer.trace("refreshTree");
        this.m_oModuleManager.refreshTree();
    }

    public Object processEvent(InternalLocalMsg oInternalmsg) {
        String strModuleId = oInternalmsg.sendModule;
        DCDebugTracer.trace("DC receive InternalLocalMsg moduleId=" + strModuleId + "|MsgID=" + oInternalmsg.ID);
        if (strModuleId.equalsIgnoreCase("DmsCASModule")) {
            this.m_oModuleManager.processChangeAuditModuleReq(oInternalmsg);
        } else if (strModuleId.equalsIgnoreCase("TunnelModule") || strModuleId.equalsIgnoreCase("MigrateModule")) {
            this.m_oModuleManager.processTopoModuleReq(oInternalmsg, true);
        } else if (strModuleId.equalsIgnoreCase("BMS_Global_Module") || strModuleId.equalsIgnoreCase("BMS_Device_Module")) {
            this.m_oModuleManager.processTopoModuleReq(oInternalmsg, false);
        } else if (strModuleId.equalsIgnoreCase("necommonmodule")) {
            this.m_oModuleManager.processDMSCommonModuleReq(oInternalmsg);
        } else if (strModuleId.equalsIgnoreCase("teCfgModule")) {
            this.m_oModuleManager.processT2000TraditionalModuleReq(oInternalmsg);
        } else {
            if (strModuleId.equalsIgnoreCase("routerdcn")) {
                InternalLocalMsg returnMsg = this.m_oModuleManager.sendBackupFileLstResponseToDMS(oInternalmsg);
                return returnMsg.data;
            }
            DCDebugTracer.trace("no Support msg:" + strModuleId);
        }
        return oInternalmsg.data;
    }

    public void stop() {
        DCDebugTracer.traceWarning("[DC-Exit] DataCenterModuleForU2000#stop start");
        if (!this.m_oModuleManager.isHaveOpenedDC()) {
            DCDebugTracer.trace("[DC-Exit] DataCenterModuleForU2000#not dc panel open.");
            DCFrameWorkUtil.stopShakeHand();
            DCFrameWorkUtil.shutDown();
            DCFrameWorkUtil.closeCommManager();
            TEToolkitModule.disposeComm();
        }
        try {
            DeviceBoardConfigEventReceiver devBdConfigEventReceiver = (DeviceBoardConfigEventReceiver)ObjectStore.getInstance().getObjectInstance("DeviceBoardConfigEventReceiver");
            if (null != devBdConfigEventReceiver) {
                devBdConfigEventReceiver.setToNULL();
            }
        }
        catch (Exception ignore) {
            DCDebugTracer.trace(ignore);
        }
        DCDebugTracer.traceWarning("[DC-Exit] DataCenterModuleForU2000#stop end");
    }

    public void serviceMangementAboutUpgrade() {
        DCDebugTracer.trace("Open serviceMangementAboutUpgrade");
        this.m_oModuleManager.serviceMangementAboutUpgrade();
    }

    protected void postProductSystemLoadingFinished() {
        long beginTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initialize UMCommissionGuideInf" + beginTime);
        if (!DCFrameWorkUtil.getIsSingleClient() && AdaptiveUtil.isSubsystemDeployed((String)"trans_common")) {
            try {
                UMCommissionGuideInf guideInf = U2kModuleManagerFactory.getUMUnitedMgrModule().getUMCommissionGuideInf();
                guideInf.registerCommissionItemFile("dc/xml/guidetreedesc.xml");
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        }
        long endTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initialize UMCommissionGuideInf Cost :" + (endTime - beginTime));
        beginTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initialize WelcomeButton" + beginTime);
        try {
            this.mountWelcomeButton();
        }
        catch (Exception ex) {
            DCDebugTracer.trace("Failed to load Welcome Button, " + ex.toString());
            DCDebugTracer.trace(ex);
        }
        endTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initialize WelcomeButton Cost :" + (endTime - beginTime));
        beginTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initialize verifyPluginModeMenu" + beginTime);
        try {
            this.verifyPluginModeMenu();
        }
        catch (Exception ignore) {
            DCDebugTracer.trace("verifyPluginModeMenu failed");
            DCDebugTracer.trace(ignore);
        }
        endTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initialize verifyPluginModeMenu Cost :" + (endTime - beginTime));
        if (DCFrameWorkUtil.isPluginMode()) {
            class TmpThread
            implements Runnable {
                TmpThread() {
                }

                @Override
                public void run() {
                    DataCenterModuleForU2000.this.showDeviceInfoPan();
                }
            }
            ThreadPool.getInstance().execute((Runnable)new TmpThread());
        }
    }

    private void verifyPluginModeMenu() {
        DCDebugTracer.trace("DataCenterModuleForU2000#verifyPluginModeMenu start");
        if (!DCFrameWorkUtil.isPluginMode()) {
            DCDebugTracer.trace("DataCenterModuleForU2000#verifyPluginModeMenu end..");
            return;
        }
        Menu oDataCenterMenu = this.m_oModuleManager.getDataCenterMenu();
        if (!AdaptiveUtil.isSubsystemDeployed((String)"trans_common")) {
            oDataCenterMenu.removeMenuItem("OnlineBoardUpgrade");
            oDataCenterMenu.removeMenuItem("loadBoardSoft");
            oDataCenterMenu.removeMenuItem("loadBoardPatch");
            oDataCenterMenu.removeMenuItem("tkLicense");
            oDataCenterMenu.removeMenuItem("tkBacupLog");
            oDataCenterMenu.removeMenuItem("showTL1Frame");
        }
        if (!AdaptiveUtil.isSubsystemDeployed((String)"access") || !AdaptiveUtil.isSubsystemDeployed((String)"nemgr_router")) {
            oDataCenterMenu.removeMenuItem("MXUPolicy");
        }
        DCDebugTracer.trace("DataCenterModuleForU2000#verifyPluginModeMenu end..");
    }

    private void mountWelcomeButton() {
        String welcomeButtonConfigFilePath = "conf" + File.separator + "ext_2700_dc" + File.separator + "dynamicwelcomebutton";
        WelcomeManager.loadWelcomeButtons((String)welcomeButtonConfigFilePath, null);
        if (AdaptiveUtil.isSubsystemDeployed((String)"trans_common")) {
            String welcomeButton_t2000_ConfigFilePath = "conf" + File.separator + "ext_2700_dc" + File.separator + "dynamicwelcomebutton_t2000";
            WelcomeManager.loadWelcomeButtons((String)welcomeButton_t2000_ConfigFilePath, null);
        }
        if (AdaptiveUtil.isSubsystemDeployed((String)"nemgr_router")) {
            String welcomeButton_ip_access_ConfigFilePath = "conf" + File.separator + "ext_2700_dc" + File.separator + "dynamicwelcomebutton_ip_access";
            WelcomeManager.loadWelcomeButtons((String)welcomeButton_ip_access_ConfigFilePath, null);
        }
    }
}

