/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.dcmodule;

import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StatusBarTimeUpdater;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import javax.swing.JPanel;

public class DataCenterModule
extends BaseModule {
    private DataCenterModuleManager m_oModuleManager = new DataCenterModuleManager(this);

    public DataCenterModule(ModuleManager oModuleMgr) {
        super(oModuleMgr);
        DCFrameWorkUtil.setDCModuleManager(this.m_oModuleManager);
    }

    private void initializeStatusBar() {
        Object oStatusBar;
        try {
            oStatusBar = (StatusBarManager)this.m_oModuleManager.getModule("mainstatusbarmanager");
            oStatusBar.getStatusBarItem("SelectDomainInfo").refreshItem(this.getSelectedDomainName());
            StatusBarTimeUpdater oThread = new StatusBarTimeUpdater(oStatusBar.getStatusBarItem("loginTime"));
            oThread.start();
        }
        catch (ModuleManagementException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        oStatusBar = new JPanel();
        com.huawei.dc.common.util.StatusBarManager m_statusBarManager = new com.huawei.dc.common.util.StatusBarManager((JPanel)oStatusBar);
        m_statusBarManager.setIPAddress("127.0.0.1");
        DCFrameWorkUtil.setStatusBarManager(m_statusBarManager);
    }

    private String getSelectedDomainName() {
        String strShowInfo = ResourceManager.getInstance().getResString("STAND_ALONE_STATUS_BAR_INSTALL_MODE", new String[]{""});
        String[] strDomainName = new String[1];
        switch (StandAloneDomainInfo.getInstance().getSelectedDomain()) {
            case 2: {
                strDomainName[0] = ResourceManager.getInstance().getResString("ROUTER_DOMAIN_NAME");
                break;
            }
            case 3: {
                strDomainName[0] = ResourceManager.getInstance().getResString("ACCESS_DOMAIN_NAME");
                break;
            }
            case 4: {
                strDomainName[0] = ResourceManager.getInstance().getResString("OPTIX_DOMAIN_NAME");
                break;
            }
            default: {
                strDomainName[0] = ResourceManager.getInstance().getResString("OPTIX_DOMAIN_NAME");
            }
        }
        strShowInfo = ResourceManager.getInstance().getResString("STAND_ALONE_STATUS_BAR_INSTALL_MODE", strDomainName);
        return strShowInfo;
    }

    public void initialize() {
        long beginTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initializeStatusBar" + beginTime);
        this.initializeStatusBar();
        long endTime = System.currentTimeMillis();
        DCDebugTracer.trace("[DC]initializeStatusBar Cost :" + (endTime - beginTime));
        this.m_oModuleManager.initializeDC(true);
    }

    public void showDeviceInfoPan() {
        this.m_oModuleManager.showDeviceInfoPan();
    }

    public void taskManagement() {
        this.m_oModuleManager.taskManagement();
    }

    public void softwareArchiveManagement() {
        this.m_oModuleManager.softwareArchiveManagement();
    }

    public void policyManagement() {
        this.m_oModuleManager.policyManagement();
    }

    public void displayOnlineBoard() {
        this.m_oModuleManager.displayOnlineBoard();
    }

    public void browseLog() {
        this.m_oModuleManager.browseLog();
    }

    public void configureMXUUpgradePolicy() {
        this.m_oModuleManager.configureMXUUpgradePolicy(2);
    }

    public void systemSetting() {
        this.m_oModuleManager.systemSetting();
    }

    public void showFtpFrame() {
        this.m_oModuleManager.showFtpFrame();
    }

    public void importLicenseFile() {
        this.m_oModuleManager.importLicenseFile();
    }

    public void loadBoardSoft() {
        this.m_oModuleManager.loadBoardSoft();
    }

    public void loadBoardPatch() {
        this.m_oModuleManager.loadBoardPatch();
    }

    public void tkLicenseManage() {
        this.m_oModuleManager.tkLicenseManage();
    }

    public void tkLogManage() {
        this.m_oModuleManager.tkLogManage();
    }

    public void showTL1Frame() {
        this.m_oModuleManager.showTL1Frame();
    }

    public void licenseInfo() {
        this.m_oModuleManager.licenseInfo();
    }

    public void addNewProxyNode() {
        this.m_oModuleManager.addNewProxyNode();
    }

    public void addDevices() {
        this.m_oModuleManager.addDevices();
    }

    public void addOffLineDevices() {
        this.m_oModuleManager.addOffLineDevices();
    }

    public void searchDevice() {
        this.m_oModuleManager.searchDevice();
    }

    public void modifyDevice() {
        this.m_oModuleManager.modifyDevice();
    }

    public void deleteDevices() {
        this.m_oModuleManager.deleteDevices();
    }

    public void importDevices() {
        this.m_oModuleManager.importDevices();
    }

    public void exportDevices() {
        this.m_oModuleManager.exportDevices();
    }

    public void exportDevicesTemplate() {
        this.m_oModuleManager.exportDevicesTemplate();
    }

    public void exportCheckItemTemp() {
        this.m_oModuleManager.exportCheckItemTemp();
    }

    public void exitSystem() {
        this.m_oModuleManager.exitSystem();
    }

    public void deviceAccessProtocol() {
        this.m_oModuleManager.deviceAccessProtocol();
    }

    public void refreshTree() {
        this.m_oModuleManager.refreshTree();
    }

    public void selectDomain() {
        this.m_oModuleManager.selectDomain();
    }

    public void modifyUserPassword() {
        this.m_oModuleManager.modifyUserPassword();
    }

    public void importNeTypeFile() {
        this.m_oModuleManager.importNeTypeFile();
    }

    public Object processEvent(InternalLocalMsg oInternalmsg) {
        String strModuleId = oInternalmsg.sendModule;
        if (strModuleId.equalsIgnoreCase("DmsCASModule")) {
            this.m_oModuleManager.processChangeAuditModuleReq(oInternalmsg);
        } else if (strModuleId.equalsIgnoreCase("BMS_Phyres_Module")) {
            this.m_oModuleManager.processTopoModuleReq(oInternalmsg, false);
        } else if (strModuleId.equalsIgnoreCase("necommonmodule")) {
            this.m_oModuleManager.processDMSCommonModuleReq(oInternalmsg);
        }
        return oInternalmsg.data;
    }

    public void stop() {
        DCDebugTracer.trace("standalone stop");
    }
}

