/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.dcmodule;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileOperationUtils;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.compare.CompareFileDialog;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFilesProgressDlg;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IProgressbarNotification;
import com.huawei.dc.framework.ClientFileOperations;
import com.huawei.dc.framework.IRequest;
import com.huawei.dc.framework.XFtpFileOperationFactory;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Calendar;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class CompareFileFrmTopo
implements IProgressbarNotification {
    private static CompareFileFrmTopo m_oCmpFileFrmTopo = null;
    private static ProgressBar m_oProgressbar = null;
    private static BackupFilesProgressDlg m_oprogressDlg = null;
    private String[] m_arrDestinationPath = new String[2];
    private String[] m_arrDestiFullFilePath = new String[2];
    private String[] m_arrSourcePath = null;
    private int m_iRequestId = -1;
    private String m_strRootDir = null;
    private Object m_oSyncObj = new Object();
    private boolean m_bIsSecondFile = false;
    private String m_strFileName = null;
    private boolean m_bIsClientOpenFrmTopo = false;
    private int m_iNotifiedRequestId = -1;
    private int m_iErrorCode = -1;
    private volatile boolean m_bThreadStop = false;
    private SecureRandom random = new SecureRandom();

    private CompareFileFrmTopo() {
    }

    public static CompareFileFrmTopo getInstance() {
        if (null == m_oCmpFileFrmTopo) {
            m_oCmpFileFrmTopo = new CompareFileFrmTopo();
        }
        return m_oCmpFileFrmTopo;
    }

    private double getRandomNum() {
        return this.random.nextDouble();
    }

    public static void setInstanceToNull() {
        m_oCmpFileFrmTopo = null;
    }

    public void cmpFilesFrmTopo(String[] arrFilePath, boolean bIsClientOpenfrmTopo) {
        this.openingProgressDlg();
        this.generateRequestId();
        this.m_bIsClientOpenFrmTopo = bIsClientOpenfrmTopo;
        this.m_arrSourcePath = arrFilePath;
        if (!this.checkIfFileExist(arrFilePath)) {
            this.getFileToTempFolder(this.m_arrSourcePath[0], false);
        }
    }

    private void generateRequestId() {
        Calendar oCal = Calendar.getInstance();
        StringBuffer strReqId = new StringBuffer();
        strReqId.append(oCal.get(10));
        strReqId.append(oCal.get(12));
        strReqId.append(oCal.get(13));
        this.m_iRequestId = Integer.parseInt(strReqId.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileToTempFolder(String strFilePath, boolean bIsSecondFile) {
        String strSourceFilePath = null;
        String strDestinationPath = null;
        this.m_bIsSecondFile = bIsSecondFile;
        if (!bIsSecondFile) {
            this.m_arrDestinationPath[0] = this.getnerateDestinationPath();
            strDestinationPath = this.m_arrDestinationPath[0];
            strSourceFilePath = this.m_arrSourcePath[0];
        } else {
            this.m_arrDestinationPath[1] = this.getnerateDestinationPath();
            strDestinationPath = this.m_arrDestinationPath[1];
            strSourceFilePath = this.m_arrSourcePath[1];
        }
        int iIndex = strSourceFilePath.lastIndexOf("/");
        if (-1 != iIndex) {
            this.m_strFileName = strSourceFilePath.substring(iIndex + 1);
        }
        ClientFileOperations oClientFileOperation = new ClientFileOperations();
        SystemManager oSystemInfo = new SystemManager();
        this.m_strRootDir = oSystemInfo.getSystemServerFTPRoot();
        int iFileIndex = this.m_strRootDir.length();
        if ((strSourceFilePath = strSourceFilePath.substring(iFileIndex)).startsWith("/")) {
            strSourceFilePath = strSourceFilePath.substring(1);
        }
        strSourceFilePath = FileUtil.getUnifyPath(strSourceFilePath);
        strDestinationPath = FileUtil.getUnifyPath(strDestinationPath);
        oClientFileOperation.getFileFromServer(strSourceFilePath, strDestinationPath, this.m_iRequestId, 8);
        Object object = this.m_oSyncObj;
        synchronized (object) {
            try {
                this.m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                this.handleNotification();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private String getnerateDestinationPath() {
        String strDestinationPath = DCConstants.CLIENT_TEMP_DIRECTORY;
        strDestinationPath = strDestinationPath + "/temp";
        File oFile = new File(strDestinationPath = strDestinationPath + File.separator + this.getRandomNum());
        if (!oFile.mkdirs()) {
            DCDebugTracer.trace("DC::CompareFileFrmTopo.getnerateDestinationPath(fail to make dir< " + oFile + ">)");
        }
        return strDestinationPath;
    }

    public void notifyAll(int iErrorCode, int iRequestId) {
        this.m_iNotifiedRequestId = iRequestId;
        this.m_iErrorCode = iErrorCode;
        this.notifySyncObject();
    }

    public void handleNotification() {
        if (this.m_iRequestId != this.m_iNotifiedRequestId) {
            this.cleanUp();
            return;
        }
        if (this.m_bIsSecondFile) {
            DCFrameWorkUtil.defaultCursor();
            if (0 == this.m_iErrorCode) {
                this.m_arrDestiFullFilePath[1] = this.m_arrDestinationPath[1] + File.separator + this.m_strFileName;
                m_oprogressDlg.dispose();
                this.m_bThreadStop = true;
                this.displayFiles();
            } else {
                m_oprogressDlg.dispose();
                this.m_bThreadStop = true;
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_iErrorCode, ResourceManager.getInstance().getResString("BACKUP_FILES_SFTP_ERROR"), 0);
                this.deleteDirectories();
            }
        } else if (0 == this.m_iErrorCode) {
            this.m_arrDestiFullFilePath[0] = this.m_arrDestinationPath[0] + File.separator + this.m_strFileName;
            this.m_arrDestiFullFilePath[0] = FileUtil.getUnifyPath(this.m_arrDestiFullFilePath[0]);
            this.m_arrSourcePath[1] = FileUtil.getUnifyPath(this.m_arrSourcePath[1]);
            this.getFileToTempFolder(this.m_arrSourcePath[1], true);
        } else {
            DCFrameWorkUtil.defaultCursor();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(this.m_iErrorCode), ResourceManager.getInstance().getResString("BACKUP_FILES_SFTP_ERROR"), 0);
            this.m_arrDestinationPath[0] = FileUtil.getUnifyPath(this.m_arrDestinationPath[0]);
            this.deleteTempDirectory(new File(this.m_arrDestinationPath[0]));
        }
        this.cleanUp();
    }

    private void cleanUp() {
        if (this.m_bIsClientOpenFrmTopo) {
            DCFrameWorkUtil.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySyncObject() {
        Object object = this.m_oSyncObj;
        synchronized (object) {
            this.m_oSyncObj.notifyAll();
        }
    }

    private void displayFiles() {
        CompareFileDialog oComparedialog = new CompareFileDialog((Frame)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("COMPARE_DLG_TITLE"), true);
        this.m_arrDestiFullFilePath[0] = this.checkIfFileIsZipFile(this.m_arrDestiFullFilePath[0]);
        this.m_arrDestiFullFilePath[1] = this.checkIfFileIsZipFile(this.m_arrDestiFullFilePath[1]);
        this.m_arrDestiFullFilePath[0] = FileUtil.getUnifyPath(this.m_arrDestiFullFilePath[0]);
        this.m_arrDestiFullFilePath[1] = FileUtil.getUnifyPath(this.m_arrDestiFullFilePath[1]);
        if (0 == oComparedialog.setFilePath(this.m_arrDestiFullFilePath[0], this.m_arrDestiFullFilePath[1])) {
            oComparedialog.setVisible(true);
        } else {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("COMPARE_DLG_INVALID_PATH"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
        }
        this.deleteDirectories();
    }

    private void deleteDirectories() {
        for (int i = 0; i < this.m_arrDestinationPath.length; ++i) {
            File oDeleteTempFilePath = new File(this.m_arrDestinationPath[i]);
            this.deleteTempDirectory(oDeleteTempFilePath);
        }
    }

    private String checkIfFileIsZipFile(String strDestinationPath) {
        if (strDestinationPath.endsWith("zip")) {
            File oFile = FileOperationUtils.unZipFile(strDestinationPath);
            strDestinationPath = oFile.toString();
        }
        return strDestinationPath;
    }

    private boolean deleteTempDirectory(File oFilepath) {
        block5: {
            if (oFilepath.exists()) {
                try {
                    File[] arrfiles = oFilepath.listFiles();
                    for (int i = 0; i < arrfiles.length; ++i) {
                        if (arrfiles[i].isDirectory()) {
                            this.deleteTempDirectory(arrfiles[i]);
                            continue;
                        }
                        if (arrfiles[i].delete()) continue;
                        DCDebugTracer.trace("DC::CompareFileFrmTopo.deleteTempDirectory(fail to delete " + arrfiles[i] + ")");
                    }
                }
                catch (Exception e) {
                    if (oFilepath.delete()) break block5;
                    DCDebugTracer.trace("DC::CompareFileFrmTopo.deleteTempDirectory(fail to delete " + oFilepath + ")");
                }
            }
        }
        return oFilepath.delete();
    }

    @Override
    public void operationCancelled() {
    }

    public void openingProgressDlg() {
        m_oprogressDlg = new BackupFilesProgressDlg(this);
        m_oprogressDlg.setTitle(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        m_oprogressDlg.setInfomation(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        m_oProgressbar = new ProgressBar(m_oprogressDlg.getProgressBar());
        m_oProgressbar.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                m_oprogressDlg.setVisible(true);
            }
        });
    }

    private boolean checkIfFileExist(String[] strPaths) {
        ClientFileOperations oClientFileOperation = new ClientFileOperations();
        SystemManager oSystemInfo = new SystemManager();
        this.m_strRootDir = oSystemInfo.getSystemServerFTPRoot();
        int iFileIndex = this.m_strRootDir.length();
        boolean isExist = false;
        for (int i = 0; i < strPaths.length; ++i) {
            String strPath = strPaths[i].substring(iFileIndex);
            IRequest oGetFileRequest = XFtpFileOperationFactory.createXFtpFileOperation(8, strPaths[i], "", oClientFileOperation);
            oGetFileRequest.createConnect();
            int iErrCode = oGetFileRequest.checkIfFileExists(strPath);
            oGetFileRequest.closeConnect();
            if (0 == iErrCode) continue;
            isExist = true;
            break;
        }
        if (isExist) {
            m_oprogressDlg.dispose();
            this.m_bThreadStop = true;
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("COMPARE_DLG_INVALID_PATH"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            return isExist;
        }
        return isExist;
    }

    public class ProgressBar
    extends Thread {
        private static final int TIMEOUT = 80;
        private static final int MILLISECONDS = 6000;
        private static final int MAXVALUE = 100;
        private static final int DELAY = 4800;
        private JProgressBar oProgressBar;

        public ProgressBar(JProgressBar bar) {
            this.oProgressBar = bar;
        }

        @Override
        public void run() {
            int minimum = this.oProgressBar.getMinimum();
            int maximum = this.oProgressBar.getMaximum();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (CompareFileFrmTopo.this.m_bThreadStop) {
                        return;
                    }
                    int value = ProgressBar.this.oProgressBar.getValue();
                    ProgressBar.this.oProgressBar.setValue(value + 1);
                }
            };
            try {
                for (int i = minimum; i < maximum; ++i) {
                    SwingUtilities.invokeAndWait(runner);
                    if (!CompareFileFrmTopo.this.m_bThreadStop) {
                        Thread.sleep(4800L);
                        if (maximum - 1 != i || CompareFileFrmTopo.this.m_bThreadStop) continue;
                        m_oprogressDlg.setVisible(false);
                        m_oprogressDlg.dispose();
                        CompareFileFrmTopo.this.m_iRequestId = -1;
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATION_TIME_OUT"), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                        continue;
                    }
                    return;
                }
            }
            catch (InterruptedException ignoredException) {
                return;
            }
            catch (InvocationTargetException ignoredException) {
                return;
            }
        }
    }
}

