/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCMxUWithOLT;
import com.huawei.dc.common.asndatacenter.AsnDCMxUWithOLTList;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfo;
import com.huawei.dc.common.asndatacenter.AsnGetOLTIDByMxUIDReq;
import com.huawei.dc.common.asndatacenter.AsnGetOLTIDByMxUIDRsp;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIterator;
import java.awt.Component;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.commustru.fstru.FStruct;

public final class SubMapInfoHelper {
    private SubMapInfoHelper() {
    }

    public static SubMapInfo transeAsn2SubMapInfo(AsnDCSubMapInfo oAsnDCSubMapInfo) {
        SubMapInfo oSubMapInfo = new SubMapInfo();
        oSubMapInfo.m_iSubMapTypeID = oAsnDCSubMapInfo.iSubMapTypeID.intValue();
        oSubMapInfo.m_strSubMapID = new String(oAsnDCSubMapInfo.strSubMapID);
        oSubMapInfo.m_strSubMapDN = new String(oAsnDCSubMapInfo.strSubMapDN);
        oSubMapInfo.m_strSubMapName = new String(oAsnDCSubMapInfo.strSubMapName);
        oSubMapInfo.m_strParentSubMapID = null == oAsnDCSubMapInfo.strParentSubMapID ? "" : new String(oAsnDCSubMapInfo.strParentSubMapID);
        oSubMapInfo.m_oSubMapDevIDLst = SubMapInfoHelper.transe2List(oAsnDCSubMapInfo.oDeviceIDLst);
        return oSubMapInfo;
    }

    public static TIntHashSet transe2List(AsnDCIntegerLst oDeviceIDLst) {
        TIntHashSet devIDLinkedLst = new TIntHashSet();
        if (null == oDeviceIDLst) {
            return devIDLinkedLst;
        }
        int iDevID = -1;
        for (int i = 0; i < oDeviceIDLst.size(); ++i) {
            iDevID = ((BigInteger)oDeviceIDLst.get(i)).intValue();
            if (devIDLinkedLst.contains(iDevID)) continue;
            devIDLinkedLst.add(iDevID);
        }
        return devIDLinkedLst;
    }

    public static TIntIntHashMap getOLTNEIDWithMXUID(final AsnGetOLTIDByMxUIDReq oAsnGetOLTIDByMxUIDReq, TIntIntHashMap oOLTIDWithMXUIDMap) throws DCException {
        DCDebugTracer.trace("Method getOLTNEIDWithMXUID start");
        final AsnGetOLTIDByMxUIDRsp oAsnGetOLTIDByMxUIDRsp = new AsnGetOLTIDByMxUIDRsp();
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44078), (FStruct)oAsnGetOLTIDByMxUIDReq, (FStruct)oAsnGetOLTIDByMxUIDRsp);
                return iErrorCode;
            }
        };
        int iErrorCode = 0;
        DCDebugTracer.trace("send request to server for GET_OLTID_BY_MXU");
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCDebugTracer.trace("get response from server for GET_OLTID_BY_MXU");
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            DCDebugTracer.trace("Send request failed for GET_OLTID_BY_MXU");
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        iErrorCode = oAsnGetOLTIDByMxUIDRsp.result.intValue();
        if (iErrorCode != 0) {
            String strMessage = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
            throw new DCException(iErrorCode, strMessage);
        }
        AsnDCMxUWithOLTList oAsnMxUWithOLTList = oAsnGetOLTIDByMxUIDRsp.oMxUWithOLTList;
        for (int i = 0; i < oAsnMxUWithOLTList.size(); ++i) {
            AsnDCMxUWithOLT oAsnMxUWithOLT = (AsnDCMxUWithOLT)oAsnMxUWithOLTList.get(i);
            if (oOLTIDWithMXUIDMap.contains(oAsnMxUWithOLT.iMxUID.intValue())) continue;
            oOLTIDWithMXUIDMap.put(oAsnMxUWithOLT.iMxUID.intValue(), oAsnMxUWithOLT.iOLTID.intValue());
        }
        DCDebugTracer.trace("Method getOLTNEIDWithMXUID end");
        return oOLTIDWithMXUIDMap;
    }

    static Set<Integer> getDeviIDRecursivelyInSubMap(SubMapInfo oSubMapInfo) {
        HashSet<Integer> oDeviceList = new HashSet<Integer>(0);
        if (null == oSubMapInfo) {
            return oDeviceList;
        }
        if (null != oSubMapInfo.m_SubMapList) {
            int iSubMapCount = oSubMapInfo.m_SubMapList.size();
            for (int i = 0; i < iSubMapCount; ++i) {
                SubMapInfo oChildSubMap = oSubMapInfo.m_SubMapList.get(i);
                oDeviceList.addAll(SubMapInfoHelper.getDeviIDRecursivelyInSubMap(oChildSubMap));
            }
        }
        oDeviceList.addAll(SubMapInfoHelper.getDevicesInSubMap(oSubMapInfo));
        return oDeviceList;
    }

    static Set<Integer> getDevicesInSubMap(SubMapInfo oSubMapInfo) {
        HashSet<Integer> oDeviceList = new HashSet<Integer>(0);
        if (null == oSubMapInfo) {
            return oDeviceList;
        }
        TIntIterator oDevItor = oSubMapInfo.m_oSubMapDevIDLst.iterator();
        int iDevID = -1;
        while (oDevItor.hasNext()) {
            iDevID = oDevItor.next();
            if (iDevID == -1) continue;
            oDeviceList.add(iDevID);
        }
        return oDeviceList;
    }

    static boolean isDevicePresentInSubMap(int iDeviceID, SubMapInfo oSubMapInfo) {
        if (oSubMapInfo.m_oSubMapDevIDLst.contains(iDeviceID)) {
            return true;
        }
        if (null == oSubMapInfo.m_SubMapList) {
            return false;
        }
        int iSubMapCount = oSubMapInfo.m_SubMapList.size();
        for (int i = 0; i < iSubMapCount; ++i) {
            SubMapInfo oChildSubMap = oSubMapInfo.m_SubMapList.get(i);
            boolean bDeviceInChildSubMap = SubMapInfoHelper.isDevicePresentInSubMap(iDeviceID, oChildSubMap);
            if (!bDeviceInChildSubMap) continue;
            return true;
        }
        return false;
    }

    static SubMapInfo getParentSubmap(SubMapInfo oRootSubmap, SubMapInfo oChildSubmap) {
        if (null == oChildSubmap || "HWMAP_PHY_SUBMAP".equalsIgnoreCase(oChildSubmap.m_strSubMapID)) {
            return null;
        }
        if (null == oRootSubmap || null == oRootSubmap.m_SubMapList) {
            return null;
        }
        if (oRootSubmap.m_SubMapList.contains(oChildSubmap)) {
            return oRootSubmap;
        }
        int iChildCount = oRootSubmap.m_SubMapList.size();
        SubMapInfo oParentSubmap = null;
        for (int i = 0; i < iChildCount; ++i) {
            oParentSubmap = SubMapInfoHelper.getParentSubmap(oRootSubmap.m_SubMapList.get(i), oChildSubmap);
            if (null == oParentSubmap) continue;
            return oParentSubmap;
        }
        return null;
    }

    static SubMapInfo getSubmapForID(String strSubMapID, SubMapInfo oMainSubMap) {
        if (null == oMainSubMap || null == strSubMapID) {
            return null;
        }
        if (strSubMapID.equals(oMainSubMap.m_strSubMapID)) {
            return oMainSubMap;
        }
        if (0 == oMainSubMap.m_SubMapList.size()) {
            return null;
        }
        Iterator oSubMapIterator = oMainSubMap.m_SubMapList.iterator();
        SubMapInfo oSubMapInfo = null;
        while (oSubMapIterator.hasNext()) {
            oSubMapInfo = SubMapInfoHelper.getSubmapForID(strSubMapID, (SubMapInfo)oSubMapIterator.next());
            if (null == oSubMapInfo) continue;
            return oSubMapInfo;
        }
        return null;
    }

    static SubMapInfo getSubMapInfoByDevID(SubMapInfo subMapInfo, int devID) {
        SubMapInfo rtnSubMapInfo = new SubMapInfo();
        boolean isExist = false;
        TIntIterator oDevIDItor = subMapInfo.m_oSubMapDevIDLst.iterator();
        int iDevID = -1;
        while (oDevIDItor.hasNext()) {
            iDevID = oDevIDItor.next();
            if (iDevID != devID) continue;
            isExist = true;
            break;
        }
        if (isExist) {
            return subMapInfo;
        }
        int mapLstSize = subMapInfo.m_SubMapList.size();
        SubMapInfo tmpSubMap = null;
        for (int i = 0; i < mapLstSize; ++i) {
            tmpSubMap = subMapInfo.m_SubMapList.get(i);
            rtnSubMapInfo = SubMapInfoHelper.getSubMapInfoByDevID(tmpSubMap, devID);
            if (null != rtnSubMapInfo.m_strSubMapID && null != rtnSubMapInfo.m_strSubMapName) break;
        }
        return rtnSubMapInfo;
    }

    static void deleteDevSubMapInfo(int iDeleteDeviceId, SubMapInfo subMapInfo) {
        if (null == subMapInfo) {
            return;
        }
        boolean m_bDeviceFound = false;
        TIntHashSet devIDLst = subMapInfo.m_oSubMapDevIDLst;
        if (null != devIDLst && 0 != devIDLst.size()) {
            TIntIterator oDevIDItor = devIDLst.iterator();
            int iDevID = -1;
            while (oDevIDItor.hasNext()) {
                iDevID = oDevIDItor.next();
                if (iDeleteDeviceId != iDevID) continue;
                m_bDeviceFound = true;
                oDevIDItor.remove();
                break;
            }
            if (!m_bDeviceFound) {
                int iNextLevelSubMap = subMapInfo.m_SubMapList.size();
                for (int j = 0; j < iNextLevelSubMap; ++j) {
                    if (m_bDeviceFound) continue;
                    SubMapInfoHelper.deleteDevSubMapInfo(iDeleteDeviceId, subMapInfo.m_SubMapList.get(j));
                }
            }
        }
    }

    public static SubMapInfo fillSubMapInfoList(SubMapInfo subMapInfo, AsnDCSubMapInfo asnDCSubMapInfo) {
        SubMapInfo nextSubMapInfo = null;
        if (null != asnDCSubMapInfo && null != subMapInfo) {
            nextSubMapInfo = new SubMapInfo();
            nextSubMapInfo.m_strSubMapID = new String(asnDCSubMapInfo.strSubMapID);
            nextSubMapInfo.m_strSubMapName = new String(asnDCSubMapInfo.strSubMapName);
            subMapInfo.m_SubMapList.add(nextSubMapInfo);
        }
        return nextSubMapInfo;
    }

    public static String getLeafSubmapID(AsnDCSubMapInfo oAsnDCSubMapInfo) {
        AsnDCSubMapInfo oSubmapInfo = oAsnDCSubMapInfo;
        while (null != oSubmapInfo.oAsnDCSubMapInfoLst && oSubmapInfo.oAsnDCSubMapInfoLst.size() > 0) {
            oSubmapInfo = (AsnDCSubMapInfo)oSubmapInfo.oAsnDCSubMapInfoLst.get(0);
        }
        String submapID = new String(oSubmapInfo.strSubMapID);
        return submapID;
    }
}

