/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeleteFileInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceType;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceTypeLst;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceTypeLstRsp;
import com.huawei.dc.common.asndatacenter.AsnDCFrameList;
import com.huawei.dc.common.asndatacenter.AsnDCGetBoardsRes;
import com.huawei.dc.common.asndatacenter.AsnDCOSPFStatusNotify;
import com.huawei.dc.common.asndatacenter.AsnDCSWDLStatusNotify;
import com.huawei.dc.common.asndatacenter.AsnToleranceSearchRsp;
import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanel;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileListError;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.boardinfo.BoardInfoPanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.framework.StClientFileTransInfo;
import com.huawei.dc.framework.ThreadPool;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.sam.view.SeriesInfo;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.model.TaskMgmtOperationSelecModel;
import com.swimap.external.sm.adapter.message.EmfSecurityInterface;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.io.File;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public final class DeviceInfoManagerImplHelper {
    private static boolean m_bFirstStartDevInfoPanel = false;
    private static ArrayList<SeriesInfo> oSeriesInfos = new ArrayList();
    static AsnDCDeviceTypeLstRsp oDeviceTypeLstRsp = new AsnDCDeviceTypeLstRsp();

    public static void showErrorMessage(final int serverError) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(serverError), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        });
    }

    public static void refreshDevTablePanel(final int iSubMapType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != DCFrameWorkUtil.getDeviceTreePanel()) {
                    DeviceTablePanel oDevTablePanel = DCFrameWorkUtil.getDeviceTablePanel();
                    if (null != oDevTablePanel) {
                        oDevTablePanel.setNeedNotify(false);
                    }
                    DCFrameWorkUtil.getDeviceTreePanel().refreshDeviceTree(iSubMapType);
                    if (null != oDevTablePanel) {
                        oDevTablePanel.setNeedNotify(true);
                        oDevTablePanel.notifyEvent();
                        oDevTablePanel.refreshSelectedDevCountLabel();
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        DCDebugTracer.trace(e);
                    }
                    if (m_bFirstStartDevInfoPanel) {
                        m_bFirstStartDevInfoPanel = false;
                        DCFrameWorkUtil.getDeviceTablePanel().setAllColWidthInAppro();
                    }
                }
                DCFrameWorkUtil.defaultCursor();
            }
        });
    }

    public static HashMap<String, DeviceTypeInfo> getDeviceTypeFromDCServer(int iCmdCode, String strSupportDevTypes) throws DCException {
        AsnDCDeviceTypeLstRsp asnDeviceTypeLstRsp = new AsnDCDeviceTypeLstRsp();
        BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
        DCFrameWorkUtil.getCommManager();
        int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode), null, (FStruct)asnDeviceTypeLstRsp);
        if (errorcode != 0) {
            DCDebugTracer.trace("errorcode : " + errorcode);
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("GET_DEVICETYPE_INFO_ERROR"));
        }
        int serverError = asnDeviceTypeLstRsp.oErrorInfo.iErrorNo.intValue();
        if (serverError != 0) {
            DCDebugTracer.trace("serverError :" + errorcode);
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("GET_DEVICETYPE_INFO_ERROR"));
        }
        oDeviceTypeLstRsp = asnDeviceTypeLstRsp;
        AsnDCDeviceTypeLst asnDeviceTypeList = asnDeviceTypeLstRsp.oDeviceTypeLst;
        int length = null != asnDeviceTypeList ? asnDeviceTypeList.size() : 0;
        HashMap<String, DeviceTypeInfo> oDevTypeHm = new HashMap<String, DeviceTypeInfo>();
        String sKey = "";
        boolean bFound = false;
        for (int i = 0; i < length; ++i) {
            AsnDCDeviceType asnDeviceType;
            DeviceTypeInfo currDeviceTypeInfo;
            if (asnDeviceTypeList == null || (bFound = oDevTypeHm.containsKey(sKey = (currDeviceTypeInfo = DeviceInfoManagerImplHelper.getDeviceTypeFromAsn(asnDeviceType = (AsnDCDeviceType)asnDeviceTypeList.elementAt(i))).getDevTypeID() + "_" + currDeviceTypeInfo.getDevTypeVersionId()))) continue;
            if (currDeviceTypeInfo.getDevDomain() == 6) {
                currDeviceTypeInfo.setDevDomain(4);
            }
            DCDebugTracer.trace("DC::DeviceInfoManagerImplHelper#getDeviceTypeFromDCServer sKey:" + sKey);
            oDevTypeHm.put(sKey, currDeviceTypeInfo);
        }
        DCDebugTracer.trace("DC::DeviceInfoManagerImplHelper#getDeviceTypeFromDCServer-->DeviceSize::" + oDevTypeHm.size());
        DeviceInfoManagerImplHelper.getSupportedSeries();
        return oDevTypeHm;
    }

    public static void getSupportedSeries() {
        int i;
        AsnDCDeviceTypeLst asnDeviceTypeList = DeviceInfoManagerImplHelper.oDeviceTypeLstRsp.oDeviceTypeLst;
        int length = null != asnDeviceTypeList ? asnDeviceTypeList.size() : 0;
        DCDebugTracer.trace("DC::DeviceInfoManagerImplHelper#getDeviceTypeFromDCServer-->DeviceSize::" + length);
        ArrayList<String> strDevSerisLst = new ArrayList<String>();
        ArrayList<String> strDevTypeLst = new ArrayList<String>();
        int index = 0;
        for (i = 0; i < length; ++i) {
            if (null == asnDeviceTypeList) continue;
            AsnDCDeviceType asnDeviceType = (AsnDCDeviceType)asnDeviceTypeList.elementAt(i);
            if (null == asnDeviceType.strDevSeries) continue;
            String strDevSeries = new String(asnDeviceType.strDevSeries);
            DCDebugTracer.trace("DC::DeviceInfoManagerImplHelper#getDeviceTypeFromDCServer-->strDevSeries::" + strDevSeries);
            if (strDevSerisLst.size() > 0 && strDevSerisLst.contains(strDevSeries) || strDevSeries.length() <= 0) continue;
            strDevSerisLst.add(index++, strDevSeries);
        }
        DCDebugTracer.trace("DC::DeviceInfoManagerImplHelper#getDeviceTypeFromDCServer-->strDevSerisLst.size()::" + strDevSerisLst.size());
        int iSize = strDevSerisLst.size();
        for (i = 0; i < iSize; ++i) {
            String strDevSeris = (String)strDevSerisLst.get(i);
            strDevTypeLst.clear();
            int index2 = 0;
            for (int j = 0; j < length; ++j) {
                if (null == asnDeviceTypeList) continue;
                AsnDCDeviceType asnDeviceType = (AsnDCDeviceType)asnDeviceTypeList.elementAt(j);
                String strDevType = asnDeviceType.iDevTypeId.toString();
                String strDevSerisfromAsn = new String(asnDeviceType.strDevSeries);
                if (strDevTypeLst.size() > 0 && strDevTypeLst.contains(strDevType)) continue;
                DCDebugTracer.trace("DC::DeviceInfoManagerImplHelper#getDeviceTypeFromDCServer strDevSerisfromAsn:" + strDevSerisfromAsn);
                if (!strDevSeris.equals(strDevSerisfromAsn)) continue;
                strDevTypeLst.add(index2++, strDevType);
            }
            Object[] strDevTypeLstSort = new String[strDevTypeLst.size()];
            strDevTypeLst.toArray(strDevTypeLstSort);
            Arrays.sort(strDevTypeLstSort);
            SeriesInfo oSeriesInfo = new SeriesInfo(strDevSeris, (String[])strDevTypeLstSort);
            if (oSeriesInfos.contains(oSeriesInfo)) {
                oSeriesInfos.remove(oSeriesInfo);
            }
            DCDebugTracer.trace("DC::DeviceInfoManagerImplHelper#getDeviceTypeFromDCServer oSeriesInfo:" + oSeriesInfo);
            oSeriesInfos.add(i, oSeriesInfo);
        }
    }

    public static String[] getSupportDevTypeIDs(String sSeriesName) {
        for (int i = 0; i < oSeriesInfos.size(); ++i) {
            String strSeriesID;
            SeriesInfo oSeriesInfo = oSeriesInfos.get(i);
            if (null == oSeriesInfo || !(strSeriesID = oSeriesInfo.getSeriesName()).contains(sSeriesName)) continue;
            return oSeriesInfo.getDevTypes();
        }
        return null;
    }

    public static DeviceTypeInfo getDeviceTypeFromAsn(AsnDCDeviceType asnDCDeviceType) {
        DeviceTypeInfo deviceTypeInfo = new DeviceTypeInfo();
        deviceTypeInfo.setDevTypeID(asnDCDeviceType.iDevTypeId.intValue());
        deviceTypeInfo.setDevTypeName(new String(asnDCDeviceType.strDevTypeName));
        deviceTypeInfo.setDevTypeVersionId(asnDCDeviceType.iDevVersionId.intValue());
        deviceTypeInfo.setDevTypeVersionName(new String(asnDCDeviceType.strDevVersionName));
        deviceTypeInfo.setDeviceType(asnDCDeviceType.enSnmpType.value);
        deviceTypeInfo.setDevDomain(DeviceInfoManagerImplHelper.getDeviceDomain(asnDCDeviceType.enDeviceDomain.value));
        deviceTypeInfo.setIsMxuDevice(asnDCDeviceType.iType.intValue());
        DCDebugTracer.trace("DC::AsnDCDeviceType:: " + deviceTypeInfo);
        return deviceTypeInfo;
    }

    public static int getDeviceDomain(int iAsnDevDomain) {
        switch (iAsnDevDomain) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    public static boolean isSubmapManagable(SubMapInfo oSubMapInfo) {
        if (DCFrameWorkUtil.isShowSubMap()) {
            return true;
        }
        boolean result = false;
        try {
            EmfSecurityInterface securityInterface = (EmfSecurityInterface)DCFrameWorkUtil.getDCModuleManager().getModule("com.swimap.adapter.message.sm");
            result = securityInterface.isSubmapManagable(oSubMapInfo.m_strSubMapDN);
        }
        catch (ModuleManagementException e) {
            DCDebugTracer.trace((Exception)((Object)e));
            result = false;
        }
        DCDebugTracer.trace("isSubmapManagable=>  strSubmapDN : " + oSubMapInfo.m_strSubMapName + "->" + result);
        return result;
    }

    public static boolean isDeviceManagable(SubMapInfo oSubMapInfo, THashMap<Integer, DeviceInfo> m_oDevIdDevInfoMap) {
        if (DCFrameWorkUtil.isShowSubMap()) {
            return true;
        }
        boolean result = false;
        int devID2 = 0;
        DeviceInfo devInfo = null;
        try {
            TIntHashSet devIDLst = oSubMapInfo.getSubMapDevIDLst();
            for (int devID2 : devIDLst) {
                devInfo = DeviceInfoManagerImpl.getInstance().getDevice(devID2);
                if (devInfo == null || !m_oDevIdDevInfoMap.containsKey((Object)devID2)) continue;
                DCDebugTracer.trace("isDeviceManagable=>  DeviceID : " + devID2);
                result = true;
                break;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            result = false;
        }
        return result;
    }

    static void handleQueryFailedBoardResponse(MSGPacketExt packetExt) {
        final AsnToleranceSearchRsp oAsnToleranceSearchRsp = new AsnToleranceSearchRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnToleranceSearchRsp, packetExt.getData());
        DCDebugTracer.trace("DC::handleQueryFailedBoardResponse:begin");
        if (0 != iErrorCode) {
            DCDebugTracer.trace("iErrorCode :" + iErrorCode);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCFrameWorkUtil.getTaskTablePanel().handleQueryFailedBoardResponse(oAsnToleranceSearchRsp);
            }
        });
    }

    static void handleSWDLStatusResponse(MSGPacketExt packetExt) {
        AsnDCSWDLStatusNotify asnDCSWDLStatusNotify = new AsnDCSWDLStatusNotify();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnDCSWDLStatusNotify, packetExt.getData());
        DCDebugTracer.trace("oPacketExt.mheader.cmdCode :" + asnDCSWDLStatusNotify.toString());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("iErrorCode :" + iErrorCode);
            return;
        }
        int iTaskId = asnDCSWDLStatusNotify.iTaskID.intValue();
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        if (null != oTask) {
            if (IsolationCommonOperation.isIsolationTask(oTask.getTaskTypeId())) {
                DCFrameWorkUtil.getIsolationTaskInfoPanel().handleSWDLStatusResponse(asnDCSWDLStatusNotify);
            } else {
                DCFrameWorkUtil.getTaskTablePanel().handleSWDLStatusResponse(asnDCSWDLStatusNotify);
            }
        } else {
            DCFrameWorkUtil.getTaskTablePanel().handleSWDLStatusResponse(asnDCSWDLStatusNotify);
        }
    }

    static void handleOSPFStatusResponse(MSGPacketExt packetExt) {
        AsnDCOSPFStatusNotify asnDCOSPFStatusNotify = new AsnDCOSPFStatusNotify();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnDCOSPFStatusNotify, packetExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        DCFrameWorkUtil.getDeviceTablePanel().handleOSPFStatusResponse(asnDCOSPFStatusNotify);
    }

    static void getBoardInformation(MSGPacketExt packetExt, AbstractDeviceInfoManager oDevInfoImpl) {
        DCDebugTracer.trace("Method DeviceInfoManagerImpl#getBoardInformation start");
        BoardInfoPanel boardInfoPanel = DCFrameWorkUtil.getBoardInfoPanel();
        AsnDCGetBoardsRes asnGetBoardRes = new AsnDCGetBoardsRes();
        AsnDCFrameList asnFrameList = new AsnDCFrameList();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnGetBoardRes, packetExt.getData());
        DCDebugTracer.trace("Method DeviceInfoManagerImpl=>decodeAsn1Data iErrorCode : " + iErrorCode);
        if (iErrorCode == 0) {
            if (null == DCFrameWorkUtil.getDeviceTablePanel()) {
                DCDebugTracer.trace("Method DeviceInfoManagerImpl#getBoardInformation end.. DeviceTablePanel is null");
                return;
            }
            int[] devTableSelectRow = DCFrameWorkUtil.getDeviceTablePanel().getDeviceTreeTable().getSelectedRows();
            if (devTableSelectRow.length != 1) {
                DCDebugTracer.trace("Method DeviceInfoManagerImpl#getBoardInformation end.. devTableSelectRow.length != 1");
                return;
            }
            ArrayList<DeviceInfo> selectResource = DCFrameWorkUtil.getDeviceTablePanel().getSelectedDevices();
            int devID = ((DeviceInfo)selectResource.get(0)).getDevId();
            if (asnGetBoardRes.iDeviceId.intValue() != devID) {
                DCDebugTracer.trace("Method DeviceInfoManagerImpl#getBoardInformation end.. iDeviceId = " + asnGetBoardRes.iDeviceId + " , devID = " + devID);
                return;
            }
            if (asnGetBoardRes.oErrorInfo.iErrorNo.intValue() == 0) {
                asnFrameList.addAll((Collection)asnGetBoardRes.oFrameList);
                if (!asnGetBoardRes.bMoreBoards) {
                    DCFrameWorkUtil.getCommManager().removeMessageListener(43850, (MSGListener)oDevInfoImpl);
                    boardInfoPanel.notifyBoardInformation(asnFrameList, asnGetBoardRes.oErrorInfo.iErrorNo.intValue());
                    asnFrameList.removeAllElements();
                }
            } else {
                DCDebugTracer.trace("Method DeviceInfoManagerImpl#getBoardInformation end.. ErrorCode\u00ef\u00bc\u009a" + asnGetBoardRes.oErrorInfo.iErrorNo);
                DCFrameWorkUtil.getCommManager().removeMessageListener(43850, (MSGListener)oDevInfoImpl);
                boardInfoPanel.notifyBoardInformation(asnFrameList, asnGetBoardRes.oErrorInfo.iErrorNo.intValue());
                asnFrameList.removeAllElements();
            }
        }
        DCDebugTracer.trace("Method DeviceInfoManagerImpl#getBoardInformation end..");
    }

    static void refreshPolicyTree() {
        DCDebugTracer.trace("Refresh the Policy Tree Begin");
        PolicyManager.getInstance().reInitPolicy();
        DCDebugTracer.trace("Refresh the Policy Tree End");
    }

    static Vector getDevTypeInfo(DeviceType m_oDeviceType) {
        Vector devTypeInfoList = new Vector();
        THashSet<Resource> m_oResources = m_oDeviceType.getResources();
        for (Resource m_oResource : m_oResources) {
            DeviceTypeInfo m_oDeviceTypeInfo = (DeviceTypeInfo)CloneUtil.getClone(DeviceInfoManagerImpl.getInstance().getDevice(m_oResource.getDeviceID()).getDeviceTypeInfo());
            if (m_oDeviceTypeInfo.isDMSDomain() && 0 != (m_oResource.getUpgradeMode() & 0x1000)) {
                m_oDeviceTypeInfo.setDevTypeVersionName(m_oDeviceTypeInfo.getDevTypeVersionName() + "_telnet");
            }
            DeviceInfoManagerImplHelper.checkHaveExist(devTypeInfoList, m_oDeviceTypeInfo);
        }
        return devTypeInfoList;
    }

    static void checkHaveExist(Vector devTypeInfoList, DeviceTypeInfo m_oDeviceTypeInfo) {
        boolean isExist = false;
        int count = devTypeInfoList.size();
        for (int i = 0; i < count; ++i) {
            DeviceTypeInfo oDeviceTypeInfo = (DeviceTypeInfo)devTypeInfoList.get(i);
            if (oDeviceTypeInfo.getDevTypeID() != m_oDeviceTypeInfo.getDevTypeID() || oDeviceTypeInfo.getDevTypeVersionId() != m_oDeviceTypeInfo.getDevTypeVersionId() || !oDeviceTypeInfo.getDevTypeVersionName().equals(m_oDeviceTypeInfo.getDevTypeVersionName())) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            devTypeInfoList.add(m_oDeviceTypeInfo);
        }
    }

    static ValidationResult checkDevicesAreOfSameDomain(Resource[] arrResources) {
        ValidationResult oValidResult = new ValidationResult();
        oValidResult.setErrorCode(0);
        IDeviceInfoManager oDevInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        int iDomain = oDevInfoMgr.getDevice(arrResources[0].getDeviceID()).getDeviceTypeInfo().getDevDomain();
        int iSize = arrResources.length;
        for (int i = 0; i < iSize; ++i) {
            int iDevDomain = oDevInfoMgr.getDevice(arrResources[i].getDeviceID()).getDeviceTypeInfo().getDevDomain();
            if (iDomain == iDevDomain) continue;
            oValidResult.setErrorCode(-1);
            oValidResult.setErrorMessage(ResourceManager.getInstance().getResString("DEVICES_OF_DIFFERENT_DOMAIN_SELECTED"));
            break;
        }
        return oValidResult;
    }

    public static ValidationResult checkSupportOperationTheSame(DeviceSelectionPanel m_oDeviceSelectionPanel, ITask m_oTaskDataObj) {
        ValidationResult oValidResult = new ValidationResult();
        oValidResult.setErrorCode(0);
        DeviceType m_oDeviceType = m_oDeviceSelectionPanel.getCurrentDeviceDataModelFromTable();
        Vector m_oDevTypeInfoLst = DeviceInfoManagerImplHelper.getDevTypeInfo(m_oDeviceType);
        if ((m_oDeviceType.getDeviceTypeID() != -1 || m_oDeviceType.getDeviceTypeVersionID() != -1 || m_oDevTypeInfoLst.size() == 1) && m_oTaskDataObj.getTaskTypeId() == 13 && DCCommonUtil.isTL1Dev((DeviceTypeInfo)m_oDevTypeInfoLst.get(0))) {
            oValidResult.setErrorMessage(ResourceManager.getInstance().getResString("NORTH_AMERICA_DEVTYPE_NOT_SUPPORT_DOWN_UPGRADE_TASK"));
            oValidResult.setErrorType(1);
            oValidResult.setErrorCode(1);
            return oValidResult;
        }
        DeviceTypeInfo m_oDeviceTypeInfo = (DeviceTypeInfo)m_oDevTypeInfoLst.get(0);
        TaskMgmtOperationSelecModel m_oTaskPanelModel = new TaskMgmtOperationSelecModel();
        List oBaseSupportedOpLst = DeviceInfoManagerImplHelper.getSupportOperationLst(m_oDeviceTypeInfo, m_oTaskDataObj);
        int count = m_oDevTypeInfoLst.size();
        DeviceTypeInfo oDevTypeInfo = null;
        for (int i = 1; i < count; ++i) {
            oDevTypeInfo = (DeviceTypeInfo)m_oDevTypeInfoLst.get(i);
            if (m_oTaskDataObj.getTaskTypeId() == 13 && DCCommonUtil.isTL1Dev((DeviceTypeInfo)m_oDevTypeInfoLst.get(0))) {
                oValidResult.setErrorMessage(ResourceManager.getInstance().getResString("NORTH_AMERICA_DEVTYPE_NOT_SUPPORT_DOWN_UPGRADE_TASK"));
                oValidResult.setErrorType(1);
                oValidResult.setErrorCode(1);
                return oValidResult;
            }
            try {
                List oSupportedOpLst = m_oTaskPanelModel.getSupportedOperationLst(m_oTaskDataObj, oDevTypeInfo.getDevTypeName(), oDevTypeInfo.getDevTypeVersionName(), oDevTypeInfo);
                if (DeviceInfoManagerImplHelper.checkSupportOperation(oBaseSupportedOpLst, oSupportedOpLst)) continue;
                StringBuilder oStrBuild = new StringBuilder();
                oStrBuild.append("checkSupportOperationTheSame false deivcetype=").append(m_oDeviceTypeInfo).append(" | ").append(oDevTypeInfo);
                DCDebugTracer.trace(oStrBuild.toString());
                oValidResult.setErrorCode(-1);
                oValidResult.setErrorMessage(ResourceManager.getInstance().getResString("SUPPORT_OPERATIONS_DIFFER"));
                return oValidResult;
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        }
        return oValidResult;
    }

    static boolean checkSupportOperation(List oBaseSupportedOpLst, List oSupportedOpLst) {
        boolean isSame = true;
        if (oBaseSupportedOpLst.size() != oSupportedOpLst.size()) {
            return false;
        }
        int count = oBaseSupportedOpLst.size();
        for (int i = 0; i < count; ++i) {
            ITaskDeviceOperation oBaseTaskOp = (ITaskDeviceOperation)oBaseSupportedOpLst.get(i);
            boolean isTheSame = false;
            int twoLevelCount = oSupportedOpLst.size();
            for (int j = 0; j < twoLevelCount; ++j) {
                ITaskDeviceOperation oTaskOp = (ITaskDeviceOperation)oSupportedOpLst.get(j);
                if (oBaseTaskOp.getOperationId() != oTaskOp.getOperationId()) continue;
                isTheSame = true;
                break;
            }
            if (isTheSame) continue;
            isSame = false;
            break;
        }
        return isSame;
    }

    static List getSupportOperationLst(DeviceTypeInfo m_oDeviceTypeInfo, ITask m_oTaskDataObj) {
        TaskMgmtOperationSelecModel m_oTaskPanelModel = new TaskMgmtOperationSelecModel();
        List oSupportedOpLst = new ArrayList();
        try {
            oSupportedOpLst = m_oTaskPanelModel.getSupportedOperationLst(m_oTaskDataObj, m_oDeviceTypeInfo.getDevTypeName(), m_oDeviceTypeInfo.getDevTypeVersionName(), m_oDeviceTypeInfo);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        return oSupportedOpLst;
    }

    static int getT2kSelectDevicesMostNum() {
        int mostNum = -1;
        int DEFAULT_DEVICE_SIZE = 100;
        String number = ResourceManager.getInstance().getResString("Select_Devices_Most_Number", "config");
        if (!number.equals("Select_Devices_Most_Number")) {
            try {
                mostNum = Integer.parseInt(number);
            }
            catch (NumberFormatException nfe) {
                mostNum = 100;
            }
        }
        return mostNum;
    }

    static int getAccRouterT2kPatchTaskSelectDevicesMostNum() {
        int mostNum = -1;
        int DEFAULT_DEVICE_SIZE = 1000;
        String number = ResourceManager.getInstance().getResString("ACC_ROUTER_T2k_Patch_Task_Devices_Most_Number", "config");
        if (!number.equals("ACC_ROUTER_T2k_Patch_Task_Devices_Most_Number")) {
            try {
                mostNum = Integer.parseInt(number);
            }
            catch (NumberFormatException nfe) {
                mostNum = 1000;
            }
        }
        return mostNum;
    }

    private static boolean isContainDMSDevice(Resource[] resources) {
        for (int index = 0; index < resources.length; ++index) {
            int iDeviceDomain = -1;
            iDeviceDomain = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfoByDevId(resources[index].getDeviceID()).getDevDomain();
            if (iDeviceDomain != 2) continue;
            return true;
        }
        return false;
    }

    static ValidationResult validateDeviceSelection(DeviceSelectionPanel m_oDeviceSelectionPanel, ITask m_oTaskDataObj, DeviceTypeInfo m_oDevTypeInfo) {
        int devMostNum;
        ValidationResult oValidResult = new ValidationResult();
        oValidResult.setErrorCode(0);
        Resource[] arrResourceIdentifiers = m_oDeviceSelectionPanel.getCurrentDevices();
        if (m_oDevTypeInfo == null || m_oDevTypeInfo.getDevTypeID() == -1 && m_oDevTypeInfo.getDevTypeVersionId() == -1) {
            DeviceType oDeviceType = m_oTaskDataObj.getDeviceType();
            if (oDeviceType != null) {
                DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oDeviceType.getDeviceTypeID(), oDeviceType.getDeviceTypeVersionID()).getDevDomain();
            }
        } else {
            m_oDevTypeInfo.getDevDomain();
        }
        int iArrSize = arrResourceIdentifiers.length;
        if (0 >= iArrSize) {
            oValidResult.setErrorCode(-1);
            oValidResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_DEVICES_SELECTED"));
            return oValidResult;
        }
        if (m_oTaskDataObj.getTaskTypeId() == 3 || m_oTaskDataObj.getTaskTypeId() == 4 || m_oTaskDataObj.getTaskTypeId() == 5 || m_oTaskDataObj.getTaskTypeId() == 13 || m_oTaskDataObj.getTaskTypeId() == 12) {
            devMostNum = DeviceInfoManagerImplHelper.getT2kSelectDevicesMostNum();
            if (devMostNum != -1 && iArrSize > devMostNum) {
                oValidResult.setErrorCode(-1);
                StringBuffer strErrorMsg = new StringBuffer(ResourceManager.getInstance().getResString("DEV_NUMBER_LESS_THAN_MOST"));
                strErrorMsg.append(' ');
                strErrorMsg.append(devMostNum);
                strErrorMsg.append('.');
                oValidResult.setErrorMessage(strErrorMsg.toString());
                return oValidResult;
            }
        } else {
            devMostNum = DeviceInfoManagerImplHelper.getAccRouterT2kPatchTaskSelectDevicesMostNum();
            if (devMostNum != -1 && iArrSize > devMostNum) {
                oValidResult.setErrorCode(-1);
                StringBuffer strErrorMsg = new StringBuffer(ResourceManager.getInstance().getResString("DEV_NUMBER_LESS_THAN_MOST"));
                strErrorMsg.append(' ');
                strErrorMsg.append(devMostNum);
                strErrorMsg.append('.');
                oValidResult.setErrorMessage(strErrorMsg.toString());
                return oValidResult;
            }
            if ((m_oTaskDataObj.getTaskTypeId() == 0 || m_oTaskDataObj.getTaskTypeId() == 1 || m_oTaskDataObj.getTaskTypeId() == 2) && DeviceInfoManagerImplHelper.isContainDMSDevice(arrResourceIdentifiers)) {
                int iRoleType = arrResourceIdentifiers[0].getRoleType();
                for (int i = 1; i < arrResourceIdentifiers.length; ++i) {
                    if (3 == arrResourceIdentifiers[i].getRoleType() || 3 == iRoleType || 4 == iRoleType || 4 == arrResourceIdentifiers[i].getRoleType() || arrResourceIdentifiers[i].getRoleType() == iRoleType) continue;
                    oValidResult.setErrorCode(-1);
                    oValidResult.setErrorMessage(ResourceManager.getInstance().getResString("DIFFERENT_DEVICES_SELECTED"));
                    break;
                }
                if (0 != oValidResult.getErrorCode()) {
                    return oValidResult;
                }
                oValidResult = DeviceInfoManagerImplHelper.checkDevicesAreOfSameDomain(arrResourceIdentifiers);
                if (0 != oValidResult.getErrorCode()) {
                    return oValidResult;
                }
                if (0 != oValidResult.getErrorCode()) {
                    return oValidResult;
                }
            }
        }
        if ((oValidResult = DeviceInfoManagerImplHelper.checkSupportOperationTheSame(m_oDeviceSelectionPanel, m_oTaskDataObj)).getErrorCode() == 0 && !m_oTaskDataObj.getIsOffLineTask() && (!m_oTaskDataObj.getIsOffLineTask() && m_oTaskDataObj.getTaskTypeId() == 4 || m_oTaskDataObj.getTaskTypeId() == 13 || m_oTaskDataObj.getTaskTypeId() == 5 || m_oTaskDataObj.getTaskTypeId() == 12)) {
            ArrayList<String> oSWDLStatusLst = new ArrayList<String>(0);
            String sNormal = ResourceManager.getInstance().getResString("SWDL_STATUS_1");
            String sToStabilize = ResourceManager.getInstance().getResString("SWDL_STATUS_10");
            oSWDLStatusLst.add(sNormal);
            oSWDLStatusLst.add(sToStabilize);
            String sSWDLStatus = "";
            String sFirstSWDLStatus = sSWDLStatus = arrResourceIdentifiers[0].getProgressInfo().getSWDLStatus();
            Collator oInstans = Collator.getInstance();
            for (int i = 1; i < arrResourceIdentifiers.length; ++i) {
                sSWDLStatus = arrResourceIdentifiers[i].getProgressInfo().getSWDLStatus();
                if (oInstans.equals(sFirstSWDLStatus, sSWDLStatus) || oSWDLStatusLst.contains(sFirstSWDLStatus) && oSWDLStatusLst.contains(sSWDLStatus)) continue;
                oValidResult.setErrorCode(-1);
                oValidResult.setErrorMessage(ResourceManager.getInstance().getResString("NE_SWDL_NOT_SAME"));
                break;
            }
        }
        return oValidResult;
    }

    static DeviceInfo[] filterDevicesByVersion(DeviceInfo[] oOriginalDeviceList, String strVersion, DeviceTypeInfo oDeviceTypeInfo) {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        if (oOriginalDeviceList == null || oOriginalDeviceList.length == 0 || null == strVersion || null == oDeviceTypeInfo) {
            return new DeviceInfo[0];
        }
        DeviceInfo devInfo = null;
        for (int i = 0; i < oOriginalDeviceList.length; ++i) {
            devInfo = oOriginalDeviceList[i];
            if (null == devInfo || !oDeviceTypeInfo.equals(devInfo.getDeviceTypeInfo())) continue;
            String strDevVersion = devInfo.getDevVersion().getDevVersion().trim();
            if (null == strDevVersion || "".equals(strDevVersion)) {
                if (!strVersion.equals(ResourceManager.getInstance().getResString("UNKNOWN_VERSION"))) continue;
                deviceVec.add(devInfo);
                continue;
            }
            if (!strVersion.trim().equals(strDevVersion)) continue;
            deviceVec.add(devInfo);
        }
        return deviceVec.toArray(new DeviceInfo[deviceVec.size()]);
    }

    private static boolean isExist(Vector devVec, int devID) {
        boolean isExist = false;
        int vecSize = devVec.size();
        DeviceInfo devInfo = null;
        for (int i = 0; i < vecSize; ++i) {
            devInfo = (DeviceInfo)devVec.get(i);
            if (devID != devInfo.getDevId()) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    static DeviceInfo[] filterDevicesByType(DeviceInfo[] oOriginalDeviceList, int iDeviceTypeID, int iTypeVersionID) {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        if (oOriginalDeviceList == null || oOriginalDeviceList.length == 0) {
            return new DeviceInfo[0];
        }
        DeviceInfo oDeviceInfo = null;
        for (int i = 0; i < oOriginalDeviceList.length; ++i) {
            oDeviceInfo = oOriginalDeviceList[i];
            if (null == oDeviceInfo || null == oDeviceInfo.getDeviceTypeInfo() || oOriginalDeviceList[i].getDeviceTypeInfo().getDevTypeID() != iDeviceTypeID || oOriginalDeviceList[i].getDeviceTypeInfo().getDevTypeVersionId() != iTypeVersionID || DeviceInfoManagerImplHelper.isExist(deviceVec, oOriginalDeviceList[i].getDevId())) continue;
            deviceVec.add(oOriginalDeviceList[i]);
        }
        return deviceVec.toArray(new DeviceInfo[deviceVec.size()]);
    }

    static String getBoardNameForT2000(int iBoardId) {
        byte[] byteArray = new byte[]{(byte)(iBoardId >> 24 & 0xFF), (byte)(iBoardId >> 16 & 0xFF), (byte)(iBoardId >> 8 & 0xFF), (byte)(iBoardId & 0xFF)};
        String strBoardName = "";
        strBoardName = byteArray[2] == 0 ? "" + byteArray[3] : byteArray[2] + "-" + byteArray[3];
        return strBoardName;
    }

    static boolean deleteBckupFolders(File oBckupDir) {
        if (oBckupDir.isDirectory()) {
            String[] children = oBckupDir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = DeviceInfoManagerImplHelper.deleteBckupFolders(new File(oBckupDir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return oBckupDir.delete();
    }

    static String clientFileTrnsOP(DeviceInfo oDevInfo) {
        TIntObjectHashMap oDeviceClientInfoMap = XFtpManager.getInstance().getDeviceClientInfoMap();
        if (0 < oDeviceClientInfoMap.size()) {
            StClientFileTransInfo oClientInfoObj;
            int iDevId = oDevInfo.getDevId();
            Object oClientObj = oDeviceClientInfoMap.get(Integer.valueOf(iDevId).intValue());
            XFtpManager.getInstance().decrementSftpOPerationCount(iDevId);
            if (oClientObj instanceof StClientFileTransInfo && null != (oClientInfoObj = (StClientFileTransInfo)oClientObj) && 1 != oClientInfoObj.m_iOperationType) {
                ThreadPool.getInstance().stopSingleThread(oClientInfoObj.m_strThreadName);
            }
        }
        return null;
    }

    static DeviceTypeInfo[] trans2Devices(Map<String, DeviceTypeInfo> oDevTypeHm) {
        Set<Map.Entry<String, DeviceTypeInfo>> oSet = oDevTypeHm.entrySet();
        Iterator<Map.Entry<String, DeviceTypeInfo>> oItor = oSet.iterator();
        DeviceTypeInfo[] oDevTypInfos = new DeviceTypeInfo[oDevTypeHm.size()];
        DeviceTypeInfo oDevType = null;
        int i = 0;
        while (oItor.hasNext()) {
            oDevTypInfos[i] = oDevType = oItor.next().getValue();
            ++i;
        }
        return oDevTypInfos;
    }

    static DeviceTypeInfo[] getAddedDeviceTypes(DeviceInfo[] oDeviceInfo) {
        DeviceTypeInfo[] arrDeviceTypeList = new DeviceTypeInfo[]{};
        if (null == oDeviceInfo || oDeviceInfo.length < 1) {
            DCDebugTracer.trace("get DevLst null.");
            return arrDeviceTypeList;
        }
        DCDebugTracer.trace("get DevLst length=" + oDeviceInfo.length);
        Vector<DeviceTypeInfo> collectDevTypeVec = new Vector<DeviceTypeInfo>(0);
        DeviceTypeInfo curDevTypeInfo = null;
        for (int index = 0; index < oDeviceInfo.length; ++index) {
            curDevTypeInfo = oDeviceInfo[index].getDeviceTypeInfo();
            if (null == curDevTypeInfo) {
                DCDebugTracer.trace("get DevType null:" + oDeviceInfo[index]);
                continue;
            }
            if (collectDevTypeVec.contains(curDevTypeInfo)) continue;
            DCDebugTracer.trace("curDevTypeInfo:" + curDevTypeInfo);
            collectDevTypeVec.add(curDevTypeInfo);
        }
        try {
            Collections.sort(collectDevTypeVec);
        }
        catch (RuntimeException ignore) {
            DCDebugTracer.trace(ignore);
        }
        arrDeviceTypeList = collectDevTypeVec.toArray(new DeviceTypeInfo[collectDevTypeVec.size()]);
        return arrDeviceTypeList;
    }

    static int[] getAddedDeviceIdLst(DeviceInfo[] oDeviceInfo) {
        if (null == oDeviceInfo || oDeviceInfo.length < 1) {
            DCDebugTracer.trace("get DevIdLst null.");
            return null;
        }
        DCDebugTracer.trace("get DevIdLst length=" + oDeviceInfo.length);
        int[] iDeviceIdLst = new int[oDeviceInfo.length];
        for (int index = 0; index < oDeviceInfo.length; ++index) {
            iDeviceIdLst[index] = oDeviceInfo[index].getDevId();
        }
        return iDeviceIdLst;
    }

    static boolean isDevicePresentForVersion(String strDeviceVersion, DeviceTypeInfo oDeviceTypeInfo, DeviceInfo[] arrDevices) {
        boolean isDevicePresent = false;
        for (int i = 0; i < arrDevices.length; ++i) {
            String strVersion = arrDevices[i].getDevVersion().getDevVersion();
            if (strDeviceVersion.equals(strVersion)) {
                isDevicePresent = true;
                break;
            }
            if (!strDeviceVersion.trim().equals(ResourceManager.getInstance().getResString("UNKNOWN_VERSION")) || null != strVersion && !"".equals(strVersion)) continue;
            isDevicePresent = true;
            break;
        }
        return isDevicePresent;
    }

    static Vector getDevicesForVersion(String strDeviceVersion, DeviceInfo[] arrDevices) {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        for (int i = 0; i < arrDevices.length; ++i) {
            String strVersion = arrDevices[i].getDevVersion().getDevVersion();
            if (strDeviceVersion.equals(strVersion)) {
                deviceVec.add(arrDevices[i]);
                continue;
            }
            if (!strDeviceVersion.trim().equals(ResourceManager.getInstance().getResString("UNKNOWN_VERSION")) || null != strVersion && !"".equals(strVersion)) continue;
            deviceVec.add(arrDevices[i]);
        }
        return deviceVec;
    }

    static Vector getDevicesForVersion(String strDeviceVersion, String strBoardType, DeviceInfo[] arrDevices) {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        for (int i = 0; i < arrDevices.length; ++i) {
            String strVersion = arrDevices[i].getDevVersion().getDevVersion();
            String devBoard = arrDevices[i].getDevBoardType();
            if (null != strDeviceVersion && null != strBoardType && strDeviceVersion.equals(strVersion) && strBoardType.equals(devBoard)) {
                deviceVec.add(arrDevices[i]);
            }
            if (null == strDeviceVersion || !strDeviceVersion.trim().equals(ResourceManager.getInstance().getResString("UNKNOWN_VERSION")) || null != strVersion && !"".equals(strVersion)) continue;
            if (null == strBoardType) {
                deviceVec.add(arrDevices[i]);
                continue;
            }
            if (!strBoardType.equals(devBoard)) continue;
            deviceVec.add(arrDevices[i]);
        }
        return deviceVec;
    }

    static HashMap getDeviceVersionMapByDevInfo(DeviceInfo[] deviceInfo) {
        HashMap versionMap = new HashMap(0);
        Vector<String> versionVector = new Vector<String>(0);
        for (int i = 0; i < deviceInfo.length; ++i) {
            if (versionVector.capacity() > 0 && versionVector.contains(deviceInfo[i].getDevVersion().getDevVersion())) continue;
            if (deviceInfo[i].getDevVersion().getDevVersion().equals("") && !versionVector.contains(ResourceManager.getInstance().getResString("UNKNOWN_VERSION"))) {
                versionVector.add(ResourceManager.getInstance().getResString("UNKNOWN_VERSION"));
                continue;
            }
            if (deviceInfo[i].getDevVersion().getDevVersion().equals("")) continue;
            versionVector.add(deviceInfo[i].getDevVersion().getDevVersion());
        }
        Object[] obj = versionVector.toArray(new Object[0]);
        String[] versionArray = new String[obj.length];
        for (int k = 0; k < obj.length; ++k) {
            versionArray[k] = (String)obj[k];
        }
        for (int i = 0; i < versionArray.length; ++i) {
            Vector<DeviceInfo> deviceVector = new Vector<DeviceInfo>(0);
            for (int j = 0; j < deviceInfo.length; ++j) {
                if (deviceInfo[j].getDevVersion().getDevVersion().equals(versionArray[i])) {
                    deviceVector.add(deviceInfo[j]);
                    versionMap.put(versionArray[i], deviceVector);
                    continue;
                }
                if (!versionArray[i].equals(ResourceManager.getInstance().getResString("UNKNOWN_VERSION")) || !deviceInfo[j].getDevVersion().getDevVersion().equals("")) continue;
                deviceVector.add(deviceInfo[j]);
                versionMap.put(versionArray[i], deviceVector);
            }
        }
        return versionMap;
    }

    public static Resource converDevInfoToRes(DeviceInfo oDeviceInfo) {
        Resource oResource = new Resource();
        oResource.setDeviceID(oDeviceInfo.getDevId());
        oResource.setDeviceIP(oDeviceInfo.getDevIPAddress());
        oResource.setDeviceName(oDeviceInfo.getDevName());
        oResource.setRoleType(oDeviceInfo.getRoleType());
        oResource.setUpgradeMode(oDeviceInfo.getUpgradeMode());
        oResource.setUpgradeModeConfig(oDeviceInfo.getUpgradeModeConfig());
        return oResource;
    }

    public static ArrayList<SeriesInfo> getSessionInfo() {
        return oSeriesInfos;
    }

    public static FileListError getDeleteFileListResult(AsnDCDeleteFileInfo asnDCDeleteFileInfo) {
        FileListError fileListError = new FileListError();
        fileListError.setErrorNo(asnDCDeleteFileInfo.oErrorInfo.iErrorNo.intValue());
        fileListError.setFilePath(new String(asnDCDeleteFileInfo.strFileName));
        return fileListError;
    }

    public static void setFirstStartDevInfoPanel(boolean bValue) {
        m_bFirstStartDevInfoPanel = bValue;
    }

    public static void doClear() {
        DCDebugTracer.trace("DC::DeviceInfoManagerImplHelper#getDeviceTypeFromDCServer-->oSeriesInfos.clear()::");
        if (null != oSeriesInfos) {
            oSeriesInfos.clear();
        }
        oDeviceTypeLstRsp = null;
    }
}

