/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.controller;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnBackUpFileListResp;
import com.huawei.dc.common.asndatacenter.AsnDCDeleteFileListResp;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDeleteBackUpFileReq;
import com.huawei.dc.common.asndatacenter.AsnGetOLTIDByMxUIDReq;
import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanel;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DevInfoSynMsgHelper;
import com.huawei.dc.common.controller.DeviceInfoManagerImplHelper;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.controller.SubMapInfoHelper;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceinfo.DeviceVersionInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.OLTDevVerInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.security.ISecurityManager;
import com.huawei.dc.standalone.IManualOperation;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DeviceInfoManagerImpl
extends AbstractDeviceInfoManager {
    private static DeviceInfoManagerImpl m_oDeviceInfoManagerImpl;
    private long firstOpenClientTime = System.nanoTime();
    private int clientId = -1;
    private int userId = -1;

    private DeviceInfoManagerImpl() throws DCException {
        if (null != DCFrameWorkUtil.getSecurityManager()) {
            this.clientId = DCFrameWorkUtil.getSecurityManager().getClientId();
            this.userId = DCFrameWorkUtil.getSecurityManager().getUserId();
        }
        this.m_isNeedToGotDeviceInfo = true;
        this.m_oManualOperationVec = new Vector();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.m_iMaxDevID = StandAloneDomainInfo.getInstance().getInitializationDevId();
        }
        DCDebugTracer.trace("initialize m_oDeviceInfoManagerImpl");
    }

    public static synchronized IDeviceInfoManager getInstance() {
        if (null == m_oDeviceInfoManagerImpl || m_oDeviceInfoManagerImpl.isClosed()) {
            if (null != m_oDeviceInfoManagerImpl) {
                DCDebugTracer.trace("exception to close m_oDeviceInfoManagerImpl");
            }
            try {
                m_oDeviceInfoManagerImpl = new DeviceInfoManagerImpl();
                DCObjectDestructor.getInstance().addObjectForDestructor(m_oDeviceInfoManagerImpl);
                ObjectStore.getInstance().putObjectInstance("DeviceInfoManager", m_oDeviceInfoManagerImpl);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        }
        return m_oDeviceInfoManagerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setToNULL() {
        this.m_bIsGettingSubmapInfo = false;
        this.clearData();
        if (null == m_oDeviceInfoManagerImpl) return;
        try {
            byte[] byArray = this.m_oGetDevSyncObj;
            synchronized (this.m_oGetDevSyncObj) {
                this.m_oGetDevSyncObj.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        {
            try {
                byte[] e = this.syncObj;
                synchronized (this.syncObj) {
                    this.syncObj.notifyAll();
                    // ** MonitorExit[e] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
            {
                if (null != this.deviceInfoVec) {
                    this.deviceInfoVec.clear();
                    this.deviceInfoVec = null;
                }
                if (null != this.m_oDevIdDevInfoMap) {
                    this.m_oDevIdDevInfoMap.clear();
                    this.m_oDevIdDevInfoMap = null;
                }
                this.m_arrDeviceInfo = null;
                if (null != this.m_oDeviceTypeHm) {
                    this.m_oDeviceTypeHm.clear();
                    this.m_oDeviceTypeHm = null;
                }
                if (null != this.m_tempasnLogicalList) {
                    this.m_tempasnLogicalList.clear();
                    this.m_tempasnLogicalList = null;
                }
                if (null != this.oDCDeviceLstRspLst) {
                    this.oDCDeviceLstRspLst.clear();
                    this.oDCDeviceLstRspLst = null;
                }
                if (null != this.m_tempasnNonLogicalList) {
                    this.m_tempasnNonLogicalList.clear();
                    this.m_tempasnNonLogicalList = null;
                }
                this.m_oLTSubMapInfo = null;
                this.m_oSubMapInfo = null;
                this.oMxuSubMapInfo = null;
                if (null != this.m_oSubMapList) {
                    this.m_oSubMapList.clear();
                    this.m_oSubMapList = null;
                }
                if (null != this.allSubmapInfo) {
                    this.allSubmapInfo.clear();
                    this.allSubmapInfo = null;
                }
                if (null != this.existDeviceTypeList) {
                    this.existDeviceTypeList.clear();
                    this.existDeviceTypeList = null;
                }
                ObjectStore.getInstance().removeObjectInstance("DeviceInfoManager");
                this.closeReceiver();
                m_oDeviceInfoManagerImpl = null;
                return;
            }
        }
    }

    @Override
    public int getExistDeviceTypeFromDCServer() {
        int iErrCode = 0;
        try {
            this.existDeviceTypeList = DeviceInfoManagerImplHelper.getDeviceTypeFromDCServer(44038, this.m_strSupportDevTypes);
        }
        catch (DCException e) {
            iErrCode = e.getErrorCode();
            DCDebugTracer.trace("failed to get exist device type from server.");
            DCDebugTracer.trace(e);
        }
        return iErrCode;
    }

    @Override
    public int getDeviceTypeFromDCServer() {
        int iErrCode = 0;
        try {
            this.m_oDeviceTypeHm = DeviceInfoManagerImplHelper.getDeviceTypeFromDCServer(43812, this.m_strSupportDevTypes);
        }
        catch (DCException e) {
            iErrCode = e.getErrorCode();
        }
        return iErrCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDeviceFromDCServerWithParent(int iType) {
        DCDebugTracer.trace("getDeviceFromDCServerWithParent start");
        DCDebugTracer.trace("type : " + iType);
        int iErrCode = 0;
        try {
            this.objGetDevLock.acquire();
            DCDebugTracer.trace("[objLock] objGetDevLock-acquire");
            switch (iType) {
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    this.m_isFirstPackage = true;
                    break;
                }
                case 4: {
                    this.setNeedWait(false);
                    this.m_isFirstPackage = true;
                    break;
                }
                case -1: {
                    this.m_isFirstPackage = false;
                    break;
                }
                default: {
                    this.m_isFirstPackage = false;
                }
            }
            DCDebugTracer.trace("DC: isNeedToGotDeviceInfo" + this.m_isNeedToGotDeviceInfo);
            DCDebugTracer.trace("DC: isFinishGetDevAndSubmapInfo" + this.isFinishGetDevAndSubmapInfo);
            if (this.m_isNeedToGotDeviceInfo) {
                iErrCode = this.getDeviceFromDCServer(43811);
                if (null != DCFrameWorkUtil.getTaskTablePanel()) {
                    TaskAsynCommController.getInstance().getTaskList();
                }
                this.m_isNeedToGotDeviceInfo = false;
            } else if (this.isFinishGetDevAndSubmapInfo && 4 == iType && null != DCFrameWorkUtil.getDeviceTablePanel()) {
                DCFrameWorkUtil.getDeviceTablePanel().closeGettingDevProgressDlg();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            DCDebugTracer.trace("[objLock] objGetDevLock-Exception");
        }
        finally {
            this.objGetDevLock.release();
            DCDebugTracer.trace("[objLock] objLock-release");
        }
        DCDebugTracer.trace("getDeviceFromDCServerWithParent end..");
        return iErrCode;
    }

    @Override
    public boolean isNeedToGotDeviceInfo() {
        return this.m_isNeedToGotDeviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceInfo getDevice(int aDeviceId) {
        Object object = this.sycObj;
        synchronized (object) {
            if (this.m_oDevIdDevInfoMap == null || this.m_oDevIdDevInfoMap.size() == 0) {
                return null;
            }
            return (DeviceInfo)this.m_oDevIdDevInfoMap.get((Object)aDeviceId);
        }
    }

    public boolean isDevicePresent(int aDeviceId) {
        return this.m_oDevIdDevInfoMap.containsKey((Object)aDeviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DeviceInfo> getDevsInfoByDeviceName(String devName) {
        ArrayList<DeviceInfo> oDevInfoLst = new ArrayList<DeviceInfo>(2);
        if (this.m_oDevIdDevInfoMap.isEmpty() || StringUtils.isNullOrEmptyStr(devName)) {
            return oDevInfoLst;
        }
        Object object = this.sycObj;
        synchronized (object) {
            Collection oDevSet = this.m_oDevIdDevInfoMap.values();
            for (DeviceInfo oDevInfo : oDevSet) {
                if (null == oDevInfo || !devName.equals(oDevInfo.getDevName())) continue;
                oDevInfoLst.add(oDevInfo);
            }
        }
        return oDevInfoLst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DeviceInfo> getDevsInfoByIP(String ip) {
        ArrayList<DeviceInfo> oDevInfoLst = new ArrayList<DeviceInfo>(2);
        if (this.m_oDevIdDevInfoMap.isEmpty()) {
            return null;
        }
        Object object = this.sycObj;
        synchronized (object) {
            Collection oDevSet = this.m_oDevIdDevInfoMap.values();
            for (DeviceInfo oDevInfo : oDevSet) {
                if (null == oDevInfo || !ip.equals(oDevInfo.getDevIPAddress())) continue;
                oDevInfoLst.add(oDevInfo);
            }
        }
        return oDevInfoLst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceInfo getDeviceByIP(String ip) {
        if (this.m_oDevIdDevInfoMap.isEmpty()) {
            return null;
        }
        Object object = this.sycObj;
        synchronized (object) {
            Collection oDevSet = this.m_oDevIdDevInfoMap.values();
            for (DeviceInfo oDevInfo : oDevSet) {
                if (null == oDevInfo || !ip.equals(oDevInfo.getDevIPAddress())) continue;
                return oDevInfo;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DeviceInfo[] getDevices() {
        if (!this.m_oDevIdDevInfoMap.isEmpty()) return this.getDevices(this.m_oDevIdDevInfoMap.keySet());
        ISecurityManager oSecuInterface = DCFrameWorkUtil.getSecurityManager();
        TIntHashSet setOfDevices = null;
        if (null == oSecuInterface) {
            DCDebugTracer.trace("oSecuInterface is null.getDevices end.. ");
            return this.getDevices(this.m_oDevIdDevInfoMap.keySet());
        }
        setOfDevices = oSecuInterface.getSetOfDevices();
        if (null != setOfDevices) {
            DCDebugTracer.trace(" [getDevices ]DC:: access device list size " + setOfDevices.size());
            this.getDeviceFromDCServer();
            return this.getDevices(this.m_oDevIdDevInfoMap.keySet());
        }
        DCDebugTracer.trace(" [getDevices ]DC:: access device is null  getDevices end.. ");
        return new DeviceInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceInfo[] getDevices(int[] arrDeviceIds) {
        int iDevCount = arrDeviceIds.length;
        DeviceInfo[] arrDeviceInfo = new DeviceInfo[iDevCount];
        Object object = this.sycObj;
        synchronized (object) {
            if (this.m_oDevIdDevInfoMap == null || this.m_oDevIdDevInfoMap.size() == 0) {
                return null;
            }
            for (int i = 0; i < iDevCount; ++i) {
                if (!this.m_oDevIdDevInfoMap.contains((Object)arrDeviceIds[i])) continue;
                arrDeviceInfo[i] = (DeviceInfo)this.m_oDevIdDevInfoMap.get((Object)arrDeviceIds[i]);
            }
        }
        return arrDeviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceInfo[] getDevices(Set<Integer> devIdlst) {
        int iDevCount = devIdlst.size();
        DeviceInfo[] arrDeviceInfo = new DeviceInfo[iDevCount];
        Object object = this.sycObj;
        synchronized (object) {
            if (this.m_oDevIdDevInfoMap == null || this.m_oDevIdDevInfoMap.size() == 0) {
                return null;
            }
            int index = 0;
            Iterator<Integer> itr = devIdlst.iterator();
            while (itr.hasNext()) {
                arrDeviceInfo[index] = (DeviceInfo)this.m_oDevIdDevInfoMap.get((Object)itr.next());
                ++index;
            }
        }
        return arrDeviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceInfo[] getDevicesByType(int aDeviceTypeId) {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        Object object = this.sycObj;
        synchronized (object) {
            if (this.m_oDevIdDevInfoMap.isEmpty()) {
                return null;
            }
            Collection oDevSet = this.m_oDevIdDevInfoMap.values();
            for (DeviceInfo oDevInfo : oDevSet) {
                if (null == oDevInfo || null == oDevInfo.getDeviceTypeInfo() || aDeviceTypeId != oDevInfo.getDeviceTypeInfo().getDevTypeID()) continue;
                deviceVec.add(oDevInfo);
            }
        }
        return deviceVec.toArray(new DeviceInfo[0]);
    }

    @Override
    public HashMap getDeviceVersionMapByDeviceType(int idevTypeId) {
        DeviceInfo[] deviceInfo;
        int allDevType = -1;
        if (this.m_arrDeviceInfo == null || this.m_arrDeviceInfo.length == 0) {
            return null;
        }
        if (idevTypeId == allDevType) {
            Vector<DeviceInfo> resourceList = new Vector<DeviceInfo>(0);
            Vector devTypeList = this.getDevTypeListByDiffusionTask();
            int devTypeCount = devTypeList.size();
            for (int i = 0; i < devTypeCount; ++i) {
                DeviceTypeInfo deviceType = (DeviceTypeInfo)devTypeList.get(i);
                int iDeviceTypeID = deviceType.getDevTypeID();
                DeviceInfo[] deviceList = this.getDevicesByType(iDeviceTypeID);
                for (int j = 0; j < deviceList.length; ++j) {
                    resourceList.add(deviceList[j]);
                }
            }
            deviceInfo = resourceList.toArray(new DeviceInfo[0]);
        } else {
            deviceInfo = this.getDevicesByType(idevTypeId);
        }
        HashMap versionMap = DeviceInfoManagerImplHelper.getDeviceVersionMapByDevInfo(deviceInfo);
        return versionMap;
    }

    @Override
    public HashMap getDeviceVersionMapForAllDeviceType() {
        if (this.m_arrDeviceInfo == null || this.m_arrDeviceInfo.length == 0) {
            return null;
        }
        DeviceInfo[] deviceInfo = this.getDevices();
        HashMap versionMap = DeviceInfoManagerImplHelper.getDeviceVersionMapByDevInfo(deviceInfo);
        return versionMap;
    }

    @Override
    public HashMap getDeviceVersionMapByDeviceTypeAndVersion(int idevTypeId, int iDevVersionId) {
        HashMap versionMap = new HashMap(0);
        Vector<String> versionVector = new Vector<String>(0);
        if (this.m_oDevIdDevInfoMap.isEmpty()) {
            return null;
        }
        DeviceInfo[] deviceInfo = this.getDevicesByTypeAndVersion(idevTypeId, iDevVersionId);
        for (int i = 0; i < deviceInfo.length; ++i) {
            if (versionVector.capacity() > 0 && versionVector.contains(deviceInfo[i].getDevVersion().getDevVersion())) continue;
            if (deviceInfo[i].getDevVersion().getDevVersion().equals("") && !versionVector.contains(ResourceManager.getInstance().getResString("UNKNOWN_VERSION"))) {
                versionVector.add(ResourceManager.getInstance().getResString("UNKNOWN_VERSION"));
                continue;
            }
            if (deviceInfo[i].getDevVersion().getDevVersion().equals("")) continue;
            versionVector.add(deviceInfo[i].getDevVersion().getDevVersion());
        }
        Object[] obj = versionVector.toArray(new Object[0]);
        String[] versionArray = new String[obj.length];
        for (int k = 0; k < obj.length; ++k) {
            versionArray[k] = (String)obj[k];
        }
        for (int i = 0; i < versionArray.length; ++i) {
            Vector<DeviceInfo> deviceVector = new Vector<DeviceInfo>(0);
            for (int j = 0; j < deviceInfo.length; ++j) {
                if (deviceInfo[j].getDevVersion().getDevVersion().equals(versionArray[i])) {
                    deviceVector.add(deviceInfo[j]);
                    versionMap.put(versionArray[i], deviceVector);
                    continue;
                }
                if (!versionArray[i].equals(ResourceManager.getInstance().getResString("UNKNOWN_VERSION")) || !deviceInfo[j].getDevVersion().getDevVersion().equals("")) continue;
                deviceVector.add(deviceInfo[j]);
                versionMap.put(versionArray[i], deviceVector);
            }
        }
        return versionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceInfo[] getDevicesByTypeAndVersion(int aDeviceTypeId, int aDeviceTypeVersionId) {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        if (this.m_oDevIdDevInfoMap.isEmpty()) {
            return new DeviceInfo[0];
        }
        Object object = this.sycObj;
        synchronized (object) {
            Collection oDevSet = this.m_oDevIdDevInfoMap.values();
            for (DeviceInfo oDevInfo : oDevSet) {
                if (null == oDevInfo || null == oDevInfo.getDeviceTypeInfo() || oDevInfo.getDeviceTypeInfo().getDevTypeID() != aDeviceTypeId || oDevInfo.getDeviceTypeInfo().getDevTypeVersionId() != aDeviceTypeVersionId) continue;
                deviceVec.add(oDevInfo);
            }
        }
        return deviceVec.toArray(new DeviceInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceInfo[] getDevicesByVersion(String strDeviceVersionId) {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        if (this.m_oDevIdDevInfoMap.isEmpty()) {
            return new DeviceInfo[0];
        }
        Collator oCompare = Collator.getInstance();
        Object object = this.sycObj;
        synchronized (object) {
            Collection oDevSet = this.m_oDevIdDevInfoMap.values();
            for (DeviceInfo oDevInfo : oDevSet) {
                if (null == oDevInfo) continue;
                if (0 == oCompare.compare(strDeviceVersionId.trim(), oDevInfo.getDevVersion().getDevVersion().trim())) {
                    deviceVec.add(oDevInfo);
                    continue;
                }
                if (0 != oCompare.compare(strDeviceVersionId.trim(), ResourceManager.getInstance().getResString("UNKNOWN_VERSION"))) continue;
                deviceVec.add(oDevInfo);
            }
        }
        return deviceVec.toArray(new DeviceInfo[0]);
    }

    @Override
    public DeviceInfo[] getDevicesForVersion(String strDeviceVersion, DeviceTypeInfo oDeviceTypeInfo) {
        if (null == strDeviceVersion) {
            return new DeviceInfo[0];
        }
        if (null == oDeviceTypeInfo) {
            return this.getDevicesByVersion(strDeviceVersion);
        }
        DeviceInfo[] arrDevices = this.getDevicesByTypeAndVersion(oDeviceTypeInfo.getDevTypeID(), oDeviceTypeInfo.getDevTypeVersionId());
        if (null == arrDevices || 0 == arrDevices.length) {
            return arrDevices;
        }
        Vector deviceVec = DeviceInfoManagerImplHelper.getDevicesForVersion(strDeviceVersion, arrDevices);
        return deviceVec.toArray(new DeviceInfo[deviceVec.size()]);
    }

    @Override
    public boolean isDevicePresentForVersion(String strDeviceVersion, DeviceTypeInfo oDeviceTypeInfo) {
        boolean isDevicePresent = false;
        if (null == strDeviceVersion) {
            return isDevicePresent;
        }
        if (null == oDeviceTypeInfo) {
            return isDevicePresent;
        }
        DeviceInfo[] arrDevices = this.getDevicesByTypeAndVersion(oDeviceTypeInfo.getDevTypeID(), oDeviceTypeInfo.getDevTypeVersionId());
        if (null == arrDevices || 0 == arrDevices.length) {
            return isDevicePresent;
        }
        return DeviceInfoManagerImplHelper.isDevicePresentForVersion(strDeviceVersion, oDeviceTypeInfo, arrDevices);
    }

    @Override
    public void getDevicesVersion(int iReqId, DeviceInfo[] oDevInfo) throws DCException {
        DevInfoSynMsgHelper.getDevicesVersion(iReqId, oDevInfo);
    }

    @Override
    public Vector getDevTypeListByDiffusionTask() {
        return this.devTypeListByDiffusionTask;
    }

    @Override
    public void setDevTypeListByDiffusionTask(Vector devTypeListByDiffusionTask) {
        this.devTypeListByDiffusionTask = devTypeListByDiffusionTask;
    }

    @Override
    public DeviceTypeInfo[] getAddedDeviceTypes() {
        return DeviceInfoManagerImplHelper.getAddedDeviceTypes(this.getDevices());
    }

    @Override
    public int[] getAddedDeviceIdLst() {
        return DeviceInfoManagerImplHelper.getAddedDeviceIdLst(this.getDevices());
    }

    @Override
    public DeviceTypeInfo[] getDeviceTypes() {
        if (null == this.m_oDeviceTypeHm || 0 >= this.m_oDeviceTypeHm.size()) {
            this.getDeviceTypeFromDCServer();
        }
        return DeviceInfoManagerImplHelper.trans2Devices(this.m_oDeviceTypeHm);
    }

    @Override
    public DeviceTypeInfo[] getExistDeviceTypes() {
        int iErrCode;
        if (this.m_isDevConfigurationChanged && 0 == (iErrCode = this.getExistDeviceTypeFromDCServer())) {
            this.m_isDevConfigurationChanged = false;
        }
        return DeviceInfoManagerImplHelper.trans2Devices(this.existDeviceTypeList);
    }

    @Override
    public int refreshDevices() {
        DCDebugTracer.trace("DeviceInfoManagerImpl#refreshDevices() start");
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
        this.setDeviceInfoError(0);
        this.m_bFirst = true;
        this.m_bLogicalFirst = true;
        this.m_bFirstError = true;
        this.m_bDeviceInfoObtained = false;
        this.m_bGroupInfoObtained = false;
        this.m_isDevConfigurationChanged = true;
        int errorcode = 0;
        errorcode = this.getDeviceTypeFromDCServer();
        if (errorcode != 0) {
            this.m_bIsGettingSubmapInfo = false;
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
            DCDebugTracer.trace("DeviceInfoManagerImpl#refreshDevices() getDeviceTypeFromDCServer end.. errorcode : " + errorcode);
            return errorcode;
        }
        errorcode = this.getDeviceFromDCServerForRefresh(43832);
        if (errorcode != 0) {
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
            DCDebugTracer.trace("DeviceInfoManagerImpl#refreshDevices()  getDeviceFromDCServerForRefresh end.. errorcode : " + errorcode);
            return errorcode;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
        DCDebugTracer.trace("DeviceInfoManagerImpl#refreshDevices() end.. errorcode : " + errorcode);
        return errorcode;
    }

    public DeviceInfo[] serachByStar(DeviceInfo[] lDeviceList, String strDeviceName, int posstar) {
        Vector<DeviceInfo> finalSearchDevicesVec = new Vector<DeviceInfo>(0);
        String strsubDeviceName1 = "";
        String strsubDeviceName2 = "";
        if (posstar == 0) {
            strsubDeviceName2 = strDeviceName.substring(1, strDeviceName.length()).toLowerCase(DCResourceMng.getInstance().getLocale());
        } else {
            strsubDeviceName1 = strDeviceName.substring(0, posstar).toLowerCase(DCResourceMng.getInstance().getLocale());
            strsubDeviceName2 = posstar != strDeviceName.length() - 1 ? strDeviceName.substring(posstar + 1, strDeviceName.length()).toLowerCase(DCResourceMng.getInstance().getLocale()) : "";
        }
        int deviceListLength = lDeviceList.length;
        for (int i = 0; i < deviceListLength; ++i) {
            String strDevNameAfterStar;
            String deviceName = lDeviceList[i].getDevName();
            if (posstar == strDeviceName.length() - 1 && deviceName.toLowerCase(DCResourceMng.getInstance().getLocale()).startsWith(strsubDeviceName1.toLowerCase(DCResourceMng.getInstance().getLocale())) && !strDeviceName.equals("*")) {
                finalSearchDevicesVec.add(lDeviceList[i]);
                continue;
            }
            if (deviceName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(strsubDeviceName2.toLowerCase(DCResourceMng.getInstance().getLocale())) && posstar == 0 && !strDeviceName.equals("*")) {
                finalSearchDevicesVec.add(lDeviceList[i]);
                continue;
            }
            if (posstar == strDeviceName.length() - 1 || posstar == 0 || !deviceName.toLowerCase(DCResourceMng.getInstance().getLocale()).startsWith(strsubDeviceName1.toLowerCase(DCResourceMng.getInstance().getLocale())) || !(strDevNameAfterStar = deviceName.substring(strsubDeviceName1.length()).toLowerCase(DCResourceMng.getInstance().getLocale())).endsWith(strsubDeviceName2)) continue;
            finalSearchDevicesVec.add(lDeviceList[i]);
        }
        return finalSearchDevicesVec.toArray(new DeviceInfo[0]);
    }

    @Override
    public DeviceTypeInfo getDeviceTypeInfo(int aDeviceTypeId, int aDeviceTypeVersionId) {
        int deviceTypeListLength = -1;
        String sKey = aDeviceTypeId + "_" + aDeviceTypeVersionId;
        if (DCConstants.UNKNOW_TYPE_ID == aDeviceTypeId && DCConstants.UNKNOW_TYPE_ID == aDeviceTypeVersionId) {
            if (DCFrameWorkUtil.getIsSingleClient()) {
                if (StandAloneDomainInfo.getInstance().getSelectedDomain() == 2) {
                    DeviceTypeInfo oDevTypeInfo = new DeviceTypeInfo();
                    oDevTypeInfo.setDeviceType(DCConstants.UNKNOW_TYPE_ID);
                    oDevTypeInfo.setDevTypeVersionId(DCConstants.UNKNOW_TYPE_ID);
                    oDevTypeInfo.setDevTypeName(DCConstants.UNKNOW_TYPE);
                    oDevTypeInfo.setDevTypeVersionName(DCConstants.UNKNOW_TYPE);
                    return oDevTypeInfo;
                }
            } else {
                DeviceTypeInfo oDevTypeInfo = new DeviceTypeInfo();
                oDevTypeInfo.setDeviceType(DCConstants.UNKNOW_TYPE_ID);
                oDevTypeInfo.setDevTypeVersionId(DCConstants.UNKNOW_TYPE_ID);
                oDevTypeInfo.setDevTypeName(DCConstants.UNKNOW_TYPE);
                oDevTypeInfo.setDevTypeVersionName(DCConstants.UNKNOW_TYPE);
                return oDevTypeInfo;
            }
        }
        if (null == this.m_oDeviceTypeHm || this.m_oDeviceTypeHm.size() == 0) {
            this.getDeviceTypeFromDCServer();
        }
        if (this.m_oDeviceTypeHm != null) {
            deviceTypeListLength = this.m_oDeviceTypeHm.size();
            if (0 == deviceTypeListLength) {
                DCDebugTracer.trace("deviceTypeList is not null can not find device type deviceTypeID=" + aDeviceTypeId + " deviceTypeVersionID=" + aDeviceTypeVersionId);
                return null;
            }
            if (null == this.m_oDeviceTypeHm.get(sKey)) {
                this.getDeviceTypeFromDCServer();
            }
        } else {
            DCDebugTracer.trace("deviceTypeList is null can not find device type deviceTypeID=" + aDeviceTypeId + " deviceTypeVersionID=" + aDeviceTypeVersionId);
            return null;
        }
        DeviceTypeInfo devTypeInfo = (DeviceTypeInfo)CloneUtil.getClone(this.m_oDeviceTypeHm.get(sKey));
        if (null == devTypeInfo) {
            DCDebugTracer.trace("exit getDeviceTypeInfo can not find device type deviceTypeID=" + aDeviceTypeId + " deviceTypeVersionID=" + aDeviceTypeVersionId);
        }
        return devTypeInfo;
    }

    @Override
    public DeviceTypeInfo getDeviceTypeInfoByDevId(int iDeviceId) {
        DeviceTypeInfo oDevTypeInfo = null;
        DeviceInfo devInfo = this.getDevice(iDeviceId);
        if (null == devInfo) {
            DCDebugTracer.trace("DeviceInfoManagerImpl#getDeviceTypeInfoByDevId#devInfo is null,devid = " + iDeviceId);
            return null;
        }
        oDevTypeInfo = devInfo.getDeviceTypeInfo();
        if (null == oDevTypeInfo) {
            DCDebugTracer.trace("DeviceInfoManagerImpl#getDeviceTypeInfoByDevId#devTypeInfo is null,devid = " + iDeviceId);
            return null;
        }
        return oDevTypeInfo;
    }

    @Override
    public DeviceTypeInfo[] getDeviceTypeInfoByTypeID(int aDeviceTypeId) {
        DeviceTypeInfo[] devTypes = new DeviceTypeInfo[]{};
        if (!this.isCanGetDevTypeInfo()) {
            DCDebugTracer.trace("getDeviceTypeInfoByTypeID can not find device type aDeviceTypeId=" + aDeviceTypeId);
            return devTypes;
        }
        Vector tmpVec = new Vector();
        Set oSet = this.m_oDeviceTypeHm.entrySet();
        Iterator oItor = oSet.iterator();
        String sKey = "";
        Map.Entry oEntry = null;
        while (oItor.hasNext()) {
            oEntry = oItor.next();
            sKey = (String)oEntry.getKey();
            if (!sKey.startsWith(aDeviceTypeId + "_")) continue;
            tmpVec.add(oEntry.getValue());
        }
        devTypes = tmpVec.toArray(new DeviceTypeInfo[0]);
        return devTypes;
    }

    @Override
    public DeviceTypeInfo getFirstDeviceTypeInfo(int iDeviceTypeID) {
        DeviceTypeInfo oDeviceTypeInfo = null;
        int deviceTypeListLength = -1;
        if (null == this.m_oDeviceTypeHm) {
            this.getDeviceTypeFromDCServer();
        }
        if (this.m_oDeviceTypeHm != null) {
            deviceTypeListLength = this.m_oDeviceTypeHm.size();
            if (0 == deviceTypeListLength) {
                return oDeviceTypeInfo;
            }
        } else {
            return oDeviceTypeInfo;
        }
        Set oSet = this.m_oDeviceTypeHm.entrySet();
        Iterator oItor = oSet.iterator();
        String sKey = "";
        Map.Entry oEntry = null;
        while (oItor.hasNext()) {
            oEntry = oItor.next();
            sKey = (String)oEntry.getKey();
            if (!sKey.startsWith(iDeviceTypeID + "_")) continue;
            oDeviceTypeInfo = (DeviceTypeInfo)oEntry.getValue();
            break;
        }
        return oDeviceTypeInfo;
    }

    @Override
    public DeviceTypeInfo[] getDevTypeInfoByTypeName(String strDevTypeName) {
        DeviceTypeInfo[] devTypes = new DeviceTypeInfo[]{};
        if (!this.isCanGetDevTypeInfo()) {
            DCDebugTracer.trace("getDevTypeInfoByTypeName can not find device type strDevTypeName=" + strDevTypeName);
            return devTypes;
        }
        Vector<DeviceTypeInfo> tmpVec = new Vector<DeviceTypeInfo>();
        Set oSet = this.m_oDeviceTypeHm.entrySet();
        Iterator oItor = oSet.iterator();
        DeviceTypeInfo oDevType = null;
        while (oItor.hasNext()) {
            oDevType = (DeviceTypeInfo)oItor.next().getValue();
            if (!oDevType.getDevTypeName().equals(strDevTypeName)) continue;
            tmpVec.add(oDevType);
        }
        devTypes = tmpVec.toArray(new DeviceTypeInfo[0]);
        return devTypes;
    }

    @Override
    public int getDeviceTypeVersionId(int aDeviceTypeId) {
        int deviceTypeListLength = -1;
        int devTypeVersionId = -1;
        if (null == this.m_oDeviceTypeHm) {
            this.getDeviceTypeFromDCServer();
        }
        if (null != this.m_oDeviceTypeHm) {
            deviceTypeListLength = this.m_oDeviceTypeHm.size();
            if (0 == deviceTypeListLength) {
                return devTypeVersionId;
            }
        } else {
            return devTypeVersionId;
        }
        Set oSet = this.m_oDeviceTypeHm.entrySet();
        Iterator oItor = oSet.iterator();
        String sKey = "";
        Map.Entry oEntry = null;
        while (oItor.hasNext()) {
            oEntry = oItor.next();
            sKey = (String)oEntry.getKey();
            if (!sKey.startsWith(aDeviceTypeId + "_")) continue;
            String sVerID = sKey.substring(String.valueOf(aDeviceTypeId).length() + 1);
            devTypeVersionId = Integer.valueOf(sVerID);
            break;
        }
        return devTypeVersionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void processMessage(MSGPacketExt packetExt) {
        try {
            this.processAsynMessage(packetExt);
            return;
        }
        catch (Exception e) {
            if (43811 == packetExt.mheader.cmdCode || 43840 == packetExt.mheader.cmdCode) {
                byte[] byArray = this.m_oGetDevSyncObj;
                // MONITORENTER : this.m_oGetDevSyncObj
                this.m_oGetDevSyncObj.notifyAll();
                // MONITOREXIT : byArray
            }
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public DeviceInfo getDeviceFromAsn(AsnDCDeviceInfo asnDCDevice) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDevId(asnDCDevice.iDevId.intValue());
        if (null != asnDCDevice.iNeID) {
            deviceInfo.setNEDevId(asnDCDevice.iNeID.intValue());
        }
        if (null != asnDCDevice.iProtocol) {
            deviceInfo.setProtocol(asnDCDevice.iProtocol.intValue());
        }
        if (null != asnDCDevice.strNeTId) {
            deviceInfo.setNeTId(new String(asnDCDevice.strNeTId));
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("Device id = ");
            strBuf.append(deviceInfo.getDevId());
            strBuf.append("|Tid=");
            strBuf.append(deviceInfo.getNeTId());
            DCDebugTracer.trace(strBuf.toString());
        }
        if (null != asnDCDevice.strBoard) {
            deviceInfo.setDevBoardType(new String(asnDCDevice.strBoard));
        }
        deviceInfo.setDevIPAddress(new String(asnDCDevice.strDevIPAddress));
        deviceInfo.setDevName(new String(asnDCDevice.strDevName));
        deviceInfo.setDevType(this.getDeviceTypeInfo(asnDCDevice.iDevTypeId.intValue(), asnDCDevice.iDevTypeVersionId.intValue()));
        deviceInfo.setDevTypeVersionId(asnDCDevice.iDevTypeVersionId.intValue());
        DeviceVersionInfo devVersion = new DeviceVersionInfo();
        devVersion.setDevId(asnDCDevice.iDevId.intValue());
        if (null != asnDCDevice.strDevVersion) {
            devVersion.setDevVersion(new String(asnDCDevice.strDevVersion));
            deviceInfo.setDevVersionId(devVersion);
        }
        if (null != asnDCDevice.strDevPatchVersion) {
            devVersion.setPatchVersion(new String(asnDCDevice.strDevPatchVersion));
        }
        if (null != asnDCDevice.oErrorInfo && null != asnDCDevice.oLastOperationState) {
            String m_strResult = null;
            if (null != asnDCDevice.oErrorInfo.strResult) {
                m_strResult = new String(asnDCDevice.oErrorInfo.strResult);
            }
            deviceInfo.setLastOperationErrorCode(asnDCDevice.oErrorInfo.iErrorNo.intValue(), asnDCDevice.oLastOperationState.value);
            deviceInfo.setLastOperationErrorCode(asnDCDevice.oErrorInfo.iErrorNo.intValue(), m_strResult);
        }
        deviceInfo.setLastOperationType(-1);
        if (null != asnDCDevice.enLastOperationType) {
            deviceInfo.setLastOperationType(asnDCDevice.enLastOperationType.value);
        }
        deviceInfo.setRoleType(asnDCDevice.enRoleType.value);
        DCDebugTracer.trace("AsnDCDeviceInfo::enRoleType:" + asnDCDevice.enRoleType.value);
        return deviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceInfo[] getDeviceInfoByTypeOrVersion(int aDeviceType, int aDeviceTypeVersion) {
        Vector<DeviceInfo> deviceVec = new Vector<DeviceInfo>(0);
        Object object = this.sycObj;
        synchronized (object) {
            if (this.m_oDevIdDevInfoMap.isEmpty()) {
                return null;
            }
            Collection oDevSet = this.m_oDevIdDevInfoMap.values();
            for (DeviceInfo oDevInfo : oDevSet) {
                if (null == oDevInfo || null == oDevInfo.getDeviceTypeInfo() || oDevInfo.getDeviceTypeInfo().getDevTypeID() != aDeviceType && oDevInfo.getDeviceTypeInfo().getDevTypeVersionId() != aDeviceTypeVersion) continue;
                deviceVec.add(oDevInfo);
            }
        }
        return deviceVec.toArray(new DeviceInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySyncObject() {
        byte[] byArray = this.syncObj;
        synchronized (this.syncObj) {
            this.syncObj.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void unregisterForVersion() {
        DCFrameWorkUtil.getCommManager().removeMessageListener(43829, (MSGListener)this);
    }

    public Set getMxuDeviceIDLst() {
        return this.mxuDeviceIDLst;
    }

    @Override
    public int getBoardVersion(int iDeviceId) {
        return DevInfoSynMsgHelper.getBoardVersion(iDeviceId, this);
    }

    @Override
    public SubMapInfo getSubMapInfo() {
        return this.m_oSubMapInfo;
    }

    @Override
    public SubMapInfo getSubMapInfoByDevID(SubMapInfo subMapInfo, int devID) {
        return SubMapInfoHelper.getSubMapInfoByDevID(subMapInfo, devID);
    }

    @Override
    public SubMapInfo getOLTSubmapInfo() {
        return this.m_oLTSubMapInfo;
    }

    @Override
    public DeviceInfo[] getDevices(OLTDevVerInfo oLTDevVerInfo) {
        DeviceInfo[] deviceInfoLst = null;
        if (null == oLTDevVerInfo) {
            return null;
        }
        ArrayList devIDList = oLTDevVerInfo.getDevIDLst();
        DeviceInfo deviceInfo = null;
        int devID = -1;
        Vector<DeviceInfo> devcieInfoVct = new Vector<DeviceInfo>();
        int devCount = devIDList.size();
        for (int i = 0; i < devCount; ++i) {
            devID = (Integer)devIDList.get(i);
            deviceInfo = this.getDevice(devID);
            devcieInfoVct.add(deviceInfo);
        }
        deviceInfoLst = new DeviceInfo[devCount];
        deviceInfoLst = devcieInfoVct.toArray(deviceInfoLst);
        return deviceInfoLst;
    }

    @Override
    public SubMapInfo getMxuSubMapInfo() {
        if (null != this.oMxuSubMapInfo) {
            return this.oMxuSubMapInfo;
        }
        this.initMxuSubmapInfo();
        return this.oMxuSubMapInfo;
    }

    @Override
    public String getBoardNameForT2000(int iBoardId) {
        return DeviceInfoManagerImplHelper.getBoardNameForT2000(iBoardId);
    }

    @Override
    public boolean isBusyInGettingSubmapInfo() {
        return this.m_bIsGettingSubmapInfo;
    }

    @Override
    public void unRegisterForNotification(int iCmdCode) {
        if (null != DCFrameWorkUtil.getCommManager()) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(iCmdCode, (MSGListener)this);
        }
    }

    @Override
    public int getBackupFileList(int iDevId, AsnBackUpFileListResp asnBackUpFileListResp) {
        return DevInfoSynMsgHelper.getBackupFileList(iDevId, asnBackUpFileListResp);
    }

    @Override
    public int getSaveAsBackupFileList(List<BigInteger> oDevIDList, AsnBackUpFileListResp oAsnBackUpFileListResp) {
        return DevInfoSynMsgHelper.getSaveAsBackupFileList(oDevIDList, oAsnBackUpFileListResp);
    }

    @Override
    public int deleteBackupFiles(AsnDeleteBackUpFileReq asnDeleteBackUpFileReq, AsnDCDeleteFileListResp asnDCDeleteFileListResp) {
        return DevInfoSynMsgHelper.deleteBackupFiles(asnDeleteBackUpFileReq, asnDCDeleteFileListResp);
    }

    @Override
    public SubMapInfo getSubmapForID(String strSubMapID) {
        if (null == this.m_oSubMapInfo || null == strSubMapID) {
            return null;
        }
        return this.getSubmapForID(strSubMapID, this.m_oSubMapInfo);
    }

    @Override
    public SubMapInfo getSubmapForID(String strSubMapID, SubMapInfo oMainSubMap) {
        return SubMapInfoHelper.getSubmapForID(strSubMapID, oMainSubMap);
    }

    @Override
    public DeviceInfo[] getDevicesRecursivelyInSubMap(SubMapInfo oSubMapInfo) {
        if (null == oSubMapInfo) {
            return new DeviceInfo[0];
        }
        if (null != oSubMapInfo.m_strSubMapID && oSubMapInfo.m_strSubMapID.equals(this.m_oSubMapInfo.m_strSubMapID)) {
            return this.getDevices();
        }
        Set<Integer> oDeviceList = SubMapInfoHelper.getDeviIDRecursivelyInSubMap(oSubMapInfo);
        return this.getDevices(oDeviceList);
    }

    @Override
    public DeviceInfo[] getDevicesSubMapCurLev(SubMapInfo oSubMapInfo) {
        if (null == oSubMapInfo) {
            return new DeviceInfo[0];
        }
        Set<Integer> oDeviceList = SubMapInfoHelper.getDevicesInSubMap(oSubMapInfo);
        return this.getDevices(oDeviceList);
    }

    @Override
    public boolean isDevicePresentInSubMap(int iDeviceID, SubMapInfo oSubMapInfo) {
        return SubMapInfoHelper.isDevicePresentInSubMap(iDeviceID, oSubMapInfo);
    }

    @Override
    public SubMapInfo getParentSubmap(SubMapInfo oRootSubmap, SubMapInfo oChildSubmap) {
        return SubMapInfoHelper.getParentSubmap(oRootSubmap, oChildSubmap);
    }

    @Override
    public DeviceInfo[] filterDevicesByType(DeviceInfo[] oOriginalDeviceList, int iDeviceTypeID, int iTypeVersionID) {
        return DeviceInfoManagerImplHelper.filterDevicesByType(oOriginalDeviceList, iDeviceTypeID, iTypeVersionID);
    }

    @Override
    public DeviceInfo[] filterDevicesByVersion(DeviceInfo[] oOriginalDeviceList, String strVersion, DeviceTypeInfo oDeviceTypeInfo) {
        return DeviceInfoManagerImplHelper.filterDevicesByVersion(oOriginalDeviceList, strVersion, oDeviceTypeInfo);
    }

    @Override
    public Resource getResourceForID(int iDeviceID) {
        DeviceInfo oDeviceInfo = this.getDevice(iDeviceID);
        if (oDeviceInfo == null) {
            return null;
        }
        return DeviceInfoManagerImplHelper.converDevInfoToRes(oDeviceInfo);
    }

    @Override
    public boolean isDomainSupported(int iDomainType) {
        DCDebugTracer.trace("Method isDomainSupported start");
        boolean bFlag = false;
        DeviceTypeInfo[] oDevicetypeInfo = this.getDeviceTypes();
        int iSize = oDevicetypeInfo.length;
        for (int i = 0; i < iSize; ++i) {
            if (iDomainType != oDevicetypeInfo[i].getDevDomain()) continue;
            bFlag = true;
            break;
        }
        DCDebugTracer.trace("Method isDomainSupported end..");
        return bFlag;
    }

    @Override
    public ValidationResult validateDeviceSelection(DeviceSelectionPanel m_oDeviceSelectionPanel, ITask m_oTaskDataObj, DeviceTypeInfo m_oDevTypeInfo) {
        return DeviceInfoManagerImplHelper.validateDeviceSelection(m_oDeviceSelectionPanel, m_oTaskDataObj, m_oDevTypeInfo);
    }

    @Override
    public boolean isMxuDevicesPresent() {
        boolean bIsMxu = false;
        if (null == this.m_oDeviceTypeHm) {
            return bIsMxu;
        }
        Set oEntrySet = this.m_oDeviceTypeHm.entrySet();
        Iterator oDevTypeItor = oEntrySet.iterator();
        DeviceTypeInfo oDevType = null;
        while (oDevTypeItor.hasNext()) {
            oDevType = (DeviceTypeInfo)oDevTypeItor.next().getValue();
            if (null == oDevType || !oDevType.getIsMXUDevice()) continue;
            bIsMxu = true;
            break;
        }
        return bIsMxu;
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst deviceInfoList) {
        DCDebugTracer.trace("[DeviceConfigNotification] method handleDeviceConfigNotification start");
        DCDebugTracer.trace("[DeviceConfigNotification] iEventType : " + iEventType);
        switch (iEventType) {
            case 0: {
                this.m_isDevConfigurationChanged = true;
                this.handleDeviceAddNotification(deviceInfoList);
                break;
            }
            case 1: {
                this.m_isDevConfigurationChanged = true;
                this.handleDeviceDeleteNotification(deviceInfoList);
                DeviceInfoManagerImplHelper.refreshPolicyTree();
                break;
            }
            case 2: {
                this.m_isDevConfigurationChanged = true;
                this.handleDeviceModifyNotification(deviceInfoList);
                break;
            }
            case 3: {
                this.handleSubMapAddNotification(deviceInfoList);
                DeviceInfoManagerImplHelper.refreshPolicyTree();
                break;
            }
            case 4: {
                this.handleSubMapDeleteNotification(deviceInfoList);
                DeviceInfoManagerImplHelper.refreshPolicyTree();
                break;
            }
            case 5: {
                this.handleSubMapModifyNotification(deviceInfoList, this.m_oSubMapInfo);
                DeviceInfoManagerImplHelper.refreshPolicyTree();
                break;
            }
        }
        if (DCFrameWorkUtil.getIsSingleClient()) {
            DataCenterModuleManager dcModuleManager = DCFrameWorkUtil.getDCModuleManager();
            dcModuleManager.refreshDomainMenus();
        }
        DCDebugTracer.trace("[DeviceConfigNotification] method handleDeviceConfigNotification end..");
    }

    @Override
    public int getMaxDevID() {
        return this.m_iMaxDevID;
    }

    @Override
    public void registManualOprMessage(IManualOperation oManualOperation) {
        this.m_oManualOperationVec.add(oManualOperation);
    }

    @Override
    public int getDevicesCount() {
        return this.m_oDevIdDevInfoMap.size();
    }

    @Override
    public Map<Integer, SubMapInfo> getSubMapList() {
        return this.m_oSubMapList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clientId;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        result = 31 * result + this.userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceInfoManagerImpl other = (DeviceInfoManagerImpl)obj;
        if (this.clientId != other.clientId) {
            return false;
        }
        if (this.firstOpenClientTime != other.firstOpenClientTime) {
            return false;
        }
        return this.userId == other.userId;
    }

    @Override
    public boolean isHaveResourceInSys() {
        return this.m_oDevIdDevInfoMap.size() != 0;
    }

    @Override
    public TIntIntHashMap getOLTIDWithMXUIDMap(DeviceInfo[] devInfoLst) throws DCException {
        DCDebugTracer.trace("Method getOLTIDWithMXUIDMap start");
        AsnGetOLTIDByMxUIDReq oAsnGetOLTIDByMxUIDReq = new AsnGetOLTIDByMxUIDReq();
        for (DeviceInfo deviceInfo : devInfoLst) {
            if (!this.mxuDeviceIDLst.contains(deviceInfo.getDevId()) || this.oOLTIDWithMXUIDMap.contains(deviceInfo.getDevId())) continue;
            oAsnGetOLTIDByMxUIDReq.oMxUIDList.add((Object)BigInteger.valueOf(deviceInfo.getDevId()));
        }
        if (0 == oAsnGetOLTIDByMxUIDReq.oMxUIDList.size()) {
            return this.oOLTIDWithMXUIDMap;
        }
        return SubMapInfoHelper.getOLTNEIDWithMXUID(oAsnGetOLTIDByMxUIDReq, this.oOLTIDWithMXUIDMap);
    }

    @Override
    public TIntIntHashMap getOLTIDWithMXUIDMap(THashSet<Resource> resourceList) throws DCException {
        DCDebugTracer.trace("Method getOLTIDWithMXUIDMap start");
        Resource resource2 = null;
        AsnGetOLTIDByMxUIDReq oAsnGetOLTIDByMxUIDReq = new AsnGetOLTIDByMxUIDReq();
        for (Resource resource2 : resourceList) {
            if (this.oOLTIDWithMXUIDMap.contains(resource2.getDeviceID())) continue;
            oAsnGetOLTIDByMxUIDReq.oMxUIDList.add((Object)BigInteger.valueOf(resource2.getDeviceID()));
        }
        if (0 == oAsnGetOLTIDByMxUIDReq.oMxUIDList.size()) {
            return this.oOLTIDWithMXUIDMap;
        }
        return SubMapInfoHelper.getOLTNEIDWithMXUID(oAsnGetOLTIDByMxUIDReq, this.oOLTIDWithMXUIDMap);
    }

    @Override
    public boolean isFinishGetDevAndSubmapInfo() {
        return this.isFinishGetDevAndSubmapInfo;
    }
}

