/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.controller;

import com.huawei.dc.adapter.swimap.iview.framework.util.DCFrameworkUtilities;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnBackUpFileListResp;
import com.huawei.dc.common.asndatacenter.AsnDCDeleteFileListResp;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceIdReq;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLst;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLstRsp;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnDeleteBackUpFileReq;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.GUIConstants;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class DevInfoSynMsgHelper {
    static int deleteBackupFiles(final AsnDeleteBackUpFileReq asnDeleteBackUpFileReq, final AsnDCDeleteFileListResp asnDCDeleteFileListResp) {
        int iReturnCode;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43857), (FStruct)asnDeleteBackUpFileReq, (FStruct)asnDCDeleteFileListResp);
                return iErrorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameworkUtilities.getMainFrame(), true);
        if (syncCommand.getResult() != null && (iReturnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            return iReturnCode;
        }
        return asnDCDeleteFileListResp.oErrorInfo.iErrorNo.intValue();
    }

    static int getSaveAsBackupFileList(List<BigInteger> oDevIDList, final AsnBackUpFileListResp oAsnBackUpFileListResp) {
        int iReturnCode;
        final AsnDCIntegerLst oAsnDeviceIdReq = new AsnDCIntegerLst();
        int iSize = oDevIDList.size();
        for (int i = 0; i < iSize; ++i) {
            oAsnDeviceIdReq.add((Object)oDevIDList.get(i));
        }
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43856), (FStruct)oAsnDeviceIdReq, (FStruct)oAsnBackUpFileListResp);
                return iErrorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameworkUtilities.getMainFrame(), true);
        if (syncCommand.getResult() != null && (iReturnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            return iReturnCode;
        }
        return oAsnBackUpFileListResp.iErrorCode.iErrorNo.intValue();
    }

    static int getBackupFileList(int iDevId, AsnBackUpFileListResp asnBackUpFileListResp) {
        AsnDCDeviceIdReq asnDeviceIdReq = new AsnDCDeviceIdReq();
        asnDeviceIdReq.iDeviceId = BigInteger.valueOf(iDevId);
        BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
        DCFrameWorkUtil.getCommManager();
        int iErrorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43856), (FStruct)asnDeviceIdReq, (FStruct)asnBackUpFileListResp);
        if (iErrorcode != 0) {
            return iErrorcode;
        }
        return asnBackUpFileListResp.iErrorCode.iErrorNo.intValue();
    }

    static int getBoardVersion(final int iDeviceId, AbstractDeviceInfoManager devInfoManager) {
        DCDebugTracer.trace("getBoardVersion iDeviceId:" + iDeviceId);
        final AsnDCOpertionRsp asnOperationRsp = new AsnDCOpertionRsp();
        DCFrameWorkUtil.getCommManager().addMessageListener(43850, (MSGListener)devInfoManager);
        int errorcode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                AsnDCDeviceIdReq asnDevIdReq = new AsnDCDeviceIdReq();
                asnDevIdReq.iDeviceId = BigInteger.valueOf(iDeviceId);
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43850, 0, 0, GUIConstants.DC_SERVER_ID), (FStruct)asnDevIdReq, (FStruct)asnOperationRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (errorcode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(43850, (MSGListener)devInfoManager);
            return errorcode;
        }
        errorcode = asnOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (errorcode != 0) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(43850, (MSGListener)devInfoManager);
        }
        return errorcode;
    }

    static void getDevicesVersion(int iReqId, DeviceInfo[] oDevInfo) throws DCException {
        int returnCode;
        final AsnDCSyncReq oAsnGetVersionReq = new AsnDCSyncReq();
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        oAsnGetVersionReq.oReqID = BigInteger.valueOf(iReqId);
        int iLength = oDevInfo.length;
        for (int i = 0; i < iLength; ++i) {
            oAsnGetVersionReq.oDevIDLst.add((Object)BigInteger.valueOf(oDevInfo[i].getDevId()));
        }
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43829), (FStruct)oAsnGetVersionReq, (FStruct)oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (0 != oRsp.oErrorInfo.iErrorNo.intValue()) {
            int errorCode = oRsp.oErrorInfo.iErrorNo.intValue();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            throw new DCException(errorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorCode)));
        }
    }

    public static DeviceInfo[] getDevInfoByAppointedDevIds(int[] arrDevId) throws DCException {
        AsnDCIntegerLst oGetDevInfoReq = new AsnDCIntegerLst();
        AsnDCDeviceLstRsp oGetDevInfoRsp = new AsnDCDeviceLstRsp();
        for (int iDevId : arrDevId) {
            oGetDevInfoReq.add((Object)BigInteger.valueOf(iDevId));
        }
        int errorcode = DCFrameWorkUtil.getCommManager().sendSyncMsgWithSyncCommand(44068, (FStruct)oGetDevInfoReq, (FStruct)oGetDevInfoRsp);
        DCDebugTracer.trace("errorcode : " + errorcode);
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("GET_DEVICETYPE_INFO_ERROR"));
        }
        errorcode = oGetDevInfoRsp.oErrorInfo.iErrorNo.intValue();
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("GET_DEVICETYPE_INFO_ERROR"));
        }
        AsnDCDeviceLst asnDeviceList = oGetDevInfoRsp.oDeviceLst;
        int length = asnDeviceList.size();
        Vector<DeviceInfo> oDevInfoVec = new Vector<DeviceInfo>(length);
        for (int i = 0; i < length; ++i) {
            AsnDCDeviceInfo asnDevice = (AsnDCDeviceInfo)asnDeviceList.elementAt(i);
            DeviceInfo deviceInfo = DeviceInfoManagerImpl.getInstance().getDeviceFromAsn(asnDevice);
            oDevInfoVec.add(deviceInfo);
        }
        return oDevInfoVec.toArray(new DeviceInfo[0]);
    }
}

