/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.controller;

import com.huawei.dc.common.asndatacenter.FStruDecoderFixUTC;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.ShakeHandThread;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.GUIConstants;
import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.MSGHead;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import com.swimap.iview.communicate.MSGSyncReceiver;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.awt.Cursor;
import java.io.Serializable;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public abstract class BaseCommManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected CommHandle m_oCommHandle = null;
    private ShakeHandThread m_oShakehandThread;
    private int m_iTimes;

    protected BaseCommManager() {
        String TIMEOUTPERIOD = ResourceManager.getInstance().getResString("Default_Time_Out", "config");
        try {
            this.m_iTimes = Integer.parseInt(TIMEOUTPERIOD);
        }
        catch (NumberFormatException nfe) {
            this.m_iTimes = 25000;
        }
        catch (Exception e) {
            this.m_iTimes = 25000;
        }
    }

    public static final MSGHead getMSGHead(int iCmdCode) {
        MSGHead head = new MSGHead();
        head.cmdCode = (char)iCmdCode;
        head.receiverProcID = GUIConstants.DC_SERVER_ID;
        head.receiverModule = 0;
        head.msgType = (byte)6;
        head.cmdHandle = '\u0000';
        head.senderCmdHandle = '\u0000';
        return head;
    }

    public static final MSGHead getMSGHead(int iCmdCode, int iServerProcessId) {
        MSGHead head = new MSGHead();
        head.cmdCode = (char)iCmdCode;
        head.receiverProcID = (char)iServerProcessId;
        head.receiverModule = 0;
        head.msgType = (byte)6;
        head.cmdHandle = '\u0000';
        head.senderCmdHandle = '\u0000';
        return head;
    }

    public static final MSGHead getMSGHead(int iCmdCode, int oRecvCmdHandle, int iServerModuleId, int iServerProcessId) {
        MSGHead head = new MSGHead();
        head.cmdCode = (char)iCmdCode;
        head.receiverProcID = (char)iServerProcessId;
        head.receiverModule = (byte)iServerModuleId;
        head.msgType = (byte)6;
        head.cmdHandle = (char)oRecvCmdHandle;
        head.senderCmdHandle = '\u0000';
        return head;
    }

    public final int sendAsyncMsg(MSGHead oMsgHead, FStruct oData, MSGReceiver listener) {
        if (null == this.m_oCommHandle) {
            return 996147202;
        }
        try {
            this.m_oCommHandle.sendAsyncMessage(oMsgHead, oData, (MSGListener)listener, this.m_iTimes);
        }
        catch (FStruException asnEx) {
            return 996147201;
        }
        catch (Exception ioEx) {
            return 996147203;
        }
        return 0;
    }

    public int sendSyncMsg(MSGHead oMsgHead, FStruct oSendData, FStruct oRecvData) {
        int error = this.sendSyncMsg(oMsgHead, oSendData, oRecvData, this.m_iTimes);
        return error;
    }

    public int sendSyncMsgWithSyncCommand(final int iCmdCode, final FStruct oSendData, final FStruct oRecvData) {
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = BaseCommManager.this.sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode), oSendData, oRecvData);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int returnCode = 0;
        if (syncCommand.getResult() != null) {
            returnCode = (Integer)syncCommand.getResult();
        }
        return returnCode;
    }

    public final int sendSyncMsgInBkground(MSGHead oMsgHead, FStruct oSendData, FStruct oRecvData) {
        if (null == this.m_oCommHandle) {
            return 996147202;
        }
        MSGSyncReceiver reply = new MSGSyncReceiver();
        int errorcode = this.m_oCommHandle.sendMessage(oMsgHead, oSendData, reply, this.m_iTimes);
        if (0 != errorcode) {
            return errorcode;
        }
        MSGPacketExt[] result = reply.getResults();
        if (null == result || 0 == result.length) {
            return 996147204;
        }
        if (1 == result.length) {
            byte[] bytes = result[0].getData();
            if (null == bytes) {
                return 996147205;
            }
            int error = this.decodeAsn1Data(oRecvData, bytes);
            if (0 != error) {
                return error;
            }
        }
        return 0;
    }

    public final int sendSyncMsg(MSGHead oMsgHead, FStruct oSendData, FStruct oRecvData, int iTimes) {
        if (null == this.m_oCommHandle) {
            return 996147202;
        }
        this.setWaitingCursor();
        MSGSyncReceiver reply = new MSGSyncReceiver();
        int errorcode = -1;
        try {
            errorcode = this.m_oCommHandle.sendMessage(oMsgHead, oSendData, reply, iTimes);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        if (0 != errorcode) {
            this.setDefaultCursor();
            return errorcode;
        }
        MSGPacketExt[] result = reply.getResults();
        if (null == result || 0 == result.length) {
            this.setDefaultCursor();
            return 996147204;
        }
        if (1 == result.length) {
            byte[] bytes = result[0].getData();
            if (null == bytes) {
                this.setDefaultCursor();
                return 996147205;
            }
            int error = this.decodeAsn1Data(oRecvData, bytes);
            if (0 != error) {
                this.setDefaultCursor();
                return error;
            }
        }
        this.setDefaultCursor();
        return 0;
    }

    public void addMessageListener(int iCmdID, MSGListener listener) {
        this.m_oCommHandle.addMessageListener((int)((char)iCmdID), listener);
    }

    public final void removeMessageListener(int iCmdID, MSGListener listener) {
        try {
            if (null != this.m_oCommHandle) {
                this.m_oCommHandle.removeMessageListener((int)((char)iCmdID), listener);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            DCDebugTracer.trace("Fail to removeMessageListener. the exception is" + iCmdID);
        }
    }

    public final int decodeAsn1Data(FStruct oDestData, byte[] arrSrcData) {
        return this.decodeAsn1Data(oDestData, arrSrcData, true);
    }

    public final int decodeAsn1Data(FStruct oDestData, byte[] arrSrcData, boolean isTrace) {
        try {
            if (arrSrcData == null || 0 == arrSrcData.length) {
                return 996147200;
            }
            FStruDecoderFixUTC dec = new FStruDecoderFixUTC(arrSrcData);
            oDestData.deserialize((Decoder)dec);
        }
        catch (Exception ex) {
            if (isTrace) {
                DCDebugTracer.trace(ex);
            }
            return 996147201;
        }
        return 0;
    }

    public final int sendHandShakeMsg(MSGHead oMsgHead, FStruct oSendData, FStruct oRecvData, int iTimes) {
        if (null == this.m_oCommHandle) {
            return 996147202;
        }
        MSGSyncReceiver reply = new MSGSyncReceiver();
        int errorcode = this.m_oCommHandle.sendMessage(oMsgHead, oSendData, reply, iTimes);
        if (0 != errorcode) {
            return errorcode;
        }
        MSGPacketExt[] result = reply.getResults();
        if (null == result || 0 == result.length) {
            return 996147204;
        }
        if (1 == result.length) {
            byte[] bytes = result[0].getData();
            if (null == bytes) {
                return 996147205;
            }
            int error = this.decodeAsn1Data(oRecvData, bytes);
            if (0 != error) {
                return error;
            }
        }
        return 0;
    }

    public CommHandle getCommHandle() {
        return this.m_oCommHandle;
    }

    public void startShakeHand() {
        if (null == this.m_oShakehandThread) {
            this.m_oShakehandThread = new ShakeHandThread();
            this.m_oShakehandThread.startShakeHand();
            this.m_oShakehandThread.start();
        } else {
            this.m_oShakehandThread.startShakeHand();
        }
    }

    public void stopShakeHand() {
        if (null != this.m_oShakehandThread) {
            this.m_oShakehandThread.stopShakeHand();
            this.m_oShakehandThread = null;
        }
    }

    public final void setWaitingCursor() {
        new Cursor(3);
    }

    public final void setDefaultCursor() {
        new Cursor(0);
    }
}

