/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.controller;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.asndatacenter.AsnCustomOpRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoardNotification;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLst;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLstRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCGetSubMapInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCLogicalGroupList;
import com.huawei.dc.common.asndatacenter.AsnDCNonLogicalDeviceList;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCT2000DeviceRsp;
import com.huawei.dc.common.asndatacenter.DCStringList;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImplHelper;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.controller.SubMapInfoHelper;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceinfo.DeviceVersionInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.security.ISecurityManager;
import com.huawei.dc.standalone.IManualOperation;
import com.huawei.dc.standalone.StandAloneCommonOpr;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.swimap.iview.communicate.MSGPacketExt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIterator;
import java.awt.Cursor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public abstract class AbstractDeviceInfoManager
extends AbstractDCMSGReceiver
implements IDeviceConfigChangeListener,
IDeviceInfoManager,
IDCObjectDeallocator {
    protected boolean m_bFirst = true;
    protected boolean m_bLogicalFirst = true;
    protected boolean m_bFirstError = true;
    protected boolean m_bDeviceInfoObtained = false;
    protected boolean m_bGroupInfoObtained = false;
    private boolean m_bIsrefreshDeviceType = false;
    private static int mPacketCount = 0;
    private static int mPacketTemp = 0;
    protected AsnDCLogicalGroupList m_tempasnLogicalList = new AsnDCLogicalGroupList();
    protected AsnDCNonLogicalDeviceList m_tempasnNonLogicalList = new AsnDCNonLogicalDeviceList();
    protected boolean m_bSNMPDevicesPresent = false;
    protected SubMapInfo m_oSubMapInfo = null;
    protected SubMapInfo m_oLTSubMapInfo = new SubMapInfo();
    private Set odnSubMapIDLst = Collections.synchronizedSet(new HashSet());
    protected SubMapInfo oMxuSubMapInfo = null;
    protected Set mxuDeviceIDLst = Collections.synchronizedSet(new HashSet());
    protected boolean m_bIsGettingSubmapInfo = false;
    protected Object sycObj = new Object();
    protected boolean m_bDeviceFound = false;
    protected Vector devTypeListByDiffusionTask = new Vector(0);
    protected THashMap<Integer, DeviceInfo> m_oDevIdDevInfoMap = new THashMap(4);
    protected TIntIntHashMap oOLTIDWithMXUIDMap = new TIntIntHashMap();
    private boolean isFinalForDevInfo = false;
    private boolean isFinalForSubMapInfo = false;
    protected boolean m_isNeedToGotDeviceInfo = true;
    protected boolean m_isFirstPackage = true;
    private boolean isNeedWait = true;
    protected final Semaphore objGetDevLock = new Semaphore(1, true);
    protected Map<Integer, SubMapInfo> m_oSubMapList = new HashMap<Integer, SubMapInfo>();
    protected HashMap<String, HashMap<String, SubMapInfo>> allSubmapInfo = new HashMap();
    protected boolean isFinishGetDevAndSubmapInfo = false;
    private static final int[] LISTENER_ARRAY = new int[]{43811, 43829, 43840, 43981, 44005, 44047, 43850, 43962, 43952, 54062, 44105};
    protected String m_strSupportDevTypes = "";
    protected AsnDCSubMapInfoLst oDCSubMapInfoLst = new AsnDCSubMapInfoLst();
    protected boolean m_isDevConfigurationChanged = true;
    protected List<AsnDCDeviceLstRsp> oDCDeviceLstRspLst = new ArrayList<AsnDCDeviceLstRsp>();
    protected List<AsnDCT2000DeviceRsp> oT2000DevInfoLstRspLst = new ArrayList<AsnDCT2000DeviceRsp>();
    protected List<T2000DevInfo> oT2000DevInfoLst = new ArrayList<T2000DevInfo>();
    private HashMap<String, Boolean> enableSubMap = new HashMap();

    protected AbstractDeviceInfoManager() {
        super(LISTENER_ARRAY);
    }

    private synchronized boolean isNeedWait() {
        return this.isNeedWait;
    }

    protected synchronized void setNeedWait(boolean mIsNeedWait) {
        this.isNeedWait = mIsNeedWait;
    }

    protected int getDeviceFromDCServer() {
        return this.getDeviceFromDCServerWithParent(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getDeviceFromDCServer(int iCmdCode) {
        Object object;
        BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
        DCFrameWorkUtil.getCommManager();
        int errorcode = baseCommManager.sendAsyncMsg(BaseCommManager.getMSGHead(iCmdCode), null, this);
        if (errorcode != 0) {
            this.m_bIsGettingSubmapInfo = false;
            DCDebugTracer.trace("[DEVMGR]send cmd " + iCmdCode + " error");
            return errorcode;
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.m_bIsGettingSubmapInfo = true;
        }
        this.m_bIsrefreshDeviceType = true;
        this.isFinishGetDevAndSubmapInfo = false;
        this.deviceInfoVec.clear();
        this.odnSubMapIDLst.clear();
        this.oDCSubMapInfoLst.clear();
        this.oDCDeviceLstRspLst.clear();
        this.m_oSubMapList.clear();
        this.allSubmapInfo.clear();
        this.clearData();
        this.m_oSubMapInfo = null;
        this.m_oLTSubMapInfo = new SubMapInfo();
        if (this.isNeedWait()) {
            try {
                object = this.m_oGetDevSyncObj;
                synchronized (this.m_oGetDevSyncObj) {
                    this.m_oGetDevSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                    DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
                    // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                }
            }
            catch (InterruptedException ex) {
                DCDebugTracer.trace(ex);
            }
        }
        {
            this.setNeedWait(true);
            if (this.getDeviceInfoError() != 0) {
                return this.getDeviceInfoError();
            }
            Object object2 = this.sycObj;
            object = object2;
            synchronized (object2) {
                if (null != this.deviceInfoVec) {
                    this.m_arrDeviceInfo = this.deviceInfoVec.toArray(new DeviceInfo[0]);
                }
                // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                this.m_bSNMPDevicesPresent = true;
                return errorcode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getDeviceFromDCServerForRefresh(int iCmdCode) {
        Object object;
        AsnCustomOpRsp AsnGetDevRsp = new AsnCustomOpRsp();
        BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
        DCFrameWorkUtil.getCommManager();
        int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode), null, (FStruct)AsnGetDevRsp, 5000);
        if (errorcode != 0) {
            this.m_bIsGettingSubmapInfo = false;
            return errorcode;
        }
        if (AsnGetDevRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            this.m_bIsGettingSubmapInfo = false;
            return AsnGetDevRsp.oErrorInfo.iErrorNo.intValue();
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.m_bIsGettingSubmapInfo = true;
        }
        this.m_bIsrefreshDeviceType = true;
        this.deviceInfoVec.clear();
        this.odnSubMapIDLst.clear();
        this.oDCSubMapInfoLst.clear();
        this.m_oSubMapInfo = null;
        this.m_oSubMapList.clear();
        this.allSubmapInfo.clear();
        this.oDCDeviceLstRspLst.clear();
        this.m_oLTSubMapInfo = new SubMapInfo();
        try {
            object = this.m_oGetDevSyncObj;
            synchronized (this.m_oGetDevSyncObj) {
                this.m_oGetDevSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
                // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
            }
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        {
            if (this.getDeviceInfoError() != 0) {
                return this.getDeviceInfoError();
            }
            Object object2 = this.sycObj;
            object = object2;
            synchronized (object2) {
                if (null != this.deviceInfoVec) {
                    this.m_arrDeviceInfo = this.deviceInfoVec.toArray(new DeviceInfo[0]);
                }
                // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
                this.m_bSNMPDevicesPresent = true;
                return errorcode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceVersion(AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification) {
        int iDeviceID = oAsnDCDeviceBoardNotification.oVersionInfo.iDeviceId.intValue();
        if (this.m_oDevIdDevInfoMap.isEmpty()) {
            return;
        }
        Object object = this.sycObj;
        synchronized (object) {
            DeviceInfo oDevInfo = this.getDevice(iDeviceID);
            if (null != oDevInfo) {
                DeviceVersionInfo oVersionInfo = oDevInfo.getDevVersion();
                String m_strVersion = new String(oAsnDCDeviceBoardNotification.oVersionInfo.strVersion);
                if (!(null == oVersionInfo || m_strVersion.length() == 0 && m_strVersion.equals(""))) {
                    oVersionInfo.setDevVersion(m_strVersion);
                }
                String m_strPatchVersion = "";
                if (null != oAsnDCDeviceBoardNotification.oVersionInfo.strPatchVersion) {
                    m_strPatchVersion = new String(oAsnDCDeviceBoardNotification.oVersionInfo.strPatchVersion);
                    if (null != oVersionInfo) {
                        oVersionInfo.setPatchVersion(m_strPatchVersion);
                    }
                }
                oDevInfo.setDevVersion(oVersionInfo);
                if (null != oAsnDCDeviceBoardNotification.oVersionInfo.strBoard) {
                    oDevInfo.setDevBoardType(new String(oAsnDCDeviceBoardNotification.oVersionInfo.strBoard));
                }
            }
        }
    }

    protected boolean isCanGetDevTypeInfo() {
        boolean isCanGet = true;
        int deviceTypeListLength = -1;
        if (null == this.m_oDeviceTypeHm) {
            this.getDeviceTypeFromDCServer();
        }
        if (this.m_oDeviceTypeHm != null) {
            deviceTypeListLength = this.m_oDeviceTypeHm.size();
            if (0 == deviceTypeListLength) {
                isCanGet = false;
            }
        } else {
            isCanGet = false;
        }
        return isCanGet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processAsynMessage(MSGPacketExt packetExt) {
        DCDebugTracer.trace("[DEVMGR] receive asyn msg cmdCode=" + packetExt.mheader.cmdCode);
        if (packetExt.mheader.cmdCode == 43811) {
            this.handleGetDeviceInfoAction(packetExt);
        } else if (packetExt.mheader.cmdCode == 43829) {
            this.handleGetVersionResponse(packetExt);
        } else if (43840 == packetExt.mheader.cmdCode) {
            this.handleGetSubmapInfoAction(packetExt);
        } else if (43850 == packetExt.mheader.cmdCode) {
            DeviceInfoManagerImplHelper.getBoardInformation(packetExt, this);
        } else if (43981 == packetExt.mheader.cmdCode) {
            Object object = DCFrameWorkUtil.getTaskTablePanel().getSynObject();
            synchronized (object) {
                DCDebugTracer.trace("oPacketExt.mheader.cmdCode :" + packetExt.mheader.cmdCode);
                DeviceInfoManagerImplHelper.handleSWDLStatusResponse(packetExt);
            }
        } else if (44005 == packetExt.mheader.cmdCode) {
            DeviceInfoManagerImplHelper.handleOSPFStatusResponse(packetExt);
        } else if (44047 == packetExt.mheader.cmdCode) {
            Object object = DCFrameWorkUtil.getTaskTablePanel().getSynObject();
            synchronized (object) {
                DeviceInfoManagerImplHelper.handleQueryFailedBoardResponse(packetExt);
            }
        } else if (43952 == packetExt.mheader.cmdCode) {
            this.handleGetT2KDeviceInfoAction(packetExt);
        } else if (44105 == packetExt.mheader.cmdCode) {
            this.handleGetT2KDeviceInfoAction(packetExt);
        } else if (54062 == packetExt.mheader.cmdCode) {
            int errorcode = 0;
            errorcode = this.getDeviceTypeFromDCServer();
            if (errorcode != 0) {
                DCDebugTracer.trace("DeviceInfoManagerImpl#refreshDevices() get notify device end.. errorcode : " + errorcode);
            }
        }
    }

    private void handleGetT2KDeviceInfoAction(MSGPacketExt packetExt) {
        DCDebugTracer.trace("[DEVMGR] receive asyn msg cmdCode=" + packetExt.mheader.cmdCode);
        AsnDCT2000DeviceRsp asnDCT2000DeviceRsp = new AsnDCT2000DeviceRsp();
        int errorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnDCT2000DeviceRsp, packetExt.getData());
        if (errorcode == 0) {
            int serverError = asnDCT2000DeviceRsp.oErrorInfo.iErrorNo.intValue();
            if (serverError != 0) {
                this.setDeviceInfoError(errorcode);
                this.finshGetDevInfo();
                this.m_bIsrefreshDeviceType = false;
                DeviceInfoManagerImplHelper.showErrorMessage(serverError);
                return;
            }
            DCDebugTracer.trace("T2k package No=" + ++mPacketCount);
            DCDebugTracer.trace("T2k package asnDCT2000DeviceRsp No=" + asnDCT2000DeviceRsp.serialNumber.intValue());
            if (asnDCT2000DeviceRsp.bIsLast) {
                mPacketTemp = asnDCT2000DeviceRsp.serialNumber.intValue();
            }
            if (mPacketCount != mPacketTemp) {
                this.oT2000DevInfoLstRspLst.add(asnDCT2000DeviceRsp);
                return;
            }
            this.oT2000DevInfoLstRspLst.add(asnDCT2000DeviceRsp);
            DCDebugTracer.trace("T2k package list=" + this.oT2000DevInfoLstRspLst.size());
            for (int i = 0; i < this.oT2000DevInfoLstRspLst.size(); ++i) {
                DCDebugTracer.trace("T2k package loopnumber=" + i);
                asnDCT2000DeviceRsp = this.oT2000DevInfoLstRspLst.get(i);
                this.handleoT2000DevInfoLst(asnDCT2000DeviceRsp, this.oT2000DevInfoLst);
            }
            this.oT2000DevInfoLstRspLst.clear();
            DCDebugTracer.trace("T2k package is finish");
            mPacketCount = 0;
            StandAloneSyncCtrller.getInstance().nodifyGetT2kDevObj();
        }
    }

    private void handleGetSubmapInfoAction(MSGPacketExt packetExt) {
        DCDebugTracer.trace("receive submap info from DC Server");
        try {
            this.wait(200L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace("ignore" + ex);
        }
        this.m_bIsGettingSubmapInfo = true;
        AsnDCGetSubMapInfoRsp oAsnDCGetSubMapInfoRsp = new AsnDCGetSubMapInfoRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCGetSubMapInfoRsp, packetExt.getData());
        if (iErrorCode != 0) {
            this.m_bIsGettingSubmapInfo = false;
            return;
        }
        int iMapErrorCode = oAsnDCGetSubMapInfoRsp.oErrorInfo.iErrorNo.intValue();
        if (iMapErrorCode != 0) {
            this.m_bIsGettingSubmapInfo = false;
            this.finshGetDevSubmap();
            DeviceInfoManagerImplHelper.showErrorMessage(iMapErrorCode);
            return;
        }
        AsnDCSubMapInfoLst oAsnDCSubMapInfoLst = oAsnDCGetSubMapInfoRsp.oAsnDCSubMapInfoLst;
        this.oDCSubMapInfoLst.addAll((Collection)oAsnDCSubMapInfoLst);
        if (oAsnDCGetSubMapInfoRsp.bIsFinal) {
            DCDebugTracer.trace("end receive submap info from server");
            Thread populateSubmapInfo = new Thread(){

                @Override
                public void run() {
                    AbstractDeviceInfoManager.this.populateSubmapInfo();
                    AbstractDeviceInfoManager.this.m_bIsGettingSubmapInfo = false;
                    AbstractDeviceInfoManager.this.setRefreshBtnStatus();
                    if (!DCFrameWorkUtil.getIsSingleClient() || DCFrameWorkUtil.isShowSubMap()) {
                        AbstractDeviceInfoManager.this.initOLTAndMxuSubMapInfo();
                    }
                    AbstractDeviceInfoManager.this.finshGetDevSubmap();
                    if (!AbstractDeviceInfoManager.this.m_oDevIdDevInfoMap.isEmpty()) {
                        DeviceInfoManagerImplHelper.refreshDevTablePanel(1);
                    } else {
                        DeviceInfoManagerImplHelper.refreshDevTablePanel(3);
                    }
                }
            };
            populateSubmapInfo.setName("construct all submap information");
            populateSubmapInfo.start();
        } else {
            DCDebugTracer.trace("receive submap info not last from server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handleGetDeviceInfoAction(MSGPacketExt packetExt) {
        Object object;
        try {
            this.wait(200L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace("ignore" + ex);
        }
        AsnDCDeviceLstRsp deviceLstRsp = new AsnDCDeviceLstRsp();
        int errorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)deviceLstRsp, packetExt.getData());
        if (errorcode != 0) {
            this.setDeviceInfoError(errorcode);
            DCDebugTracer.trace(" end refresh device tree panel exception!!! + getDeviceInfoError" + this.getDeviceInfoError());
            this.finshGetDevInfo();
            DeviceInfoManagerImplHelper.refreshDevTablePanel(1);
            return;
        }
        int serverError = deviceLstRsp.oErrorInfo.iErrorNo.intValue();
        if (serverError != 0) {
            this.setDeviceInfoError(errorcode);
            this.finshGetDevInfo();
            this.m_bIsrefreshDeviceType = false;
            DeviceInfoManagerImplHelper.showErrorMessage(serverError);
            return;
        }
        DCDebugTracer.trace("the count of devices are " + deviceLstRsp.oDeviceLst.size());
        if (deviceLstRsp.bMoreDevices) {
            this.oDCDeviceLstRspLst.add(deviceLstRsp);
            return;
        }
        this.oDCDeviceLstRspLst.add(deviceLstRsp);
        this.storeDevInfoToSys(this.oDCDeviceLstRspLst);
        if (this.m_bIsrefreshDeviceType) {
            object = this.sycObj;
            // MONITORENTER : object
            this.m_arrDeviceInfo = this.deviceInfoVec.toArray(new DeviceInfo[0]);
            // MONITOREXIT : object
        }
        if (this.m_isFirstPackage) {
            object = this.m_oGetDevSyncObj;
            // MONITORENTER : this.m_oGetDevSyncObj
            this.m_oGetDevSyncObj.notifyAll();
            DCDebugTracer.trace("Datacenter : m_oGetDevSyncObj.notify()");
            this.m_isFirstPackage = false;
            // MONITOREXIT : object
        }
        if (!deviceLstRsp.bMoreDevices) {
            this.finshGetDevInfo();
            DeviceInfoManagerImplHelper.refreshDevTablePanel(1);
            this.m_bIsrefreshDeviceType = false;
        }
        this.setRefreshBtnStatus();
    }

    @Override
    public List<T2000DevInfo> getT2kDevLst() {
        return this.oT2000DevInfoLst;
    }

    @Override
    public void clearT2kDevLst() {
        this.oT2000DevInfoLst.clear();
    }

    protected void clearData() {
        DCDebugTracer.trace("method clearData start ");
        this.oDCSubMapInfoLst.clear();
        if (null == this.allSubmapInfo) {
            DCDebugTracer.trace("method clearData#allSubmapInfo is NULL");
            return;
        }
        Collection<HashMap<String, SubMapInfo>> submapHashCollection = this.allSubmapInfo.values();
        Iterator<HashMap<String, SubMapInfo>> subMapInfoIterator = submapHashCollection.iterator();
        SubMapInfo oSubMapInfo2 = null;
        while (subMapInfoIterator.hasNext()) {
            HashMap<String, SubMapInfo> subMap = subMapInfoIterator.next();
            Collection<SubMapInfo> subMapInfo = subMap.values();
            for (SubMapInfo oSubMapInfo2 : subMapInfo) {
                if (null == oSubMapInfo2) continue;
                oSubMapInfo2.clear();
            }
            subMap.clear();
        }
        DCDebugTracer.trace("method clearData end.. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finshGetDevSubmap() {
        DCDebugTracer.trace("finish get submap info");
        if (DCFrameWorkUtil.getIsSingleClient()) {
            byte[] byArray = this.m_oGetDevSyncObj;
            synchronized (this.m_oGetDevSyncObj) {
                this.m_oGetDevSyncObj.notifyAll();
                if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
                    DCFrameWorkUtil.getDeviceTablePanel().closeGettingDevProgressDlg();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        byte[] byArray = this.m_oGetDevSyncObj;
        synchronized (this.m_oGetDevSyncObj) {
            this.isFinalForSubMapInfo = true;
            if (this.isFinalForDevInfo) {
                this.isFinishGetDevAndSubmapInfo = true;
                this.m_oGetDevSyncObj.notifyAll();
                this.isFinalForSubMapInfo = false;
                this.isFinalForDevInfo = false;
                if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
                    DCFrameWorkUtil.getDeviceTablePanel().closeGettingDevProgressDlg();
                } else {
                    DCDebugTracer.trace("device table panel is null");
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finshGetDevInfo() {
        DCDebugTracer.trace("finish get deviceinfo");
        if (DCFrameWorkUtil.getIsSingleClient()) {
            byte[] byArray = this.m_oGetDevSyncObj;
            synchronized (this.m_oGetDevSyncObj) {
                this.m_oGetDevSyncObj.notifyAll();
                if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
                    DCFrameWorkUtil.getDeviceTablePanel().closeGettingDevProgressDlg();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        byte[] byArray = this.m_oGetDevSyncObj;
        synchronized (this.m_oGetDevSyncObj) {
            this.isFinalForDevInfo = true;
            if (this.isFinalForSubMapInfo) {
                this.isFinishGetDevAndSubmapInfo = true;
                this.m_oGetDevSyncObj.notifyAll();
                this.isFinalForSubMapInfo = false;
                this.isFinalForDevInfo = false;
                if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
                    DCFrameWorkUtil.getDeviceTablePanel().closeGettingDevProgressDlg();
                } else {
                    DCDebugTracer.trace("device table panel is null");
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceInfo(DeviceInfo oDevInfo) {
        Object object = this.sycObj;
        synchronized (object) {
            this.m_oDevIdDevInfoMap.put((Object)oDevInfo.getDevId(), (Object)oDevInfo);
        }
    }

    private void storeDevInfoToSys(List<AsnDCDeviceLstRsp> oDCDeviceLstRspLst) {
        ISecurityManager oSecuInterface;
        int iErrcode;
        DCDebugTracer.trace(" storeDevInfoToSys method start.");
        if (oDCDeviceLstRspLst == null || oDCDeviceLstRspLst.size() == 0) {
            DCDebugTracer.trace(" storeDevInfoToSys oDCDeviceLstRspLst is null or empty");
            return;
        }
        long curTime = System.currentTimeMillis();
        DCDebugTracer.trace("getDevAccessList Time Start:" + curTime);
        if (!DCFrameWorkUtil.getIsSingleClient() && (iErrcode = (oSecuInterface = DCFrameWorkUtil.getSecurityManager()).getDevAccessList()) != 0) {
            DCDebugTracer.trace(" failed to get access device list");
            return;
        }
        DCDebugTracer.trace("getDevAccessList Time End:" + (System.currentTimeMillis() - curTime));
        Set oCurDevIDSet = this.m_oDevIdDevInfoMap.keySet();
        THashSet oCopyDevIDSet = new THashSet();
        for (Integer devId : oCurDevIDSet) {
            if (null == oCopyDevIDSet) continue;
            oCopyDevIDSet.add(devId);
        }
        LinkedList<Integer> oNewDevIDLst = new LinkedList<Integer>();
        curTime = System.currentTimeMillis();
        DCDebugTracer.trace("AsnDCDeviceLstRsp Time Start:" + curTime);
        for (AsnDCDeviceLstRsp deviceLstRsp : oDCDeviceLstRspLst) {
            if (deviceLstRsp == null || deviceLstRsp.oDeviceLst.size() == 0) {
                DCDebugTracer.trace(" storeDevInfoToSys deviceLstRsp is null or empty");
                continue;
            }
            DCDebugTracer.trace("the count of devices in oDCDeviceLstRspLst are " + deviceLstRsp.oDeviceLst.size());
            TIntHashSet setOfDevices = null;
            ISecurityManager oSecuInterface2 = DCFrameWorkUtil.getSecurityManager();
            if (null != oSecuInterface2) {
                setOfDevices = oSecuInterface2.getSetOfDevices();
                if (null != setOfDevices) {
                    DCDebugTracer.trace("storeDevInfoToSys  access device list size " + setOfDevices.size());
                } else {
                    DCDebugTracer.trace("storeDevInfoToSys  access device is null ");
                }
            }
            AsnDCDeviceLst asnDeviceList = deviceLstRsp.oDeviceLst;
            int length = asnDeviceList.size();
            boolean isStandalone = DCFrameWorkUtil.getIsSingleClient();
            DeviceInfo deviceInfo = null;
            AsnDCDeviceInfo asnDevice = null;
            DeviceTypeInfo oDeviceType = null;
            long curTime1 = System.currentTimeMillis();
            DCDebugTracer.trace("AsnDCDeviceInfo Time Start:" + curTime1);
            for (int i = 0; i < length; ++i) {
                asnDevice = (AsnDCDeviceInfo)asnDeviceList.elementAt(i);
                oDeviceType = this.getDeviceTypeInfo(asnDevice.iDevTypeId.intValue(), asnDevice.iDevTypeVersionId.intValue());
                if (null == oDeviceType) {
                    deviceInfo = this.getDeviceFromAsn(asnDevice);
                    DCDebugTracer.trace("Device type is not found ! Please check file style\\productstyle\\dc\\conf\\dc\\config.properties");
                    DCDebugTracer.trace("Device Information : " + deviceInfo);
                    continue;
                }
                deviceInfo = this.getDeviceFromAsn(asnDevice);
                int iDevId = deviceInfo.getDevId();
                if (isStandalone || null != setOfDevices && setOfDevices.contains(iDevId)) {
                    if (!this.m_oDevIdDevInfoMap.contains((Object)iDevId)) {
                        DCDebugTracer.trace("In processAsynMessage - Adding device : " + deviceInfo);
                        if (deviceInfo.getDeviceTypeInfo().isBMSDomain() && deviceInfo.getRoleType() == 2 && !this.mxuDeviceIDLst.contains(iDevId)) {
                            this.mxuDeviceIDLst.add(iDevId);
                        }
                    } else {
                        DeviceInfo oTmpDevInfo = (DeviceInfo)this.m_oDevIdDevInfoMap.get((Object)iDevId);
                        deviceInfo.setDeviceOperationStatus(oTmpDevInfo.getDeviceOperationStatus());
                        DCDebugTracer.trace("Data Model Corruption(have repeat device)");
                    }
                    this.addDeviceInfo(deviceInfo);
                    oNewDevIDLst.add(iDevId);
                    if (iDevId <= this.m_iMaxDevID) continue;
                    this.m_iMaxDevID = iDevId;
                    if (!isStandalone) continue;
                    StandAloneCommonOpr.getInstance().setMaxDevID(this.m_iMaxDevID);
                    continue;
                }
                DCDebugTracer.trace("can not show device " + deviceInfo);
            }
            DCDebugTracer.trace("AsnDCDeviceInfo Time End:" + (System.currentTimeMillis() - curTime1));
        }
        DCDebugTracer.trace("AsnDCDeviceLstRsp Time End:" + (System.currentTimeMillis() - curTime));
        oDCDeviceLstRspLst.clear();
        if (null != oCopyDevIDSet) {
            oCopyDevIDSet.removeAll(oNewDevIDLst);
            if (!oCopyDevIDSet.isEmpty()) {
                Iterator oDevIDItor = oCopyDevIDSet.iterator();
                while (oDevIDItor.hasNext()) {
                    this.m_oDevIdDevInfoMap.remove(oDevIDItor.next());
                }
            }
        }
        DCDebugTracer.trace(" storeDevInfoToSys method end.");
    }

    private void populateSubmapInfo() {
        DCDebugTracer.trace("method populateSubmapInfo start ");
        if (null == this.oDCSubMapInfoLst || this.oDCSubMapInfoLst.size() == 0) {
            DCDebugTracer.trace("method populateSubmapInfo end : oAsnDCSubMapInfoLst is null.");
            return;
        }
        this.m_oSubMapInfo = null;
        long curTime = System.currentTimeMillis();
        DCDebugTracer.trace("initSubmapInfoMap Time Start:" + curTime);
        this.initSubmapInfoMap();
        this.setRootSubMap();
        DCDebugTracer.trace("initSubmapInfoMap Time End:" + (System.currentTimeMillis() - curTime));
        curTime = System.currentTimeMillis();
        DCDebugTracer.trace("setChildSubMap Time Start:" + curTime);
        this.setChildSubMap(this.m_oSubMapInfo);
        DCDebugTracer.trace("setChildSubMap Time End:" + (System.currentTimeMillis() - curTime));
        DCDebugTracer.trace("method populateSubmapInfo end.. ");
    }

    public void initSubmapInfoMap() {
        DCDebugTracer.trace("method initSubmapInfoMap start ");
        AsnDCSubMapInfo oAsnDCSubMapInfo = null;
        int subMapLstSize = this.oDCSubMapInfoLst.size();
        String subMapId = null;
        String parMapId = null;
        SubMapInfo oSubMapInfo = null;
        HashMap<String, SubMapInfo> subMap = null;
        HashMap<String, SubMapInfo> subMapForDev = null;
        HashMap<String, HashMap<String, SubMapInfo>> allSubmapInfoForDev = new HashMap<String, HashMap<String, SubMapInfo>>();
        this.enableSubMap.clear();
        for (int i = 0; i < subMapLstSize; ++i) {
            oAsnDCSubMapInfo = (AsnDCSubMapInfo)this.oDCSubMapInfoLst.get(i);
            if (null == oAsnDCSubMapInfo.strParentSubMapID) continue;
            parMapId = new String(oAsnDCSubMapInfo.strParentSubMapID);
            subMapId = new String(oAsnDCSubMapInfo.strSubMapID);
            oSubMapInfo = null;
            oSubMapInfo = SubMapInfoHelper.transeAsn2SubMapInfo(oAsnDCSubMapInfo);
            this.refreshODNSubMapIDLst(oAsnDCSubMapInfo.strODNSubMapIDLst);
            subMap = this.allSubmapInfo.get(parMapId);
            if (null == subMap) {
                subMap = new HashMap();
                subMap.put(subMapId, oSubMapInfo);
                this.allSubmapInfo.put(parMapId, subMap);
            } else {
                subMap.put(subMapId, oSubMapInfo);
            }
            subMapForDev = (HashMap<String, SubMapInfo>)allSubmapInfoForDev.get(parMapId);
            if (null == subMapForDev) {
                subMapForDev = new HashMap<String, SubMapInfo>();
                subMapForDev.put(subMapId, oSubMapInfo);
                allSubmapInfoForDev.put(parMapId, subMapForDev);
            } else {
                subMapForDev.put(subMapId, oSubMapInfo);
                allSubmapInfoForDev.put(subMapId, subMapForDev);
            }
            TIntHashSet oDevIDLstHashSet = oSubMapInfo.getSubMapDevIDLst();
            if (null == oDevIDLstHashSet || oDevIDLstHashSet.isEmpty()) continue;
            for (int devID : oDevIDLstHashSet) {
                this.m_oSubMapList.put(devID, oSubMapInfo);
            }
            if (!DeviceInfoManagerImplHelper.isDeviceManagable(oSubMapInfo, this.m_oDevIdDevInfoMap)) continue;
            if (null == this.enableSubMap.get(oSubMapInfo.m_strSubMapID)) {
                this.enableSubMap.put(oSubMapInfo.m_strSubMapID, true);
            }
            if (oSubMapInfo.m_strParentSubMapID.equals("")) continue;
            this.getEnableSubMap((SubMapInfo)((HashMap)allSubmapInfoForDev.get(oSubMapInfo.m_strParentSubMapID)).get(oSubMapInfo.m_strParentSubMapID), allSubmapInfoForDev);
        }
        DCDebugTracer.trace("method initSubmapInfoMap end.. ");
    }

    private void getEnableSubMap(SubMapInfo oSubMapInfo, HashMap<String, HashMap<String, SubMapInfo>> allSubmapInfoForDev) {
        if (null != oSubMapInfo) {
            if (null == this.enableSubMap.get(oSubMapInfo.m_strSubMapID)) {
                DCDebugTracer.trace("isSubmapManagable=>  strSubmapDN in getEnableSubMap: " + oSubMapInfo.m_strSubMapName + "->" + "true");
                this.enableSubMap.put(oSubMapInfo.m_strSubMapID, true);
            }
            if (!oSubMapInfo.m_strParentSubMapID.equals("")) {
                this.getEnableSubMap(allSubmapInfoForDev.get(oSubMapInfo.m_strParentSubMapID).get(oSubMapInfo.m_strParentSubMapID), allSubmapInfoForDev);
            }
        }
    }

    private void setChildSubMap(SubMapInfo parentSubMap) {
        String subMapId = null == parentSubMap.m_strSubMapID ? "" : parentSubMap.m_strSubMapID;
        HashMap<String, SubMapInfo> subMap = this.allSubmapInfo.get(subMapId);
        if (null == subMap) {
            DCDebugTracer.trace("DeviceInfoManagerImpl|setChildSubMap get null:" + subMapId);
            return;
        }
        SubMapInfo oSubMapInfo2 = null;
        Collection<SubMapInfo> subMapInfo = subMap.values();
        for (SubMapInfo oSubMapInfo2 : subMapInfo) {
            DCDebugTracer.trace("DeviceInfoManagerImpl|ChildSubMap:" + oSubMapInfo2);
            boolean bEnableDev = this.enableSubMap.get(oSubMapInfo2.m_strSubMapID) != null;
            boolean bEnableSubMap = DeviceInfoManagerImplHelper.isSubmapManagable(oSubMapInfo2);
            if (parentSubMap.m_strParentSubMapID.equals("") && (bEnableSubMap || bEnableDev)) {
                parentSubMap.m_SubMapList.add(oSubMapInfo2);
                this.setChildSubMap(oSubMapInfo2);
                continue;
            }
            if (!bEnableSubMap && !bEnableDev) continue;
            parentSubMap.m_SubMapList.add(oSubMapInfo2);
            this.setChildSubMap(oSubMapInfo2);
        }
        DCDebugTracer.trace("DeviceInfoManagerImpl|setChildSubMap:" + parentSubMap);
    }

    private void setRootSubMap() {
        DCDebugTracer.trace("method setRootSubmap start");
        int subMapLstSize = this.oDCSubMapInfoLst.size();
        AsnDCSubMapInfo oAsnDCSubMapInfo = null;
        SubMapInfo oSubMapInfo = null;
        for (int i = 0; i < subMapLstSize; ++i) {
            oAsnDCSubMapInfo = (AsnDCSubMapInfo)this.oDCSubMapInfoLst.get(i);
            if (null == oAsnDCSubMapInfo) continue;
            oSubMapInfo = SubMapInfoHelper.transeAsn2SubMapInfo(oAsnDCSubMapInfo);
            if (null != this.m_oSubMapInfo || !"".equals(oSubMapInfo.m_strParentSubMapID)) continue;
            this.m_oSubMapInfo = oSubMapInfo;
            this.refreshODNSubMapIDLst(oAsnDCSubMapInfo.strODNSubMapIDLst);
            DCDebugTracer.trace(oSubMapInfo.toString());
            break;
        }
        DCDebugTracer.trace("method setRootSubmap end..");
    }

    private void handleGetVersionResponse(MSGPacketExt packetExt) {
        AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification = new AsnDCDeviceBoardNotification();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCDeviceBoardNotification, packetExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        if (null != oAsnDCDeviceBoardNotification.oVersionInfo) {
            if (0 == oAsnDCDeviceBoardNotification.oErrorInfo.iErrorNo.intValue() || 0 == oAsnDCDeviceBoardNotification.oPatchErrorInfo.iErrorNo.intValue()) {
                this.updateDeviceVersion(oAsnDCDeviceBoardNotification);
            } else if (0 < oAsnDCDeviceBoardNotification.oVersionInfo.strVersion.length) {
                this.updateDeviceVersion(oAsnDCDeviceBoardNotification);
            }
        }
        this.notifyRefreshDevVersionMes(oAsnDCDeviceBoardNotification);
        if (DCFrameWorkUtil.getIsSingleClient() && null != DCFrameWorkUtil.getRouterDevInfoPanel()) {
            DCFrameWorkUtil.getRouterDevInfoPanel().checkRightForPopupMenu();
        }
    }

    protected synchronized void handleDeviceAddNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        DCDebugTracer.trace(" DeviceInfoManagerImpl::handleDeviceAddNotification->begin");
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        DeviceInfo oNewDeviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            String iDestSubmapID;
            SubMapInfo oSub;
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            oNewDeviceInfo = this.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
            DCDebugTracer.trace(" handleDeviceAddNotification : " + oNewDeviceInfo);
            try {
                DCDebugTracer.trace("DC::In handleDeviceAddNotification - Adding device " + oNewDeviceInfo);
                if (this.m_oDevIdDevInfoMap.containsKey((Object)oNewDeviceInfo.getDevId())) {
                    SubMapInfoHelper.deleteDevSubMapInfo(oNewDeviceInfo.getDevId(), this.m_oSubMapInfo);
                    if (null != this.m_oSubMapList.get(oNewDeviceInfo.getDevId())) {
                        this.m_oSubMapList.remove(oNewDeviceInfo.getDevId());
                    }
                }
                this.m_oDevIdDevInfoMap.put((Object)oNewDeviceInfo.getDevId(), (Object)oNewDeviceInfo);
                if (oNewDeviceInfo.getDevId() > this.m_iMaxDevID) {
                    this.m_iMaxDevID = oNewDeviceInfo.getDevId();
                    if (DCFrameWorkUtil.getIsSingleClient()) {
                        StandAloneCommonOpr.getInstance().setMaxDevID(this.m_iMaxDevID);
                    }
                }
                if (oNewDeviceInfo.getDeviceTypeInfo().isBMSDomain() && oNewDeviceInfo.getRoleType() == 2 && !this.mxuDeviceIDLst.contains(oNewDeviceInfo.getDevId())) {
                    this.mxuDeviceIDLst.add(oNewDeviceInfo.getDevId());
                }
            }
            catch (Exception ignore) {
                DCDebugTracer.trace(ignore);
            }
            int iDevID = oNewDeviceInfo.getDevId();
            if (DCFrameWorkUtil.getIsSingleClient() || null == (oSub = this.getSubmapForID(iDestSubmapID = SubMapInfoHelper.getLeafSubmapID(oAsnDeviceInfo.oAsnDCSubMapInfo))) || oSub.m_oSubMapDevIDLst.contains(iDevID)) continue;
            oSub.m_oSubMapDevIDLst.add(iDevID);
        }
        if (null != oNewDeviceInfo && null != oNewDeviceInfo.getDeviceTypeInfo() && oNewDeviceInfo.getDeviceTypeInfo().isSNMPType()) {
            this.m_bSNMPDevicesPresent = true;
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.initSubMapList();
            this.initOLTAndMxuSubMapInfo();
        }
    }

    private void initSubMapList() {
        LinkedList<SubMapInfo> m_oSubMapInfoLst = this.m_oSubMapInfo.m_SubMapList;
        this.initSubMapListBySubMap(m_oSubMapInfoLst);
    }

    private void initSubMapListBySubMap(LinkedList<SubMapInfo> m_oSubMapInfoLst) {
        for (SubMapInfo oSubMapInfo : m_oSubMapInfoLst) {
            this.initSubMapListBySubMap(oSubMapInfo.m_SubMapList);
            TIntHashSet oDevIDLstHashSet = oSubMapInfo.getSubMapDevIDLst();
            if (null == oDevIDLstHashSet || oDevIDLstHashSet.isEmpty()) continue;
            for (int devID : oDevIDLstHashSet) {
                this.m_oSubMapList.put(devID, oSubMapInfo);
            }
        }
    }

    public void addDevSubMapInfo(AsnDCDeviceInfo oAsnDevInfoFromServer, AsnDCSubMapInfo asnDCSubMapInfo) {
        DCDebugTracer.trace(" DeviceInfoManagerImpl::addDevSubMapInfo->begin");
        this.m_bDeviceFound = false;
        SubMapInfo subMapInfoFromServer = new SubMapInfo();
        subMapInfoFromServer.m_strSubMapID = new String(asnDCSubMapInfo.strSubMapID);
        subMapInfoFromServer.m_strSubMapName = new String(asnDCSubMapInfo.strSubMapName);
        AsnDCSubMapInfoLst oAsnDCSubMapInfoLst = asnDCSubMapInfo.oAsnDCSubMapInfoLst;
        if (null != oAsnDCSubMapInfoLst) {
            int submapInfoSize = oAsnDCSubMapInfoLst.size();
            DCDebugTracer.trace(" DeviceInfoManagerImpl::addDevSubMapInfo->oAsnDCSubMapInfoLst size = " + submapInfoSize);
            if (null != oAsnDCSubMapInfoLst && 0 != submapInfoSize) {
                AsnDCSubMapInfo asnNextDCSubMapInfo = null;
                SubMapInfo nextMapInfo = subMapInfoFromServer;
                for (int l = 0; l < submapInfoSize; ++l) {
                    asnNextDCSubMapInfo = (AsnDCSubMapInfo)oAsnDCSubMapInfoLst.get(l);
                    nextMapInfo = SubMapInfoHelper.fillSubMapInfoList(nextMapInfo, asnNextDCSubMapInfo);
                }
            }
        }
        this.addDevSubMapInfoRecusively(oAsnDevInfoFromServer, subMapInfoFromServer, this.m_oSubMapInfo);
    }

    protected void addDevSubMapInfoRecusively(AsnDCDeviceInfo oAsnDevInfoFromServer, SubMapInfo subMapInfoFromServer, SubMapInfo subMapInfo) {
        DCDebugTracer.trace(" DeviceInfoManagerImpl::addDevSubMapInfoRecusively->begin");
        String subMapIdFromServer = subMapInfoFromServer.m_strSubMapID;
        if (0 == subMapInfo.m_strSubMapID.compareTo(subMapIdFromServer)) {
            DCDebugTracer.trace(" DeviceInfoManagerImpl::addDevSubMapInfoRecusively->0");
            LinkedList<SubMapInfo> subMapListFromServer = subMapInfoFromServer.m_SubMapList;
            if (null == subMapListFromServer || 0 == subMapListFromServer.size()) {
                DCDebugTracer.trace(" DeviceInfoManagerImpl::addDevSubMapInfoRecusively->subMapListFromServer == null");
                this.addDeviceInfo(subMapInfo, oAsnDevInfoFromServer);
            } else {
                int iNextLevelSubMap = subMapInfo.m_SubMapList.size();
                SubMapInfo subMapFromServer = subMapListFromServer.get(0);
                String strNewSubMapID = subMapFromServer.m_strSubMapID;
                boolean isSubMapFound = false;
                for (int j = 0; j < iNextLevelSubMap; ++j) {
                    SubMapInfo nextSubMap = subMapInfo.m_SubMapList.get(j);
                    if (0 != nextSubMap.m_strSubMapID.compareTo(strNewSubMapID)) continue;
                    DCDebugTracer.trace(" DeviceInfoManagerImpl::addDevSubMapInfoRecusively->strNewSubMapID :: " + strNewSubMapID);
                    isSubMapFound = true;
                    this.addDevSubMapInfoRecusively(oAsnDevInfoFromServer, subMapFromServer, nextSubMap);
                    break;
                }
                if (!isSubMapFound) {
                    this.addSubMap(subMapInfo, subMapListFromServer, oAsnDevInfoFromServer);
                }
            }
        } else {
            DCDebugTracer.trace(" DeviceInfoManagerImpl::addDevSubMapInfoRecusively->0");
            int iNextLevelSubMap = subMapInfo.m_SubMapList.size();
            String strNewSubMapID = subMapInfoFromServer.m_strSubMapID;
            boolean isSubMapFound = false;
            for (int j = 0; j < iNextLevelSubMap; ++j) {
                SubMapInfo nextSubMap = subMapInfo.m_SubMapList.get(j);
                if (0 != nextSubMap.m_strSubMapID.compareTo(strNewSubMapID)) continue;
                DCDebugTracer.trace(" DeviceInfoManagerImpl::addDevSubMapInfoRecusively->strNewSubMapID :: " + strNewSubMapID);
                isSubMapFound = true;
                this.addDevSubMapInfoRecusively(oAsnDevInfoFromServer, subMapInfoFromServer, nextSubMap);
                break;
            }
            if (!isSubMapFound) {
                SubMapInfo localSubMapInfo = new SubMapInfo();
                localSubMapInfo.m_strSubMapID = subMapInfoFromServer.m_strSubMapID;
                localSubMapInfo.m_strSubMapName = subMapInfoFromServer.m_strSubMapName;
                subMapInfo.m_SubMapList.add(localSubMapInfo);
                if (subMapInfoFromServer.m_SubMapList.size() > 0) {
                    this.addSubMap(localSubMapInfo, subMapInfoFromServer.m_SubMapList, oAsnDevInfoFromServer);
                } else {
                    this.addDeviceInfo(localSubMapInfo, oAsnDevInfoFromServer);
                }
            }
        }
    }

    private void addSubMap(SubMapInfo subMapInfo, LinkedList subMapListFromServer, AsnDCDeviceInfo oAsnDevInfoFromServer) {
        SubMapInfo subMapFromServer = (SubMapInfo)subMapListFromServer.get(0);
        SubMapInfo localSubMapInfo = new SubMapInfo();
        localSubMapInfo.m_strSubMapID = subMapFromServer.m_strSubMapID;
        localSubMapInfo.m_strSubMapName = subMapFromServer.m_strSubMapName;
        subMapInfo.m_SubMapList.add(localSubMapInfo);
        if (subMapFromServer.m_SubMapList.size() > 0) {
            this.addSubMap(localSubMapInfo, subMapFromServer.m_SubMapList, oAsnDevInfoFromServer);
        } else {
            this.addDeviceInfo(localSubMapInfo, oAsnDevInfoFromServer);
        }
    }

    private void addDeviceInfo(SubMapInfo subMapInfo, AsnDCDeviceInfo oAsnDevSubInfoFromServer) {
        DCDebugTracer.trace(" DeviceInfoManagerImpl::addDeviceInfo->begin");
        int iDevID = oAsnDevSubInfoFromServer.iDevId.intValue();
        DCDebugTracer.trace(" DeviceInfoManagerImpl::addDeviceInfo->iDevID::" + iDevID);
        TIntIterator devIteroator = subMapInfo.m_oSubMapDevIDLst.iterator();
        while (devIteroator.hasNext()) {
            int iDeviceID = devIteroator.next();
            if (iDeviceID != iDevID) continue;
            devIteroator.remove();
            break;
        }
        if (!this.m_bDeviceFound) {
            DCDebugTracer.trace(" DeviceInfoManagerImpl::addDeviceInfo->m_bDeviceFound:: false");
            subMapInfo.m_oSubMapDevIDLst.add(iDevID);
            this.m_oSubMapList.put(iDevID, subMapInfo);
            this.m_bDeviceFound = true;
        }
    }

    protected synchronized void handleDeviceDeleteNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        this.m_bDeviceFound = false;
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        DeviceInfo deviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            deviceInfo = this.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
            DCDebugTracer.trace("DC::In handleDeviceDeleteNotification - Delete device " + deviceInfo);
            String strDelFilePath = DeviceInfoManagerImplHelper.clientFileTrnsOP(deviceInfo);
            int iDeleteDeviceId = deviceInfo.getDevId();
            this.m_oDevIdDevInfoMap.remove((Object)iDeleteDeviceId);
            if (null != deviceInfo.getDeviceTypeInfo() && deviceInfo.getDeviceTypeInfo().getDevDomain() == 1 && deviceInfo.getRoleType() == 2 && this.mxuDeviceIDLst.contains(iDeleteDeviceId)) {
                this.mxuDeviceIDLst.remove(iDeleteDeviceId);
            }
            SubMapInfoHelper.deleteDevSubMapInfo(iDeleteDeviceId, this.m_oSubMapInfo);
            if (null != this.m_oSubMapList.get(iDeleteDeviceId)) {
                this.m_oSubMapList.remove(iDeleteDeviceId);
            }
            if (null != strDelFilePath) {
                File oDir = new File(strDelFilePath);
                DeviceInfoManagerImplHelper.deleteBckupFolders(oDir);
            }
            BusyDeviceObjectStore.getInstance().removeDeviceProgress(iDeleteDeviceId);
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.initOLTAndMxuSubMapInfo();
        }
        if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
            DCFrameWorkUtil.getDeviceTablePanel().refreshSelectedDevCountLabel();
        }
    }

    protected synchronized void handleDeviceModifyNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        DCDebugTracer.trace("handleDeviceModifyNotification start");
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        DCDebugTracer.trace("iNoOfDevicesFromServer " + iNoOfDevicesFromServer);
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            DeviceInfo oldDevice;
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            int iDeviceId = oAsnDeviceInfo.oDeviceInfo.iDevId.intValue();
            if (null != oAsnDeviceInfo.oAsnDCSubMapInfo) {
                AsnDCSubMapInfo oAsnDCSubMapInfo = oAsnDeviceInfo.oAsnDCSubMapInfo;
                SubMapInfo oOldSubmap = this.getSubMapInfoByDevID(this.m_oSubMapInfo, iDeviceId);
                if (null == oOldSubmap || null == oOldSubmap.m_strSubMapID || "".equals(oOldSubmap.m_strSubMapID)) {
                    DCDebugTracer.trace("DEVMGR old submap not correct");
                    continue;
                }
                SubMapInfoHelper.deleteDevSubMapInfo(iDeviceId, oOldSubmap);
                if (this.m_oSubMapList.containsKey(iDeviceId)) {
                    this.m_oSubMapList.remove(iDeviceId);
                }
                DCDebugTracer.trace(" iDeviceId " + iDeviceId);
                SubMapInfo oNewSubMap = this.getSubmapForID(new String(oAsnDCSubMapInfo.strParentSubMapID));
                if (null == oNewSubMap) {
                    DCDebugTracer.trace("DEVMGR new submap not correct");
                    continue;
                }
                this.m_bDeviceFound = false;
                SubMapInfo oNewSubmapCopy = new SubMapInfo();
                oNewSubmapCopy.m_strSubMapID = oNewSubMap.m_strSubMapID;
                this.addDevSubMapInfoRecusively(oAsnDeviceInfo.oDeviceInfo, oNewSubmapCopy, oNewSubMap);
            }
            String newIPAddress = "";
            if (null != oAsnDeviceInfo.oDeviceInfo.strDevIPAddress) {
                newIPAddress = new String(oAsnDeviceInfo.oDeviceInfo.strDevIPAddress);
                newIPAddress = newIPAddress.trim();
            } else {
                DCDebugTracer.trace("DEVMGR new ip is null");
            }
            String newDeviceName = "";
            if (null != oAsnDeviceInfo.oDeviceInfo.strDevName) {
                newDeviceName = new String(oAsnDeviceInfo.oDeviceInfo.strDevName);
            } else {
                DCDebugTracer.trace("DEVMGR new device name is null");
            }
            int iRoleType = -1;
            if (null != oAsnDeviceInfo.oDeviceInfo.enRoleType) {
                iRoleType = oAsnDeviceInfo.oDeviceInfo.enRoleType.value;
                DCDebugTracer.trace("AsnDCDeviceSubmapNtfnInfo::enRoleType:" + iRoleType);
            }
            int iNeID = -1;
            String strNeTId = "";
            if (null != oAsnDeviceInfo.oDeviceInfo.iNeID) {
                iNeID = oAsnDeviceInfo.oDeviceInfo.iNeID.intValue();
            }
            if (null != oAsnDeviceInfo.oDeviceInfo.strNeTId) {
                strNeTId = DCCommonUtil.convertByteArrayToStr(oAsnDeviceInfo.oDeviceInfo.strNeTId);
            }
            if (null == (oldDevice = (DeviceInfo)this.m_oDevIdDevInfoMap.get((Object)iDeviceId))) {
                this.getDeviceTypeFromDCServer();
                oldDevice = this.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
                if (oldDevice != null && oldDevice.getDeviceTypeInfo() != null) {
                    this.m_oDevIdDevInfoMap.put((Object)iDeviceId, (Object)oldDevice);
                }
                return;
            }
            if (0 != newIPAddress.compareTo("") && !oldDevice.getDevIPAddress().equals(newIPAddress)) {
                DCDebugTracer.trace("device modify ip " + oldDevice.getDevIPAddress() + "-->" + newIPAddress);
                oldDevice.setDevIPAddress(newIPAddress);
            }
            if (!oldDevice.getDevName().equals(newDeviceName)) {
                DCDebugTracer.trace("device modify name " + oldDevice.getDevName() + "-->" + newDeviceName);
                oldDevice.setDevName(newDeviceName);
            }
            int iDevTypeID = oAsnDeviceInfo.oDeviceInfo.iDevTypeId.intValue();
            int iDevTypeVersionID = oAsnDeviceInfo.oDeviceInfo.iDevTypeVersionId.intValue();
            if (oldDevice.getDeviceTypeInfo().getDevTypeID() != iDevTypeID || oldDevice.getDeviceTypeInfo().getDevTypeVersionId() != iDevTypeVersionID) {
                DCDebugTracer.trace("device modify typeId " + oldDevice.getDeviceTypeInfo().getDevTypeID() + "-->" + iDevTypeID);
                DCDebugTracer.trace("device modify typeVerId " + oldDevice.getDeviceTypeInfo().getDevTypeVersionId() + "-->" + iDevTypeVersionID);
                oldDevice.setDevType(this.getDeviceTypeInfo(iDevTypeID, iDevTypeVersionID));
            }
            if (-1 != iRoleType && oldDevice.getRoleType() != iRoleType) {
                DCDebugTracer.trace("device modify roteType " + oldDevice.getRoleType() + "-->" + iRoleType);
                oldDevice.setRoleType(iRoleType);
            }
            if (-1 != iNeID && oldDevice.getNEDevId() != iNeID) {
                DCDebugTracer.trace("device modify neID " + oldDevice.getNEDevId() + "-->" + iNeID);
                oldDevice.setNEDevId(iNeID);
            }
            if (!StringUtils.isNullOrEmptyStr(strNeTId) && !oldDevice.getNeTId().equals(strNeTId)) {
                DCDebugTracer.trace("device modify neTID " + oldDevice.getNeTId() + "-->" + strNeTId);
                oldDevice.setNeTId(strNeTId);
            }
            String m_strDevVersion = "";
            if (null != oAsnDeviceInfo.oDeviceInfo.strDevVersion && 0 != (m_strDevVersion = new String(oAsnDeviceInfo.oDeviceInfo.strDevVersion)).compareTo("") && !oldDevice.getDevVersion().getDevVersion().equals(m_strDevVersion)) {
                DCDebugTracer.trace("device modify version " + oldDevice.getDevVersion().getDevVersion() + "-->" + m_strDevVersion);
                oldDevice.getDevVersion().setDevVersion(m_strDevVersion);
            }
            String m_strDevPatchVersion = "";
            if (null == oAsnDeviceInfo.oDeviceInfo.strDevPatchVersion) continue;
            m_strDevPatchVersion = new String(oAsnDeviceInfo.oDeviceInfo.strDevPatchVersion);
            if (oldDevice.getDevVersion().getPatchVersion().equals(m_strDevPatchVersion)) continue;
            DCDebugTracer.trace("device modify patchVersion " + oldDevice.getDevVersion().getPatchVersion() + "-->" + m_strDevPatchVersion);
            oldDevice.getDevVersion().setPatchVersion(m_strDevPatchVersion);
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.initOLTAndMxuSubMapInfo();
        }
        DCDebugTracer.trace("handleDeviceModifyNotification end..");
    }

    private void initOLTAndMxuSubMapInfo() {
        if (!DCFrameWorkUtil.getIsSingleClient() && null != this.m_oSubMapInfo || DCFrameWorkUtil.isShowSubMap()) {
            this.m_oLTSubMapInfo = this.m_oSubMapInfo.cloneSubmap();
        }
        if (this.odnSubMapIDLst.size() > 0) {
            this.m_oLTSubMapInfo = this.m_oLTSubMapInfo.filterSubmapInfo(this.odnSubMapIDLst);
        }
        this.initMxuSubmapInfo();
    }

    protected void initMxuSubmapInfo() {
        if (!DCFrameWorkUtil.getIsSingleClient() && null != this.m_oSubMapInfo || DCFrameWorkUtil.isShowSubMap()) {
            this.oMxuSubMapInfo = this.m_oSubMapInfo.cloneSubmap();
        }
        if (this.mxuDeviceIDLst.size() > 0) {
            this.oMxuSubMapInfo = this.oMxuSubMapInfo.filterMXUSubmapInfo(this.mxuDeviceIDLst);
        }
    }

    protected synchronized void handleSubMapAddNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        for (int i = 0; i < oDeviceInfoList.size(); ++i) {
            SubMapInfo oSubMapInfo;
            AsnDCDeviceSubmapNtfnInfo oDeviceNtfnInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            AsnDCSubMapInfo oAsnDCSubMapInfo = oDeviceNtfnInfo.oAsnDCSubMapInfo;
            if (null == oAsnDCSubMapInfo || null != (oSubMapInfo = this.getSubmapForID(new String(oAsnDCSubMapInfo.strSubMapID)))) continue;
            String strParentSubMapID = new String(oAsnDCSubMapInfo.strParentSubMapID);
            SubMapInfo oParentSubMap = this.getSubmapForID(strParentSubMapID);
            if (null != oParentSubMap) {
                if (null == oParentSubMap.m_SubMapList) {
                    oParentSubMap.m_SubMapList = new LinkedList();
                }
                SubMapInfo oSubMapInfoNew = new SubMapInfo();
                oSubMapInfoNew.m_strSubMapID = new String(oAsnDCSubMapInfo.strSubMapID);
                oSubMapInfoNew.m_strSubMapName = new String(oAsnDCSubMapInfo.strSubMapName);
                oSubMapInfoNew.m_iSubMapTypeID = oAsnDCSubMapInfo.iSubMapTypeID.intValue();
                oSubMapInfoNew.m_strParentSubMapID = new String(oAsnDCSubMapInfo.strParentSubMapID);
                oParentSubMap.m_SubMapList.add(oSubMapInfoNew);
                HashMap<String, SubMapInfo> subMap = this.allSubmapInfo.get(strParentSubMapID);
                if (null != subMap) {
                    subMap.put(new String(oAsnDCSubMapInfo.strSubMapID), oSubMapInfoNew);
                }
            }
            DCStringList dcStringList = oAsnDCSubMapInfo.strODNSubMapIDLst;
            this.refreshODNSubMapIDLst(dcStringList);
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.initOLTAndMxuSubMapInfo();
        }
    }

    protected synchronized void handleSubMapDeleteNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        DCDebugTracer.trace("[DeviceConfigNotification] handleSubMapDeleteNotification start");
        SubMapInfo oSubmapToBeDeleted = null;
        String strSubmapId = null;
        for (int i = 0; i < oDeviceInfoList.size(); ++i) {
            AsnDCDeviceSubmapNtfnInfo oDeviceNtfnInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            AsnDCSubMapInfo oAsnDCSubMapInfo = oDeviceNtfnInfo.oAsnDCSubMapInfo;
            if (null == oAsnDCSubMapInfo) continue;
            strSubmapId = new String(oAsnDCSubMapInfo.strSubMapID);
            DCDebugTracer.trace("[DeviceConfigNotification] strSubmapId : " + strSubmapId);
            oSubmapToBeDeleted = this.getSubmapForID(strSubmapId);
            if (null == oSubmapToBeDeleted) continue;
            DCDebugTracer.trace("[DeviceConfigNotification] is not null");
            SubMapInfo oParentSubmap = this.getParentSubmap(this.m_oSubMapInfo, oSubmapToBeDeleted);
            if (null == oParentSubmap || null == oParentSubmap.m_SubMapList) continue;
            int childSubmapSize = oSubmapToBeDeleted.m_SubMapList.size();
            HashMap<String, SubMapInfo> subParentMap = this.allSubmapInfo.get(oParentSubmap.m_strSubMapID);
            for (int j = 0; j < childSubmapSize; ++j) {
                SubMapInfo oSubMapInfo = oSubmapToBeDeleted.m_SubMapList.get(j);
                if (oSubMapInfo == null) continue;
                oSubMapInfo.m_strParentSubMapID = oParentSubmap.m_strSubMapID;
                oParentSubmap.m_SubMapList.add(oSubMapInfo);
                if (null == subParentMap) continue;
                subParentMap.put(oSubMapInfo.m_strSubMapID, oSubMapInfo);
            }
            oParentSubmap.m_oSubMapDevIDLst.addAll(oSubmapToBeDeleted.m_oSubMapDevIDLst.toArray());
            TIntIterator oSubMapDevIDItor = oSubmapToBeDeleted.m_oSubMapDevIDLst.iterator();
            int iDevID = -1;
            while (oSubMapDevIDItor.hasNext()) {
                iDevID = oSubMapDevIDItor.next();
                this.m_oSubMapList.remove(iDevID);
                this.m_oSubMapList.put(iDevID, oParentSubmap);
            }
            DCDebugTracer.trace("[DeviceConfigNotification] oSubmapToBeDeleted OK");
            oParentSubmap.m_SubMapList.remove(oSubmapToBeDeleted);
            if (null == subParentMap) continue;
            subParentMap.remove(oSubmapToBeDeleted.m_strSubMapID);
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.initOLTAndMxuSubMapInfo();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCFrameWorkUtil.getDeviceTablePanel().refreshSelectedDevCountLabel();
            }
        });
        DCDebugTracer.trace("[DeviceConfigNotification] handleSubMapDeleteNotification end..");
    }

    protected synchronized void handleSubMapModifyNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList, SubMapInfo rootSubMap) {
        DCDebugTracer.trace("[DeviceConfigNotification] handleSubMapModifyNotification start");
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        String strSubmapId = null;
        SubMapInfo oModifiedSubmap = null;
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            SubMapInfo oNewParentSubMap;
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            if (null == oAsnDeviceInfo.oAsnDCSubMapInfo) continue;
            AsnDCSubMapInfo oAsnDCSubMapInfo = oAsnDeviceInfo.oAsnDCSubMapInfo;
            strSubmapId = new String(oAsnDCSubMapInfo.strSubMapID);
            DCDebugTracer.trace("[DeviceConfigNotification] strSubmapId : " + strSubmapId);
            oModifiedSubmap = this.getSubmapForID(strSubmapId);
            if (null == oModifiedSubmap) continue;
            if (null != oAsnDCSubMapInfo.strSubMapName && 0 < oAsnDCSubMapInfo.strSubMapName.length) {
                oModifiedSubmap.m_strSubMapName = new String(oAsnDCSubMapInfo.strSubMapName);
            }
            if (null == oAsnDCSubMapInfo.strParentSubMapID || null == (oNewParentSubMap = this.getSubmapForID(new String(oAsnDCSubMapInfo.strParentSubMapID)))) continue;
            SubMapInfo oOldParentSubmap = this.getParentSubmap(rootSubMap, oModifiedSubmap);
            if (null != oOldParentSubmap && null != oOldParentSubmap.m_SubMapList) {
                oOldParentSubmap.m_SubMapList.remove(oModifiedSubmap);
            }
            if (null == oNewParentSubMap.m_SubMapList) {
                oNewParentSubMap.m_SubMapList = new LinkedList();
            }
            oNewParentSubMap.m_SubMapList.add(oModifiedSubmap);
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.initOLTAndMxuSubMapInfo();
        }
        DCDebugTracer.trace("[DeviceConfigNotification] handleSubMapModifyNotification end..");
    }

    protected void refreshODNSubMapIDLst(DCStringList odnIDLst) {
        if (null == odnIDLst) {
            return;
        }
        int odnLstSize = odnIDLst.size();
        String ondsubMapID = "";
        for (int i = 0; i < odnLstSize; ++i) {
            ondsubMapID = new String((byte[])odnIDLst.get(i));
            if (this.odnSubMapIDLst.contains(ondsubMapID)) continue;
            this.odnSubMapIDLst.add(ondsubMapID);
        }
    }

    private void setRefreshBtnStatus() {
        if (!this.m_bIsrefreshDeviceType && !this.m_bIsGettingSubmapInfo) {
            DCDebugTracer.trace("receive all the device info and device submap info");
            DCFrameWorkUtil.defaultCursor();
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void notifyRefreshDevVersionMes(AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification) {
        int iCount = this.m_oManualOperationVec.size();
        for (int i = 0; i < iCount; ++i) {
            IManualOperation tmpManualOperation = (IManualOperation)this.m_oManualOperationVec.get(i);
            tmpManualOperation.setVersionProgress(oAsnDCDeviceBoardNotification);
        }
    }

    public boolean isMbSNMPDevicesPresent() {
        return this.m_bSNMPDevicesPresent;
    }

    @Override
    public DeviceInfo[] getDevicesForVersion(String strDeviceVersion, String strBoradType, DeviceTypeInfo oDeviceTypeInfo) {
        if (null == strDeviceVersion) {
            return new DeviceInfo[0];
        }
        DeviceInfo[] arrDevices = null;
        Vector deviceVec = null;
        if (null == oDeviceTypeInfo) {
            arrDevices = this.getDevicesByVersion(strDeviceVersion);
            if (null == arrDevices || 0 == arrDevices.length) {
                return arrDevices;
            }
            if (null == strBoradType) {
                return arrDevices;
            }
            deviceVec = DeviceInfoManagerImplHelper.getDevicesForVersion(strDeviceVersion, strBoradType, arrDevices);
        } else {
            arrDevices = this.getDevicesByTypeAndVersion(oDeviceTypeInfo.getDevTypeID(), oDeviceTypeInfo.getDevTypeVersionId());
            deviceVec = null == strBoradType ? DeviceInfoManagerImplHelper.getDevicesForVersion(strDeviceVersion, arrDevices) : DeviceInfoManagerImplHelper.getDevicesForVersion(strDeviceVersion, strBoradType, arrDevices);
        }
        return deviceVec.toArray(new DeviceInfo[deviceVec.size()]);
    }
}

