/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.controller;

import com.huawei.dc.common.asndatacenter.AsnDCT2000DeviceRsp;
import com.huawei.dc.common.asndatacenter.AsnDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDevInfoList;
import com.huawei.dc.common.asndatacenter.AsnT2000DevInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.standalone.IManualOperation;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGReceiver;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class AbstractDCMSGReceiver
extends MSGReceiver {
    private int[] m_iCmdCodes;
    protected boolean m_isClosed = false;
    protected DeviceInfo[] m_arrDeviceInfo = null;
    protected Map<String, DeviceTypeInfo> m_oDeviceTypeHm = null;
    protected Map<String, DeviceTypeInfo> existDeviceTypeList;
    protected int m_iMaxDevID = 0;
    protected static final int WAIT_TIME = 200;
    protected Vector<IManualOperation> m_oManualOperationVec;
    protected byte[] syncObj = new byte[0];
    protected byte[] m_oGetDevSyncObj = new byte[0];
    protected Vector deviceInfoVec = new Vector(0);
    protected int iDevInfoError = 0;

    public int getDeviceInfoError() {
        return this.iDevInfoError;
    }

    public void setDeviceInfoError(int getDeviceInfoError) {
        this.iDevInfoError = getDeviceInfoError;
    }

    public AbstractDCMSGReceiver(int iCmdCode) {
        this(new int[]{iCmdCode});
    }

    public AbstractDCMSGReceiver(int[] iCmdCodes) {
        this.m_iCmdCodes = iCmdCodes;
        this.addMessageListener();
    }

    private void removeMessageListener() {
        DCDebugTracer.trace("remove message listener start...");
        for (int iCommandCode : this.m_iCmdCodes) {
            DCDebugTracer.trace("remove command code is " + iCommandCode);
            DCFrameWorkUtil.getCommManager().removeMessageListener(iCommandCode, (MSGListener)this);
        }
        DCDebugTracer.trace("remove message listener end...");
    }

    private void addMessageListener() {
        DCDebugTracer.trace("add message listener start...");
        for (int iCommandCode : this.m_iCmdCodes) {
            DCDebugTracer.trace("add command code is " + iCommandCode);
            DCFrameWorkUtil.getCommManager().addMessageListener(iCommandCode, (MSGListener)this);
        }
        DCDebugTracer.trace("add message listener end...");
    }

    protected void closeReceiver() {
        this.m_isClosed = true;
        DCDebugTracer.trace("close receiver start...");
        this.removeMessageListener();
        this.close();
        DCDebugTracer.trace("close receiver end...");
    }

    protected boolean isClosed() {
        if (this.m_isClosed) {
            DCDebugTracer.trace(((Object)((Object)this)).getClass().getName() + " : m_isClosed = true");
        }
        return this.m_isClosed;
    }

    public void timeout(int i, Character character) {
        DCDebugTracer.trace(((Object)((Object)this)).getClass().getName() + " time out.");
    }

    public void handleoT2000DevInfoLst(AsnDCT2000DeviceRsp asnDCT2000DeviceRsp, List<T2000DevInfo> oT2000DevInfoLst) {
        AsnDevInfoList asnDevInfoList = asnDCT2000DeviceRsp.oDeviceInfoLst;
        DCDebugTracer.trace("T2k package asnDevInfoList.size()" + asnDevInfoList.size());
        T2000DevInfo oT2000DevInfo = null;
        AsnT2000DevInfo oAsnT2000DevInfo = null;
        AsnDevInfo oAsnDevInfo = null;
        for (int i = 0; i < asnDevInfoList.size(); ++i) {
            oAsnDevInfo = (AsnDevInfo)asnDevInfoList.get(i);
            if (null == oAsnDevInfo) continue;
            oAsnT2000DevInfo = oAsnDevInfo.oAsnT2000DevInfo;
            oT2000DevInfo = new T2000DevInfo();
            oT2000DevInfo.setDeviceID(oAsnDevInfo.iDevId.intValue());
            oT2000DevInfo.setDeviceName(new String(oAsnDevInfo.strDevName));
            oT2000DevInfo.setProtocolType(oAsnDevInfo.enDevProtocol.value);
            if (2 == oT2000DevInfo.getProtocolType()) {
                oT2000DevInfo.setMMLProtocolDevPhyId(oAsnT2000DevInfo.iNeID.intValue());
            } else if (4 == oT2000DevInfo.getProtocolType()) {
                oT2000DevInfo.setTL1ProtocolDevPhyId(new String(oAsnT2000DevInfo.strNETid));
            }
            oT2000DevInfo.setGateWayType(oAsnT2000DevInfo.enGatewayType.value);
            oT2000DevInfo.setGatewayAddress(new String(oAsnT2000DevInfo.strGatewayIP));
            oT2000DevInfo.setPort(oAsnT2000DevInfo.iIPPort.intValue());
            oT2000DevInfo.setUserName(new String(oAsnT2000DevInfo.strUserName));
            oT2000DevInfo.setPass(DCCommonUtil.convertByteArrayToChar(oAsnT2000DevInfo.strPassword));
            oT2000DevInfo.setISUseSSH(oAsnT2000DevInfo.bUseSSH);
            if (null != oAsnT2000DevInfo.iSSHLoginMode) {
                oT2000DevInfo.setSSHLoginMode(oAsnT2000DevInfo.iSSHLoginMode.intValue());
            }
            if (null != oAsnT2000DevInfo.strSSHLoginKey) {
                oT2000DevInfo.setSSHLoginKey(DCCommonUtil.convertByteArrayToChar(oAsnT2000DevInfo.strSSHLoginKey));
            }
            if (null != oAsnT2000DevInfo.strSSHPassPhrase) {
                oT2000DevInfo.setSSHPassPhrase(DCCommonUtil.convertByteArrayToChar(oAsnT2000DevInfo.strSSHPassPhrase));
            }
            if (null != oAsnT2000DevInfo.strSFTPPassPhrase) {
                oT2000DevInfo.setSFTPPassPhrase(DCCommonUtil.convertByteArrayToChar(oAsnT2000DevInfo.strSFTPPassPhrase));
            }
            oT2000DevInfoLst.add(oT2000DevInfo);
        }
    }
}

