/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.configtree;

import com.huawei.dc.common.configtree.ConfigNodeAttr;
import com.huawei.dc.common.configtree.ConfigNodeAttrEx;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.connectivity.view.ConnectTestInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class ConfigTreeRender
implements TreeCellRenderer {
    private ResourceManager m_resMgr = null;
    private ITask m_oTaskInfo = null;

    public ConfigTreeRender(ITask oTask) {
        this.m_oTaskInfo = oTask;
        this.m_resMgr = ResourceManager.getInstance();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object aValue, boolean anIsSelected, boolean anIsExpanded, boolean leaf, int row, boolean hasFocus) {
        JLabel oLabel;
        ConfigTreeNodeInfo oNodeInfo;
        block12: {
            if (!(aValue instanceof DefaultMutableTreeNode)) {
                return null;
            }
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)aValue;
            Object oNodeUserObject = oNode.getUserObject();
            if (!(oNodeUserObject instanceof ConfigTreeNodeInfo)) {
                return null;
            }
            oNodeInfo = (ConfigTreeNodeInfo)oNodeUserObject;
            oLabel = this.initializeLabelForNode(oNodeInfo, anIsSelected, leaf, anIsExpanded, tree.getBackground());
            ConfigNodeAttr l_nodeAttr = oNodeInfo.getConfigNodeAttr();
            if (null != l_nodeAttr && !l_nodeAttr.getNodeName().isEmpty()) {
                try {
                    if (null == this.m_oTaskInfo) {
                        oLabel.setText(this.m_resMgr.getResString(l_nodeAttr.getNodeName()));
                        break block12;
                    }
                    oLabel.setText(this.m_resMgr.getSpecialResForDMS(this.m_oTaskInfo.getDeviceType().getDeviceTypeName(), l_nodeAttr.getNodeName()));
                }
                catch (Exception e) {
                    oLabel.setText(this.m_resMgr.getResString(l_nodeAttr.getNodeName()));
                }
            } else {
                try {
                    if (null == this.m_oTaskInfo) {
                        oLabel.setText(this.m_resMgr.getResString(oNodeInfo.getNodeID()));
                    } else {
                        oLabel.setText(this.m_resMgr.getSpecialResForDMS(this.m_oTaskInfo.getDeviceType().getDeviceTypeName(), oNodeInfo.getNodeID()));
                    }
                }
                catch (Exception e) {
                    oLabel.setText(this.m_resMgr.getResString(oNodeInfo.getNodeID()));
                }
            }
        }
        if (!oNodeInfo.isNodeSelectable()) {
            oLabel.setEnabled(false);
        }
        JPanel oPanel = new JPanel();
        oPanel.setBackground(DCFrameWorkUtil.getBackgroundColor());
        oPanel.setLayout(new BorderLayout());
        oPanel.add(oLabel);
        return oPanel;
    }

    protected JLabel initializeLabelForNode(ConfigTreeNodeInfo oUserObject, boolean bIsSelected, boolean bIsLeaf, boolean bIsExpanded, Color oBGColor) {
        JLabel oLabel = this.createLabelWithIcon(oUserObject, bIsLeaf, bIsExpanded, oBGColor);
        if (bIsSelected) {
            oLabel.setForeground(Color.BLUE);
        } else if (oUserObject.getParentID().equals("Connectivity") && 2 != oUserObject.getNodeSelectedState()) {
            ConnectTestInfo l_connInfo = oUserObject.getConfigNodeConnInfo();
            if (null != l_connInfo && l_connInfo.getCheckContent().isEmpty()) {
                oLabel.setForeground(Color.RED);
            }
        } else {
            oLabel.setForeground(Color.BLACK);
        }
        return oLabel;
    }

    protected JLabel createLabelWithIcon(ConfigTreeNodeInfo oUserObject, boolean bIsLeaf, boolean anIsExpanded, Color oBGColor) {
        JLabel oLabel = new JLabel();
        ImageIcon oCheckBoxIcon = null;
        if (0 == oUserObject.getNodeType()) {
            oCheckBoxIcon = this.m_resMgr.getImage("");
            oLabel.setIcon(oCheckBoxIcon);
            return oLabel;
        }
        oCheckBoxIcon = oUserObject.isNodeSelectable() ? this.getCheckBoxIcon(oUserObject) : this.m_resMgr.getImage("all.gif");
        oLabel.setIcon(oCheckBoxIcon);
        return oLabel;
    }

    private ImageIcon getCheckBoxIcon(ConfigTreeNodeInfo oUserObject) {
        ConfigNodeAttrEx oNodeAttrEx = oUserObject.getConfigNodeAttrEx();
        if (null == oNodeAttrEx) {
            return this.m_resMgr.getImage("");
        }
        int iNodeState = oNodeAttrEx.getStatus();
        if (-1 != iNodeState) {
            return this.getReportTreeIcon(iNodeState);
        }
        int iNodeSelectedState = oUserObject.getNodeSelectedState();
        return this.getCheckItemIcon(iNodeSelectedState);
    }

    private ImageIcon getCheckItemIcon(int iNodeSelectedState) {
        ImageIcon oCheckBoxIcon;
        switch (iNodeSelectedState) {
            case 0: {
                oCheckBoxIcon = this.m_resMgr.getImage("all.gif");
                break;
            }
            case 1: {
                oCheckBoxIcon = this.m_resMgr.getImage("part.gif");
                break;
            }
            case 2: {
                oCheckBoxIcon = this.m_resMgr.getImage("noneselect.gif");
                break;
            }
            default: {
                oCheckBoxIcon = this.m_resMgr.getImage("noneselect.gif");
            }
        }
        return oCheckBoxIcon;
    }

    private ImageIcon getReportTreeIcon(int iNodeState) {
        ImageIcon oCheckBoxIcon;
        switch (iNodeState) {
            case 0: {
                oCheckBoxIcon = this.m_resMgr.getImage("ready.gif");
                break;
            }
            case 1: {
                oCheckBoxIcon = this.m_resMgr.getImage("rpt_normal.gif");
                break;
            }
            case 2: {
                oCheckBoxIcon = this.m_resMgr.getImage("rpt_failure.gif");
                break;
            }
            case 3: {
                oCheckBoxIcon = this.m_resMgr.getImage("rpt_alarm.gif");
                break;
            }
            case 4: {
                oCheckBoxIcon = this.m_resMgr.getImage("rpt_nocompare.gif");
                break;
            }
            default: {
                oCheckBoxIcon = this.m_resMgr.getImage("rpt_nocompare.gif");
            }
        }
        return oCheckBoxIcon;
    }
}

