/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.configtree;

import com.huawei.dc.common.configtree.ConfigCheckTree;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.model.ITask;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ConfigTreePanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 8434498987213434544L;
    private ConfigCheckTree m_oConfigTree = null;
    private JScrollPane m_oScrollPane = null;
    private List<DCTreeEventListener> m_oListenerList = new ArrayList<DCTreeEventListener>(0);
    private boolean bAlreadyVisited = false;
    private boolean bIsTreeEditable = false;

    public ConfigTreePanel(ConfigTreeNodeInfo oConfigTreeNodeInfo, ITask oTask) {
        this.m_oConfigTree = new ConfigCheckTree(oConfigTreeNodeInfo, oTask);
        this.m_oScrollPane = new JScrollPane(this.m_oConfigTree);
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(230, 300));
        this.setMinimumSize(new Dimension(230, 300));
        this.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_oConfigTree.addMouseListener(this);
    }

    public ConfigTreePanel(ConfigTreeNodeInfo oConfigTreeNodeInfo, boolean bIstreeEditable, ITask oTask) {
        this(oConfigTreeNodeInfo, oTask);
        this.bIsTreeEditable = bIstreeEditable;
    }

    public ConfigCheckTree getConfigTree() {
        return this.m_oConfigTree;
    }

    public void setConfigTree(ConfigCheckTree configTree) {
        this.m_oConfigTree = configTree;
    }

    public void addDeviceTreeEventListener(DCTreeEventListener oDevTreeListener) {
        if (null != oDevTreeListener && !this.m_oListenerList.contains(oDevTreeListener)) {
            this.m_oListenerList.add(oDevTreeListener);
        }
    }

    public void removeDeviceTreeEventListener(DCTreeEventListener oDevTreeListener) {
        if (null != oDevTreeListener && !this.m_oListenerList.contains(oDevTreeListener)) {
            this.m_oListenerList.remove(oDevTreeListener);
        }
    }

    private void mouseClickedConfigTree(MouseEvent oMouseEvent) {
        DCDebugTracer.trace("Entering mouseClickedConfigTree");
        int mouseX = oMouseEvent.getX();
        int mouseY = oMouseEvent.getY();
        int iRow = this.m_oConfigTree.getRowForLocation(mouseX, mouseY);
        if (0 > iRow) {
            iRow = this.m_oConfigTree.getRowForLocation(mouseX + 20, mouseY);
        }
        if (0 > iRow) {
            return;
        }
        if (4 == oMouseEvent.getModifiers()) {
            return;
        }
        if (0 == (oMouseEvent.getModifiers() & 0x10) && 0 == (oMouseEvent.getModifiers() & 8) && 500 == oMouseEvent.getID() && 1 == oMouseEvent.getClickCount()) {
            this.m_oConfigTree.setSelectionPath(null);
            return;
        }
        this.clickCheckBoxAction(mouseX, iRow);
        DCDebugTracer.trace("Exiting mouseClickedConfigTree");
    }

    private void clickCheckBoxAction(int mouseX, int iRow) {
        Rectangle rec = this.m_oConfigTree.getRowBounds(iRow);
        DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)this.m_oConfigTree.getLastSelectedPathComponent();
        if (this.bAlreadyVisited) {
            if (!(this.m_oConfigTree.getLastSelectedPathComponent() instanceof DefaultMutableTreeNode) || null == rec) {
                this.sendNotificationToTreeListeners(nodeObject);
            }
            return;
        }
        double iCheckX = rec.getMinX();
        JCheckBox l_checkBox = new JCheckBox();
        Dimension l_checkDimension = l_checkBox.getPreferredSize();
        if ((double)mouseX > iCheckX && (double)mouseX < iCheckX + l_checkDimension.getWidth()) {
            ConfigTreeNodeInfo nodeInfo = (ConfigTreeNodeInfo)nodeObject.getUserObject();
            if (0 == nodeInfo.getNodeType() || !this.bIsTreeEditable || !nodeInfo.isNodeSelectable()) {
                return;
            }
            int selectedState = nodeInfo.getNodeSelectedState();
            Enumeration<TreeNode> childrens = nodeObject.breadthFirstEnumeration();
            this.handleSelection(nodeObject, nodeInfo, selectedState, childrens);
            this.updateTree();
        }
        this.sendNotificationToTreeListeners(nodeObject);
    }

    public void handleSelection(DefaultMutableTreeNode nodeObject, ConfigTreeNodeInfo nodeInfo, int selectedState, Enumeration<DefaultMutableTreeNode> childrens) {
        DCDebugTracer.trace("Entering handleSelection");
        switch (selectedState) {
            case 0: {
                this.handleAllSelect(nodeObject, nodeInfo, childrens);
                break;
            }
            case 1: 
            case 2: {
                this.handleNoneSelect(nodeObject, nodeInfo, childrens);
                break;
            }
        }
        DCDebugTracer.trace("Exiting handleSelection");
    }

    private void handleAllSelect(DefaultMutableTreeNode nodeObject, ConfigTreeNodeInfo nodeInfo, Enumeration<DefaultMutableTreeNode> childrens) {
        nodeInfo.setNodeSelectedState(2);
        if (null != childrens) {
            while (childrens.hasMoreElements()) {
                ((ConfigTreeNodeInfo)childrens.nextElement().getUserObject()).setNodeSelectedState(2);
            }
        }
        ConfigTreePanel.propogateSelectionToParentNode(nodeObject, 2);
    }

    public void handleNoneSelect(DefaultMutableTreeNode nodeObject, ConfigTreeNodeInfo nodeInfo, Enumeration<DefaultMutableTreeNode> childrens) {
        nodeInfo.setNodeSelectedState(0);
        if (null != childrens) {
            while (childrens.hasMoreElements()) {
                DefaultMutableTreeNode node = childrens.nextElement();
                ConfigTreeNodeInfo tempNode = (ConfigTreeNodeInfo)node.getUserObject();
                tempNode.setNodeSelectedState(0);
            }
        }
        ConfigTreePanel.propogateSelectionToParentNode(nodeObject, 0);
    }

    public static void propogateSelectionToParentNode(DefaultMutableTreeNode childNode, int typeOfSelection) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)childNode.getParent();
        ConfigTreeNodeInfo child = null;
        if (null == parentNode) {
            child = (ConfigTreeNodeInfo)childNode.getUserObject();
            child.setNodeSelectedState(typeOfSelection);
            return;
        }
        ConfigTreePanel.updateSelectionForParent(parentNode);
    }

    private static void updateSelectionForParent(DefaultMutableTreeNode parentNode) {
        if (null == parentNode) {
            return;
        }
        DefaultMutableTreeNode oChildNode = null;
        ConfigTreeNodeInfo oChildNodeInfo = null;
        boolean isAnyChildSelected = false;
        boolean isPartiallySelected = false;
        boolean isAnyChildDeselected = false;
        int iChildCount = parentNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            oChildNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            oChildNodeInfo = (ConfigTreeNodeInfo)oChildNode.getUserObject();
            if (1 == oChildNodeInfo.getNodeSelectedState()) {
                isPartiallySelected = true;
                ((ConfigTreeNodeInfo)parentNode.getUserObject()).setNodeSelectedState(1);
                ConfigTreePanel.propogateSelectionToParentNode(parentNode, 1);
                break;
            }
            if (0 == oChildNodeInfo.getNodeSelectedState()) {
                isAnyChildSelected = true;
                if (!isAnyChildDeselected) continue;
                break;
            }
            if (2 != oChildNodeInfo.getNodeSelectedState()) continue;
            isAnyChildDeselected = true;
            if (isAnyChildSelected) break;
        }
        ConfigTreePanel.populateNodeForChildSelection(parentNode, isAnyChildSelected, isPartiallySelected, isAnyChildDeselected);
    }

    private static void populateNodeForChildSelection(DefaultMutableTreeNode oParentNode, boolean isAnyChildSelected, boolean isPartiallySelected, boolean isAnyChildDeselected) {
        if (null == oParentNode) {
            return;
        }
        if (isPartiallySelected) {
            return;
        }
        ConfigTreeNodeInfo oNodeInfo = (ConfigTreeNodeInfo)oParentNode.getUserObject();
        if (isAnyChildSelected && isAnyChildDeselected) {
            oNodeInfo.setNodeSelectedState(1);
            ConfigTreePanel.propogateSelectionToParentNode(oParentNode, 1);
        } else if (isAnyChildSelected && !isAnyChildDeselected) {
            oNodeInfo.setNodeSelectedState(0);
            ConfigTreePanel.propogateSelectionToParentNode(oParentNode, 0);
        } else if (!isAnyChildSelected && isAnyChildDeselected) {
            oNodeInfo.setNodeSelectedState(2);
            ConfigTreePanel.propogateSelectionToParentNode(oParentNode, 2);
        }
    }

    public DefaultMutableTreeNode getNode(String sNodeId) {
        DefaultMutableTreeNode oRootNode = this.getConfigTree().getRootNode();
        DefaultMutableTreeNode oNode = null;
        ConfigTreeNodeInfo oNodeInfo = null;
        Enumeration<TreeNode> oChilds = oRootNode.children();
        while (oChilds.hasMoreElements()) {
            oNode = (DefaultMutableTreeNode)oChilds.nextElement();
            oNodeInfo = (ConfigTreeNodeInfo)oNode.getUserObject();
            if (null == oNodeInfo || !oNodeInfo.getNodeID().equals(sNodeId)) continue;
            return oNode;
        }
        return null;
    }

    public void sendNotificationToTreeListeners(DefaultMutableTreeNode oNode) {
        if (null == oNode) {
            return;
        }
        Object oUserObject = this.getUserObject();
        this.notifyEvent(new DCDeviceTreeNodeSelectionEventObject(oUserObject));
    }

    private Object getUserObject() {
        TreePath oPath = this.m_oConfigTree.getSelectionPath();
        DefaultMutableTreeNode oSelectedNode = (DefaultMutableTreeNode)oPath.getLastPathComponent();
        return oSelectedNode.getUserObject();
    }

    private void notifyEvent(final DCEventObject oEventObject) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (DCTreeEventListener oListener : ConfigTreePanel.this.m_oListenerList) {
                    oListener.onTreeNodeSelection(oEventObject);
                }
            }
        });
    }

    public void updateTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigTreePanel.this.m_oConfigTree.treeDidChange();
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent oMouseEvent) {
        this.mouseClickedConfigTree(oMouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.bAlreadyVisited = false;
        if (4 != mouseEvent.getModifiers()) {
            int y;
            if (0 == (mouseEvent.getModifiers() & 0x10) && 0 == (mouseEvent.getModifiers() & 8) && 500 == mouseEvent.getID() && 1 == mouseEvent.getClickCount()) {
                this.m_oConfigTree.setSelectionPath(null);
                return;
            }
            int x = mouseEvent.getX();
            int row = this.m_oConfigTree.getRowForLocation(x, y = mouseEvent.getY());
            Rectangle rec = this.m_oConfigTree.getRowBounds(row);
            if (null == rec) {
                this.bAlreadyVisited = true;
            }
            return;
        }
        DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)this.m_oConfigTree.getLastSelectedPathComponent();
        this.sendNotificationToTreeListeners(nodeObject);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

