/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.configtree;

import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.configtree.ConfigTreeRender;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.model.ITask;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ConfigCheckTree
extends JTree {
    private static final long serialVersionUID = -958015509835137163L;
    private DefaultTreeModel m_oTreeModel = null;
    private DefaultMutableTreeNode m_oRoot;
    private ConfigTreeNodeInfo m_oConfigTreeNodeInfo = null;

    public ConfigCheckTree(ConfigTreeNodeInfo oConfigTreeNodeInfo, ITask oTask) {
        if (DCFrameWorkUtil.getIsSingleClient() && oTask.getDeviceType().getDeviceDomain() == 1) {
            List<ConfigTreeNodeInfo> m_oNodeInfoLst = oConfigTreeNodeInfo.getNodeInfoLst();
            int iSize = m_oNodeInfoLst.size();
            String str = ResourceManager.getInstance().getResString("DeviceAlarm");
            for (int index = 0; index < iSize; ++index) {
                if (!m_oNodeInfoLst.get(index).toString().contains(str)) continue;
                m_oNodeInfoLst.remove(index);
                --iSize;
                --index;
            }
            oConfigTreeNodeInfo.setNodeInfoLst(m_oNodeInfoLst);
        }
        this.m_oConfigTreeNodeInfo = oConfigTreeNodeInfo;
        this.initTree(oTask);
    }

    private void initTree(ITask oTask) {
        this.setShowsRootHandles(true);
        this.setName("sam_upmodechech_ConfigCheckTree");
        this.m_oTreeModel = (DefaultTreeModel)this.getModel();
        this.getSelectionModel().setSelectionMode(1);
        this.m_oRoot = new DefaultMutableTreeNode();
        this.m_oRoot.setUserObject(this.m_oConfigTreeNodeInfo);
        this.m_oTreeModel.setRoot(this.m_oRoot);
        List<ConfigTreeNodeInfo> l_nodeList = this.m_oConfigTreeNodeInfo.getNodeInfoLst();
        if (null != l_nodeList) {
            for (ConfigTreeNodeInfo subNode : l_nodeList) {
                this.populateTree(this.m_oRoot, subNode);
            }
        }
        this.setSelectionRow(0);
        this.setCellRenderer(new ConfigTreeRender(oTask));
        this.expandFirstLevel();
    }

    private void expandFirstLevel() {
        TreePath rowTreePath = this.getPathForRow(0);
        if (this.isCollapsed(rowTreePath)) {
            this.expandPath(rowTreePath);
        }
    }

    private void populateTree(DefaultMutableTreeNode parentNode, ConfigTreeNodeInfo oConfigInfo) {
        if (null == oConfigInfo) {
            return;
        }
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(oConfigInfo);
        parentNode.add(treeNode);
        List<ConfigTreeNodeInfo> l_nodeList = oConfigInfo.getNodeInfoLst();
        if (null != l_nodeList) {
            for (ConfigTreeNodeInfo subNode : l_nodeList) {
                if (subNode == null || subNode.getNodeID() == null || subNode.getParentID() == null || subNode.getNodeID().indexOf(subNode.getParentID()) >= 0) continue;
                this.populateTree(treeNode, subNode);
            }
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.m_oRoot;
    }
}

