/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.u2kcbb;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.swimap.imap12.util.InmLengthLimitPasswordField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;

public class U2kPasswordFiled
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int OLD_NEW_CONFIRM = 0;
    public static final int NEW_CONFIRM = 1;
    public static final int SINGLE = 2;
    public static final int COMMON_MIN_LEN = 6;
    public static final int SPECIAL_MIN_LEN = 8;
    public static final String DISPLAY_VALUE = "........";
    private JPasswordField txt = new JPasswordField();
    private JButton btn = new JButton("...");
    private char[] pwd;
    private int minLen;
    private int maxLen;
    private JDialog parentJDlg;
    private DCModalDialog parentModalDlg;
    private InputPwdDlg modifyPwdDlg = null;
    private int PWD_CHECK_SUCCESS = 0;
    private int PWD_NOT_EQUAL = 1;
    private int PWD_LENGTH_NOT_ENOUGH = 2;
    InmLengthLimitPasswordField pwdTxt1 = null;
    InmLengthLimitPasswordField pwdTxt2 = null;
    private ActionListener m_oEscKeyHandler;
    private KeyStroke m_oEscKeyStroke;

    public U2kPasswordFiled(int iMaxLength) {
        this.init();
    }

    public U2kPasswordFiled() {
        this.init();
    }

    public U2kPasswordFiled(JDialog dlg) {
        this.parentJDlg = dlg;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        Dimension dimn = new Dimension(21, 21);
        this.btn.setMaximumSize(dimn);
        this.btn.setMinimumSize(dimn);
        this.btn.setPreferredSize(dimn);
        this.btn.setName("btn_pwd");
        this.txt.setPreferredSize(dimn);
        this.txt.setEditable(false);
        this.txt.setEnabled(false);
        this.txt.setText(DISPLAY_VALUE);
        this.txt.setName("txt_pwd");
        this.add((Component)this.txt, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
        this.btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                U2kPasswordFiled.this.btnActionPerformed(event);
            }
        });
    }

    private void btnActionPerformed(ActionEvent event) {
        this.modifyPwd();
    }

    public void setPassword(char[] pwd) {
        this.pwd = pwd;
        if (StringUtils.isNullOrEmptyChar(pwd)) {
            this.txt.setText("");
        } else {
            this.txt.setText(DISPLAY_VALUE);
        }
    }

    public char[] getPasswordInChar() {
        return this.pwd;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.txt.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.txt.getDocument().removeDocumentListener(listener);
    }

    public void setMinLength(int min) {
        this.minLen = min;
    }

    public int getMinLength() {
        return this.minLen;
    }

    public void setMaxLength(int max) {
        this.maxLen = 480 < max ? 480 : max;
    }

    public int getMaxLength() {
        return this.maxLen;
    }

    private void modifyPwd() {
        if (null == this.parentJDlg) {
            this.modifyPwdDlg = new InputPwdDlg();
            this.modifyPwdDlg.setSize(280, 140);
            TKScreenToolKit.centerLocateToScreen(this.modifyPwdDlg);
        } else {
            this.modifyPwdDlg = new InputPwdDlg(this.parentJDlg);
            this.modifyPwdDlg.setSize(280, 140);
            this.modifyPwdDlg.setLocationRelativeTo(this.parentJDlg);
        }
        this.initializeKeyStrokeActions();
        this.modifyPwdDlg.setResizable(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setSize(250, 95);
        mainPanel.setLayout(null);
        this.modifyPwdDlg.setIconImage(ResourceManager.getInstance().getImage("frameicon.gif").getImage());
        this.modifyPwdDlg.setTitle(ResourceManager.getInstance().getResString("MODIFY"));
        this.modifyPwdDlg.setModal(true);
        this.pwdTxt1 = new InmLengthLimitPasswordField(50);
        this.pwdTxt2 = new InmLengthLimitPasswordField(50);
        JLabel pwdLable = new JLabel(ResourceManager.getInstance().getResString("PASSWORD"));
        JLabel confirmPwdLable = new JLabel(ResourceManager.getInstance().getResString("CONFIRM_PASSWORD"));
        JButton oKBtn = new JButton(ResourceManager.getInstance().getResString("SYSTEM_INFO_OK_BTN"));
        JButton closeBtn = new JButton(ResourceManager.getInstance().getResString("SYSTEM_INFO_CANCEL_BTN"));
        oKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                U2kPasswordFiled.this.okBtn_actionPerformed();
            }
        });
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                U2kPasswordFiled.this.cancelBtn_actionPerformed();
            }
        });
        pwdLable.setBounds(new Rectangle(10, 10, 110, 21));
        confirmPwdLable.setBounds(new Rectangle(10, 40, 110, 21));
        this.pwdTxt1.setBounds(new Rectangle(125, 10, 140, 21));
        this.pwdTxt2.setBounds(new Rectangle(125, 40, 140, 21));
        oKBtn.setBounds(new Rectangle(30, 75, 80, 21));
        closeBtn.setBounds(new Rectangle(150, 75, 80, 21));
        mainPanel.add(pwdLable);
        mainPanel.add(confirmPwdLable);
        mainPanel.add((Component)this.pwdTxt1);
        mainPanel.add((Component)this.pwdTxt2);
        mainPanel.add(oKBtn);
        mainPanel.add(closeBtn);
        this.modifyPwdDlg.add(mainPanel);
        this.modifyPwdDlg.setVisible(true);
    }

    public char[] getPwd() {
        return this.pwd;
    }

    private int checkPwd(char[] pwdStr1, char[] pwdStr2) {
        int result = this.PWD_CHECK_SUCCESS;
        String pwd1 = String.valueOf(pwdStr1);
        String pwd2 = String.valueOf(pwdStr2);
        Object parentCom = null;
        if (null != this.parentModalDlg) {
            parentCom = this.parentModalDlg;
        }
        if (null != this.parentJDlg) {
            parentCom = this.parentJDlg;
        }
        if (!pwd1.equals(pwd2)) {
            DCOptionPane.showErrorDialog((Component)parentCom, ResourceManager.getInstance().getResString("CONFIRM_PASSWORD_FAILED_ERROR"));
            return this.PWD_NOT_EQUAL;
        }
        if (this.maxLen != 0 && (pwd1.length() < this.maxLen || pwd2.length() < this.maxLen)) {
            DCOptionPane.showErrorDialog((Component)parentCom, ResourceManager.getInstance().getResString("CONFIRM_PASSWORD_FAILED_ERROR"));
            return this.PWD_LENGTH_NOT_ENOUGH;
        }
        if (this.minLen != 0 && (pwd1.length() > this.minLen || pwd2.length() > this.minLen)) {
            DCOptionPane.showErrorDialog((Component)parentCom, ResourceManager.getInstance().getResString("CONFIRM_PASSWORD_FAILED_ERROR"));
            return this.PWD_LENGTH_NOT_ENOUGH;
        }
        pwd1 = null;
        pwd2 = null;
        return result;
    }

    void cancelBtn_actionPerformed() {
        if (null != this.modifyPwdDlg) {
            this.modifyPwdDlg.closeDialog();
        }
    }

    void okBtn_actionPerformed() {
        int result = this.checkPwd(this.pwdTxt1.getPassword(), this.pwdTxt2.getPassword());
        if (result == this.PWD_CHECK_SUCCESS) {
            this.setPassword(DCEncryptServiceUtil.encrypt(this.pwdTxt1.getPassword()));
            this.modifyPwdDlg.closeDialog();
        }
    }

    private void initializeKeyStrokeActions() {
        ActionListener oEnterKeyHandler = this.createActionListenerForEnter();
        KeyStroke oEnterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyBoardActionFor(oEnterKeyStroke, oEnterKeyHandler);
        this.m_oEscKeyHandler = this.createActionListenerForEscape();
        this.m_oEscKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyBoardActionFor(this.m_oEscKeyStroke, this.m_oEscKeyHandler);
    }

    protected ActionListener createActionListenerForEscape() {
        ActionListener oEscKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                U2kPasswordFiled.this.cancelBtn_actionPerformed();
            }
        };
        return oEscKeyHandler;
    }

    private ActionListener createActionListenerForEnter() {
        ActionListener oEnterKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                U2kPasswordFiled.this.okBtn_actionPerformed();
            }
        };
        return oEnterKeyHandler;
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.modifyPwdDlg.getRootPane().registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    public char[] getPassword() {
        return this.pwdTxt1.getPassword();
    }

    public class InputPwdDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public InputPwdDlg() {
        }

        public InputPwdDlg(JDialog dlg) {
            super(dlg);
        }

        protected void closeDialog() {
            super.dispose();
        }
    }
}

