/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.view;

import com.huawei.dc.common.components.treetable.ISortTreeTableListener;
import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DeviceTreeTableCellRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SortTreeTablePanel
extends JPanel {
    private JSortTreeTable m_oSortTreeTable;
    private AbstractSortTreeTableModel m_oSortTreeTableModel;
    private JLabel m_statLbl;
    private JScrollPane m_scrollPane;
    private boolean m_isEditable = false;
    private boolean m_isShowTreeLine = true;
    private JPanel m_bottomPanel;
    private TreeTableNode m_root;
    private ISortTreeTableListener m_oSortTreeTableListener;

    public SortTreeTablePanel(AbstractSortTreeTableModel sortTreeTableModel) {
        this(sortTreeTableModel, false, false);
    }

    public SortTreeTablePanel(AbstractSortTreeTableModel sortTreeTableModel, boolean isEditable) {
        this(sortTreeTableModel, isEditable, false);
    }

    public SortTreeTablePanel(AbstractSortTreeTableModel sortTreeTableModel, boolean isEditable, boolean isShowTreeLine) {
        this.setLayout(new BorderLayout());
        this.m_oSortTreeTableModel = sortTreeTableModel;
        this.m_isEditable = isEditable;
        this.m_isShowTreeLine = isShowTreeLine;
        this.jInit();
        this.registListener();
    }

    public void registListener(ISortTreeTableListener listener) {
        this.m_oSortTreeTableListener = listener;
    }

    private void jInit() {
        this.m_oSortTreeTable = new JSortTreeTable(this.m_oSortTreeTableModel, this.m_isShowTreeLine, this.m_isEditable);
        this.m_oSortTreeTable.setName("com.huawei.dc.common.components.treetable.view.SortTreeTablePanel.m_oSortTreeTable");
        this.m_oSortTreeTable.getTree().setEditable(false);
        this.m_oSortTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oSortTreeTable.setShowHorizontalLines(true);
        this.m_oSortTreeTable.setShowVerticalLines(true);
        this.m_oSortTreeTable.setRowHeight(20);
        this.m_oSortTreeTable.setDefaultRenderer(String.class, new DeviceTreeTableCellRenderer(this.m_oSortTreeTable));
        this.m_scrollPane = new JScrollPane((Component)((Object)this.m_oSortTreeTable));
        this.m_scrollPane.setName("com.huawei.dc.common.components.treetable.view.SortTreeTablePanel.m_scrollPane");
        this.m_bottomPanel = new JPanel();
        this.m_bottomPanel.setLayout(new BorderLayout());
        this.m_bottomPanel.setName("com.huawei.dc.common.components.treetable.view.SortTreeTablePanel.m_bottomPanel");
        this.m_statLbl = new JLabel();
        this.m_statLbl.setName("com.huawei.dc.common.components.treetable.view.SortTreeTablePanel.m_statLbl");
        this.m_bottomPanel.add((Component)this.m_statLbl, "West");
        this.m_bottomPanel.add(Box.createVerticalStrut(5), "North");
        this.m_bottomPanel.add(Box.createVerticalStrut(5), "South");
        this.m_root = this.m_oSortTreeTableModel.getRoot();
        this.add((Component)this.m_scrollPane, "Center");
        this.add((Component)this.m_bottomPanel, "South");
    }

    private void registListener() {
        this.m_oSortTreeTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SortTreeTablePanel.this.stopAllCellEditor();
            }
        });
        this.m_oSortTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SortTreeTablePanel.this.handleRightClickEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (0 == (4 & e.getModifiers())) {
                    SortTreeTablePanel.this.updateSelectionState();
                }
            }
        });
        this.m_oSortTreeTable.addKeyListener(new MyKeyAdapter());
        this.m_scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SortTreeTablePanel.this.handleRightClickEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SortTreeTablePanel.this.stopAllCellEditor();
            }
        });
    }

    private void stopAllCellEditor() {
        if (this.m_isEditable && null != this.m_oSortTreeTable.getCellEditor()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SortTreeTablePanel.this.m_oSortTreeTable.getCellEditor().stopCellEditing();
                    SortTreeTablePanel.this.m_oSortTreeTable.updateUI();
                }
            });
        }
    }

    public JSortTreeTable getTreeTable() {
        return this.m_oSortTreeTable;
    }

    public TreeTableNode getRoot() {
        return this.m_root;
    }

    public JPanel getBottomPanel() {
        return this.m_bottomPanel;
    }

    private void updateSelectionState() {
        if (null != this.m_oSortTreeTableListener) {
            this.m_oSortTreeTableListener.updateSelectionState();
        }
    }

    private void handleRightClickEvent(MouseEvent oMouseEvent) {
        if (null != this.m_oSortTreeTableListener) {
            this.m_oSortTreeTableListener.handleMouseClickEvent(oMouseEvent);
        }
    }

    public void setStatInfo(String strStatInfo) {
        this.m_statLbl.setText(strStatInfo);
    }

    public void updateTreeTable() {
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oSortTreeTable));
    }

    public void expandTree(DefaultMutableTreeNode start) {
        if (null == start) {
            return;
        }
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)children.nextElement();
            if (dtm.isLeaf()) continue;
            TreePath tp = new TreePath(dtm.getPath());
            this.m_oSortTreeTable.getTree().expandPath(tp);
            this.expandTree(dtm);
        }
    }

    public void scrollRectToVisible(int iRow, int iCol) {
        this.m_scrollPane.scrollRectToVisible(this.m_oSortTreeTable.getCellRect(iRow, iCol, true));
    }

    class MyKeyAdapter
    extends KeyAdapter {
        MyKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int iKeyCode = e.getKeyCode();
            if (65 == iKeyCode && 2 == e.getModifiers()) {
                SortTreeTablePanel.this.updateSelectionState();
            } else if (38 == iKeyCode || 40 == iKeyCode) {
                SortTreeTablePanel.this.updateSelectionState();
            } else {
                DCDebugTracer.trace("dc won't handle the other key.");
            }
        }
    }
}

