/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.view;

import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import java.awt.Color;
import java.awt.Component;
import java.text.Collator;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class ReportTreeTableRenderer
implements TableCellRenderer {
    protected int iNodeIconAlignment = 2;
    protected JTree m_oTree;
    protected JSortTreeTable m_oSortTreeTable;
    protected JTable m_oTable;
    protected boolean bIsCurrentCellSelected = false;
    protected Border m_oBorder = BorderFactory.createMatteBorder(0, 0, 1, 1, Color.white);
    protected int iAlign = 2;
    private Map<String, Integer> m_oRowHightMap = new HashMap<String, Integer>();
    private static final long serialVersionUID = 1L;

    public ReportTreeTableRenderer(JSortTreeTable oSortTableTree) {
        this.m_oSortTreeTable = oSortTableTree;
        if (null != this.m_oSortTreeTable) {
            this.m_oTree = this.m_oSortTreeTable.getTree();
        }
    }

    public ReportTreeTableRenderer(JSortTreeTable oSortTableTree, int iAlignment) {
        this(oSortTableTree);
        this.iNodeIconAlignment = iAlignment;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
        this.m_oTable = table;
        this.bIsCurrentCellSelected = isSelected;
        Component oComponent = null;
        JLabel oLabel = null;
        if (value instanceof TreeTableNodeCellData) {
            TreeTableNodeCellData treeTableNodeCellData = (TreeTableNodeCellData)value;
            oComponent = this.getRendererComponentForNodeCell(treeTableNodeCellData);
        } else if (value instanceof CheckReportTableCell) {
            CheckReportTableCell tableCellData = (CheckReportTableCell)value;
            oLabel = new JLabel();
            if (null != oLabel) {
                oLabel.setOpaque(true);
                String strCellValue = "";
                strCellValue = tableCellData.getValue();
                oLabel.setText(strCellValue);
                oLabel.setBorder(this.getBorder());
            }
            oComponent = oLabel;
            Color foreground = tableCellData.getCellColor();
            Color background = tableCellData.getCellBackground();
            if (null != oComponent) {
                if (null != background) {
                    oComponent.setBackground(background);
                } else {
                    oComponent.setBackground(Color.WHITE);
                }
                if (null != foreground) {
                    oComponent.setForeground(foreground);
                } else {
                    oComponent.setForeground(Color.WHITE);
                }
                if (oComponent.getForeground().equals(oComponent.getBackground())) {
                    oComponent.setForeground(Color.BLACK);
                }
            }
        } else {
            oLabel = new JLabel();
            oLabel.setOpaque(true);
            String strVal = "";
            if (null != value) {
                strVal = value.toString();
            }
            oLabel.setText(strVal);
            oLabel.setBorder(this.getBorder());
            oComponent = oLabel;
            oComponent.setBackground(Color.WHITE);
        }
        if (oComponent instanceof JLabel) {
            oLabel = (JLabel)oComponent;
            String text = oLabel.getText();
            int iRowHeight = 0;
            if (null != text) {
                text = Normalizer.normalize(text, Normalizer.Form.NFC);
                String[] strColumns = null;
                strColumns = text.split("\n");
                oLabel.setText(text);
                iRowHeight = this.getRowHeight(iRow, strColumns.length);
                oComponent.setSize(oComponent.getWidth(), iRowHeight);
            } else {
                iRowHeight = this.getRowHeight(iRow, 1);
                oComponent.setSize(oComponent.getWidth(), iRowHeight);
            }
        }
        return oComponent;
    }

    private int getRowHeight(int iRow, int rate) {
        String strRow = String.valueOf(iRow);
        int iReturn = 0;
        if (!this.m_oRowHightMap.containsKey(strRow)) {
            iReturn = 20 * rate;
            this.m_oRowHightMap.put(strRow, iReturn);
        } else {
            iReturn = this.m_oRowHightMap.get(strRow);
            if (iReturn < 20 * rate) {
                iReturn = 20 * rate;
                this.m_oRowHightMap.put(strRow, iReturn);
            }
        }
        return iReturn;
    }

    public int getAlign() {
        return this.iAlign;
    }

    public void setAlign(int align) {
        this.iAlign = align;
    }

    protected Component getRendererComponentForNodeCell(TreeTableNodeCellData treeTableNodeCellData) {
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        TreeTableNode oTreeTableNode = treeTableNodeCellData.getAttachedTreeNode();
        TreePath path = new TreePath(oTreeTableNode.getPath());
        this.populateNodeIcon(oLabel, treeTableNodeCellData, path);
        if (null != treeTableNodeCellData.getCellDataValue()) {
            this.populateValueAndToolTipForCell(oLabel, treeTableNodeCellData);
        }
        oLabel.setHorizontalAlignment(treeTableNodeCellData.getNodeIconAlignment());
        oLabel.setIconTextGap(8);
        oLabel.setBorder(this.getBorder());
        return oLabel;
    }

    private void populateNodeIcon(JLabel oLabel, TreeTableNodeCellData oTreeTableNodeCellData, TreePath oPath) {
        String strIconName = null;
        strIconName = null != oPath && this.m_oTree.isExpanded(oPath) ? oTreeTableNodeCellData.getNodeOpenedIcon() : oTreeTableNodeCellData.getNodeClosedIcon();
        if (oTreeTableNodeCellData.getAttachedTreeNode().isLeaf()) {
            strIconName = oTreeTableNodeCellData.getNodeLeafIcon();
        }
        if (null != strIconName && !Collator.getInstance().equals("", strIconName)) {
            oLabel.setIcon(ResourceManager.getInstance().getImage(strIconName));
        }
    }

    protected Component getRendererComponentForCell(TreeTableCellData treeTableCellData) {
        Object cellDataValue = treeTableCellData.getCellDataValue();
        if (null != cellDataValue) {
            return this.getDefaultRendererComponentForCell(cellDataValue);
        }
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        oLabel.setBorder(this.getBorder());
        return oLabel;
    }

    protected Component getDefaultRendererComponentForCell(Object cellDataValue) {
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        String strCellValue = "";
        strCellValue = cellDataValue instanceof ResourceProgressInfo ? ((ResourceProgressInfo)cellDataValue).getCurrentOperationName() : cellDataValue.toString();
        if (null != strCellValue && !Collator.getInstance().equals("", strCellValue.trim())) {
            oLabel.setText(strCellValue);
            oLabel.setToolTipText(strCellValue);
        }
        oLabel.setBorder(this.getBorder());
        return oLabel;
    }

    private void populateValueAndToolTipForCell(JLabel oLabel, TreeTableNodeCellData treeTableNodeCellData) {
        String strCellValue = treeTableNodeCellData.getCellDataValue().toString();
        if (null != strCellValue && !Collator.getInstance().equals("", strCellValue.trim())) {
            oLabel.setText(strCellValue);
            oLabel.setToolTipText(strCellValue);
        }
    }

    public Border getBorder() {
        return this.m_oBorder;
    }

    public void setBorder(Border border) {
        this.m_oBorder = border;
    }

    public void setNodeIconAlignment(int iAlignment) {
        this.iNodeIconAlignment = iAlignment;
    }
}

