/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.view;

import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import com.swimap.iview.templates.filtertreetable.FilterTreeTable;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;

public class JSortTreeTable
extends FilterTreeTable {
    private boolean m_isEditable = false;
    private boolean m_isShowTreeLine = false;
    protected AbstractSortTreeTableModel m_sortModel;

    public JSortTreeTable(AbstractSortTreeTableModel oTreeTableModel) {
        this(oTreeTableModel, false, false);
    }

    public JSortTreeTable(AbstractSortTreeTableModel oTreeTableModel, boolean isShowGrid) {
        this(oTreeTableModel, false, false);
        this.setShowGrid(isShowGrid);
    }

    public JSortTreeTable(AbstractSortTreeTableModel oTreeTableModel, boolean isShowTreeLine, boolean isEditable) {
        super((TreeTableModel)oTreeTableModel);
        this.m_sortModel = oTreeTableModel;
        this.m_isShowTreeLine = isShowTreeLine;
        this.m_isEditable = isEditable;
        this.setDefaultEditor(TreeTableModel.class, (TableCellEditor)((Object)new DCSortTreeTableCellEditor()));
        this.setRootVisible(false);
        this.setSelectionMode(2);
    }

    public void updateUI() {
        try {
            super.updateUI();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        if (this.rendererTree != null) {
            try {
                this.rendererTree.updateUI();
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
            this.setDefaultEditor(TreeTableModel.class, (TableCellEditor)((Object)new DCSortTreeTableCellEditor()));
        }
        LookAndFeel.installColorsAndFont((JComponent)((Object)this), "Tree.background", "Tree.foreground", "Tree.font");
    }

    public JTree getTree() {
        return this.rendererTree;
    }

    private Object getNodeForRow(int row) {
        TreePath oTreePath = super.getTree().getPathForRow(row);
        if (null != oTreePath) {
            return oTreePath.getLastPathComponent();
        }
        return null;
    }

    public Object getValueAt(int iRow, int iColumn) {
        Object oNode = this.getNodeForRow(iRow);
        if (this.m_sortModel.getColumnName(0).equals(ResourceManager.getInstance().getResString("RESOURCE_NAME"))) {
            TaskTableUtil.setbInTaskSubTablePanel(true);
        }
        return this.m_sortModel.getValueAt(oNode, iColumn);
    }

    class DCSortTreeTableCellEditor
    extends FilterTreeTable.TreeTableCellEditor {
        public DCSortTreeTableCellEditor() {
            super((FilterTreeTable)JSortTreeTable.this);
        }

        public Component getTableCellEditorComponent(JTable oTable, Object oValue, boolean isSelected, int iRow, int iColumn) {
            JTree oTree = JSortTreeTable.this.getTree();
            boolean isRootVisible = oTree.isRootVisible();
            if (!isRootVisible) {
                ++iRow;
            }
            return super.getTableCellEditorComponent(oTable, oValue, isSelected, iRow, iColumn);
        }

        public boolean isCellEditable(EventObject paramEventObject) {
            if (paramEventObject instanceof MouseEvent) {
                MouseEvent localMouseEvent1 = (MouseEvent)paramEventObject;
                if (localMouseEvent1.getModifiers() == 0 || localMouseEvent1.getModifiers() == 16) {
                    for (int i = JSortTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                        if (JSortTreeTable.this.getColumnClass(i) != TreeTableModel.class) continue;
                        SwingUtilities.convertMouseEvent((Component)((Object)JSortTreeTable.this), localMouseEvent1, (Component)JSortTreeTable.this.rendererTree);
                        MouseEvent localMouseEvent2 = new MouseEvent((Component)JSortTreeTable.this.rendererTree, localMouseEvent1.getID(), localMouseEvent1.getWhen(), localMouseEvent1.getModifiers(), localMouseEvent1.getX() - JSortTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, localMouseEvent1.getY(), localMouseEvent1.getClickCount(), localMouseEvent1.isPopupTrigger());
                        JSortTreeTable.this.rendererTree.dispatchEvent((AWTEvent)localMouseEvent2);
                        break;
                    }
                }
                return JSortTreeTable.this.m_isEditable && 2 == localMouseEvent1.getClickCount();
            }
            return false;
        }
    }
}

