/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import java.awt.Color;
import java.awt.Component;
import java.text.Collator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class DeviceTreeTableCellRenderer
extends DCTreeTableCellRenderer {
    public DeviceTreeTableCellRenderer(JSortTreeTable oSortTableTree) {
        super(oSortTableTree);
        this.m_oSortTreeTable = oSortTableTree;
        if (null != this.m_oSortTreeTable) {
            this.m_oTree = this.m_oSortTreeTable.getTree();
        }
        this.m_oBorder = DCConstants.DEFAULT_TABLE_CELL_BORDER;
    }

    public DeviceTreeTableCellRenderer(JSortTreeTable oSortTableTree, int iAlignment) {
        this(oSortTableTree);
        this.m_iNodeIconAlignment = iAlignment;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
        this.m_oTable = table;
        this.m_bIsCurrentCellSelected = isSelected;
        Component oComponent = null;
        if (value instanceof DeviceInfo) {
            oComponent = this.getRendererComponentForNodeCell((DeviceInfo)value);
        } else if (value instanceof String) {
            oComponent = this.getDefaultRendererComponentForCell((String)value);
        } else if (value instanceof OperationStatus) {
            oComponent = this.getRendererComponentForProgressInfo((OperationStatus)value);
        } else {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            String strVal = "";
            if (null != value) {
                strVal = value.toString();
            }
            oLabel.setText(strVal);
            oLabel.setBorder(this.getBorder());
            oComponent = oLabel;
        }
        if (oComponent instanceof JProgressBar) {
            return oComponent;
        }
        if (value instanceof OperationStatus) {
            if (this.m_bIsCurrentCellSelected) {
                oComponent.setBackground(this.m_oTable.getSelectionBackground());
            } else {
                oComponent.setBackground(this.m_oTable.getBackground());
            }
            return oComponent;
        }
        this.setBackgroundColorForComponent(oComponent);
        return oComponent;
    }

    private Component getRendererComponentForProgressInfo(OperationStatus oOperationStatus) {
        if (oOperationStatus.getIsProgress()) {
            return this.generateProgressBar(oOperationStatus);
        }
        return this.generateLinkRenderer(oOperationStatus);
    }

    private Component generateLinkRenderer(OperationStatus oOperationStatus) {
        JButton oButton = new JButton();
        oButton.setBackground(this.m_oTable.getBackground());
        String valueStr = oOperationStatus.toString();
        if (this.m_bIsCurrentCellSelected) {
            valueStr = StringUtils.convertColorsToWhite(valueStr);
            oButton.setForeground(Color.WHITE);
        }
        oButton.setText(valueStr);
        oButton.setToolTipText(oOperationStatus.getToolTipText());
        oButton.setHorizontalAlignment(2);
        MatteBorder oMatteBorder = BorderFactory.createMatteBorder(0, 0, 0, 0, this.m_oTable.getGridColor());
        oButton.setBorder(oMatteBorder);
        oButton.setEnabled(true);
        return oButton;
    }

    private Component generateProgressBar(OperationStatus oOperationStatus) {
        JProgressBar progressBar = new JProgressBar(0, 0, 100);
        progressBar.setOpaque(true);
        progressBar.setBackground(this.m_oTable.getBackground());
        progressBar.setForeground(new Color(0, 0, 115));
        progressBar.setStringPainted(true);
        if (-1 != oOperationStatus.getProgress()) {
            progressBar.setValue(oOperationStatus.getProgress());
        }
        progressBar.setString(oOperationStatus.toString());
        progressBar.setToolTipText(oOperationStatus.toString());
        progressBar.setBorder(this.getBorder());
        return progressBar;
    }

    @Override
    protected void setBackgroundColorForComponent(Component oComponent) {
        if (this.m_bIsCurrentCellSelected) {
            oComponent.setBackground(this.m_oTable.getSelectionBackground());
            oComponent.setForeground(Color.white);
        } else {
            oComponent.setBackground(this.m_oTable.getBackground());
            oComponent.setForeground(this.m_oTable.getForeground());
        }
    }

    protected Component getRendererComponentForNodeCell(DeviceInfo oDeviceInfo) {
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        ImageIcon oImageICon = ResourceManager.getInstance().getNeTypeImage(oDeviceInfo.getDevId(), this.m_oTable.getBackground());
        if (null != oImageICon) {
            oLabel.setIcon(oImageICon);
        }
        this.populateValueAndToolTipForCell(oLabel, "");
        oLabel.setHorizontalAlignment(this.m_iNodeIconAlignment);
        oLabel.setIconTextGap(8);
        oLabel.setBorder(this.getBorder());
        return oLabel;
    }

    protected Component getRendererComponentForCell(String strCellValue) {
        if (null != strCellValue) {
            return this.getDefaultRendererComponentForCell(strCellValue);
        }
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        oLabel.setBorder(this.getBorder());
        return oLabel;
    }

    protected Component getDefaultRendererComponentForCell(String strCellValue) {
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        this.populateValueAndToolTipForCell(oLabel, strCellValue);
        oLabel.setBorder(this.getBorder());
        if (this.m_bIsCurrentCellSelected) {
            oLabel.setForeground(Color.WHITE);
        }
        return oLabel;
    }

    private void populateValueAndToolTipForCell(JLabel oLabel, String strCellValue) {
        if (null != strCellValue && !Collator.getInstance().equals("", strCellValue.trim())) {
            oLabel.setText(strCellValue);
            oLabel.setToolTipText(strCellValue);
        }
    }

    @Override
    public Border getBorder() {
        return this.m_oBorder;
    }

    @Override
    public void setBorder(Border border) {
        this.m_oBorder = border;
    }

    @Override
    public void setNodeIconAlignment(int iAlignment) {
        this.m_iNodeIconAlignment = iAlignment;
    }
}

