/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import java.awt.Color;
import java.awt.Component;
import java.text.Collator;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class DCTreeTableCellRenderer
implements TableCellRenderer {
    protected static final String TASK_PROGRESS_INFO_CELL_NAME = "TaskProgressInfoCellName";
    protected int m_iNodeIconAlignment = 2;
    protected JTree m_oTree;
    protected JSortTreeTable m_oSortTreeTable;
    protected JTable m_oTable;
    protected boolean m_bIsCurrentCellSelected = false;
    protected Border m_oBorder = DCConstants.DEFAULT_TABLE_CELL_BORDER;
    private static final int PACKAGE_STATUS_COLUMN_INDEX = 3;
    private static final int OPERATION_COLUMN_INDEX = 7;

    public DCTreeTableCellRenderer(JSortTreeTable oSortTableTree) {
        this.m_oSortTreeTable = oSortTableTree;
        if (null != this.m_oSortTreeTable) {
            this.m_oTree = this.m_oSortTreeTable.getTree();
        }
    }

    public DCTreeTableCellRenderer(JSortTreeTable oSortTableTree, int iAlignment) {
        this(oSortTableTree);
        this.m_iNodeIconAlignment = iAlignment;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
        this.m_oTable = table;
        this.m_bIsCurrentCellSelected = isSelected;
        ResourceManager oResMgr = ResourceManager.getInstance();
        String strFirstColName = this.m_oTable.getColumnName(0);
        if (!(strFirstColName.equals(oResMgr.getResString("SUB_OPERATION")) || strFirstColName.equals(oResMgr.getResString("RES_OPR_NAME")) || strFirstColName.equals(oResMgr.getResString("SL_NO")))) {
            String tableName = "";
            DCTreeTableModel tableModel = null;
            if (this.m_oTable instanceof DCSortableTreeTable) {
                tableModel = ((DCSortableTreeTable)((Object)this.m_oTable)).getDataModel();
            }
            if (tableModel != null) {
                tableName = tableModel.getFlag();
            }
            iCol = TaskTableUtil.convertColumnIndexToModel(iCol, tableName);
        }
        Component oComponent = null;
        if (value instanceof TreeTableNodeCellData) {
            TreeTableNodeCellData treeTableNodeCellData = (TreeTableNodeCellData)value;
            oComponent = this.getRendererComponentForNodeCell(treeTableNodeCellData);
        } else if (value instanceof TreeTableCellData) {
            TreeTableCellData treeTableCellData = (TreeTableCellData)value;
            oComponent = this.getRendererComponentForCell(treeTableCellData, iCol);
        } else {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            String strVal = "";
            if (null != value) {
                strVal = value.toString();
            }
            oLabel.setText(strVal);
            oLabel.setBorder(this.getBorder());
            oComponent = oLabel;
        }
        if (!this.m_bIsCurrentCellSelected && this.isIsolation(iRow, iCol)) {
            oComponent.setEnabled(false);
        }
        if (oComponent instanceof JProgressBar) {
            return oComponent;
        }
        this.setBackgroundColorForComponent(oComponent);
        return oComponent;
    }

    protected void setBackgroundColorForComponent(Component oComponent) {
        boolean isIsTaskProgressCell = this.checkIsTaskProgressCell(oComponent);
        if (this.m_bIsCurrentCellSelected) {
            oComponent.setBackground(this.m_oTable.getSelectionBackground());
            if (!isIsTaskProgressCell) {
                oComponent.setForeground(Color.white);
            }
        } else {
            oComponent.setBackground(this.m_oTable.getBackground());
            if (!isIsTaskProgressCell) {
                oComponent.setForeground(this.m_oTable.getForeground());
            }
        }
    }

    private boolean checkIsTaskProgressCell(Component oComponent) {
        boolean isInstanceofJLabel = false;
        isInstanceofJLabel = oComponent instanceof JLabel;
        if (!isInstanceofJLabel) {
            return false;
        }
        JLabel jLabel = (JLabel)oComponent;
        return jLabel.getName() != null && jLabel.getName().equals(TASK_PROGRESS_INFO_CELL_NAME);
    }

    protected Component getRendererComponentForNodeCell(TreeTableNodeCellData treeTableNodeCellData) {
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        TreeTableNode oTreeTableNode = treeTableNodeCellData.getAttachedTreeNode();
        TreePath path = new TreePath(oTreeTableNode.getPath());
        this.populateNodeIcon(oLabel, treeTableNodeCellData, path);
        if (null != treeTableNodeCellData.getCellDataValue()) {
            this.populateValueAndToolTipForCell(oLabel, treeTableNodeCellData);
        }
        oLabel.setHorizontalAlignment(treeTableNodeCellData.getNodeIconAlignment());
        oLabel.setIconTextGap(8);
        oLabel.setBorder(this.getBorder());
        return oLabel;
    }

    private void populateNodeIcon(JLabel oLabel, TreeTableNodeCellData oTreeTableNodeCellData, TreePath oPath) {
        String strIconName = null;
        strIconName = null != oPath && this.m_oTree.isExpanded(oPath) ? oTreeTableNodeCellData.getNodeOpenedIcon() : oTreeTableNodeCellData.getNodeClosedIcon();
        if (oTreeTableNodeCellData.getAttachedTreeNode().isLeaf()) {
            strIconName = oTreeTableNodeCellData.getNodeLeafIcon();
        }
        if (null != strIconName && !Collator.getInstance().equals("", strIconName)) {
            oLabel.setIcon(ResourceManager.getInstance().getImage(strIconName));
        }
    }

    protected Component getRendererComponentForCell(TreeTableCellData treeTableCellData, int col) {
        Object cellDataValue = treeTableCellData.getCellDataValue();
        if (null != cellDataValue) {
            return this.getDefaultRendererComponentForCell(cellDataValue, col);
        }
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        oLabel.setBorder(this.getBorder());
        return oLabel;
    }

    protected Component getDefaultRendererComponentForCell(Object cellDataValue, int col) {
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        String strCellValue = "";
        if (cellDataValue instanceof ResourceProgressInfo) {
            if (col == 7) {
                strCellValue = ((ResourceProgressInfo)cellDataValue).getCurrentOperationName();
            } else if (col == 3) {
                strCellValue = ((ResourceProgressInfo)cellDataValue).getSWDLStatus();
            }
        } else {
            strCellValue = cellDataValue.toString();
        }
        if (!StringUtils.isNullOrEmptyStr(strCellValue)) {
            if (this.m_bIsCurrentCellSelected) {
                strCellValue = StringUtils.convertColorsToWhite(strCellValue);
                oLabel.setText(strCellValue);
            } else {
                oLabel.setText(strCellValue);
            }
            oLabel.setToolTipText(strCellValue);
        }
        oLabel.setBorder(this.getBorder());
        return oLabel;
    }

    private void populateValueAndToolTipForCell(JLabel oLabel, TreeTableNodeCellData treeTableNodeCellData) {
        String strCellValue = treeTableNodeCellData.getCellDataValue().toString();
        if (null != strCellValue && !Collator.getInstance().equals("", strCellValue.trim())) {
            oLabel.setText(strCellValue);
            oLabel.setToolTipText(strCellValue);
        }
    }

    public Border getBorder() {
        return this.m_oBorder;
    }

    public void setBorder(Border border) {
        this.m_oBorder = border;
    }

    public void setNodeIconAlignment(int iAlignment) {
        this.m_iNodeIconAlignment = iAlignment;
    }

    public void removeAll() {
        if (null != this.m_oTree) {
            this.m_oTree.removeAll();
            this.m_oTree = null;
        }
        if (null != this.m_oSortTreeTable) {
            this.m_oSortTreeTable.removeAll();
            this.m_oSortTreeTable = null;
        }
        if (null != this.m_oTable) {
            this.m_oTable.removeAll();
            this.m_oTable = null;
        }
        if (null != this.m_oBorder) {
            this.m_oBorder = null;
        }
    }

    private boolean isIsolation(int iRow, int iCol) {
        TreePath oTreePath = this.m_oSortTreeTable.getTree().getPathForRow(iRow);
        if (null == oTreePath) {
            return false;
        }
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        return IsolationCommonOperation.isIsolationResource(oNode);
    }
}

