/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.view;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortButtonRenderer;
import com.huawei.dc.common.MyMouseMotionAdapter;
import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceIDDataObject;
import com.swimap.iview.templates.filtertreetable.FilterTreeTable;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DCSortableTreeTable
extends JSortTreeTable {
    private static final long serialVersionUID = 1L;
    private static final int DEVICE_ID_COL_INDEX = 0;
    private DCTreeTableModel m_oDataModel;
    private DCSortButtonRenderer m_oSortRenderer;

    public DCSortableTreeTable(DCTreeTableModel oTreeTableModel) {
        super(oTreeTableModel);
        this.m_oDataModel = oTreeTableModel;
    }

    public DCSortableTreeTable(DCTreeTableModel oTreeTableModel, FilterTreeTable.TreeTableCellRenderer oTableCellRenderer, FilterTreeTable.TreeTableCellRenderer oHeaderCellRenderer) {
        super(oTreeTableModel);
        this.m_oDataModel = oTreeTableModel;
        this.initializeCellRenderers(oTableCellRenderer, oHeaderCellRenderer);
    }

    public DCSortableTreeTable(AbstractSortTreeTableModel mSortTreeTableModel, boolean b, boolean isEditable) {
        super(mSortTreeTableModel, b, isEditable);
    }

    private void initializeCellRenderers(FilterTreeTable.TreeTableCellRenderer oTableCellRenderer, FilterTreeTable.TreeTableCellRenderer oHeaderCellRenderer) {
        int iColumnCount = this.getColumnModel().getColumnCount();
        if (null != oTableCellRenderer) {
            for (int i = 0; i < iColumnCount; ++i) {
                this.getColumnModel().getColumn(i).setCellRenderer((TableCellRenderer)oTableCellRenderer);
            }
        }
    }

    public int getCurrentSortState(int iCurrentColumn) {
        if (null == this.m_oSortRenderer) {
            return 0;
        }
        return this.m_oSortRenderer.getState(iCurrentColumn);
    }

    public void setCurrentSortColumn(int iCurrentColumn) {
        if (null != this.m_oSortRenderer) {
            this.m_oSortRenderer.setSelectedColumn(iCurrentColumn);
        }
    }

    public void clearCurrentSort() {
        if (null != this.m_oSortRenderer) {
            this.m_oSortRenderer.clearSortFlag();
        }
    }

    public DCTreeTableModel getDataModel() {
        return this.m_oDataModel;
    }

    public DeviceIDDataObject getSelectedDeviceIDObject(JSortTreeTable oDeviceTreeTable) {
        DeviceIDDataObject deviceIDObject = null;
        if (null != oDeviceTreeTable) {
            int iNumOFRows = oDeviceTreeTable.getRowCount();
            int iSelectedRow = oDeviceTreeTable.getSelectedRow();
            int iSelectedRowCount = oDeviceTreeTable.getSelectedRowCount();
            if (iSelectedRowCount == 1 && iNumOFRows > 0) {
                deviceIDObject = this.getDeviceIDObject(oDeviceTreeTable.getValueAt(iSelectedRow, 0));
            }
        }
        return deviceIDObject;
    }

    private DeviceIDDataObject getDeviceIDObject(Object tableCellData) {
        DeviceIDDataObject oDCDeviceIDDataObject = null;
        if (tableCellData instanceof TreeTableNodeCellData) {
            TreeTableNodeCellData cellData = (TreeTableNodeCellData)tableCellData;
            Object cellDataValue = cellData.getCellDataValue();
            if (cellDataValue instanceof DeviceIDDataObject) {
                oDCDeviceIDDataObject = (DeviceIDDataObject)cellDataValue;
            }
        } else if (tableCellData instanceof DeviceInfo) {
            oDCDeviceIDDataObject = new DeviceIDDataObject(((DeviceInfo)tableCellData).getDevId());
        }
        return oDCDeviceIDDataObject;
    }

    public void deleteTableRow(int[] iarrSelectedRows) {
        if (null != iarrSelectedRows) {
            int i;
            TreeTableNode oRootNode = this.getDataModel().getRoot();
            TreeTableNode[] oChildNode = new TreeTableNode[iarrSelectedRows.length];
            for (i = 0; i < iarrSelectedRows.length; ++i) {
                oChildNode[i] = (TreeTableNode)oRootNode.getChildAt(iarrSelectedRows[i]);
            }
            for (i = 0; i < iarrSelectedRows.length; ++i) {
                oRootNode.remove(oChildNode[i]);
            }
            this.refereshTable(iarrSelectedRows[0]);
        }
    }

    public void refereshTable(final int row) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCSortableTreeTable.this.updateUI();
                if (row != DCSortableTreeTable.this.getRowCount()) {
                    DCSortableTreeTable.this.setRowSelectionInterval(row, row);
                } else if (0 < DCSortableTreeTable.this.getRowCount()) {
                    DCSortableTreeTable.this.setRowSelectionInterval(0, 0);
                }
            }
        });
    }

    public void refereshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCSortableTreeTable.this.updateUI();
                DCSortableTreeTable.this.repaint();
            }
        });
    }

    public void expandTree(JTree tree, DefaultMutableTreeNode start) {
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)children.nextElement();
            if (dtm.isLeaf()) continue;
            TreePath tp = new TreePath(dtm.getPath());
            tree.expandPath(tp);
            this.expandTree(tree, dtm);
        }
    }

    public void collapseTree(JTree tree, DefaultMutableTreeNode start) {
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)children.nextElement();
            if (dtm.isLeaf()) continue;
            TreePath tp = new TreePath(dtm.getPath());
            tree.collapsePath(tp);
            this.collapseTree(tree, dtm);
        }
    }

    public void doClean() {
        int iColumnCount = this.getColumnModel().getColumnCount();
        DCTreeTableCellRenderer oDefaultCellRenderer = null;
        for (int i = 0; i < iColumnCount; ++i) {
            oDefaultCellRenderer = (DCTreeTableCellRenderer)this.getColumnModel().getColumn(i).getCellRenderer();
            if (null == oDefaultCellRenderer) continue;
            oDefaultCellRenderer.removeAll();
        }
        for (MouseMotionListener oMouseMotionListener : this.getMouseMotionListeners()) {
            if (!(oMouseMotionListener instanceof MyMouseMotionAdapter)) continue;
            MyMouseMotionAdapter myMouseMotionAdapter = (MyMouseMotionAdapter)oMouseMotionListener;
            myMouseMotionAdapter.clearUp();
        }
        this.getSelectionModel().clearSelection();
        if (null != this.m_oDataModel) {
            this.m_oDataModel.clearUp();
            this.m_oDataModel = null;
        }
    }
}

