/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.model;

import com.huawei.dc.common.components.treetable.model.TreeTableCellData;

public class TreeTableRowData
implements Comparable {
    private TreeTableCellData[] columnData = null;
    private Object m_oUserObject;
    private int nodeType = -1;
    public static final int TASK_NODE_TYPE = 1;
    public static final int DEVICE_NODE_TYPE = 2;
    public static final int BOARD_NODE_TYPE = 3;
    public static final int OPERATION_TYPE = 4;
    public static final int SUBOPERATION_TYPE = 5;
    private int iNodeStatus = -1;
    public static final int RESET_NO_BOARD = 0;
    private int iDevID = -1;

    public TreeTableRowData(int noOfColumns) {
        this.columnData = new TreeTableCellData[noOfColumns];
    }

    public TreeTableRowData(int noOfColumns, int nodeType) {
        this.nodeType = nodeType;
        this.columnData = new TreeTableCellData[noOfColumns];
    }

    public TreeTableRowData(TreeTableCellData[] treeTableColumnData, int nodeType) {
        this.nodeType = nodeType;
        this.columnData = treeTableColumnData;
    }

    public TreeTableRowData(TreeTableCellData[] treeTableColumnData) {
        this.columnData = treeTableColumnData;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public void setNodeStatus(int iStatus) {
        this.iNodeStatus = iStatus;
    }

    public int getNodeStatus() {
        return this.iNodeStatus;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setColumnData(int colIndex, TreeTableCellData cellData) {
        if (null != cellData) {
            this.columnData[colIndex] = cellData;
        }
    }

    public TreeTableCellData getColumnData(int colIndex) {
        return this.columnData[colIndex];
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_oUserObject == null ? 0 : this.m_oUserObject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeTableRowData other = (TreeTableRowData)obj;
        return !(this.m_oUserObject == null ? other.m_oUserObject != null : !this.m_oUserObject.equals(other.m_oUserObject));
    }

    public Object getUserObject() {
        return this.m_oUserObject;
    }

    public void setUserObject(Object userObject) {
        this.m_oUserObject = userObject;
    }

    public String toString() {
        String cellDataValue = "";
        TreeTableCellData firstNode = this.columnData[0];
        if (firstNode == null) {
            return "";
        }
        Object dataValue = firstNode.getCellDataValue();
        if (dataValue instanceof String) {
            cellDataValue = (String)dataValue;
        }
        return cellDataValue;
    }

    public int getDevID() {
        return this.iDevID;
    }

    public void setDevID(int iDevID) {
        this.iDevID = iDevID;
    }

    public void clearData() {
        if (null == this.columnData) {
            return;
        }
        int length = this.columnData.length;
        for (int i = 0; i < length; ++i) {
            if (null == this.columnData[i]) continue;
            this.columnData[i].clearData();
            this.columnData[i] = null;
        }
    }
}

