/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.model;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.components.treetable.model.ISortTableComparator;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.model.deviceinfo.VisualData;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import java.text.Collator;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreeTableComparator
implements ISortTableComparator {
    protected int m_iColumnIndex;
    protected int m_iDirection = 0;
    protected boolean m_bCompareNumAndString = false;
    protected int m_iColumnDataType;

    public TreeTableComparator() {
        this.m_iColumnIndex = 0;
    }

    public TreeTableComparator(boolean bIsAscending, int iColumn) {
        this.m_iColumnIndex = iColumn;
    }

    public TreeTableComparator(boolean bIsAscending, int iColumn, boolean bCompareNumAndString) {
        this.m_iColumnIndex = iColumn;
        this.m_bCompareNumAndString = bCompareNumAndString;
    }

    @Override
    public int compare(TreeTableNode oFirstObject, TreeTableNode oSecondObject) {
        if (null == oFirstObject || null == oSecondObject) {
            return 0;
        }
        TreeTableNode oFirstNode = oFirstObject;
        TreeTableNode oSecondNode = oSecondObject;
        Object oFirstUserObject = oFirstNode.getUserObject();
        Object oSecondUserObject = oSecondNode.getUserObject();
        if (oFirstUserObject instanceof TreeTableRowData && oSecondUserObject instanceof TreeTableRowData) {
            TreeTableRowData oFirstRow = (TreeTableRowData)oFirstUserObject;
            TreeTableRowData oSecondRow = (TreeTableRowData)oSecondUserObject;
            if (null != oFirstRow.getColumnData(this.m_iColumnIndex) && null != oSecondRow.getColumnData(this.m_iColumnIndex)) {
                Object oFirstValue = oFirstRow.getColumnData(this.m_iColumnIndex).getCellDataValue();
                Object oSecondValue = oSecondRow.getColumnData(this.m_iColumnIndex).getCellDataValue();
                if (oFirstValue instanceof VisualData && oSecondValue instanceof VisualData) {
                    int iResult = ((VisualData)oFirstValue).compareTo((VisualData)oSecondValue);
                    return this.m_iDirection * iResult;
                }
                if (oFirstValue instanceof TaskProgressInfo && oSecondValue instanceof TaskProgressInfo) {
                    int iReturnValue = 0;
                    iReturnValue = oFirstValue.toString().compareTo(oSecondValue.toString());
                    return this.m_iDirection * iReturnValue;
                }
                if (1 != this.getColumnDataType()) {
                    if (oFirstValue instanceof String && oSecondValue instanceof String) {
                        int iReturnValue = 0;
                        iReturnValue = this.m_bCompareNumAndString ? this.compareByNumberAndString(oFirstValue.toString(), oSecondValue.toString()) : this.compareString(oFirstValue, oSecondValue);
                        return this.m_iDirection * iReturnValue;
                    }
                } else {
                    Integer s1 = Integer.valueOf(oFirstValue.toString());
                    Integer s2 = Integer.valueOf(oSecondValue.toString());
                    int result = 0;
                    result = s1.compareTo(s2);
                    return this.m_iDirection * result;
                }
            }
        }
        return this.m_iDirection * Collator.getInstance().compare(oFirstObject.toString(), oSecondObject.toString());
    }

    protected int compareString(Object oFirstValue, Object oSecondValue) {
        int iReturnValue = Collator.getInstance().compare(((String)oFirstValue).toLowerCase(DCResourceMng.getInstance().getLocale()), oSecondValue.toString().toLowerCase(DCResourceMng.getInstance().getLocale()));
        return iReturnValue;
    }

    protected int compareDate(Date oFirstValue, Date oSecondValue) {
        int iReturnValue = 0;
        try {
            iReturnValue = oFirstValue.compareTo(oSecondValue);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        return iReturnValue;
    }

    protected int compareByNumberAndString(String oFirstValue, String oSecondValue) {
        String firstValue = this.updateNumberString(oFirstValue);
        String secondValue = this.updateNumberString(oSecondValue);
        int iReturnValue = Collator.getInstance().compare(firstValue.toLowerCase(DCResourceMng.getInstance().getLocale()), secondValue.toLowerCase(DCResourceMng.getInstance().getLocale()));
        return iReturnValue;
    }

    protected String updateNumberString(String str) {
        String digistPattern = "([0-9]+)";
        String space = " ";
        int digistWidth = 20;
        Pattern pattern = Pattern.compile(digistPattern);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replaceStr = this.setStringToFitWidth(matcher.group(1), space, digistWidth);
            matcher.appendReplacement(sb, replaceStr);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String setStringToFitWidth(String str, String tag, int length) {
        if (str.length() < length) {
            int len = length - str.length();
            StringBuffer space = new StringBuffer("");
            for (int i = 0; i < len; ++i) {
                space.append(tag);
            }
            space.append(str);
            str = space.toString();
        }
        return str;
    }

    public void setColumnDataType(int iColumnDataType) {
        this.m_iColumnDataType = iColumnDataType;
    }

    public int getColumnDataType() {
        return this.m_iColumnDataType;
    }

    @Override
    public void setDirection(int direction) {
        this.m_iDirection = direction;
    }

    @Override
    public void setSortColumn(int column) {
        this.m_iColumnIndex = column;
    }
}

