/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.model;

import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceIDDataObject;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public class DeviceTreeTableModel
extends DCTreeTableModel {
    public static final int DEVICE_ICON_COL = 0;
    public static final int DEVICE_NAME_COL = 1;
    public static final int DEVICE_IP_COL = 2;
    public static final int DEVICE_TYPE_COL = 3;
    public static final int DEVICE_VERSION_COL = 4;
    public static final int DEVICE_PATCH_VERSION_COL = 5;
    public static final int DEVICE_PROGRESS_COL = 6;
    public int m_iColumnCount;
    private boolean[] m_arrSortableColumns;
    private boolean[] m_arrEditableColumns;

    public DeviceTreeTableModel(String[] arrTableHeader, Class[] arrColumnTypes, boolean[] arrSortableColumns, boolean[] arrEditableColumns) {
        super(arrTableHeader, arrColumnTypes, arrSortableColumns, arrEditableColumns);
        this.m_arrSortableColumns = arrSortableColumns;
        this.m_arrEditableColumns = arrEditableColumns;
        this.m_iColumnCount = arrTableHeader.length;
    }

    @Override
    public Object getValueAt(Object oTreeNode, int iColumn) {
        TreeTableNode oTreeTableNode;
        Object oUserData;
        if (oTreeNode instanceof TreeTableNode && (oUserData = (oTreeTableNode = (TreeTableNode)oTreeNode).getUserObject()) instanceof DeviceInfo) {
            DeviceInfo oDevInfo = (DeviceInfo)oUserData;
            switch (DeviceTableUtil.convertColumnIndexToModel(iColumn)) {
                case 0: {
                    return oDevInfo;
                }
                case 1: {
                    return oDevInfo.getDevName();
                }
                case 2: {
                    return StringUtils.getShowIP(oDevInfo.getDevIPAddress());
                }
                case 3: {
                    DeviceTypeInfo oTypeInfo = oDevInfo.getDeviceTypeInfo();
                    String sDevType = "";
                    if (null != oTypeInfo) {
                        sDevType = oTypeInfo.toString();
                    }
                    if (null != oTypeInfo && oTypeInfo.getDevDomain() == 4) {
                        sDevType = oTypeInfo.getDevTypeVersionName();
                    }
                    if (!StringUtils.isNullOrEmptyStr(oDevInfo.getDevBoardType())) {
                        sDevType = sDevType + "-";
                        sDevType = sDevType + oDevInfo.getDevBoardType();
                    }
                    return sDevType;
                }
                case 4: {
                    return oDevInfo.getDevVersion().getDevVersion();
                }
                case 5: {
                    return oDevInfo.getDevVersion().getPatchVersion();
                }
                case 6: {
                    OperationStatus oStatus = BusyDeviceObjectStore.getInstance().getDeviceProgress(oDevInfo.getDevId());
                    if (null == oStatus) {
                        oStatus = oDevInfo.getDeviceOperationStatus();
                    }
                    return oStatus;
                }
            }
        }
        return super.getValueAt(oTreeNode, iColumn);
    }

    @Override
    public boolean isCellEditable(Object oNode, int iColumn) {
        if (this.m_arrEditableColumns == null || iColumn >= this.m_arrEditableColumns.length) {
            return false;
        }
        return this.m_arrEditableColumns[iColumn];
    }

    @Override
    public boolean isColumnSortable(int iColumn) {
        if (this.m_arrSortableColumns == null || iColumn >= this.m_arrSortableColumns.length || iColumn < 0) {
            return false;
        }
        return this.m_arrSortableColumns[iColumn];
    }

    @Override
    public TreeTableNode getNodeForCellInColumn(Object oDeviceId, int iColumn) {
        if (null == oDeviceId || -1 == iColumn || this.m_iColumnCount <= iColumn) {
            return null;
        }
        Enumeration<TreeNode> oNodesEnum = this.m_oRoot.breadthFirstEnumeration();
        TreeNode oNextElement = null;
        while (oNodesEnum.hasMoreElements()) {
            DeviceIDDataObject oDevId;
            DeviceInfo oDeviceInfo;
            TreeTableNode oNode;
            oNextElement = oNodesEnum.nextElement();
            if (!(oNextElement instanceof TreeTableNode) || !((oNode = (TreeTableNode)oNextElement).getUserObject() instanceof DeviceInfo) || null == (oDeviceInfo = (DeviceInfo)oNode.getUserObject()) || !(oDevId = new DeviceIDDataObject(oDeviceInfo.getDevId())).equals(oDeviceId)) continue;
            return oNode;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (null != this.m_oRoot) {
            return this.m_oRoot.getChildCount();
        }
        return 0;
    }
}

