/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.model;

import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.components.treetable.model.ISortTableComparator;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.util.DCDebugTracer;

public class DefaultTreeTableComparator
implements ISortTableComparator {
    private int m_iSortColumn;
    private int m_iDirection = 0;
    private AbstractSortTreeTableModel m_oTreeTableModel;

    public DefaultTreeTableComparator(AbstractSortTreeTableModel oTreeTableModel) {
        this.m_oTreeTableModel = oTreeTableModel;
    }

    @Override
    public void setSortColumn(int iColumn) {
        this.m_iSortColumn = iColumn;
    }

    @Override
    public int compare(TreeTableNode oLeftNode, TreeTableNode oRightNode) {
        if (null == oLeftNode || null == oRightNode) {
            return 0;
        }
        try {
            Comparable oLeftValue = (Comparable)this.m_oTreeTableModel.getValueAt(oLeftNode, this.m_iSortColumn);
            Comparable oRightValue = (Comparable)this.m_oTreeTableModel.getValueAt(oRightNode, this.m_iSortColumn);
            return this.m_iDirection * oLeftValue.compareTo(oRightValue);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return 0;
        }
    }

    @Override
    public void setDirection(int iDirection) {
        this.m_iDirection = iDirection;
    }

    public void clearUp() {
        this.m_oTreeTableModel = null;
    }
}

