/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.model;

import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class DCTreeTableModel
extends AbstractSortTreeTableModel {
    private static final long serialVersionUID = 5162150076155628439L;
    private int m_iColumnCount;
    private boolean[] m_arrSortableColumns;
    private boolean[] m_arrEditableColumns;
    private String flag = "";

    public DCTreeTableModel(String[] arrTableHeader, Class[] arrColumnTypes, boolean[] arrSortableColumns, boolean[] arrEditableColumns) {
        super(arrTableHeader, null, null, arrColumnTypes);
        this.m_arrSortableColumns = arrSortableColumns;
        this.m_arrEditableColumns = arrEditableColumns;
        this.m_iColumnCount = arrTableHeader.length;
    }

    public DCTreeTableModel(String[] arrTableHeader, Class[] arrColumnTypes, boolean[] arrSortableColumns, boolean[] arrEditableColumns, String[] strGetMethodNames) {
        super(arrTableHeader, strGetMethodNames, null, arrColumnTypes);
        this.m_arrSortableColumns = arrSortableColumns;
        this.m_arrEditableColumns = arrEditableColumns;
        this.m_iColumnCount = arrTableHeader.length;
    }

    @Override
    public Object getValueAt(Object oTreeNode, int iColumn) {
        if (oTreeNode instanceof TreeTableNode) {
            Vector oVector;
            int iColumnCount;
            TreeTableNode oTreeTableNode = (TreeTableNode)oTreeNode;
            Object oUserData = oTreeTableNode.getUserObject();
            if (TaskTableUtil.getbInTaskSubTablePanel()) {
                iColumn = TaskTableUtil.convertColumnIndexToModel(iColumn, this.flag);
            }
            TaskTableUtil.setbInTaskSubTablePanel(false);
            if (oUserData instanceof TreeTableRowData) {
                TreeTableRowData oRowData = (TreeTableRowData)oUserData;
                TreeTableCellData oCellDate = oRowData.getColumnData(iColumn);
                if (oCellDate instanceof TreeTableNodeCellData) {
                    return oCellDate;
                }
                if (null == oRowData.getColumnData(iColumn)) {
                    return "";
                }
                return oRowData.getColumnData(iColumn);
            }
            if (oUserData instanceof Vector && 0 < (iColumnCount = (oVector = (Vector)oUserData).size()) && iColumnCount <= this.m_iColumnCount && iColumn < this.m_iColumnCount) {
                return oVector.get(iColumn);
            }
        }
        return super.getValueAt(oTreeNode, iColumn);
    }

    @Override
    public boolean isCellEditable(Object oNode, int iColumn) {
        if (this.m_arrEditableColumns == null || iColumn >= this.m_arrEditableColumns.length) {
            return false;
        }
        return this.m_arrEditableColumns[iColumn];
    }

    @Override
    public boolean isColumnSortable(int iColumn) {
        if (this.m_arrSortableColumns == null || iColumn >= this.m_arrSortableColumns.length || iColumn < 0) {
            return false;
        }
        return this.m_arrSortableColumns[iColumn];
    }

    public TreeTableNode getNodeForCellInColumn(Object oCellDataKey, int iColumn) {
        if (null == oCellDataKey || -1 == iColumn || this.m_iColumnCount <= iColumn) {
            return null;
        }
        Enumeration<TreeNode> oNodesEnum = this.m_oRoot.breadthFirstEnumeration();
        TreeNode oNextElement = null;
        while (oNodesEnum.hasMoreElements()) {
            TreeTableCellData oCell;
            TreeTableNode oNode;
            oNextElement = oNodesEnum.nextElement();
            if (!(oNextElement instanceof TreeTableNode) || !((oNode = (TreeTableNode)oNextElement).getUserObject() instanceof TreeTableRowData) || null == (oCell = ((TreeTableRowData)oNode.getUserObject()).getColumnData(iColumn)) || !oCell.getCellDataValue().equals(oCellDataKey)) continue;
            return oNode;
        }
        return null;
    }

    public int getRowCount() {
        if (null != this.m_oRoot) {
            return this.m_oRoot.getChildCount();
        }
        return 0;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public String getFlag() {
        return this.flag;
    }

    public void moveRow(int start, int end, int to) {
        int last;
        int first;
        int shift = to - start;
        if (shift < 0) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        DCTreeTableModel.rotate(this.m_oRoot, first, last + 1, shift);
    }

    public void moveRow(TreeTableNode oNode, int start, int end, int to) {
        int last;
        int first;
        int shift = to - start;
        if (shift < 0) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        DCTreeTableModel.rotate(oNode, first, last + 1, shift);
    }

    private static int gcd(int i, int j) {
        return j == 0 ? i : DCTreeTableModel.gcd(j, i % j);
    }

    private static void rotate(TreeTableNode oNode, int a, int b, int shift) {
        int size = b - a;
        int r = size - shift;
        int g = DCTreeTableModel.gcd(size, r);
        for (int i = 0; i < g; ++i) {
            int to = i;
            if (a + to < 0 || a + to >= oNode.getChildCount()) continue;
            TreeTableNode oFirstNode = (TreeTableNode)oNode.getChildAt(a + to);
            int from = (to + r) % size;
            while (from != i) {
                TreeTableNode oTempNode = (TreeTableNode)oNode.getChildAt(a + from);
                oNode.insert(oTempNode, a + to);
                to = from;
                from = (to + r) % size;
            }
            oNode.insert(oFirstNode, a + to);
        }
    }
}

