/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.model;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class CustomTableColumnModel
extends DefaultTableColumnModel {
    private static final long serialVersionUID = 8683055960661942686L;
    protected Vector<TableColumn> m_oAllTableColumns = new Vector();

    public void setColumnVisible(TableColumn oColumn, boolean bVisible) {
        if (bVisible) {
            int inVisibleColumnSize = this.tableColumns.size();
            int iNoInvisibleColumns = this.m_oAllTableColumns.size();
            int visibleIndex = 0;
            TableColumn oVisibleColumn = null;
            TableColumn oBaseColumn = null;
            for (int index = 0; index < iNoInvisibleColumns; ++index) {
                oVisibleColumn = visibleIndex < inVisibleColumnSize ? (TableColumn)this.tableColumns.get(visibleIndex) : null;
                oBaseColumn = this.m_oAllTableColumns.get(index);
                if (oBaseColumn == oColumn) {
                    if (oVisibleColumn != oColumn) {
                        super.addColumn(oColumn);
                        super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                    }
                    oColumn.setMinWidth(100);
                    oColumn.setMaxWidth(300);
                    oBaseColumn.setMinWidth(100);
                    oBaseColumn.setMaxWidth(300);
                    if (null != oVisibleColumn) {
                        oVisibleColumn.setMinWidth(100);
                        oVisibleColumn.setMaxWidth(300);
                    }
                    return;
                }
                if (oBaseColumn != oVisibleColumn) continue;
                ++visibleIndex;
            }
        } else {
            oColumn.setMinWidth(0);
            oColumn.setPreferredWidth(0);
            oColumn.setMaxWidth(0);
        }
    }

    public void setAllColumnsVisible() {
        int noColumns = this.m_oAllTableColumns.size();
        TableColumn iVisibleColumn = null;
        TableColumn oInvisibleColumn = null;
        for (int iColumnIndex = 0; iColumnIndex < noColumns; ++iColumnIndex) {
            iVisibleColumn = iColumnIndex < this.tableColumns.size() ? (TableColumn)this.tableColumns.get(iColumnIndex) : null;
            if (iVisibleColumn == (oInvisibleColumn = this.m_oAllTableColumns.get(iColumnIndex))) continue;
            super.addColumn(oInvisibleColumn);
            super.moveColumn(this.tableColumns.size() - 1, iColumnIndex);
        }
    }

    public TableColumn getColumnByModelIndex(int modelColumnIndex) {
        TableColumn oColumn = null;
        int iSize = this.m_oAllTableColumns.size();
        for (int iColumnIndex = 0; iColumnIndex < iSize; ++iColumnIndex) {
            oColumn = this.m_oAllTableColumns.elementAt(iColumnIndex);
            if (oColumn.getModelIndex() != modelColumnIndex) continue;
            return oColumn;
        }
        return null;
    }

    public boolean isColumnVisible(TableColumn oColumn) {
        return this.tableColumns.indexOf(oColumn) >= 0;
    }

    @Override
    public void addColumn(TableColumn oColumn) {
        this.m_oAllTableColumns.addElement(oColumn);
        super.addColumn(oColumn);
    }

    @Override
    public void removeColumn(TableColumn oColumn) {
        int allColumnsIndex = this.m_oAllTableColumns.indexOf(oColumn);
        if (allColumnsIndex != -1) {
            this.m_oAllTableColumns.removeElementAt(allColumnsIndex);
        }
        super.removeColumn(oColumn);
    }

    @Override
    public void moveColumn(int from, int to) {
        if (from < 0 || from >= this.getColumnCount()) {
            throw new IllegalArgumentException("Source Index out of range");
        }
        TableColumn mFrom = (TableColumn)this.tableColumns.get(from);
        if (to < 0 || to >= this.getColumnCount()) {
            throw new IllegalArgumentException("Destination Index out of range");
        }
        TableColumn mTo = (TableColumn)this.tableColumns.get(to);
        int fromIndex = this.m_oAllTableColumns.indexOf(mFrom);
        int toIndex = this.m_oAllTableColumns.indexOf(mTo);
        if (from != to) {
            this.m_oAllTableColumns.removeElementAt(fromIndex);
            this.m_oAllTableColumns.insertElementAt(mFrom, toIndex);
        }
        super.moveColumn(from, to);
    }

    public int getColumnCount(boolean visible) {
        if (visible) {
            return this.tableColumns.size();
        }
        return this.m_oAllTableColumns.size();
    }

    public Enumeration<TableColumn> getColumns(boolean visible) {
        if (visible) {
            return this.tableColumns.elements();
        }
        return this.m_oAllTableColumns.elements();
    }

    public int getColumnIndex(Object identifier, boolean visible) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Vector<TableColumn> mColumns = null;
        TableColumn mColumn = null;
        int size = 0;
        if (visible) {
            mColumns = this.tableColumns;
            size = this.tableColumns.size();
        } else {
            mColumns = this.m_oAllTableColumns;
            size = this.m_oAllTableColumns.size();
        }
        for (int index = 0; index < size; ++index) {
            mColumn = mColumns.get(index);
            if (!identifier.equals(mColumn.getIdentifier())) continue;
            return index;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public TableColumn getColumn(int index, boolean visible) {
        if (visible) {
            return (TableColumn)this.tableColumns.elementAt(index);
        }
        return this.m_oAllTableColumns.elementAt(index);
    }

    public void setToNULL() {
        if (null != this.m_oAllTableColumns) {
            this.m_oAllTableColumns.removeAllElements();
            this.m_oAllTableColumns = null;
        }
        if (null != this.tableColumns) {
            this.tableColumns.removeAllElements();
            this.tableColumns = null;
        }
        if (null != this.listenerList) {
            this.listenerList = null;
        }
        if (null != this.changeEvent) {
            this.changeEvent = null;
        }
        if (null != this.selectionModel) {
            this.selectionModel = null;
        }
    }
}

