/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.treetable.model;

import com.huawei.dc.common.components.table.model.ITableInfo;
import com.huawei.dc.common.components.treetable.model.DefaultTreeTableComparator;
import com.huawei.dc.common.components.treetable.model.ISortTableComparator;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.swimap.iview.templates.filtertreetable.AbstractTreeTableModel;
import java.lang.reflect.Method;
import javax.swing.tree.TreeNode;

public abstract class AbstractSortTreeTableModel
extends AbstractTreeTableModel {
    private String[] m_columnNames;
    private String[] m_getterMethodNames;
    private String[] m_setterMethodNames;
    private Class[] m_columnTypes;
    protected TreeTableNode m_oRoot;
    private ISortTableComparator m_oComparator;

    public AbstractSortTreeTableModel(String[] columnNames) {
        this(columnNames, null, null, null);
    }

    public AbstractSortTreeTableModel(String[] columnNames, String[] getterMethodNames, String[] setterMethodNames, Class[] cTypes) {
        this(new TreeTableNode(), columnNames, getterMethodNames, setterMethodNames, cTypes);
    }

    public AbstractSortTreeTableModel(ITableInfo oTableInfo) {
        this(oTableInfo.getHeader(), oTableInfo.getGetterMethods(), oTableInfo.getSetterMethods(), oTableInfo.getColumnTypes());
    }

    public AbstractSortTreeTableModel(TreeTableNode oRootNode, String[] columnNames, String[] getterMethodNames, String[] setterMethodNames, Class[] cTypes) {
        super((Object)oRootNode);
        this.m_columnNames = columnNames;
        this.m_getterMethodNames = getterMethodNames;
        this.m_setterMethodNames = setterMethodNames;
        this.m_columnTypes = cTypes;
        this.m_oRoot = (TreeTableNode)this.root;
        this.m_oComparator = new DefaultTreeTableComparator(this);
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getColumnName(int iColumn) {
        if (iColumn < this.m_columnNames.length) {
            return this.m_columnNames[iColumn];
        }
        return "";
    }

    public Object getValueAt(Object oNode, int iColumn) {
        Object oUserObj;
        if (oNode instanceof TreeTableNode && null != (oUserObj = ((TreeTableNode)oNode).getUserObject())) {
            try {
                Method oMethod = oUserObj.getClass().getMethod(this.m_getterMethodNames[iColumn], new Class[0]);
                if (null != oMethod) {
                    return oMethod.invoke(oUserObj, new Object[0]);
                }
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }
        return null;
    }

    public void setValueAt(Object oValue, Object oNode, int iColumn) {
        boolean isFound = false;
        try {
            Object oUserObj = ((TreeTableNode)oNode).getUserObject();
            if (null != oUserObj) {
                Method[] oMethods = oUserObj.getClass().getMethods();
                for (int iMethodIndex = oMethods.length - 1; iMethodIndex >= 0; --iMethodIndex) {
                    Method oMethod = oMethods[iMethodIndex];
                    if (!oMethod.getName().equals(this.m_setterMethodNames[iColumn]) || null == oMethod.getParameterTypes() || 1 != oMethod.getParameterTypes().length) continue;
                    Class<?> oPara = oMethod.getParameterTypes()[0];
                    if (!oPara.isInstance(oValue)) {
                        oValue = null;
                    }
                    oMethod.invoke(oUserObj, oValue);
                    isFound = true;
                    break;
                }
            }
            if (isFound) {
                TreeTableNode oParent = (TreeTableNode)((TreeTableNode)oNode).getParent();
                if (null == oParent) {
                    DCDebugTracer.trace("AbstractSortTreeTableModel#setValueAt,oParent is null:" + oNode.toString());
                }
                this.fireTreeNodesChanged((Object)this, this.getPathToRoot(oParent, 0), new int[]{this.getIndexOfChild(oParent, oNode)}, new Object[]{oNode});
            }
        }
        catch (Exception th) {
            DCDebugTracer.trace(th);
        }
    }

    private TreeTableNode[] getPathToRoot(TreeTableNode oNode, int iDepth) {
        TreeTableNode[] oNodesInPath = new TreeTableNode[]{};
        if (null == oNode) {
            if (0 == iDepth) {
                return oNodesInPath;
            }
            oNodesInPath = new TreeTableNode[iDepth];
        } else {
            oNodesInPath = oNode == this.m_oRoot ? new TreeTableNode[iDepth] : this.getPathToRoot((TreeTableNode)oNode.getParent(), ++iDepth);
            oNodesInPath[oNodesInPath.length - iDepth] = oNode;
        }
        return oNodesInPath;
    }

    public boolean isCellEditable(Object node, int iColumn) {
        return null != this.m_setterMethodNames && iColumn < this.m_setterMethodNames.length && null != this.m_setterMethodNames[iColumn];
    }

    public Object getChild(Object oNode, int index) {
        int iChildCount;
        if (oNode instanceof TreeTableNode && index < (iChildCount = ((TreeTableNode)oNode).getChildCount())) {
            TreeNode obj = ((TreeTableNode)oNode).getChildAt(index);
            return obj;
        }
        return null;
    }

    public int getChildCount(Object oNode) {
        if (oNode instanceof TreeTableNode) {
            return ((TreeTableNode)oNode).getChildCount();
        }
        return 0;
    }

    public Class getColumnClass(int iColumn) {
        if (null != this.m_columnTypes && iColumn < this.m_columnTypes.length) {
            return this.m_columnTypes[iColumn];
        }
        return Object.class;
    }

    public TreeTableNode getRoot() {
        return this.m_oRoot;
    }

    public boolean isColumnSortable(int iColumn) {
        return true;
    }

    public void setColumnSorted(int iColumn, boolean isAscending) {
        int iDirection = isAscending ? 1 : -1;
        iColumn = DeviceTableUtil.convertModelColumnIndexToCurIndex(this.m_columnNames, iColumn);
        this.m_oComparator.setDirection(iDirection);
        this.m_oComparator.setSortColumn(iColumn);
        this.m_oRoot.sortNode(this.m_oComparator);
        this.fireTreeStructureChanged((Object)this, new Object[]{this.getRoot()}, null, null);
    }

    public void setComparator(ISortTableComparator oComparator) {
        this.m_oComparator = oComparator;
    }

    public void clearUp() {
        DCDebugTracer.trace("AbstractSortTreeTableModel clearUp begin");
        if (null != this.m_oRoot) {
            this.m_oRoot.removeAllChildren();
            this.m_oRoot = null;
        }
        if (null != this.m_oComparator) {
            ((DefaultTreeTableComparator)this.m_oComparator).clearUp();
            this.m_oComparator = null;
        }
        this.listenerList = null;
        this.m_columnNames = null;
        this.m_getterMethodNames = null;
        this.m_setterMethodNames = null;
        this.m_columnTypes = null;
        DCDebugTracer.trace("AbstractSortTreeTableModel clearUp end ...");
    }
}

