/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.renderer;

import com.huawei.dc.common.components.tree.renderer.DCDefaultTreeCellRenderer;
import com.huawei.dc.common.components.treetable.model.ISelectableNodeInfo;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class DCSelectableTreeRenderer
extends DCDefaultTreeCellRenderer {
    private JTree m_oTree;

    public DCSelectableTreeRenderer(JTree oTree) {
        this.m_oTree = oTree;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree oTree, Object oValue, boolean anIsSelected, boolean anIsExpanded, boolean leaf, int row, boolean hasFocus) {
        if (null == oValue || !(oValue instanceof DefaultMutableTreeNode)) {
            return new JPanel();
        }
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oValue;
        if (oNode.getUserObject() instanceof ISelectableNodeInfo) {
            return this.getRendererComponentForSelectableNode(oNode);
        }
        return super.getTreeCellRendererComponent(oTree, oValue, anIsSelected, anIsExpanded, leaf, row, hasFocus);
    }

    private Component getRendererComponentForSelectableNode(DefaultMutableTreeNode oNode) {
        ISelectableNodeInfo oNodeInfo = (ISelectableNodeInfo)oNode.getUserObject();
        JCheckBox oChkBox = new JCheckBox();
        oChkBox.setSelected(oNodeInfo.isSelected());
        oChkBox.setBackground(this.m_oTree.getBackground());
        oChkBox.setHorizontalAlignment(2);
        oChkBox.setText(oNodeInfo.toString());
        JPanel oPanel = new JPanel(new GridLayout());
        oPanel.add(oChkBox);
        return oPanel;
    }
}

