/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.renderer;

import com.huawei.dc.common.framework.utility.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DCDefaultTreeCellRenderer
implements TreeCellRenderer {
    private String m_strNodeClosedIcon;
    private String m_strNodeOpenedIcon;
    private String m_strLeafNodeIcon;

    public DCDefaultTreeCellRenderer(String strNodeClosedIcon, String strNodeOpenedIcon, String strLeafNodeIcon) {
        this.m_strNodeClosedIcon = strNodeClosedIcon;
        this.m_strNodeOpenedIcon = strNodeOpenedIcon;
        this.m_strLeafNodeIcon = strLeafNodeIcon;
    }

    public DCDefaultTreeCellRenderer() {
        this("folderclosed.gif", "folderopen.gif", "folderopen.gif");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object aValue, boolean anIsSelected, boolean anIsExpanded, boolean leaf, int row, boolean hasFocus) {
        if (!(aValue instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)aValue;
        Object oNodeUserObject = oNode.getUserObject();
        if (null == oNodeUserObject) {
            oNodeUserObject = "";
        }
        JPanel oPanel = new JPanel();
        oPanel.setBackground(tree.getBackground());
        JLabel oLabel = this.initializeLabelForNode(oNodeUserObject, anIsSelected, leaf, anIsExpanded);
        oLabel.setText(oNodeUserObject.toString());
        oPanel.setLayout(new BorderLayout());
        oPanel.add((Component)oLabel, "Center");
        return oPanel;
    }

    protected JLabel initializeLabelForNode(Object oUserObject, boolean anIsSelected, boolean bIsLeaf, boolean anIsExpanded) {
        JLabel oLabel = this.createLabelWithIcon(oUserObject, bIsLeaf, anIsExpanded);
        if (anIsSelected) {
            oLabel.setForeground(Color.BLUE);
        } else {
            oLabel.setForeground(Color.BLACK);
        }
        return oLabel;
    }

    protected JLabel createLabelWithIcon(Object oUserObject, boolean bIsLeaf, boolean anIsExpanded) {
        JLabel oLabel = new JLabel();
        if (bIsLeaf) {
            ImageIcon oLeafNodeImageIcon = ResourceManager.getInstance().getImage(this.m_strLeafNodeIcon);
            oLabel.setIcon(oLeafNodeImageIcon);
        } else if (anIsExpanded) {
            ImageIcon oExpendedImageIcon = ResourceManager.getInstance().getImage(this.m_strNodeOpenedIcon);
            oLabel.setIcon(oExpendedImageIcon);
        } else {
            ImageIcon oCollapsedImageIcon = ResourceManager.getInstance().getImage(this.m_strNodeClosedIcon);
            oLabel.setIcon(oCollapsedImageIcon);
        }
        return oLabel;
    }
}

