/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.editor;

import com.huawei.dc.common.components.treetable.model.ISelectableNodeInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.MatteBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DCSelectableTreeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static final long serialVersionUID = 1L;
    private JTree m_oTree;
    private JCheckBox m_oNodeCheckBox = new JCheckBox();

    public DCSelectableTreeEditor(JTree oTree) {
        this.m_oTree = oTree;
        this.m_oNodeCheckBox.addMouseListener(this.generateMouseAdapter());
    }

    private MouseAdapter generateMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent oMouseEvent) {
                DCSelectableTreeEditor.this.updateNodeSelection(oMouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent oMouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent oMouseEvent) {
            }
        };
    }

    @Override
    public Component getTreeCellEditorComponent(JTree oTree, Object oVal, boolean bIsSelected, boolean bIsExpanded, boolean bIsLeaf, int iRow) {
        TreePath oTreePath = this.m_oTree.getPathForRow(iRow);
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oTreePath.getLastPathComponent();
        if (null == oNode || !(oNode.getUserObject() instanceof ISelectableNodeInfo)) {
            return new JLabel();
        }
        ISelectableNodeInfo oNodeInfo = (ISelectableNodeInfo)oNode.getUserObject();
        this.m_oNodeCheckBox.setSelected(oNodeInfo.isSelected());
        this.m_oNodeCheckBox.setBackground(this.m_oTree.getBackground());
        this.m_oNodeCheckBox.setHorizontalAlignment(2);
        this.m_oNodeCheckBox.setText(oNodeInfo.toString());
        JPanel oPanel = new JPanel(new GridLayout());
        oPanel.add(this.m_oNodeCheckBox);
        MatteBorder oBorder = BorderFactory.createMatteBorder(0, 0, 0, 0, Color.gray);
        oPanel.setBorder(oBorder);
        if (bIsSelected) {
            oPanel.setForeground(oTree.getBackground());
            oPanel.setForeground(Color.blue);
        } else {
            oPanel.setBackground(oTree.getBackground());
            oPanel.setForeground(oTree.getForeground());
        }
        return oPanel;
    }

    @Override
    public Object getCellEditorValue() {
        TreePath oTreePath = this.m_oTree.getSelectionPath();
        if (null == oTreePath) {
            return "";
        }
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oTreePath.getLastPathComponent();
        if (null == oNode || !(oNode.getUserObject() instanceof ISelectableNodeInfo)) {
            return "";
        }
        return oNode.getUserObject();
    }

    private void propogateSelectionToParentNode(DefaultMutableTreeNode oNode, boolean bFlag) {
        if (null == oNode || !(oNode.getUserObject() instanceof ISelectableNodeInfo)) {
            return;
        }
        if (bFlag || !this.isAnyChildSelectedForNode(oNode)) {
            ((ISelectableNodeInfo)oNode.getUserObject()).setSelected(bFlag);
        }
        this.propogateSelectionToParentNode((DefaultMutableTreeNode)oNode.getParent(), bFlag);
    }

    private boolean isAnyChildSelectedForNode(DefaultMutableTreeNode oNode) {
        int iChildCount = oNode.getChildCount();
        DefaultMutableTreeNode oChildNode = null;
        for (int i = 0; i < iChildCount; ++i) {
            oChildNode = (DefaultMutableTreeNode)oNode.getChildAt(i);
            ISelectableNodeInfo oNodeInfo = (ISelectableNodeInfo)oChildNode.getUserObject();
            if (null == oNodeInfo || !oNodeInfo.isSelected()) continue;
            return true;
        }
        return false;
    }

    private void propogateSelectionToChildren(DefaultMutableTreeNode oNode, boolean bFlag) {
        Enumeration<TreeNode> oChildEnum = oNode.breadthFirstEnumeration();
        DefaultMutableTreeNode oChildNode = null;
        while (oChildEnum.hasMoreElements()) {
            oChildNode = (DefaultMutableTreeNode)oChildEnum.nextElement();
            if (!(oChildNode.getUserObject() instanceof ISelectableNodeInfo)) continue;
            ((ISelectableNodeInfo)oChildNode.getUserObject()).setSelected(bFlag);
        }
    }

    private void updateNodeSelection(MouseEvent oMouseEvent) {
        ISelectableNodeInfo oNodeInfo;
        int[] selRows = this.m_oTree.getSelectionRows();
        int iRow = selRows[0];
        TreePath oTreePath = this.m_oTree.getPathForRow(iRow);
        if (null == oTreePath) {
            return;
        }
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oTreePath.getLastPathComponent();
        if (null == oNode || !(oNode.getUserObject() instanceof ISelectableNodeInfo)) {
            return;
        }
        boolean bFlag = (oNodeInfo = (ISelectableNodeInfo)oNode.getUserObject()).isSelected();
        oNodeInfo.setSelected(!bFlag);
        this.propogateSelectionToChildren(oNode, !bFlag);
        this.propogateSelectionToParentNode(oNode, !bFlag);
        this.fireEditingStopped();
    }
}

