/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree.renderer;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DeviceTreeRenderer
implements TreeCellRenderer {
    private final ImageIcon m_oRootNodeImageIcon = ResourceManager.getInstance().getImage("rooticon.gif");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object aValue, boolean anIsSelected, boolean anIsExpanded, boolean leaf, int row, boolean hasFocus) {
        if (!(aValue instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)aValue;
        Object oNodeUserObject = oNode.getUserObject();
        if (!(oNodeUserObject instanceof TreeNodeInfo)) {
            return null;
        }
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)oNodeUserObject;
        JPanel oPanel = new JPanel();
        oPanel.setBackground(DCFrameWorkUtil.getBackgroundColor());
        JLabel oLabel = this.createLabelForNode(oTreeNodeInfo, anIsSelected, anIsExpanded);
        oLabel.setText(oNodeUserObject.toString());
        oPanel.setLayout(new BorderLayout());
        oPanel.add(oLabel);
        return oPanel;
    }

    protected JLabel createLabelForNode(TreeNodeInfo oTreeNodeInfo, boolean anIsSelected, boolean anIsExpanded) {
        JLabel oLabel = new JLabel();
        if (anIsSelected) {
            oLabel.setForeground(Color.BLUE);
        } else {
            oLabel.setForeground(Color.BLACK);
        }
        if (3 == oTreeNodeInfo.m_iNodeType) {
            oLabel.setIcon(this.m_oRootNodeImageIcon);
        }
        DeviceTypeInfo oDevTypeInfo = oTreeNodeInfo.getDeviceTypeInfo();
        ImageIcon oImage = ResourceManager.getInstance().getNeTypeImage(oDevTypeInfo);
        oLabel.setIcon(oImage);
        return oLabel;
    }
}

