/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree.renderer;

import com.huawei.dc.adapter.swimap.external.common.adapter.message.util.DCEmfColorFilter;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DeviceSelectionTreeRenderer
implements TreeCellRenderer {
    private static int SMALLICON_WIDTH = 12;
    private static int SMALLICON_HEIGHT = 12;
    private static int MAXICON_WIDTH = 20;
    private static int MAXICON_HEIGHT = 20;
    private static final int ICON_SPACE_WIDTH = 4;
    private static final int ICON_SPACE_HEIGHT = 0;
    private static int RECT_WIDTH = SMALLICON_WIDTH + MAXICON_WIDTH + 4;
    private static int RECT_HEIGHT = MAXICON_HEIGHT + 0;
    private DCEmfColorFilter m_oFilter = null;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object aValue, boolean anIsSelected, boolean anIsExpanded, boolean leaf, int row, boolean hasFocus) {
        if (null == aValue) {
            return new JPanel();
        }
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)aValue;
        Object oNodeUserObject = oNode.getUserObject();
        if (!(oNodeUserObject instanceof TreeNodeInfo)) {
            return null;
        }
        TreeNodeInfo deviceNodeInfo = (TreeNodeInfo)oNodeUserObject;
        JPanel oPanel = new JPanel();
        oPanel.setBackground(DCFrameWorkUtil.getBackgroundColor());
        int iNodeSelectedState = deviceNodeInfo.getSelectedState();
        JLabel oLabel = new JLabel();
        this.initializeLabelForNode(oLabel, anIsSelected, anIsExpanded, deviceNodeInfo, iNodeSelectedState, tree.getBackground(), oNode, oPanel);
        oPanel.setLayout(new BorderLayout());
        oPanel.add((Component)oLabel, "West");
        return oPanel;
    }

    private void initializeLabelForNode(JLabel oLabel, boolean bIsSelected, boolean bIsExpanded, TreeNodeInfo oDeviceNodeInfo, int iNodeSelectedState, Color oBGColor, DefaultMutableTreeNode oNode, JPanel oPanel) {
        if (bIsSelected) {
            oLabel.setForeground(Color.BLUE);
        } else {
            oLabel.setForeground(Color.BLACK);
        }
        ImageIcon oDeviceTypeImageIcon = null;
        ImageIcon oCheckBoxIcon = null;
        switch (iNodeSelectedState) {
            case 0: {
                oCheckBoxIcon = ResourceManager.getInstance().getImage("all.gif");
                break;
            }
            case 1: {
                oCheckBoxIcon = ResourceManager.getInstance().getImage("part.gif");
                break;
            }
            case 2: {
                oCheckBoxIcon = ResourceManager.getInstance().getImage("noneselect.gif");
                break;
            }
            default: {
                oCheckBoxIcon = ResourceManager.getInstance().getImage("noneselect.gif");
            }
        }
        DeviceInfo oDeviceInfo = new DeviceInfo();
        if (null == oDeviceNodeInfo) {
            return;
        }
        if (null != oDeviceNodeInfo.m_oDevType) {
            oDeviceTypeImageIcon = ResourceManager.getInstance().getNeTypeImage(oDeviceNodeInfo.getDeviceTypeInfo());
        } else if (oDeviceNodeInfo.m_oDevInfo != null) {
            oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(oDeviceNodeInfo.m_oDevInfo.m_iDeviceID);
            if (null == oDeviceInfo) {
                return;
            }
            oDeviceTypeImageIcon = ResourceManager.getInstance().getNeTypeImage(oDeviceInfo.getDeviceTypeInfo());
        } else if (oDeviceNodeInfo.m_oDeviceInfo != null) {
            oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(oDeviceNodeInfo.m_oDeviceInfo.getDeviceId());
            if (null == oDeviceInfo) {
                return;
            }
            oDeviceTypeImageIcon = ResourceManager.getInstance().getNeTypeImage(oDeviceInfo.getDeviceTypeInfo());
        }
        if (!oDeviceNodeInfo.isNodeSelectable()) {
            oPanel.setEnabled(false);
            oCheckBoxIcon = ResourceManager.getInstance().getImage("noneselect.gif");
        }
        if (4 == oDeviceNodeInfo.m_iNodeType && null != oDeviceNodeInfo.m_oDevInfo) {
            oDeviceTypeImageIcon = ResourceManager.getInstance().getNeTypeImage(oDeviceNodeInfo.m_oDevInfo.m_iDeviceID);
        }
        if (null == oDeviceTypeImageIcon) {
            oDeviceTypeImageIcon = ResourceManager.getInstance().getImage("folderopen.gif");
        }
        Image iNodeImage = this.getComposedImage(oCheckBoxIcon, oDeviceTypeImageIcon, oBGColor);
        oLabel.setIcon(new ImageIcon(iNodeImage));
        oLabel.setText(oDeviceNodeInfo.toString());
    }

    private Image getComposedImage(ImageIcon chooseImage, ImageIcon nodeImage, Color oBGColor) {
        int iChooseImageWidth = 0;
        int iChooseImageHeight = 0;
        int iNodeImageWidth = 0;
        int iNodeImageHeight = 0;
        Image oChooseImage = null;
        Image oNodeImage = null;
        if (null != chooseImage) {
            oChooseImage = chooseImage.getImage();
            iChooseImageWidth = oChooseImage.getWidth(null);
            iChooseImageHeight = oChooseImage.getHeight(null);
        }
        if (null != nodeImage) {
            oNodeImage = nodeImage.getImage();
            iNodeImageWidth = oNodeImage.getWidth(null);
            iNodeImageHeight = oNodeImage.getHeight(null);
        }
        if (iChooseImageWidth != -1 && iChooseImageHeight != -1) {
            SMALLICON_WIDTH = iChooseImageWidth;
            SMALLICON_HEIGHT = iChooseImageHeight;
        }
        if (iNodeImageWidth != -1 && iNodeImageHeight != -1) {
            MAXICON_WIDTH = iNodeImageWidth;
            MAXICON_HEIGHT = iNodeImageHeight;
        }
        BufferedImage oBufImage = new BufferedImage(RECT_WIDTH, RECT_HEIGHT, 1);
        Graphics2D oBufImageGraphic = (Graphics2D)oBufImage.getGraphics();
        oBufImageGraphic.setColor(oBGColor);
        oBufImageGraphic.fillRect(0, 0, RECT_WIDTH, RECT_HEIGHT);
        Color oColorTemp = oBufImageGraphic.getColor();
        oBufImageGraphic.setColor(oColorTemp);
        if (null != oChooseImage) {
            Image oFilterImage = this.getFilterImage(oChooseImage, oBGColor);
            oBufImageGraphic.drawImage(new ImageIcon(oFilterImage).getImage(), 4, (RECT_HEIGHT - SMALLICON_HEIGHT) / 2, SMALLICON_WIDTH, SMALLICON_HEIGHT, null, null);
        }
        if (null != oNodeImage) {
            oBufImageGraphic.drawImage(new ImageIcon(oNodeImage).getImage(), SMALLICON_WIDTH + 4, (RECT_HEIGHT - MAXICON_HEIGHT) / 2, MAXICON_WIDTH, MAXICON_HEIGHT, null, null);
        }
        oBufImage.flush();
        return oBufImage;
    }

    private Image getFilterImage(Image oImage, Color oColor) {
        if (null == oColor) {
            return oImage;
        }
        this.m_oFilter = new DCEmfColorFilter(true, 40, 20.0, oColor);
        Image oNodeDrawingImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(oImage.getSource(), (ImageFilter)this.m_oFilter));
        oImage.flush();
        oNodeDrawingImage.flush();
        return oNodeDrawingImage;
    }
}

