/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree.model;

import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTypeTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceVersionTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeNode;
import com.huawei.dc.common.components.tree.devicetree.model.IDeviceTreeModelManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.DeviceInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.FrameInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SlotInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubslotInformation;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class SubmapTreeModelManager
implements IDeviceTreeModelManager,
IDCObjectDeallocator {
    private static SubmapTreeModelManager c_oInstance;
    protected IDeviceInfoManager c_oDeviceInfoManager;
    protected ResourceManager c_oResourceManager;
    private boolean isOLTSubMap = false;

    private SubmapTreeModelManager(IDeviceInfoManager oDeviceInfoMgr) {
        this.c_oDeviceInfoManager = oDeviceInfoMgr;
        this.c_oResourceManager = ResourceManager.getInstance();
    }

    public static synchronized SubmapTreeModelManager getInstance(IDeviceInfoManager oDeviceInfoMgr) {
        if (null == c_oInstance) {
            c_oInstance = new SubmapTreeModelManager(oDeviceInfoMgr);
            DCObjectDestructor.getInstance().addObjectForDestructor(c_oInstance);
        }
        return c_oInstance;
    }

    @Override
    public void populateTreeModel(DefaultMutableTreeNode oTreeNode, DeviceTreeBaseDescriptor oDescriptor, String rootName) {
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        if (null == oTreeNode) {
            return;
        }
        this.isOLTSubMap = oDescriptor.getViewType() == 5;
        int iTreeType = oDescriptor.getTreeType();
        if (2 == iTreeType) {
            int iDeviceTypeID = ((DeviceTypeTreeDescriptor)oDescriptor).getDeviceTypeID();
            int iDeviceVersionID = ((DeviceTypeTreeDescriptor)oDescriptor).getDeviceVersionID();
            this.populateDeviceTypeTree(oTreeNode, iDeviceTypeID, iDeviceVersionID, ((DeviceTypeTreeDescriptor)oDescriptor).getDevBoardType());
        } else if (3 == iTreeType) {
            String strDeviceVersion = ((DeviceVersionTreeDescriptor)oDescriptor).getDeviceVersion();
            DeviceTypeInfo oDeviceTypeInfo = ((DeviceVersionTreeDescriptor)oDescriptor).getDeviceTypeInfo();
            if (oDeviceTypeInfo != null && oDeviceTypeInfo.getDevTypeID() == allDevTypeId && oDeviceTypeInfo.getDevTypeVersionId() == allDevTypeVersionId) {
                Vector devTypeList = this.c_oDeviceInfoManager.getDevTypeListByDiffusionTask();
                int devTypeCount = devTypeList.size();
                block0: for (int i = 0; i < devTypeCount; ++i) {
                    HashMap oVersionMap;
                    DeviceTypeInfo oDeviceType = (DeviceTypeInfo)devTypeList.get(i);
                    if (oDeviceType.getDevTypeID() == allDevTypeId && oDeviceType.getDevTypeVersionId() == allDevTypeVersionId || null == (oVersionMap = this.c_oDeviceInfoManager.getDeviceVersionMapByDeviceType(oDeviceType.getDevTypeID()))) continue;
                    Iterator oVersionIterator = oVersionMap.keySet().iterator();
                    String strVersion = null;
                    while (oVersionIterator.hasNext()) {
                        strVersion = (String)oVersionIterator.next();
                        if (!strDeviceVersion.equals(strVersion)) continue;
                        oDeviceTypeInfo = oDeviceType;
                        continue block0;
                    }
                }
            }
            this.populateDeviceVersionTree(oTreeNode, strDeviceVersion, oDeviceTypeInfo, ((DeviceVersionTreeDescriptor)oDescriptor).getDeviceBoardType());
        } else if (4 == iTreeType) {
            this.populateMXUTree(oTreeNode);
        } else {
            this.populateMainTree(oTreeNode);
        }
    }

    @Override
    public void populateTreeModelByFilter(DefaultMutableTreeNode oRoot, DeviceTreeBaseDescriptor oDescriptor, String rootName, DeviceInfo[] deviceInfoList) {
    }

    private void populateMainTree(DefaultMutableTreeNode oRoot) {
        TreeNodeInfo oRootNodeInfo = new TreeNodeInfo(this.c_oResourceManager.getResString("DEVICE_TREE_PAN_ROOT_NODE"), true);
        oRoot.setUserObject(oRootNodeInfo);
        SubMapInfo oRootSubmapInfo = null;
        try {
            oRootSubmapInfo = this.isOLTSubMap ? this.c_oDeviceInfoManager.getMxuSubMapInfo() : this.c_oDeviceInfoManager.getSubMapInfo();
            if (null == oRootSubmapInfo) {
                oRootNodeInfo.setNodeSelectable(false);
                return;
            }
            DefaultMutableTreeNode oSubmapNode = this.populateSubmapNode(oRootSubmapInfo, false);
            if (null != oSubmapNode) {
                oRoot.add(oSubmapNode);
            }
        }
        catch (RuntimeException e) {
            DCDebugTracer.trace(e);
            return;
        }
    }

    private void populateMXUTree(DefaultMutableTreeNode oRoot) {
        TreeNodeInfo oRootNodeInfo = new TreeNodeInfo(this.c_oResourceManager.getResString("DEVICE_TREE_PAN_ROOT_NODE"), true);
        oRoot.setUserObject(oRootNodeInfo);
        SubMapInfo oRootSubmapInfo = null;
        try {
            oRootSubmapInfo = this.c_oDeviceInfoManager.getMxuSubMapInfo();
            if (null == oRootSubmapInfo) {
                oRootNodeInfo.setNodeSelectable(true);
                return;
            }
            DefaultMutableTreeNode oSubmapNode = this.populateMXUSubmapNode(oRootSubmapInfo);
            if (null != oSubmapNode) {
                oRoot.add(oSubmapNode);
            }
        }
        catch (RuntimeException e) {
            DCDebugTracer.trace(e);
            return;
        }
    }

    public void populateDeviceTypeTree(DefaultMutableTreeNode oTreeNode, int deviceTypeID, int deviceVersionID, String boardType) {
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        DeviceTypeInfo deviceTypeInfo = null;
        if (deviceTypeID == -1 && deviceVersionID == -1) {
            Vector devTypeList = this.c_oDeviceInfoManager.getDevTypeListByDiffusionTask();
            int devTypeCount = devTypeList.size();
            for (int i = 0; i < devTypeCount; ++i) {
                DeviceTypeInfo oDeviceType = (DeviceTypeInfo)devTypeList.get(i);
                if (oDeviceType.getDevTypeID() != -1 || oDeviceType.getDevTypeVersionId() != -1) continue;
                deviceTypeInfo = oDeviceType;
                break;
            }
        } else {
            deviceTypeInfo = this.c_oDeviceInfoManager.getDeviceTypeInfo(deviceTypeID, deviceVersionID);
        }
        if (null == deviceTypeInfo) {
            DCDebugTracer.trace("DC::SubmapTreeModelManager::populateDeviceTypeTree:: deviceTypeInfo is null");
            return;
        }
        TreeNodeInfo oNodeInfo = new TreeNodeInfo(deviceTypeInfo, boardType);
        oTreeNode.setUserObject(oNodeInfo);
        SubMapInfo oSubMapInfo = null;
        try {
            oSubMapInfo = this.isOLTSubMap ? this.c_oDeviceInfoManager.getMxuSubMapInfo() : this.c_oDeviceInfoManager.getSubMapInfo();
            oNodeInfo.setNodeSelectable(false);
            if (null == oSubMapInfo || null == oSubMapInfo.m_strSubMapID) {
                oNodeInfo.setNodeSelectable(false);
                return;
            }
            DeviceTreeNode oSubmapNode = this.populateSubmapNodeForDeviceType(oSubMapInfo, true, deviceTypeID, deviceVersionID, boardType);
            if (null != oSubmapNode && oSubmapNode.getChildCount() > 0) {
                oTreeNode.add(oSubmapNode);
                TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
                if (null != oTreeNodeInfo && !oTreeNodeInfo.isNodeSelectable()) {
                    oTreeNodeInfo.setNodeSelectable(true);
                }
            } else {
                DCDebugTracer.trace("DC::SubmapTreeModelManager::populateDeviceTypeTree::oSubmapNode.getChildCount()<= 0");
            }
        }
        catch (RuntimeException e) {
            DCDebugTracer.trace(e);
            return;
        }
    }

    private void populateOLTSubmapNode(DefaultMutableTreeNode oSubmapNode, SubMapInfo oSubmap, int devcieTypeID, int devcieVersionID, String devVersion, String boardType) {
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        if (devcieTypeID == -1 && devcieVersionID == -1) {
            Vector devTypeList = this.c_oDeviceInfoManager.getDevTypeListByDiffusionTask();
            int count = devTypeList.size();
            for (int i = 0; i < count; ++i) {
                DeviceTypeInfo devTypeInfo = (DeviceTypeInfo)devTypeList.get(i);
                if (null == devTypeInfo || devTypeInfo.getDevTypeID() == -1 && devTypeInfo.getDevTypeVersionId() == -1) continue;
                this.populateOLTSubmapVerNode(oSubmapNode, oSubmap, devTypeInfo.getDevTypeID(), devTypeInfo.getDevTypeVersionId(), devVersion, boardType);
            }
        } else {
            this.populateOLTSubmapVerNode(oSubmapNode, oSubmap, devcieTypeID, devcieVersionID, devVersion, boardType);
        }
    }

    public boolean checkIsHaveParent(SubMapInfo oSubmap) {
        boolean bHaveParent = false;
        if (null == oSubmap || oSubmap.m_iSubMapTypeID != 10101) {
            return bHaveParent;
        }
        int devID2 = -1;
        int roleType = -1;
        DeviceInfo devInfo = null;
        TIntHashSet devIDLst = oSubmap.m_oSubMapDevIDLst;
        for (int devID2 : devIDLst) {
            devInfo = DeviceInfoManagerImpl.getInstance().getDevice(devID2);
            if (devInfo == null || (roleType = devInfo.getRoleType()) != 1) continue;
            bHaveParent = true;
            break;
        }
        DCDebugTracer.trace("OLT SubMapName" + oSubmap.m_strSubMapName + " Do not have Parent Role OLT Device  : " + bHaveParent);
        return bHaveParent;
    }

    private void populateOLTSubmapVerNode(DefaultMutableTreeNode oSubmapNode, SubMapInfo oSubmap, int devcieTypeID, int devcieVersionID, String devVersion, String boardType) {
        if (null == oSubmap) {
            return;
        }
        TreeNodeInfo oSubMapNodeInfo = null;
        DefaultMutableTreeNode devVerTreeNode = null;
        TIntHashSet devIDLst = oSubmap.m_oSubMapDevIDLst;
        int devTypeID = -1;
        int devTypeVerID = -1;
        DeviceInfo devInfo = null;
        String devVer = "";
        String parentSubMapID = oSubmap.m_strSubMapID;
        String parentSubMapName = oSubmap.m_strSubMapName;
        DeviceTypeInfo devTypeInfo = null;
        TIntIterator oDevIDItor = devIDLst.iterator();
        int iDevID = -1;
        while (oDevIDItor.hasNext()) {
            iDevID = oDevIDItor.next();
            devInfo = this.c_oDeviceInfoManager.getDevice(iDevID);
            if (null == devInfo || null == devInfo.getDeviceTypeInfo()) continue;
            devTypeID = devInfo.getDeviceTypeInfo().getDevTypeID();
            devTypeVerID = devInfo.getDevTypeVersionId();
            if (devcieTypeID != -1 && devcieVersionID != -1 && (devcieTypeID != devTypeID || devcieVersionID != devTypeVerID) || null != boardType && !boardType.equals(devInfo.getDevBoardType())) continue;
            devTypeInfo = this.c_oDeviceInfoManager.getDeviceTypeInfo(devTypeID, devTypeVerID);
            if (null != devInfo.getDevVersion()) {
                devVer = devInfo.getDevVersion().getDevVersion();
            }
            if ("".equals(devVer)) {
                devVer = this.c_oResourceManager.getResString("UNKNOWN_VERSION");
            }
            oSubMapNodeInfo = new TreeNodeInfo(devVer, devTypeInfo, parentSubMapID, parentSubMapName, boardType);
            devVerTreeNode = new DefaultMutableTreeNode(oSubMapNodeInfo);
            boolean isExist = this.isChildxist(oSubmapNode, oSubMapNodeInfo);
            if (isExist || !devVersion.equals(this.c_oResourceManager.getResString("UNKNOWN_VERSION")) && !"".equals(devVersion) && !devVer.equals(devVersion)) continue;
            oSubmapNode.add(devVerTreeNode);
        }
    }

    private boolean isChildxist(DefaultMutableTreeNode submapNode, TreeNodeInfo oSubMapNodeInfo) {
        boolean isExist = false;
        int childCount = submapNode.getChildCount();
        DefaultMutableTreeNode tmpNode = null;
        TreeNodeInfo tmpTreeNode = null;
        for (int i = 0; i < childCount; ++i) {
            tmpNode = (DefaultMutableTreeNode)submapNode.getChildAt(i);
            tmpTreeNode = (TreeNodeInfo)tmpNode.getUserObject();
            if (!tmpTreeNode.getVersion().equals(oSubMapNodeInfo.getVersion()) || tmpTreeNode.getDeviceTypeInfo().getDevTypeID() != oSubMapNodeInfo.getDeviceTypeInfo().getDevTypeID() || tmpTreeNode.getDeviceTypeInfo().getDevTypeVersionId() != oSubMapNodeInfo.getDeviceTypeInfo().getDevTypeVersionId() || !tmpTreeNode.getStrOLTParentSubMapID().equals(oSubMapNodeInfo.getStrOLTParentSubMapID())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public void populateDeviceVersionTree(DefaultMutableTreeNode oTreeNode, String strVersion, DeviceTypeInfo oDeviceTypeInfo, String boardType) {
        DCDebugTracer.trace("Enter SubmapTreeModelMananger::populateDeviceVersionTree().");
        if ("".equals(strVersion) && null == oDeviceTypeInfo) {
            DCDebugTracer.trace("SubmapTreeModelMananger::populateDeviceVersionTree(the version is empty and the oDeviceTypeInfo is null).");
            return;
        }
        TreeNodeInfo oNodeInfo = null;
        oNodeInfo = new TreeNodeInfo(strVersion, boardType, oDeviceTypeInfo);
        oTreeNode.setUserObject(oNodeInfo);
        SubMapInfo oSubMapInfo = null;
        try {
            oSubMapInfo = this.isOLTSubMap ? this.c_oDeviceInfoManager.getMxuSubMapInfo() : this.c_oDeviceInfoManager.getSubMapInfo();
            oNodeInfo.setNodeSelectable(false);
            if (null == oSubMapInfo || null == oSubMapInfo.m_strSubMapID) {
                DCDebugTracer.trace("SubmapTreeModelMananger::populateDeviceVersionTree(the oSubMapInfo is null).");
                return;
            }
            DeviceTreeNode oSubmapNode = this.populateSubmapNodeForVersion(oSubMapInfo, true, strVersion, boardType, oDeviceTypeInfo);
            if (null != oSubmapNode && oSubmapNode.getChildCount() > 0) {
                oTreeNode.add(oSubmapNode);
                TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
                if (null != oTreeNodeInfo && !oTreeNodeInfo.isNodeSelectable()) {
                    oTreeNodeInfo.setNodeSelectable(true);
                }
            }
        }
        catch (RuntimeException e) {
            DCDebugTracer.trace(e);
            return;
        }
    }

    private DefaultMutableTreeNode populateSubmapNode(SubMapInfo oSubmap, boolean bDisplayDevices) {
        DefaultMutableTreeNode oSubmapNode = new DefaultMutableTreeNode();
        SubMapNodeInfo submapNodeInfo = null;
        TreeNodeInfo oSubMapNodeInfo = null;
        boolean bHasAnyChildResource = false;
        if (null != oSubmap.m_strSubMapID) {
            submapNodeInfo = new SubMapNodeInfo();
            submapNodeInfo.m_submapId = oSubmap.m_strSubMapID;
            submapNodeInfo.m_submapName = oSubmap.m_strSubMapName;
            oSubMapNodeInfo = new TreeNodeInfo(submapNodeInfo);
            oSubmapNode.setUserObject(oSubMapNodeInfo);
        }
        if (bDisplayDevices) {
            DeviceInfo devInfo = null;
            DeviceNodeInfo devNodeInfo = null;
            DefaultMutableTreeNode deviceNode = null;
            TreeNodeInfo oTreeNodeInfo = null;
            int iSubMapDeviceCount = oSubmap.m_oSubMapDevIDLst.size();
            if (0 < iSubMapDeviceCount) {
                bHasAnyChildResource = true;
            }
            TIntIterator oSubMapDevIDItor = oSubmap.m_oSubMapDevIDLst.iterator();
            int iDevID = -1;
            while (oSubMapDevIDItor.hasNext()) {
                iDevID = oSubMapDevIDItor.next();
                devInfo = this.c_oDeviceInfoManager.getDevice(iDevID);
                if (null == devInfo) continue;
                devNodeInfo = new DeviceNodeInfo();
                devNodeInfo.m_iDeviceID = devInfo.getDevId();
                devNodeInfo.m_strDeviceIP = devInfo.getDevIPAddress();
                devNodeInfo.m_strDeviceName = devInfo.getDevName();
                devNodeInfo.m_iRoleType = devInfo.getRoleType();
                oTreeNodeInfo = new TreeNodeInfo(devNodeInfo);
                deviceNode = new DefaultMutableTreeNode(oTreeNodeInfo);
                oSubmapNode.add(deviceNode);
            }
        }
        SubMapInfo oSubMapInfo = null;
        DefaultMutableTreeNode oChildSubmapNode = null;
        for (int i = 0; i < oSubmap.m_SubMapList.size(); ++i) {
            oSubMapInfo = oSubmap.m_SubMapList.get(i);
            oChildSubmapNode = this.populateSubmapNode(oSubMapInfo, bDisplayDevices);
            if (null != oChildSubmapNode) {
                oSubmapNode.add(oChildSubmapNode);
            }
            if (bHasAnyChildResource || null == oChildSubmapNode) continue;
            bHasAnyChildResource = ((TreeNodeInfo)oChildSubmapNode.getUserObject()).isNodeSelectable();
        }
        if (null != oSubMapNodeInfo) {
            oSubMapNodeInfo.setNodeSelectable(bHasAnyChildResource);
        }
        return oSubmapNode;
    }

    private DefaultMutableTreeNode populateMXUSubmapNode(SubMapInfo oSubmap) {
        DefaultMutableTreeNode oSubmapNode = new DefaultMutableTreeNode();
        SubMapNodeInfo submapNodeInfo = null;
        TreeNodeInfo oSubMapNodeInfo = null;
        if (null != oSubmap.m_strSubMapID) {
            submapNodeInfo = new SubMapNodeInfo();
            submapNodeInfo.m_submapId = oSubmap.m_strSubMapID;
            submapNodeInfo.m_submapName = oSubmap.m_strSubMapName;
            oSubMapNodeInfo = new TreeNodeInfo(submapNodeInfo);
            oSubmapNode.setUserObject(oSubMapNodeInfo);
        }
        SubMapInfo oSubMapInfo = null;
        DefaultMutableTreeNode oChildSubmapNode = null;
        for (int i = 0; i < oSubmap.m_SubMapList.size(); ++i) {
            oSubMapInfo = oSubmap.m_SubMapList.get(i);
            oChildSubmapNode = this.populateMXUSubmapNode(oSubMapInfo);
            if (null == oChildSubmapNode) continue;
            oSubmapNode.add(oChildSubmapNode);
        }
        if (null != oSubMapNodeInfo) {
            oSubMapNodeInfo.setNodeSelectable(true);
        }
        return oSubmapNode;
    }

    private DeviceTreeNode populateSubmapNodeForDeviceType(SubMapInfo oSubmap, boolean bDisplayDevices, int iDeviceType, int iVersionID, String boardType) {
        DeviceTreeNode oSubmapNode = new DeviceTreeNode();
        SubMapNodeInfo submapNodeInfo = null;
        TreeNodeInfo oSubmapNodeInfo = null;
        boolean bHasChildDevices = false;
        if (null != oSubmap.m_strSubMapID) {
            submapNodeInfo = new SubMapNodeInfo(iDeviceType, iVersionID);
            submapNodeInfo.m_submapId = oSubmap.m_strSubMapID;
            submapNodeInfo.m_submapName = oSubmap.m_strSubMapName;
            oSubmapNodeInfo = new TreeNodeInfo(submapNodeInfo, boardType);
            oSubmapNode.setUserObject(oSubmapNodeInfo);
        } else {
            DCDebugTracer.trace("DC::SubmapTreeModelManager :: populateSubmapNodeForDeviceType::oSubmap.m_strSubMapID is null");
        }
        if (bDisplayDevices && !this.isOLTSubMap) {
            this.populateDevicesForType(oSubmap, iDeviceType, iVersionID, boardType, oSubmapNode);
        }
        if (this.isOLTSubMap) {
            this.populateOLTSubmapNode(oSubmapNode, oSubmap, iDeviceType, iVersionID, "", boardType);
        }
        SubMapInfo oSubMapInfo = null;
        if (this.isOLTSubMap) {
            if (oSubmapNode.getChildCount() > 0) {
                bHasChildDevices = true;
            }
        } else if (null != oSubmapNodeInfo) {
            bHasChildDevices = oSubmapNodeInfo.isNodeSelectable();
        }
        DeviceTreeNode oChildSubmapNode = null;
        for (int i = 0; i < oSubmap.m_SubMapList.size(); ++i) {
            oSubMapInfo = oSubmap.m_SubMapList.get(i);
            oChildSubmapNode = this.populateSubmapNodeForDeviceType(oSubMapInfo, bDisplayDevices, iDeviceType, iVersionID, boardType);
            if (null != oChildSubmapNode && ((TreeNodeInfo)oChildSubmapNode.getUserObject()).isNodeSelectable()) {
                oSubmapNode.add(oChildSubmapNode);
            }
            if (bHasChildDevices || null == oChildSubmapNode) continue;
            bHasChildDevices = ((TreeNodeInfo)oChildSubmapNode.getUserObject()).isNodeSelectable();
        }
        if (null != oSubmapNodeInfo) {
            oSubmapNodeInfo.setNodeSelectable(bHasChildDevices);
        }
        return oSubmapNode;
    }

    private void populateDevicesForType(SubMapInfo oSubmap, int iDeviceType, int iVersionID, String boardType, DefaultMutableTreeNode oSubmapNode) {
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        if (iDeviceType == -1 && iVersionID == -1) {
            Vector devTypeList = this.c_oDeviceInfoManager.getDevTypeListByDiffusionTask();
            int count = devTypeList.size();
            for (int i = 0; i < count; ++i) {
                DeviceTypeInfo devTypeInfo = (DeviceTypeInfo)devTypeList.get(i);
                if (devTypeInfo.getDevTypeID() == -1 && devTypeInfo.getDevTypeVersionId() == -1) continue;
                this.populateDevicesToNode(oSubmap, devTypeInfo.getDevTypeID(), devTypeInfo.getDevTypeVersionId(), boardType, oSubmapNode);
            }
        } else {
            this.populateDevicesToNode(oSubmap, iDeviceType, iVersionID, boardType, oSubmapNode);
        }
    }

    private void populateDevicesToNode(SubMapInfo oSubmap, int iDeviceType, int iVersionID, String boardType, DefaultMutableTreeNode oSubmapNode) {
        DeviceInfo devInfo = null;
        DeviceNodeInfo devNodeInfo = null;
        DeviceTreeNode deviceNode = null;
        TreeNodeInfo oTreeNodeInfo = null;
        TIntIterator oSubMapDevIDItor = oSubmap.m_oSubMapDevIDLst.iterator();
        int iDevID = -1;
        while (oSubMapDevIDItor.hasNext()) {
            iDevID = oSubMapDevIDItor.next();
            devInfo = this.c_oDeviceInfoManager.getDevice(iDevID);
            if (null == devInfo || null == devInfo.getDeviceTypeInfo() || iDeviceType != devInfo.getDeviceTypeInfo().getDevTypeID() || iVersionID != devInfo.getDeviceTypeInfo().getDevTypeVersionId() || null != boardType && !boardType.equals(devInfo.getDevBoardType())) continue;
            devNodeInfo = new DeviceNodeInfo();
            devNodeInfo.m_iDeviceID = devInfo.getDevId();
            devNodeInfo.m_strDeviceIP = devInfo.getDevIPAddress();
            devNodeInfo.m_strDeviceName = devInfo.getDevName();
            devNodeInfo.m_iRoleType = devInfo.getRoleType();
            oTreeNodeInfo = new TreeNodeInfo(devNodeInfo, boardType);
            deviceNode = new DeviceTreeNode(oTreeNodeInfo);
            oSubmapNode.add(deviceNode);
        }
        if (0 < oSubmapNode.getChildCount()) {
            ((TreeNodeInfo)oSubmapNode.getUserObject()).setNodeSelectable(true);
        } else {
            ((TreeNodeInfo)oSubmapNode.getUserObject()).setNodeSelectable(false);
        }
    }

    private DeviceTreeNode populateSubmapNodeForVersion(SubMapInfo oSubmap, boolean bDisplayDevices, String strVersion, String boardType, DeviceTypeInfo oDeviceTypeInfo) {
        DeviceTreeNode oSubmapNode = new DeviceTreeNode();
        SubMapNodeInfo submapNodeInfo = null;
        TreeNodeInfo oSubmapNodeInfo = null;
        boolean bHasChildDevices = false;
        if (null != oSubmap.m_strSubMapID) {
            submapNodeInfo = new SubMapNodeInfo(strVersion, oDeviceTypeInfo);
            submapNodeInfo.m_submapId = oSubmap.m_strSubMapID;
            submapNodeInfo.m_submapName = oSubmap.m_strSubMapName;
            oSubmapNodeInfo = new TreeNodeInfo(submapNodeInfo, boardType);
            oSubmapNode.setUserObject(oSubmapNodeInfo);
        }
        if (bDisplayDevices && !this.isOLTSubMap) {
            DeviceInfo devInfo = null;
            DeviceNodeInfo devNodeInfo = null;
            DeviceTreeNode deviceNode = null;
            TreeNodeInfo oTreeNodeInfo = null;
            TIntIterator oSubMapDevIDItor = oSubmap.m_oSubMapDevIDLst.iterator();
            int iDevId = -1;
            while (oSubMapDevIDItor.hasNext()) {
                iDevId = oSubMapDevIDItor.next();
                devInfo = this.c_oDeviceInfoManager.getDevice(iDevId);
                if (devInfo == null || null == devInfo || null == strVersion || !oDeviceTypeInfo.equals(devInfo.getDeviceTypeInfo())) continue;
                String strDevVersion = null;
                if (null != devInfo.getDevVersion()) {
                    strDevVersion = devInfo.getDevVersion().getDevVersion();
                }
                if (null == strDevVersion || "".equals(strDevVersion) ? !strVersion.equals(this.c_oResourceManager.getResString("UNKNOWN_VERSION")) : !strDevVersion.equals(strVersion) || null != boardType && !boardType.equals(devInfo.getDevBoardType())) continue;
                devNodeInfo = new DeviceNodeInfo();
                devNodeInfo.m_iDeviceID = devInfo.getDevId();
                devNodeInfo.m_strDeviceIP = devInfo.getDevIPAddress();
                devNodeInfo.m_strDeviceName = devInfo.getDevName();
                devNodeInfo.m_iRoleType = devInfo.getRoleType();
                oTreeNodeInfo = new TreeNodeInfo(devNodeInfo, boardType);
                deviceNode = new DeviceTreeNode(oTreeNodeInfo);
                if (this.isOLTSubMap) continue;
                oSubmapNode.add(deviceNode);
            }
        }
        if (this.isOLTSubMap) {
            int iDeviceType = oDeviceTypeInfo.getDevTypeID();
            int iDevTypeVerID = oDeviceTypeInfo.getDevTypeVersionId();
            this.populateOLTSubmapVerNode(oSubmapNode, oSubmap, iDeviceType, iDevTypeVerID, strVersion, boardType);
        }
        if (0 < oSubmapNode.getChildCount()) {
            bHasChildDevices = true;
        }
        SubMapInfo oSubMapInfo = null;
        DeviceTreeNode oChildSubmapNode = null;
        for (int i = 0; i < oSubmap.m_SubMapList.size(); ++i) {
            oSubMapInfo = oSubmap.m_SubMapList.get(i);
            oChildSubmapNode = this.populateSubmapNodeForVersion(oSubMapInfo, bDisplayDevices, strVersion, boardType, oDeviceTypeInfo);
            if (null != oChildSubmapNode && ((TreeNodeInfo)oChildSubmapNode.getUserObject()).isNodeSelectable()) {
                oSubmapNode.add(oChildSubmapNode);
            }
            if (bHasChildDevices || null == oChildSubmapNode) continue;
            bHasChildDevices = ((TreeNodeInfo)oChildSubmapNode.getUserObject()).isNodeSelectable();
        }
        if (null != oSubmapNodeInfo) {
            oSubmapNodeInfo.setNodeSelectable(bHasChildDevices);
        }
        return oSubmapNode;
    }

    @Override
    public void setToNULL() {
        this.c_oDeviceInfoManager = null;
        c_oInstance = null;
        this.c_oResourceManager = null;
    }

    @Override
    public void addDeviceInformation(DefaultMutableTreeNode oDeviceNode, DeviceInformation oDeviceInfo) {
        if (null == oDeviceInfo || null == oDeviceNode) {
            return;
        }
        int iCurrentSelection = ((TreeNodeInfo)oDeviceNode.getUserObject()).getSelectedState();
        TreeNodeInfo oNewNodeInfo = new TreeNodeInfo(oDeviceInfo);
        oNewNodeInfo.setSelected(iCurrentSelection);
        oDeviceNode.setUserObject(oNewNodeInfo);
        List oFrameList = oDeviceInfo.getFrameList();
        if (null == oFrameList || 0 == oFrameList.size()) {
            oDeviceNode.setAllowsChildren(false);
            oNewNodeInfo.setNodeSelectable(false);
            return;
        }
        int iFrameCount = oFrameList.size();
        for (int i = 0; i < iFrameCount; ++i) {
            FrameInformation oFrame = (FrameInformation)oFrameList.get(i);
            this.populateFrameInformation(oDeviceNode, oFrame);
        }
    }

    private void populateFrameInformation(DefaultMutableTreeNode oDeviceNode, FrameInformation oFrame) {
        if (null == oFrame) {
            return;
        }
        TreeNodeInfo oNodeInfo = new TreeNodeInfo(oFrame);
        DefaultMutableTreeNode oFrameNode = new DefaultMutableTreeNode(oNodeInfo);
        oDeviceNode.add(oFrameNode);
        List oBoardList = oFrame.getBoardInformationList();
        if (null == oBoardList || 0 == oBoardList.size()) {
            oFrameNode.setAllowsChildren(false);
            oNodeInfo.setNodeSelectable(false);
            return;
        }
        int iBoardCount = oBoardList.size();
        for (int i = 0; i < iBoardCount; ++i) {
            SlotInformation oSlotInfo = (SlotInformation)oBoardList.get(i);
            this.populateSlotInformation(oFrameNode, oSlotInfo);
        }
    }

    private void populateSlotInformation(DefaultMutableTreeNode oFrameNode, SlotInformation oSlotInfo) {
        if (null == oSlotInfo) {
            return;
        }
        TreeNodeInfo oNodeInfo = new TreeNodeInfo(oSlotInfo);
        DefaultMutableTreeNode oSlotNode = new DefaultMutableTreeNode(oNodeInfo);
        oFrameNode.add(oSlotNode);
        List oSlotList = oSlotInfo.getSubslotList();
        if (null == oSlotList || 0 == oSlotList.size()) {
            oSlotNode.setAllowsChildren(false);
            return;
        }
        int iSlotCount = oSlotList.size();
        for (int i = 0; i < iSlotCount; ++i) {
            SubslotInformation oSubslotInfo = (SubslotInformation)oSlotList.get(i);
            this.populateSubslotInformation(oSlotNode, oSubslotInfo);
        }
    }

    private void populateSubslotInformation(DefaultMutableTreeNode oSlotNode, SubslotInformation oSlotInfo) {
        if (null == oSlotInfo) {
            return;
        }
        TreeNodeInfo oSubslotInfo = new TreeNodeInfo(oSlotInfo);
        DefaultMutableTreeNode oSubslotNode = new DefaultMutableTreeNode(oSubslotInfo);
        oSlotNode.add(oSubslotNode);
        oSubslotNode.setAllowsChildren(false);
    }
}

