/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree.model;

import com.huawei.dc.common.tree.TreeNodeInfo;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DeviceTreeNode
extends DefaultMutableTreeNode
implements Comparable {
    private static final long serialVersionUID = -2289093993675960963L;
    protected boolean isVisible = true;

    public DeviceTreeNode() {
        this(null);
    }

    public DeviceTreeNode(Object oNodeObject) {
        this(oNodeObject, true);
    }

    public DeviceTreeNode(Object oNodeObject, boolean isAllowsChild) {
        super(oNodeObject, isAllowsChild);
    }

    public TreeNode getChildAt(int index, boolean isFilterActive) {
        if (!isFilterActive) {
            return super.getChildAt(index);
        }
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        int indexOfReal = -1;
        int indexOfVisible = -1;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            DeviceTreeNode node = (DeviceTreeNode)e.nextElement();
            if (node.isVisible()) {
                ++indexOfVisible;
            }
            ++indexOfReal;
            if (indexOfVisible != index) continue;
            return (TreeNode)this.children.elementAt(indexOfReal);
        }
        return null;
    }

    public int getChildCount(boolean isfilterActive) {
        if (!isfilterActive) {
            return super.getChildCount();
        }
        if (this.children == null) {
            return 0;
        }
        int count = 0;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            DeviceTreeNode node = (DeviceTreeNode)e.nextElement();
            if (!node.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public int getIndexOfChild(Object parent, Object child, boolean filterIsActive) {
        if (!filterIsActive) {
            return super.getIndex((TreeNode)child);
        }
        if (this.children == null) {
            return 0;
        }
        int iInvisibleNodeCount = 0;
        Enumeration e = this.children.elements();
        DeviceTreeNode oNode = (DeviceTreeNode)child;
        while (e.hasMoreElements()) {
            DeviceTreeNode node = (DeviceTreeNode)e.nextElement();
            if (!node.isVisible()) {
                ++iInvisibleNodeCount;
                continue;
            }
            if (!oNode.equals(node)) continue;
            break;
        }
        return super.getIndex((TreeNode)child) - iInvisibleNodeCount;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void sortNode(boolean isRecursive) {
        if (this.children == null) {
            return;
        }
        if (isRecursive) {
            for (DeviceTreeNode child : this.children) {
                child.sortNode(isRecursive);
            }
        }
        Collections.sort(this.children);
    }

    public void sortNode() {
        this.sortNode(true);
    }

    @Override
    public String toString() {
        if (null == this.userObject) {
            return "";
        }
        return this.userObject.toString();
    }

    public int compareTo(Object arg0) {
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)this.getUserObject();
        if (!(arg0 instanceof DeviceTreeNode)) {
            return 0;
        }
        return oTreeNodeInfo.compareTo((TreeNodeInfo)((DeviceTreeNode)arg0).getUserObject());
    }

    public int hashCode() {
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)this.getUserObject();
        if (null == oTreeNodeInfo) {
            return 0;
        }
        int iNodeType = oTreeNodeInfo.m_iNodeType;
        String sNodeName = oTreeNodeInfo.m_nodeName;
        int prime = 31;
        int result = 1;
        result = 31 * result + iNodeType;
        result = 31 * result + (sNodeName == null ? 0 : sNodeName.hashCode());
        return result;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof DeviceTreeNode)) {
            return false;
        }
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)this.getUserObject();
        if (null == oTreeNodeInfo) {
            return false;
        }
        return oTreeNodeInfo.equals((TreeNodeInfo)((DeviceTreeNode)arg0).getUserObject());
    }
}

