/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree.model;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTypeTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceVersionTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeNode;
import com.huawei.dc.common.components.tree.devicetree.model.IDeviceTreeModelManager;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.DeviceInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.FrameInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SlotInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubslotInformation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class DeviceTreeModelManager
implements IDeviceTreeModelManager,
IDCObjectDeallocator {
    private static DeviceTreeModelManager c_oInstance;
    protected IDeviceInfoManager c_oDeviceInfoManager;
    protected ResourceManager c_oResourceManager = ResourceManager.getInstance();
    private HashMap<String, DefaultMutableTreeNode> m_oNETypeHm = new HashMap();
    private HashMap<String, DefaultMutableTreeNode> m_oNEVersionHm = new HashMap();

    private void populateMainTreeNew(DefaultMutableTreeNode oRoot, boolean isUserDefinedPolicy, String title) {
        this.m_oNETypeHm.clear();
        this.m_oNEVersionHm.clear();
        String sUnknowVersion = this.c_oResourceManager.getResString("UNKNOWN_VERSION");
        DeviceInfo[] oDevices = this.c_oDeviceInfoManager.getDevices();
        int iDevCount = 0;
        if (null != oDevices) {
            iDevCount = oDevices.length;
        }
        DeviceInfo oDev = null;
        DeviceTypeInfo oDevType = null;
        String sDevTypeKey = "";
        String sDevVersionKey = "";
        String sDevVersion = "";
        TreeNodeInfo oRootNode = null;
        oRootNode = StringUtils.isNullOrEmptyStr(title) ? new TreeNodeInfo(this.c_oResourceManager.getResString("DEVICE_TREE_PAN_ROOT_NODE"), true) : new TreeNodeInfo(title, true);
        oRoot.setUserObject(oRootNode);
        DefaultMutableTreeNode oDevTypeNode = null;
        DefaultMutableTreeNode oDevVerNode = null;
        DefaultMutableTreeNode oDeviceNode = null;
        for (int i = 0; i < iDevCount; ++i) {
            if (null != oDevices) {
                oDev = oDevices[i];
            }
            if (null == oDev || null == (oDevType = oDev.getDeviceTypeInfo())) continue;
            sDevTypeKey = oDevType.getDevTypeIDAndVersionID();
            if (null != oDev.getDevVersion()) {
                sDevVersion = oDev.getDevVersion().getDevVersion();
            }
            if (sDevVersion != null && sDevVersion.equals("")) {
                sDevVersion = sUnknowVersion;
            }
            oDevTypeNode = null;
            oDevVerNode = null;
            oDeviceNode = null;
            oDevTypeNode = this.m_oNETypeHm.get(sDevTypeKey);
            if (null == oDevTypeNode) {
                oDevTypeNode = this.generateDevTypeNode(oDevType);
                this.m_oNETypeHm.put(sDevTypeKey, oDevTypeNode);
                oRoot.add(oDevTypeNode);
            }
            if (null == (oDevVerNode = this.m_oNEVersionHm.get(sDevVersionKey = sDevTypeKey + "_" + sDevVersion))) {
                oDevVerNode = this.generateDevVersionNode(sDevVersion, oDevType);
                this.m_oNEVersionHm.put(sDevVersionKey, oDevVerNode);
                oDevTypeNode.add(oDevVerNode);
            }
            if (!isUserDefinedPolicy) continue;
            oDeviceNode = this.generateDeviceNode(oDev);
            oDevVerNode.add(oDeviceNode);
        }
        if (oRoot instanceof DeviceTreeNode) {
            ((DeviceTreeNode)oRoot).sortNode();
        }
    }

    private DefaultMutableTreeNode generateDevTypeNode(DeviceTypeInfo oDevType) {
        DeviceTreeNode oDevTypeMutableTreeNode = new DeviceTreeNode();
        TreeNodeInfo oDeviceTypeNode = new TreeNodeInfo(oDevType);
        oDevTypeMutableTreeNode.setUserObject(oDeviceTypeNode);
        return oDevTypeMutableTreeNode;
    }

    private DefaultMutableTreeNode generateDevVersionNode(String sDevVersion, DeviceTypeInfo oDevType) {
        DeviceTreeNode oDevTypeMutableTreeNode = new DeviceTreeNode();
        TreeNodeInfo oDeviceTypeNode = new TreeNodeInfo(sDevVersion, oDevType);
        oDevTypeMutableTreeNode.setUserObject(oDeviceTypeNode);
        return oDevTypeMutableTreeNode;
    }

    private DefaultMutableTreeNode generateDeviceNode(DeviceInfo oDevInfo) {
        DeviceTreeNode oDevNode = new DeviceTreeNode();
        DeviceNodeInfo devNodeInfo = new DeviceNodeInfo();
        devNodeInfo.m_iDeviceID = oDevInfo.getDevId();
        devNodeInfo.m_strDeviceIP = oDevInfo.getDevIPAddress();
        devNodeInfo.m_strDeviceName = oDevInfo.getDevName();
        devNodeInfo.m_iRoleType = oDevInfo.getRoleType();
        oDevNode.setUserObject(new TreeNodeInfo(devNodeInfo));
        return oDevNode;
    }

    private DeviceTreeModelManager(IDeviceInfoManager oDeviceInfoMgr) {
        this.c_oDeviceInfoManager = oDeviceInfoMgr;
    }

    public static synchronized DeviceTreeModelManager getInstance(IDeviceInfoManager oDeviceInfoMgr) {
        if (null == c_oInstance) {
            c_oInstance = new DeviceTreeModelManager(oDeviceInfoMgr);
            DCObjectDestructor.getInstance().addObjectForDestructor(c_oInstance);
        }
        return c_oInstance;
    }

    @Override
    public void populateTreeModel(DefaultMutableTreeNode oTreeNode, DeviceTreeBaseDescriptor oDescriptor, String title) {
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        if (null == oTreeNode) {
            return;
        }
        int iTreeType = oDescriptor.getTreeType();
        if (2 == iTreeType) {
            int iDeviceTypeID = ((DeviceTypeTreeDescriptor)oDescriptor).getDeviceTypeID();
            int iDeviceVersionID = ((DeviceTypeTreeDescriptor)oDescriptor).getDeviceVersionID();
            if (iDeviceTypeID == -1 && iDeviceVersionID == -1) {
                int viewType = ((DeviceTypeTreeDescriptor)oDescriptor).getViewType();
                if (6 == viewType) {
                    this.populateMainTree(oTreeNode, true, title);
                    return;
                }
                Vector devTypeList = this.c_oDeviceInfoManager.getDevTypeListByDiffusionTask();
                Collections.sort(devTypeList);
                int devTypeCount = devTypeList.size();
                for (int i = 0; i < devTypeCount; ++i) {
                    DeviceTypeInfo oDeviceType = (DeviceTypeInfo)devTypeList.get(i);
                    if (oDeviceType.getDevTypeID() == -1 && oDeviceType.getDevTypeVersionId() == -1) {
                        DeviceTypeInfo deviceType = new DeviceTypeInfo();
                        deviceType.setDevTypeName(DCConstants.ALL_TYPE);
                        deviceType.setDevTypeVersionName(DCConstants.ALL_TYPE_VERSION);
                        deviceType.setDevTypeID(-1);
                        deviceType.setDevTypeVersionId(-1);
                        oTreeNode.setUserObject(new TreeNodeInfo(deviceType));
                        continue;
                    }
                    DeviceTreeNode m_oDevTypeNode = new DeviceTreeNode();
                    this.populateDeviceType(oDeviceType, ((DeviceTypeTreeDescriptor)oDescriptor).getDevBoardType(), m_oDevTypeNode, true);
                    oTreeNode.add(m_oDevTypeNode);
                }
            } else {
                DeviceTypeInfo oDeviceType = this.c_oDeviceInfoManager.getDeviceTypeInfo(iDeviceTypeID, iDeviceVersionID);
                this.populateDeviceType(oDeviceType, ((DeviceTypeTreeDescriptor)oDescriptor).getDevBoardType(), oTreeNode, true);
            }
        } else if (3 == iTreeType) {
            DeviceVersionTreeDescriptor devVerTreeDesc = (DeviceVersionTreeDescriptor)oDescriptor;
            String strDeviceVersionID = devVerTreeDesc.getDeviceVersion();
            String strBoardType = devVerTreeDesc.getDeviceBoardType();
            DeviceTypeInfo oDeviceTypeInfo = devVerTreeDesc.getDeviceTypeInfo();
            int viewType = devVerTreeDesc.getViewType();
            if (null == strDeviceVersionID) {
                return;
            }
            if (oDeviceTypeInfo != null && oDeviceTypeInfo.getDevTypeID() == -1 && oDeviceTypeInfo.getDevTypeVersionId() == -1) {
                if (6 == viewType) {
                    this.populateMainTree(oTreeNode, true, title);
                    return;
                }
                Vector devTypeList = this.c_oDeviceInfoManager.getDevTypeListByDiffusionTask();
                int devTypeCount = devTypeList.size();
                block1: for (int i = 0; i < devTypeCount; ++i) {
                    HashMap oVersionMap;
                    DeviceTypeInfo oDeviceType = (DeviceTypeInfo)devTypeList.get(i);
                    if (oDeviceType.getDevTypeID() == -1 && oDeviceType.getDevTypeVersionId() == -1 || null == (oVersionMap = this.c_oDeviceInfoManager.getDeviceVersionMapByDeviceType(oDeviceType.getDevTypeID()))) continue;
                    Iterator oVersionIterator = oVersionMap.keySet().iterator();
                    String strVersion = null;
                    while (oVersionIterator.hasNext()) {
                        strVersion = (String)oVersionIterator.next();
                        if (!strDeviceVersionID.equals(strVersion)) continue;
                        oDeviceTypeInfo = oDeviceType;
                        continue block1;
                    }
                }
            }
            this.populateDeviceVersion(strDeviceVersionID, strBoardType, oDeviceTypeInfo, null, oTreeNode, true);
        } else {
            this.populateMainTreeNew(oTreeNode, false, title);
        }
    }

    @Override
    public void populateTreeModelByFilter(DefaultMutableTreeNode oTreeNode, DeviceTreeBaseDescriptor oDescriptor, String title, DeviceInfo[] deviceInfoList) {
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        if (null == oTreeNode) {
            return;
        }
        int iTreeType = oDescriptor.getTreeType();
        if (2 == iTreeType) {
            int iDeviceTypeID = ((DeviceTypeTreeDescriptor)oDescriptor).getDeviceTypeID();
            int iDeviceVersionID = ((DeviceTypeTreeDescriptor)oDescriptor).getDeviceVersionID();
            if (iDeviceTypeID == -1 && iDeviceVersionID == -1) {
                int viewType = ((DeviceTypeTreeDescriptor)oDescriptor).getViewType();
                if (6 == viewType) {
                    this.populateMainTree(oTreeNode, true, title);
                    return;
                }
                Vector devTypeList = this.c_oDeviceInfoManager.getDevTypeListByDiffusionTask();
                Collections.sort(devTypeList);
                int devTypeCount = devTypeList.size();
                for (int i = 0; i < devTypeCount; ++i) {
                    DeviceTypeInfo oDeviceType = (DeviceTypeInfo)devTypeList.get(i);
                    if (oDeviceType.getDevTypeID() == -1 && oDeviceType.getDevTypeVersionId() == -1) {
                        DeviceTypeInfo deviceType = new DeviceTypeInfo();
                        deviceType.setDevTypeName(DCConstants.ALL_TYPE);
                        deviceType.setDevTypeVersionName(DCConstants.ALL_TYPE_VERSION);
                        deviceType.setDevTypeID(-1);
                        deviceType.setDevTypeVersionId(-1);
                        oTreeNode.setUserObject(new TreeNodeInfo(deviceType));
                        continue;
                    }
                    DeviceTreeNode m_oDevTypeNode = new DeviceTreeNode();
                    this.populateDeviceType(oDeviceType, null, m_oDevTypeNode, true);
                    oTreeNode.add(m_oDevTypeNode);
                }
            } else {
                DeviceTypeInfo oDeviceType = this.c_oDeviceInfoManager.getDeviceTypeInfo(iDeviceTypeID, iDeviceVersionID);
                this.populateDeviceType(oDeviceType, null, oTreeNode, true);
            }
        } else if (3 == iTreeType) {
            String strDeviceVersionID = ((DeviceVersionTreeDescriptor)oDescriptor).getDeviceVersion();
            DeviceTypeInfo oDeviceTypeInfo = ((DeviceVersionTreeDescriptor)oDescriptor).getDeviceTypeInfo();
            if (null == strDeviceVersionID) {
                return;
            }
            Vector devTypeList = this.c_oDeviceInfoManager.getDevTypeListByDiffusionTask();
            int devTypeCount = devTypeList.size();
            block1: for (int i = 0; i < devTypeCount; ++i) {
                HashMap oVersionMap;
                DeviceTypeInfo oDeviceType = (DeviceTypeInfo)devTypeList.get(i);
                if (oDeviceType.getDevTypeID() == -1 && oDeviceType.getDevTypeVersionId() == -1 || null == (oVersionMap = this.c_oDeviceInfoManager.getDeviceVersionMapByDeviceType(oDeviceType.getDevTypeID()))) continue;
                Iterator oVersionIterator = oVersionMap.keySet().iterator();
                String strVersion = null;
                while (oVersionIterator.hasNext()) {
                    strVersion = (String)oVersionIterator.next();
                    if (!strDeviceVersionID.equals(strVersion)) continue;
                    oDeviceTypeInfo = oDeviceType;
                    continue block1;
                }
            }
            this.populateDeviceVersionByDevLst(strDeviceVersionID, oDeviceTypeInfo, oTreeNode, true, deviceInfoList);
        } else {
            this.populateMainTreeNew(oTreeNode, false, title);
        }
    }

    private void populateMainTree(DefaultMutableTreeNode oRoot, boolean isUserDefinedPolicy, String title) {
        TreeNodeInfo oRootNode = null;
        oRootNode = StringUtils.isNullOrEmptyStr(title) ? new TreeNodeInfo(this.c_oResourceManager.getResString("DEVICE_TREE_PAN_ROOT_NODE"), true) : new TreeNodeInfo(title, true);
        oRoot.setUserObject(oRootNode);
        DeviceTypeInfo[] deviceTypeList = this.c_oDeviceInfoManager.getExistDeviceTypes();
        DefaultMutableTreeNode oDeviceTypeNode = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        if (null == deviceTypeList || 0 >= deviceTypeList.length) {
            oRootNode.setNodeSelectable(false);
            return;
        }
        for (int j = 0; j < deviceTypeList.length; ++j) {
            boolean oDeviceVersionMapItems;
            oDeviceTypeInfo = deviceTypeList[j];
            if (null == oDeviceTypeInfo) continue;
            oDeviceTypeNode = new DefaultMutableTreeNode();
            HashMap oDeviceVersionMap = this.c_oDeviceInfoManager.getDeviceVersionMapByDeviceTypeAndVersion(oDeviceTypeInfo.getDevTypeID(), oDeviceTypeInfo.getDevTypeVersionId());
            if (null == oDeviceVersionMap || (oDeviceVersionMapItems = oDeviceVersionMap.keySet().isEmpty())) continue;
            if (isUserDefinedPolicy) {
                oRoot.add(oDeviceTypeNode);
                this.populateDeviceType(oDeviceTypeInfo, null, oDeviceTypeNode, true);
                continue;
            }
            oRoot.add(oDeviceTypeNode);
            this.populateDeviceType(oDeviceTypeInfo, null, oDeviceTypeNode, false);
        }
    }

    private void populateDeviceType(DeviceTypeInfo oDeviceTypeInfo, String strBoardType, DefaultMutableTreeNode oParentTreeNode, boolean bDisplayDevices) {
        if (null == oDeviceTypeInfo) {
            return;
        }
        TreeNodeInfo oDeviceTypeNode = new TreeNodeInfo(oDeviceTypeInfo, strBoardType);
        oParentTreeNode.setUserObject(oDeviceTypeNode);
        HashMap oDeviceVersionMap = this.c_oDeviceInfoManager.getDeviceVersionMapByDeviceTypeAndVersion(oDeviceTypeInfo.getDevTypeID(), oDeviceTypeInfo.getDevTypeVersionId());
        if (null == oDeviceVersionMap || 0 == oDeviceVersionMap.size()) {
            oDeviceTypeNode.setNodeSelectable(false);
            return;
        }
        Iterator oDeviceVersionMapIterator = oDeviceVersionMap.keySet().iterator();
        DeviceTreeNode oDeviceVersionNode = null;
        while (oDeviceVersionMapIterator.hasNext()) {
            oDeviceVersionNode = new DeviceTreeNode();
            String strVersion = (String)oDeviceVersionMapIterator.next();
            this.populateDeviceVersion(strVersion, strBoardType, oDeviceTypeInfo, oParentTreeNode, oDeviceVersionNode, bDisplayDevices);
        }
    }

    private void populateDeviceVersion(String strVersion, String strBoardType, DeviceTypeInfo oDeviceTypeInfo, DefaultMutableTreeNode oParentTreeNode, DefaultMutableTreeNode oTreeNode, boolean bDisplayDevices) {
        TreeNodeInfo oTreeNodeInfo = new TreeNodeInfo(strVersion, strBoardType, oDeviceTypeInfo);
        oTreeNode.setUserObject(oTreeNodeInfo);
        if (!bDisplayDevices) {
            return;
        }
        DeviceInfo[] deviceInfoList = this.c_oDeviceInfoManager.getDevicesForVersion(strVersion, strBoardType, oDeviceTypeInfo);
        if (0 >= deviceInfoList.length) {
            oTreeNodeInfo.setNodeSelectable(false);
            return;
        }
        if (null != oParentTreeNode) {
            oParentTreeNode.add(oTreeNode);
        }
        DeviceTreeNode oDeviceNode = null;
        for (int i = 0; i < deviceInfoList.length; ++i) {
            DeviceInfo devInfo = deviceInfoList[i];
            if (null == devInfo.getDevIPAddress() || "".equals(devInfo.getDevIPAddress())) continue;
            oDeviceNode = new DeviceTreeNode();
            oTreeNode.add(oDeviceNode);
            this.populateDevice(oDeviceNode, devInfo);
        }
    }

    private void populateDeviceVersionByDevLst(String strVersion, DeviceTypeInfo oDeviceTypeInfo, DefaultMutableTreeNode oTreeNode, boolean bDisplayDevices, DeviceInfo[] deviceInfoList) {
        TreeNodeInfo oTreeNodeInfo = new TreeNodeInfo(strVersion, oDeviceTypeInfo);
        oTreeNode.setUserObject(oTreeNodeInfo);
        if (!bDisplayDevices) {
            return;
        }
        if (0 >= deviceInfoList.length) {
            oTreeNodeInfo.setNodeSelectable(false);
            return;
        }
        DefaultMutableTreeNode oDeviceNode = null;
        for (int i = 0; i < deviceInfoList.length; ++i) {
            DeviceInfo devInfo = deviceInfoList[i];
            if (null == devInfo.getDevIPAddress() || "".equals(devInfo.getDevIPAddress())) continue;
            oDeviceNode = new DefaultMutableTreeNode();
            oTreeNode.add(oDeviceNode);
            this.populateDevice(oDeviceNode, devInfo);
        }
    }

    private void populateDevice(DefaultMutableTreeNode oDeviceNode, DeviceInfo devInfo) {
        DeviceNodeInfo devNodeInfo = new DeviceNodeInfo();
        devNodeInfo.m_iDeviceID = devInfo.getDevId();
        devNodeInfo.m_strDeviceIP = devInfo.getDevIPAddress();
        devNodeInfo.m_strDeviceName = devInfo.getDevName();
        devNodeInfo.m_iRoleType = devInfo.getRoleType();
        devNodeInfo.m_strDevBoard = devInfo.getDevBoardType();
        oDeviceNode.setUserObject(new TreeNodeInfo(devNodeInfo));
    }

    @Override
    public void setToNULL() {
        c_oInstance = null;
        this.c_oDeviceInfoManager = null;
        this.c_oResourceManager = null;
    }

    @Override
    public void addDeviceInformation(DefaultMutableTreeNode oDeviceNode, DeviceInformation oDeviceInfo) {
        if (null == oDeviceInfo || null == oDeviceNode) {
            return;
        }
        int iCurrentSelection = ((TreeNodeInfo)oDeviceNode.getUserObject()).getSelectedState();
        TreeNodeInfo oNewNodeInfo = new TreeNodeInfo(oDeviceInfo);
        oNewNodeInfo.setSelected(iCurrentSelection);
        oDeviceNode.setUserObject(oNewNodeInfo);
        List oFrameList = oDeviceInfo.getFrameList();
        if (null == oFrameList || 0 == oFrameList.size()) {
            oDeviceNode.setAllowsChildren(false);
            oNewNodeInfo.setNodeSelectable(false);
            return;
        }
        int iFrameCount = oFrameList.size();
        for (int i = 0; i < iFrameCount; ++i) {
            FrameInformation oFrame = (FrameInformation)oFrameList.get(i);
            this.populateFrameInformation(oDeviceNode, oFrame);
        }
    }

    private void populateFrameInformation(DefaultMutableTreeNode oDeviceNode, FrameInformation oFrame) {
        if (null == oFrame) {
            return;
        }
        TreeNodeInfo oNodeInfo = new TreeNodeInfo(oFrame);
        DefaultMutableTreeNode oFrameNode = new DefaultMutableTreeNode(oNodeInfo);
        oDeviceNode.add(oFrameNode);
        List oBoardList = oFrame.getBoardInformationList();
        if (null == oBoardList || 0 == oBoardList.size()) {
            oFrameNode.setAllowsChildren(false);
            oNodeInfo.setNodeSelectable(false);
            return;
        }
        int iBoardCount = oBoardList.size();
        for (int i = 0; i < iBoardCount; ++i) {
            SlotInformation oSlotInfo = (SlotInformation)oBoardList.get(i);
            this.populateSlotInformation(oFrameNode, oSlotInfo);
        }
    }

    private void populateSlotInformation(DefaultMutableTreeNode oFrameNode, SlotInformation oSlotInfo) {
        if (null == oSlotInfo) {
            return;
        }
        TreeNodeInfo oNodeInfo = new TreeNodeInfo(oSlotInfo);
        DefaultMutableTreeNode oSlotNode = new DefaultMutableTreeNode(oNodeInfo);
        oFrameNode.add(oSlotNode);
        List oSlotList = oSlotInfo.getSubslotList();
        if (null == oSlotList || 0 == oSlotList.size()) {
            oSlotNode.setAllowsChildren(false);
            return;
        }
        int iSlotCount = oSlotList.size();
        for (int i = 0; i < iSlotCount; ++i) {
            SubslotInformation oSubslotInfo = (SubslotInformation)oSlotList.get(i);
            this.populateSubslotInformation(oSlotNode, oSubslotInfo);
        }
    }

    private void populateSubslotInformation(DefaultMutableTreeNode oSlotNode, SubslotInformation oSlotInfo) {
        if (null == oSlotInfo) {
            return;
        }
        TreeNodeInfo oSubslotInfo = new TreeNodeInfo(oSlotInfo);
        DefaultMutableTreeNode oSubslotNode = new DefaultMutableTreeNode(oSubslotInfo);
        oSlotNode.add(oSubslotNode);
        oSubslotNode.setAllowsChildren(false);
    }
}

