/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree.listener;

import com.huawei.dc.common.asndatacenter.AsnDCGetBoardsReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetMultipleBoardsReq;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.event.DCTreeInitEvent;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceTreeListener
extends MouseAdapter {
    private DeviceTree m_oTree;
    protected boolean m_bAlreadyVisited = false;
    private ArrayList m_oTreeSelectionListeners;
    private static final int LISTENER_LIST_DEFAULT_SIZE = 1;

    public DeviceTreeListener(DeviceTree oTree) {
        this.m_oTree = oTree;
        this.m_oTreeSelectionListeners = new ArrayList(1);
    }

    @Override
    public void mouseClicked(MouseEvent oMouseEvent) {
        int y;
        int x = oMouseEvent.getX();
        int iRow = this.m_oTree.getRowForLocation(x, y = oMouseEvent.getY());
        if (0 > iRow) {
            iRow = this.m_oTree.getRowForLocation(x + 20, y);
        }
        if (0 > iRow) {
            return;
        }
        Rectangle rec = this.m_oTree.getRowBounds(iRow);
        DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)this.m_oTree.getLastSelectedPathComponent();
        TreePath rowTreePath = this.m_oTree.getPathForRow(iRow);
        DefaultMutableTreeNode toExpandedNode = (DefaultMutableTreeNode)rowTreePath.getLastPathComponent();
        if (this.m_bAlreadyVisited) {
            if (!(this.m_oTree.getLastSelectedPathComponent() instanceof DefaultMutableTreeNode) || rec == null) {
                this.sendNotification(nodeObject);
            }
            this.getDeviceSubNode(toExpandedNode);
            return;
        }
        if (4 == oMouseEvent.getModifiers()) {
            return;
        }
        if (0 == (oMouseEvent.getModifiers() & 0x10) && 0 == (oMouseEvent.getModifiers() & 8) && oMouseEvent.getID() == 500 && oMouseEvent.getClickCount() == 1) {
            this.m_oTree.setSelectionPath(null);
            return;
        }
        if (null == this.m_oTree.getTreeDescriptor()) {
            DCFrameWorkUtil.updateUI(this.m_oTree);
            return;
        }
        int iTreeType = this.m_oTree.getTreeDescriptor().getTreeType();
        if (iTreeType == 1) {
            return;
        }
        if (2 == oMouseEvent.getClickCount()) {
            this.getDeviceSubNode(toExpandedNode);
        }
        double iCheckX = rec.getMinX();
        JCheckBox check = new JCheckBox();
        Dimension d_Check = check.getPreferredSize();
        if ((double)x > iCheckX && (double)x < iCheckX + d_Check.getWidth()) {
            TreeNodeInfo nodeInfo = (TreeNodeInfo)nodeObject.getUserObject();
            if (!nodeInfo.isEnabled()) {
                return;
            }
            int selectedState = nodeInfo.getSelectedState();
            Enumeration<TreeNode> childrens = nodeObject.breadthFirstEnumeration();
            int iViewType = this.m_oTree.getTreeDescriptor().getViewType();
            if (!(iViewType != 2 && iViewType != 4 || selectedState != 2 && selectedState != 1 || nodeInfo.m_iNodeType == 6)) {
                AsnDCGetMultipleBoardsReq asnGetMultipleBoardsReq = new AsnDCGetMultipleBoardsReq();
                childrens = nodeObject.breadthFirstEnumeration();
                while (childrens.hasMoreElements()) {
                    DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)childrens.nextElement();
                    TreeNodeInfo tempNodeInfoObject = (TreeNodeInfo)childTreeNode.getUserObject();
                    if (tempNodeInfoObject.m_iNodeType == 4) {
                        tempNodeInfoObject.setSelected(0);
                    }
                    if (tempNodeInfoObject.m_iNodeType == 4 && childTreeNode.isLeaf()) {
                        AsnDCGetBoardsReq asnDCGetBoardsReq = new AsnDCGetBoardsReq();
                        int deviceId = tempNodeInfoObject.m_oDevInfo.m_iDeviceID;
                        if (0 != childTreeNode.getChildCount()) continue;
                        asnDCGetBoardsReq.iDevId = BigInteger.valueOf(deviceId);
                        asnGetMultipleBoardsReq.oAsnDCGetMultipleBoardsLst.add((Object)asnDCGetBoardsReq);
                        continue;
                    }
                    this.handleAlreadySelectedNode(nodeObject, nodeInfo, selectedState, childrens, asnGetMultipleBoardsReq, tempNodeInfoObject);
                }
            } else {
                this.handleSelection(nodeObject, nodeInfo, selectedState, childrens);
            }
            this.updateTree();
        }
        this.sendNotification(nodeObject);
    }

    private void handleAlreadySelectedNode(DefaultMutableTreeNode nodeObject, TreeNodeInfo nodeInfo, int selectedState, Enumeration childrens, AsnDCGetMultipleBoardsReq asnGetMultipleBoardsReq, TreeNodeInfo tempNodeInfoObject) {
        switch (selectedState) {
            case 0: {
                this.handleAllSelect(nodeObject, nodeInfo, childrens);
                break;
            }
            case 1: 
            case 2: {
                if (!nodeInfo.isEnabled()) {
                    return;
                }
                nodeInfo.setSelected(0);
                tempNodeInfoObject.setSelected(0);
                if (tempNodeInfoObject.m_iNodeType == 5 || tempNodeInfoObject.m_iNodeType == 6 || tempNodeInfoObject.m_iNodeType == 7) {
                    this.handleSelectionPropagation(childrens, asnGetMultipleBoardsReq, tempNodeInfoObject);
                }
                DeviceTreeUtil.propogateSelectionToParentNode(nodeObject, 0);
            }
        }
    }

    private void handleSelectionPropagation(Enumeration childrens, AsnDCGetMultipleBoardsReq asnGetMultipleBoardsReq, TreeNodeInfo tempNodeInfoObject) {
        while (childrens.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childrens.nextElement();
            if (null == node) continue;
            TreeNodeInfo tempNode = (TreeNodeInfo)node.getUserObject();
            if (tempNode.m_iNodeType == 4 && node.isLeaf()) {
                AsnDCGetBoardsReq asnDCGetBoardsReq = new AsnDCGetBoardsReq();
                int deviceId = tempNodeInfoObject.m_oDevInfo.m_iDeviceID;
                if (0 == node.getChildCount()) {
                    asnDCGetBoardsReq.iDevId = BigInteger.valueOf(deviceId);
                    asnGetMultipleBoardsReq.oAsnDCGetMultipleBoardsLst.add((Object)asnDCGetBoardsReq);
                }
            }
            if (tempNode.isEnabled()) {
                tempNode.setSelected(0);
                continue;
            }
            DeviceTreeUtil.propogateSelectionToParentNode(node, 2);
        }
    }

    private void handleSelection(DefaultMutableTreeNode nodeObject, TreeNodeInfo nodeInfo, int selectedState, Enumeration childrens) {
        switch (selectedState) {
            case 0: {
                this.handleAllSelect(nodeObject, nodeInfo, childrens);
                break;
            }
            case 1: 
            case 2: {
                this.handleNoneSelect(nodeObject, nodeInfo, childrens);
                break;
            }
        }
    }

    private void handleNoneSelect(DefaultMutableTreeNode nodeObject, TreeNodeInfo nodeInfo, Enumeration childrens) {
        nodeInfo.setSelected(0);
        while (childrens.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childrens.nextElement();
            TreeNodeInfo tempNode = (TreeNodeInfo)node.getUserObject();
            if (!tempNode.isEnabled() || !tempNode.isVisible()) continue;
            tempNode.setSelected(0);
        }
        DeviceTreeUtil.propogateSelectionToParentNode(nodeObject, 0);
    }

    private void handleAllSelect(DefaultMutableTreeNode nodeObject, TreeNodeInfo nodeInfo, Enumeration childrens) {
        nodeInfo.setSelected(2);
        while (childrens.hasMoreElements()) {
            ((TreeNodeInfo)((DefaultMutableTreeNode)childrens.nextElement()).getUserObject()).setSelected(2);
        }
        DeviceTreeUtil.propogateSelectionToParentNode(nodeObject, 2);
    }

    private void sendNotification(DefaultMutableTreeNode nodeObject) {
        if (null != nodeObject) {
            this.sendNotificationToTreeListeners(nodeObject);
        }
    }

    private void updateTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceTreeListener.this.m_oTree.treeDidChange();
            }
        });
    }

    private void getDeviceSubNode(DefaultMutableTreeNode toExpandedNode) {
        AsnDCGetMultipleBoardsReq asnDCGetMultipleBoardsReq = new AsnDCGetMultipleBoardsReq();
        TreeNodeInfo treeNodeInfo = (TreeNodeInfo)toExpandedNode.getUserObject();
        int iTreeType = this.m_oTree.getTreeDescriptor().getTreeType();
        if ((iTreeType == 2 || iTreeType == 3) && treeNodeInfo.m_iNodeType == 4) {
            int deviceId = treeNodeInfo.m_oDevInfo.m_iDeviceID;
            if (0 == toExpandedNode.getChildCount()) {
                AsnDCGetBoardsReq asnDCGetBoardsReq = new AsnDCGetBoardsReq();
                asnDCGetBoardsReq.iDevId = BigInteger.valueOf(deviceId);
                asnDCGetMultipleBoardsReq.oAsnDCGetMultipleBoardsLst.add((Object)asnDCGetBoardsReq);
            }
        } else {
            return;
        }
        this.m_oTree.updateUI();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_bAlreadyVisited = false;
        if (4 != e.getModifiers()) {
            int y;
            if (0 == (e.getModifiers() & 0x10) && 0 == (e.getModifiers() & 8) && e.getID() == 500 && e.getClickCount() == 1) {
                this.m_oTree.setSelectionPath(null);
                return;
            }
            int x = e.getX();
            int row = this.m_oTree.getRowForLocation(x, y = e.getY());
            Rectangle rec = this.m_oTree.getRowBounds(row);
            if (null == rec) {
                this.m_bAlreadyVisited = true;
            }
            return;
        }
        DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)this.m_oTree.getLastSelectedPathComponent();
        this.sendNotificationToTreeListeners(nodeObject);
    }

    public void sendNotificationToTreeListeners(DefaultMutableTreeNode oNode) {
        TreeNodeInfo oNodeInfo = (TreeNodeInfo)oNode.getUserObject();
        if (null == oNodeInfo) {
            oNode.removeFromParent();
            return;
        }
        DCDeviceTreeNodeSelectionEventObject eventObj = new DCDeviceTreeNodeSelectionEventObject(oNodeInfo, oNodeInfo.m_iNodeType);
        if (null != this.m_oTree) {
            eventObj.setDeviceTree(this.m_oTree);
        }
        this.notifyEvent(eventObj);
    }

    public void addDCEventListener(DCTreeEventListener eventListener) {
        if (null != eventListener && !this.m_oTreeSelectionListeners.contains(eventListener)) {
            this.m_oTreeSelectionListeners.add(eventListener);
        }
    }

    public void notifyEvent(DCEventObject eventObject) {
        int noOfListener = this.m_oTreeSelectionListeners.size();
        for (int index = 0; index < noOfListener; ++index) {
            Object oListenerObj = this.m_oTreeSelectionListeners.get(index);
            if (!(oListenerObj instanceof DCTreeEventListener)) continue;
            this.sendNotificationBasedOnEventType(eventObject, oListenerObj);
        }
    }

    private void sendNotificationBasedOnEventType(DCEventObject eventObject, Object oListenerObj) {
        if (eventObject instanceof DCTreeInitEvent) {
            ((DCTreeEventListener)oListenerObj).onTreeInit(eventObject);
        } else if (eventObject instanceof DCDeviceTreeNodeSelectionEventObject) {
            ((DCTreeEventListener)oListenerObj).onTreeNodeSelection(eventObject);
        }
    }

    public void removeDCEventListener(DCTreeEventListener eventListener) {
        if (null != eventListener) {
            this.m_oTreeSelectionListeners.remove(eventListener);
        }
    }

    public void notifyTreeNodeSelection(DefaultMutableTreeNode oNode) {
        this.sendNotificationToTreeListeners(oNode);
    }

    public void notifyTreeInit() {
        DCTreeInitEvent eventObj = new DCTreeInitEvent(this.m_oTree.getTreeDescriptor());
        this.notifyEvent(eventObj);
    }

    public void sendSelectionNotificationsToListeners() {
        List oSelectedResources = this.m_oTree.getSelectedResources();
        if (null == oSelectedResources) {
            return;
        }
        int iResourceCount = oSelectedResources.size();
        DeviceNodeInfo oDeviceNode = null;
        TreeNodeInfo oNodeInfo = null;
        DCDeviceTreeNodeSelectionEventObject eventObj = null;
        for (int i = 0; i < iResourceCount; ++i) {
            Resource oResource = (Resource)oSelectedResources.get(i);
            oDeviceNode = new DeviceNodeInfo();
            oDeviceNode.m_iDeviceID = oResource.getDeviceID();
            oDeviceNode.m_strDeviceName = oResource.getDeviceName();
            oDeviceNode.m_strDeviceIP = oResource.getDeviceIP();
            oDeviceNode.m_iRoleType = oResource.getRoleType();
            oNodeInfo = new TreeNodeInfo(oDeviceNode);
            oNodeInfo.setSelected(0);
            eventObj = new DCDeviceTreeNodeSelectionEventObject(oNodeInfo, oNodeInfo.m_iNodeType);
            this.notifyEvent(eventObj);
        }
    }

    public void setToNULL() {
        if (null != this.m_oTreeSelectionListeners) {
            this.m_oTreeSelectionListeners.clear();
            this.m_oTreeSelectionListeners = null;
        }
    }
}

