/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree.listener;

import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.tree.TreePath;

public class DeviceTreeKeyListener
extends KeyAdapter {
    private DeviceTree m_oDeviceTree;

    public DeviceTreeKeyListener(DeviceTree oDeviceTree) {
        this.m_oDeviceTree = oDeviceTree;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
            this.fireMouseEventForNode(e);
        }
    }

    private void fireMouseEventForNode(KeyEvent oEvent) {
        int[] arrSelectedRows = this.m_oDeviceTree.getSelectionRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        TreePath oTreePath = this.m_oDeviceTree.getPathForRow(arrSelectedRows[0]);
        Point oPoint = this.m_oDeviceTree.getRowBounds(this.m_oDeviceTree.getRowForPath(oTreePath)).getLocation();
        JCheckBox check = new JCheckBox();
        Dimension d_Check = check.getPreferredSize();
        oPoint.x = oPoint.x + (int)d_Check.getWidth() - 1;
        MouseEvent oMouseEvent = this.getMouseEventForPoint(oPoint);
        this.m_oDeviceTree.getTreeListener().mouseClicked(oMouseEvent);
    }

    private MouseEvent getMouseEventForPoint(Point oPoint) {
        MouseEvent oMouseEvent = new MouseEvent(this.m_oDeviceTree, 501, 0L, 1024, (int)oPoint.getX(), (int)oPoint.getY(), 1, true, 0);
        return oMouseEvent;
    }

    public void dispose() {
        this.m_oDeviceTree = null;
    }
}

