/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree.listener;

import com.huawei.dc.common.components.tree.devicetree.BoardTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.listener.DeviceTreeListener;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.tree.TreeNodeInfo;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BoardTreeListener
extends DeviceTreeListener {
    protected BoardTree m_oBoardTree;

    public BoardTreeListener(BoardTree oTree) {
        super(oTree);
        this.m_oBoardTree = oTree;
    }

    @Override
    public void mouseClicked(MouseEvent oMouseEvent) {
        int y;
        int x = oMouseEvent.getX();
        int iRow = this.m_oBoardTree.getRowForLocation(x, y = oMouseEvent.getY());
        if (0 > iRow) {
            iRow = this.m_oBoardTree.getRowForLocation(x + 20, y);
        }
        if (0 > iRow) {
            return;
        }
        Rectangle rec = this.m_oBoardTree.getRowBounds(iRow);
        DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)this.m_oBoardTree.getLastSelectedPathComponent();
        TreePath rowTreePath = this.m_oBoardTree.getPathForRow(iRow);
        DefaultMutableTreeNode toExpandedNode = (DefaultMutableTreeNode)rowTreePath.getLastPathComponent();
        if (this.m_bAlreadyVisited) {
            if (!(this.m_oBoardTree.getLastSelectedPathComponent() instanceof DefaultMutableTreeNode) || rec == null) {
                this.notify(nodeObject);
            }
            this.getDeviceSubNode(toExpandedNode);
            return;
        }
        if (4 == oMouseEvent.getModifiers()) {
            return;
        }
        if (0 == (oMouseEvent.getModifiers() & 0x10) && 0 == (oMouseEvent.getModifiers() & 8) && oMouseEvent.getID() == 500 && oMouseEvent.getClickCount() == 1) {
            this.m_oBoardTree.setSelectionPath(null);
            return;
        }
        if (2 == oMouseEvent.getClickCount()) {
            this.getDeviceSubNode(toExpandedNode);
        }
        double iCheckX = rec.getMinX();
        JCheckBox check = new JCheckBox();
        Dimension d_Check = check.getPreferredSize();
        if ((double)x > iCheckX && (double)x < iCheckX + d_Check.getWidth()) {
            TreeNodeInfo nodeInfo = (TreeNodeInfo)nodeObject.getUserObject();
            if (!nodeInfo.isEnabled()) {
                return;
            }
            int selectedState = nodeInfo.getSelectedState();
            Enumeration<TreeNode> childrens = nodeObject.breadthFirstEnumeration();
            if ((selectedState == 2 || selectedState == 1) && nodeInfo.m_iNodeType != 6) {
                ArrayList oSelectedDeviceIds = new ArrayList(0);
                childrens = nodeObject.breadthFirstEnumeration();
                while (childrens.hasMoreElements()) {
                    DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)childrens.nextElement();
                    TreeNodeInfo tempNodeInfoObject = (TreeNodeInfo)childTreeNode.getUserObject();
                    if (tempNodeInfoObject.m_iNodeType == 4) {
                        tempNodeInfoObject.setSelected(0);
                    }
                    if (tempNodeInfoObject.m_iNodeType == 4 && childTreeNode.isLeaf()) {
                        this.handleDeviceNode(oSelectedDeviceIds, childTreeNode, tempNodeInfoObject);
                        continue;
                    }
                    this.handleSlot(nodeObject, nodeInfo, selectedState, childrens, oSelectedDeviceIds, tempNodeInfoObject);
                }
                if (oSelectedDeviceIds.size() != 0) {
                    this.getBoardsForDevices(oSelectedDeviceIds);
                }
            } else {
                switch (selectedState) {
                    case 0: {
                        this.handleAllSelection(nodeObject, nodeInfo, childrens);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.handleParticialSelection(nodeObject, nodeInfo, childrens);
                        break;
                    }
                }
            }
            this.m_oBoardTree.updateUI();
            this.m_oBoardTree.revalidate();
        }
        this.notify(nodeObject);
    }

    private void handleDeviceNode(List oSelectedDeviceIds, DefaultMutableTreeNode childTreeNode, TreeNodeInfo tempNodeInfoObject) {
        int deviceId = tempNodeInfoObject.m_oDevInfo.m_iDeviceID;
        if (0 == childTreeNode.getChildCount()) {
            oSelectedDeviceIds.add(deviceId);
        }
    }

    private void handleSlot(DefaultMutableTreeNode nodeObject, TreeNodeInfo nodeInfo, int selectedState, Enumeration childrens, List oSelectedDeviceIds, TreeNodeInfo tempNodeInfoObject) {
        switch (selectedState) {
            case 0: {
                this.handleAllSelection(nodeObject, nodeInfo, childrens);
                break;
            }
            case 1: 
            case 2: {
                if (!nodeInfo.isEnabled()) {
                    return;
                }
                nodeInfo.setSelected(0);
                tempNodeInfoObject.setSelected(0);
                if (tempNodeInfoObject.m_iNodeType == 5 || tempNodeInfoObject.m_iNodeType == 6 || tempNodeInfoObject.m_iNodeType == 7) {
                    while (childrens.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)childrens.nextElement();
                        if (null == node) continue;
                        TreeNodeInfo tempNode = (TreeNodeInfo)node.getUserObject();
                        if (tempNode.m_iNodeType == 4 && node.isLeaf()) {
                            this.handleDeviceNode(oSelectedDeviceIds, node, tempNodeInfoObject);
                        }
                        if (tempNode.isEnabled()) {
                            tempNode.setSelected(0);
                            continue;
                        }
                        DeviceTreeUtil.propogateSelectionToParentNode(node, 2);
                    }
                }
                DeviceTreeUtil.propogateSelectionToParentNode(nodeObject, 0);
            }
        }
    }

    private void handleAllSelection(DefaultMutableTreeNode nodeObject, TreeNodeInfo nodeInfo, Enumeration childrens) {
        nodeInfo.setSelected(2);
        while (childrens.hasMoreElements()) {
            ((TreeNodeInfo)((DefaultMutableTreeNode)childrens.nextElement()).getUserObject()).setSelected(2);
        }
        DeviceTreeUtil.propogateSelectionToParentNode(nodeObject, 2);
    }

    private void handleParticialSelection(DefaultMutableTreeNode nodeObject, TreeNodeInfo nodeInfo, Enumeration childrens) {
        nodeInfo.setSelected(0);
        while (childrens.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childrens.nextElement();
            TreeNodeInfo tempNode = (TreeNodeInfo)node.getUserObject();
            if (!tempNode.isEnabled()) continue;
            tempNode.setSelected(0);
        }
        DeviceTreeUtil.propogateSelectionToParentNode(nodeObject, 0);
    }

    private void notify(DefaultMutableTreeNode nodeObject) {
        if (null != nodeObject) {
            this.sendNotificationToTreeListeners(nodeObject);
        }
    }

    private void getDeviceSubNode(DefaultMutableTreeNode toExpandedNode) {
        ArrayList<Integer> oSelectedDeviceIdList = new ArrayList<Integer>(0);
        TreeNodeInfo treeNodeInfo = (TreeNodeInfo)toExpandedNode.getUserObject();
        if (treeNodeInfo.m_iNodeType == 4) {
            int deviceId = treeNodeInfo.m_oDevInfo.m_iDeviceID;
            if (0 == toExpandedNode.getChildCount()) {
                oSelectedDeviceIdList.add(deviceId);
                this.getBoardsForDevices(oSelectedDeviceIdList);
            }
        }
    }

    private void getBoardsForDevices(List oSelectedDeviceIdList) {
        ArrayList oDeviceListCopy = new ArrayList(10);
        oDeviceListCopy.addAll(oSelectedDeviceIdList);
        this.m_oBoardTree.populateBoardsForDevices(oSelectedDeviceIdList, true);
        int iSelectedResourceCount = oDeviceListCopy.size();
        for (int i = 0; i < iSelectedResourceCount; ++i) {
            Integer oDeviceId = (Integer)oDeviceListCopy.get(i);
            DefaultMutableTreeNode oNode = DeviceTreeUtil.findNodeForDevice(this.m_oBoardTree, oDeviceId);
            if (null == oNode) continue;
            TreeNodeInfo oNodeInfo = (TreeNodeInfo)oNode.getUserObject();
            int iSelectionState = oNodeInfo.getSelectedState();
            DeviceTreeUtil.propogateSelectionToChildNodes(oNode, iSelectionState);
            DeviceTreeUtil.propogateSelectionToParentNode(oNode, iSelectionState);
        }
    }

    @Override
    public void notifyEvent(DCEventObject eventObject) {
        if (eventObject instanceof DCDeviceTreeNodeSelectionEventObject) {
            ((DCDeviceTreeNodeSelectionEventObject)eventObject).setDeviceTree(this.m_oBoardTree);
        }
        if (null != eventObject && eventObject.getSource() instanceof TreeNodeInfo) {
            TreeNodeInfo oNode = (TreeNodeInfo)eventObject.getSource();
            oNode.setBoardTreeNode(true);
        }
        super.notifyEvent(eventObject);
    }
}

