/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfoLst;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTypeTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceVersionTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.model.DeviceTreeNode;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SubmapTreeUtil {
    private AsnDCDeviceInfo m_oAsnDevInfo;
    private boolean m_bIsSubMapFound;
    private DeviceTree m_oDeviceTree;
    private boolean m_bShowDevices;
    private IDeviceInfoManager c_oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();

    public SubmapTreeUtil(DeviceTree oSubmapTree, boolean bShowDevices) {
        this.m_oDeviceTree = oSubmapTree;
        this.m_bShowDevices = bShowDevices;
    }

    public void getSubMapNodeForAsnSubmap(AsnDCDeviceInfo oAsnDevice, AsnDCSubMapInfoLst oAsnDCSubMapInfoLst, SubMapInfo subMapInfo) {
        if (null != oAsnDCSubMapInfoLst) {
            int iSubmapInfoSize = oAsnDCSubMapInfoLst.size();
            SubMapInfo nextMapInfo = subMapInfo;
            AsnDCSubMapInfo asnDCSubMapInfo = null;
            for (int l = 0; l < iSubmapInfoSize; ++l) {
                asnDCSubMapInfo = (AsnDCSubMapInfo)oAsnDCSubMapInfoLst.get(l);
                nextMapInfo = this.fillSubMapInfoList(nextMapInfo, asnDCSubMapInfo);
            }
        }
        this.addDeviceInSubmap(oAsnDevice, subMapInfo);
    }

    public SubMapInfo fillSubMapInfoList(SubMapInfo subMapInfo, AsnDCSubMapInfo asnDCSubMapInfo) {
        SubMapInfo nextSubMapInfo = null;
        if (null != asnDCSubMapInfo && null != subMapInfo) {
            nextSubMapInfo = new SubMapInfo();
            nextSubMapInfo.m_strSubMapID = new String(asnDCSubMapInfo.strSubMapID);
            nextSubMapInfo.m_strSubMapName = new String(asnDCSubMapInfo.strSubMapName);
            subMapInfo.m_SubMapList.add(nextSubMapInfo);
        }
        return nextSubMapInfo;
    }

    public void addDeviceInSubmap(AsnDCDeviceInfo asnDevInfo, SubMapInfo oSubmapInfo) {
        this.m_oAsnDevInfo = asnDevInfo;
        this.findSubmapAndAddDevice(this.m_oDeviceTree.getRoot().getNextNode(), oSubmapInfo);
    }

    private boolean findSubmapAndAddDevice(DefaultMutableTreeNode parentNode, SubMapInfo oSubmapInfo) {
        if (null == parentNode || null == oSubmapInfo) {
            return false;
        }
        Enumeration<TreeNode> treeEnum = parentNode.breadthFirstEnumeration();
        int iChildCount = parentNode.getChildCount();
        if (0 == iChildCount) {
            this.addDeviceSubmapToParent(parentNode, oSubmapInfo);
        }
        DefaultMutableTreeNode treeNode = null;
        while (treeEnum.hasMoreElements()) {
            treeNode = (DefaultMutableTreeNode)treeEnum.nextElement();
            TreeNodeInfo treeCellObject = (TreeNodeInfo)treeNode.getUserObject();
            if (treeCellObject.m_iNodeType != 0 || !treeCellObject.m_oSubMapNodeInfo.m_submapId.equals(oSubmapInfo.m_strSubMapID)) continue;
            if (null == oSubmapInfo.m_SubMapList || 0 == oSubmapInfo.m_SubMapList.size()) {
                if (this.m_bShowDevices) {
                    this.addDeviceToParent(treeNode, oSubmapInfo.m_strSubMapID);
                }
                this.m_bIsSubMapFound = true;
                break;
            }
            this.findSubmapAndAddDevice(treeNode, oSubmapInfo.m_SubMapList.get(0));
            break;
        }
        if (!this.m_bIsSubMapFound) {
            this.addDeviceSubmapToParent(parentNode, oSubmapInfo);
        }
        return true;
    }

    private void addDeviceToParent(DefaultMutableTreeNode parent, String strSubMapId) {
        DeviceTreeBaseDescriptor oTypeDescriptor;
        int iTreeType = this.m_oDeviceTree.getTreeDescriptor().getTreeType();
        DeviceInfo oDeviceInfo = this.c_oDeviceInfoManager.getDevice(this.m_oAsnDevInfo.iDevId.intValue());
        if (null == oDeviceInfo) {
            oDeviceInfo = this.c_oDeviceInfoManager.getDeviceFromAsn(this.m_oAsnDevInfo);
        }
        DeviceInfo[] arrDevices = new DeviceInfo[]{oDeviceInfo};
        if (2 == iTreeType) {
            oTypeDescriptor = (DeviceTypeTreeDescriptor)this.m_oDeviceTree.getTreeDescriptor();
            DeviceInfo[] arrFilteredDeviceList = this.c_oDeviceInfoManager.filterDevicesByType(arrDevices, ((DeviceTypeTreeDescriptor)oTypeDescriptor).getDeviceTypeID(), ((DeviceTypeTreeDescriptor)oTypeDescriptor).getDeviceVersionID());
            if (null == arrFilteredDeviceList || 0 == arrFilteredDeviceList.length) {
                return;
            }
        } else if (3 == iTreeType) {
            oTypeDescriptor = (DeviceVersionTreeDescriptor)this.m_oDeviceTree.getTreeDescriptor();
            DeviceTypeInfo oType = ((DeviceVersionTreeDescriptor)oTypeDescriptor).getDeviceTypeInfo();
            String strSelectedVersion = ((DeviceVersionTreeDescriptor)oTypeDescriptor).getDeviceVersion();
            DeviceInfo[] arrFilteredDeviceList = this.c_oDeviceInfoManager.filterDevicesByVersion(arrDevices, strSelectedVersion, oType);
            if (null == arrFilteredDeviceList || 0 == arrFilteredDeviceList.length) {
                return;
            }
        }
        DeviceNodeInfo devicenNodeInfo = new DeviceNodeInfo();
        devicenNodeInfo.m_iDeviceID = this.m_oAsnDevInfo.iDevId.intValue();
        devicenNodeInfo.m_strDeviceIP = new String(this.m_oAsnDevInfo.strDevIPAddress);
        devicenNodeInfo.m_strDeviceName = new String(this.m_oAsnDevInfo.strDevName);
        devicenNodeInfo.m_iRoleType = this.m_oAsnDevInfo.enRoleType.value;
        devicenNodeInfo.lastOperationStatus = -1;
        devicenNodeInfo.lastOperationType = -1;
        DeviceTreeNode deviceNode = new DeviceTreeNode(new TreeNodeInfo(devicenNodeInfo));
        parent.add(deviceNode);
    }

    private void addDeviceSubmapToParent(DefaultMutableTreeNode parent, SubMapInfo submapInfo) {
        if (null == submapInfo) {
            return;
        }
        DeviceTreeNode submapNode = null;
        SubMapNodeInfo submapNodeInfo = new SubMapNodeInfo();
        submapNodeInfo.m_submapId = submapInfo.m_strSubMapID;
        submapNodeInfo.m_submapName = submapInfo.m_strSubMapName;
        submapNode = new DeviceTreeNode(new TreeNodeInfo(submapNodeInfo));
        parent.add(submapNode);
        if (null == submapInfo.m_SubMapList || 0 == submapInfo.m_SubMapList.size()) {
            if (!this.m_bIsSubMapFound) {
                if (this.m_bShowDevices) {
                    this.addDeviceToParent(submapNode, submapInfo.m_strSubMapID);
                }
                this.m_bIsSubMapFound = true;
            }
        } else {
            this.addDeviceSubmapToParent(submapNode, submapInfo.m_SubMapList.get(0));
        }
    }
}

