/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfoLst;
import com.huawei.dc.common.components.tree.devicetree.BoardTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.SubmapTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.model.SubmapTreeModelManager;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SubmapBoardTree
extends BoardTree {
    private static final long serialVersionUID = 1L;

    public SubmapBoardTree(DeviceTreeBaseDescriptor oDescriptor, IDeviceInfoManager oDeviceInfoMgr, String rootName) {
        super(oDescriptor, oDeviceInfoMgr, rootName);
    }

    @Override
    protected void initializeTreeModelManager(IDeviceInfoManager oDeviceInfoMgr) {
        this.m_oTreeModelManager = SubmapTreeModelManager.getInstance(oDeviceInfoMgr);
    }

    @Override
    public void processEvent(int iEventType, Object oEventSource) {
        if (!(oEventSource instanceof AsnDCDeviceSubmapNtfnInfo)) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oEventSource;
        switch (iEventType) {
            case 0: {
                this.addDeviceToTree(oAsnDeviceInfo);
                break;
            }
            case 1: {
                this.removeDeviceFromTree(oAsnDeviceInfo);
                break;
            }
            case 2: {
                this.modifyDeviceInTree(oAsnDeviceInfo);
                break;
            }
            case 3: {
                this.addSubmapNodeToTree(oAsnDeviceInfo);
                break;
            }
            case 4: {
                this.removeSubmapNodeFromTree(oAsnDeviceInfo);
                break;
            }
            case 5: {
                this.modifySubmapInTree(oAsnDeviceInfo);
                break;
            }
        }
    }

    private void addDeviceToTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
        DefaultMutableTreeNode oDeviceNode = DeviceTreeUtil.findNodeForDevice(this, oDeviceInfo.getDevId());
        if (null != oDeviceNode) {
            return;
        }
        AsnDCSubMapInfo oAsnDCSubMapInfo = oAsnDeviceInfo.oAsnDCSubMapInfo;
        if (null == oAsnDCSubMapInfo) {
            return;
        }
        SubMapInfo subMapInfo = new SubMapInfo();
        subMapInfo.m_strSubMapID = new String(oAsnDCSubMapInfo.strSubMapID);
        subMapInfo.m_strSubMapName = new String(oAsnDCSubMapInfo.strSubMapName);
        AsnDCSubMapInfoLst oAsnDCSubMapInfoLst = oAsnDCSubMapInfo.oAsnDCSubMapInfoLst;
        SubmapTreeUtil oUtil = new SubmapTreeUtil(this, true);
        oUtil.getSubMapNodeForAsnSubmap(oAsnDeviceInfo.oDeviceInfo, oAsnDCSubMapInfoLst, subMapInfo);
    }

    private void removeDeviceFromTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DefaultMutableTreeNode oDeviceNode;
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDevice(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue());
        if (null == oDeviceInfo) {
            oDeviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
        }
        if (null == (oDeviceNode = DeviceTreeUtil.findNodeForDevice(this, oDeviceInfo.getDevId()))) {
            return;
        }
        oDeviceNode.removeFromParent();
    }

    private void modifyDeviceInTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
        DefaultMutableTreeNode oDeviceNode = DeviceTreeUtil.findNodeForDevice(this, oDeviceInfo.getDevId());
        if (null == oDeviceNode) {
            return;
        }
        if (null != oAsnDeviceInfo.oAsnDCSubMapInfo) {
            TreePath oPath = this.getSelectionPath();
            if (oDeviceNode.equals(oPath.getLastPathComponent())) {
                this.setSelectionRow(0);
            }
            oDeviceNode.removeFromParent();
            AsnDCSubMapInfo oMovedSubmapInfo = oAsnDeviceInfo.oAsnDCSubMapInfo;
            DefaultMutableTreeNode oNewParentSubmapNode = DeviceTreeUtil.findNodeForSubmap(this, new String(oMovedSubmapInfo.strParentSubMapID));
            if (null != oNewParentSubmapNode) {
                oNewParentSubmapNode.add(oDeviceNode);
            }
            return;
        }
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)oDeviceNode.getUserObject();
        DeviceNodeInfo oTreeNodeDeviceInfo = oTreeNodeInfo.m_oDevInfo;
        if (null == oTreeNodeDeviceInfo) {
            oTreeNodeInfo.m_oDevInfo = oTreeNodeDeviceInfo = new DeviceNodeInfo();
        }
        if (null != oDeviceInfo.getDevIPAddress()) {
            oTreeNodeDeviceInfo.m_strDeviceIP = oDeviceInfo.getDevIPAddress();
        }
        if (null != oDeviceInfo.getDevName()) {
            oTreeNodeDeviceInfo.m_strDeviceName = oDeviceInfo.getDevName();
        }
    }

    private void removeSubmapNodeFromTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DefaultMutableTreeNode oSubmapNode = DeviceTreeUtil.findNodeForSubmap(this, new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strSubMapID));
        if (null != oSubmapNode) {
            TreePath oPath = this.getSelectionPath();
            if (oSubmapNode.equals(oPath.getLastPathComponent())) {
                this.setSelectionRow(0);
            }
            oSubmapNode.removeFromParent();
        }
    }

    private void addSubmapNodeToTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DefaultMutableTreeNode oParentNode = DeviceTreeUtil.findNodeForSubmap(this, new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strParentSubMapID));
        if (null != oParentNode) {
            SubMapNodeInfo submapNodeInfo = new SubMapNodeInfo();
            submapNodeInfo.m_submapId = new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strSubMapID);
            submapNodeInfo.m_submapName = new String(oAsnDeviceInfo.oAsnDCSubMapInfo.strSubMapName);
            DefaultMutableTreeNode newSubmapNode = new DefaultMutableTreeNode(new TreeNodeInfo(submapNodeInfo));
            oParentNode.add(newSubmapNode);
        }
    }

    private void modifySubmapInTree(AsnDCDeviceSubmapNtfnInfo oAsnNotificationInfo) {
        AsnDCSubMapInfo oAsnDCSubMapInfo = oAsnNotificationInfo.oAsnDCSubMapInfo;
        String strSubmapId = new String(oAsnDCSubMapInfo.strSubMapID);
        DefaultMutableTreeNode oModifiedNode = DeviceTreeUtil.findNodeForSubmap(this, strSubmapId);
        if (null == oModifiedNode) {
            return;
        }
        TreeNodeInfo oSubmapNodeInfo = (TreeNodeInfo)oModifiedNode.getUserObject();
        if (null != oAsnDCSubMapInfo.strSubMapName && 0 < oAsnDCSubMapInfo.strSubMapName.length) {
            oSubmapNodeInfo.m_oSubMapNodeInfo.m_submapName = new String(oAsnDCSubMapInfo.strSubMapName);
            oSubmapNodeInfo.m_nodeName = new String(oAsnDCSubMapInfo.strSubMapName);
        }
        if (null != oAsnDCSubMapInfo.strParentSubMapID) {
            TreePath oPath = this.getSelectionPath();
            if (oModifiedNode.equals(oPath.getLastPathComponent())) {
                this.setSelectionRow(0);
            }
            oModifiedNode.removeFromParent();
            DefaultMutableTreeNode oNewParentSubMap = DeviceTreeUtil.findNodeForSubmap(this, new String(oAsnDCSubMapInfo.strParentSubMapID));
            if (null != oNewParentSubMap) {
                oNewParentSubMap.add(oModifiedNode);
            }
        }
    }
}

