/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.components.tree.devicetree;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubMapInfo;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.SubmapDeviceTree;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTypeTreeDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceVersionTreeDescriptor;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.OLTDevVerInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class OLTSubmapDeviceTree
extends SubmapDeviceTree {
    public OLTSubmapDeviceTree(DeviceTreeBaseDescriptor descriptor, IDeviceInfoManager deviceInfoMgr, String rootName) {
        super(descriptor, deviceInfoMgr, rootName);
    }

    @Override
    public void processEvent(int iEventType, Object oEventSource) {
        if (!(oEventSource instanceof AsnDCDeviceSubmapNtfnInfo)) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oEventSource;
        switch (iEventType) {
            case 0: {
                this.addDeviceToTree(oAsnDeviceInfo);
                break;
            }
            case 1: {
                this.removeDeviceFromTree(oAsnDeviceInfo);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.modifySubmapInTree(oAsnDeviceInfo);
                this.modifySubmapTable(oAsnDeviceInfo, 2);
                break;
            }
            case 4: {
                this.removeSubmapNodeFromTree(oAsnDeviceInfo);
                this.modifySubmapTable(oAsnDeviceInfo, 3);
                break;
            }
        }
    }

    private void modifySubmapTable(AsnDCDeviceSubmapNtfnInfo asnDeviceInfo, int cmd) {
        AsnDCSubMapInfo oAsnDCSubMapInfo = asnDeviceInfo.oAsnDCSubMapInfo;
        SubMapInfo submapInfo = new SubMapInfo();
        submapInfo.m_strSubMapID = new String(oAsnDCSubMapInfo.strSubMapID);
        submapInfo.m_strSubMapName = new String(oAsnDCSubMapInfo.strSubMapName);
        DCDeviceTreeNodeSelectionEventObject eventObj = new DCDeviceTreeNodeSelectionEventObject(submapInfo);
        eventObj.setEventType(cmd);
        this.m_oTreeListener.notifyEvent(eventObj);
    }

    private void addDeviceToTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DeviceInfo deviceInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
        int devId = deviceInfo.getDevId();
        DeviceInfo[] devInfoLst = new DeviceInfo[]{deviceInfo};
        OLTDevVerInfo[] oltVerInfoLst = DeviceTreeUtil.getOLTVerInfoLst(devInfoLst);
        SubMapInfo tmpSubmapInfo = this.m_oDeviceInfoManager.getSubMapInfoByDevID(this.m_oDeviceInfoManager.getMxuSubMapInfo(), devId);
        String parentSubmapId = tmpSubmapInfo.m_strSubMapID;
        String parentSubmapName = tmpSubmapInfo.m_strSubMapName;
        DefaultMutableTreeNode verInfoNode = null;
        DefaultMutableTreeNode parentNode = null;
        TreeNodeInfo oSubMapNodeInfo = null;
        DeviceTypeInfo devTypeInfo = null;
        int devTypeId = -1;
        int devTypeVerId = -1;
        String devVer = deviceInfo.getDevVersion().getDevVersion();
        SubMapInfo oMxuSubMapInfo = DeviceInfoManagerImpl.getInstance().getMxuSubMapInfo();
        for (int i = 0; i < oltVerInfoLst.length; ++i) {
            ArrayList neIDList = oltVerInfoLst[i].getDevIDLst();
            for (int j = 0; j < neIDList.size(); ++j) {
                int neID = (Integer)neIDList.get(j);
                SubMapInfo oParentSubMapInfo = DeviceInfoManagerImpl.getInstance().getSubMapInfoByDevID(oMxuSubMapInfo, neID);
                verInfoNode = DeviceTreeUtil.findNodeForOLTDevVer(this, oParentSubMapInfo, oltVerInfoLst[i].getStrDevVer());
                if (null == verInfoNode) {
                    devTypeId = deviceInfo.getDeviceTypeInfo().getDevTypeID();
                    devTypeVerId = deviceInfo.getDevTypeVersionId();
                    if (this.m_oTreeDescriptor instanceof DeviceTypeTreeDescriptor) {
                        DeviceTypeTreeDescriptor treeDescriptor = (DeviceTypeTreeDescriptor)this.m_oTreeDescriptor;
                        if (devTypeId != treeDescriptor.getDeviceTypeID() || devTypeVerId != treeDescriptor.getDeviceVersionID()) {
                            continue;
                        }
                    } else if (this.m_oTreeDescriptor instanceof DeviceVersionTreeDescriptor) {
                        String devVersion = deviceInfo.getDevVersion().getDevVersion();
                        DeviceVersionTreeDescriptor treeDescriptor = (DeviceVersionTreeDescriptor)this.m_oTreeDescriptor;
                        if (devTypeId != treeDescriptor.getDeviceTypeInfo().getDevTypeID() || devTypeVerId != treeDescriptor.getDeviceTypeInfo().getDevTypeVersionId() || !devVersion.equalsIgnoreCase(treeDescriptor.getDeviceVersion())) continue;
                    }
                    devTypeInfo = this.m_oDeviceInfoManager.getDeviceTypeInfo(devTypeId, devTypeVerId);
                    oSubMapNodeInfo = new TreeNodeInfo(devVer, devTypeInfo, parentSubmapId, parentSubmapName);
                    verInfoNode = new DefaultMutableTreeNode(oSubMapNodeInfo);
                    parentNode = DeviceTreeUtil.findNodeForSubmap(this, parentSubmapId);
                    if (null == parentNode) {
                        parentNode = this.constructParentSubmapNode(parentSubmapId, parentSubmapName);
                        this.getRoot().add(parentNode);
                        TreeNodeInfo root = (TreeNodeInfo)this.getRoot().getUserObject();
                        if (null != root && !root.isNodeSelectable()) {
                            root.setNodeSelectable(true);
                        }
                    }
                    if (null == (parentNode = DeviceTreeUtil.findNodeForSubmap(this, parentSubmapId))) continue;
                    parentNode.add(verInfoNode);
                    TreeNodeInfo oParentInfo = (TreeNodeInfo)parentNode.getUserObject();
                    if (null == oParentInfo || oParentInfo.isNodeSelectable()) continue;
                    oParentInfo.setNodeSelectable(true);
                    continue;
                }
                TreeNodeInfo versinNode = (TreeNodeInfo)verInfoNode.getUserObject();
                if (versinNode.getSelectedState() == 2) continue;
                DCDeviceTreeNodeSelectionEventObject eventObj = new DCDeviceTreeNodeSelectionEventObject(oltVerInfoLst[i]);
                eventObj.setEventType(0);
                this.m_oTreeListener.notifyEvent(eventObj);
            }
        }
    }

    private void removeDeviceFromTree(AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo) {
        DeviceInfo devInfo = this.m_oDeviceInfoManager.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
        int devid = devInfo.getDevId();
        DeviceInfo deviceInfo = this.m_oDeviceInfoManager.getDevice(devid);
        SubMapInfo oSubMapInfo = this.m_oDeviceInfoManager.getSubMapInfoByDevID(this.m_oDeviceInfoManager.getMxuSubMapInfo(), devid);
        if (null == deviceInfo || null == oSubMapInfo) {
            return;
        }
        OLTDevVerInfo oltDevVerInfo = new OLTDevVerInfo();
        oltDevVerInfo.setIDevTypeID(deviceInfo.getDeviceTypeInfo().getDevTypeID());
        oltDevVerInfo.setIDevVerID(deviceInfo.getDevTypeVersionId());
        oltDevVerInfo.setStrDevVer(deviceInfo.getDevVersion().getDevVersion());
        oltDevVerInfo.setStrParentSubMapID(oSubMapInfo.m_strSubMapID);
        oltDevVerInfo.setStrParentSubMapName(oSubMapInfo.m_strSubMapName);
        DCDeviceTreeNodeSelectionEventObject eventObj = new DCDeviceTreeNodeSelectionEventObject(oltDevVerInfo);
        eventObj.setEventType(1);
        this.m_oTreeListener.notifyEvent(eventObj);
        this.DeleteNodeFromTree(devInfo, oltDevVerInfo);
    }

    private void DeleteNodeFromTree(DeviceInfo devInfo, OLTDevVerInfo oltDevVerInfo) {
        SubMapInfo oMxuSubMapInfo = DeviceInfoManagerImpl.getInstance().getMxuSubMapInfo();
        for (int i = 0; i < oltDevVerInfo.getDevIDLst().size(); ++i) {
            int neID = (Integer)oltDevVerInfo.getDevIDLst().get(i);
            SubMapInfo oSubMapInfo = DeviceInfoManagerImpl.getInstance().getSubMapInfoByDevID(oMxuSubMapInfo, neID);
            DefaultMutableTreeNode verInfoNode = DeviceTreeUtil.findNodeForOLTDevVer(this, oSubMapInfo, oltDevVerInfo.getStrDevVer());
            if (null == verInfoNode) continue;
            int devId = devInfo.getDevId();
            this.checkAndRemoveNullNode(verInfoNode, devId);
        }
    }

    private void checkAndRemoveNullNode(DefaultMutableTreeNode treeNode, int devId) {
        DefaultMutableTreeNode parentNode;
        TreeNodeInfo treeNodeInfo = (TreeNodeInfo)treeNode.getUserObject();
        DeviceInfo[] deviceInfos = DeviceTreeUtil.getDeviceListForTreeNode(treeNodeInfo);
        boolean isExistDev = this.checkIfExistOltDeviceUnderNode(deviceInfos, devId);
        if (!isExistDev && null != (parentNode = (DefaultMutableTreeNode)treeNode.getParent())) {
            parentNode.remove(treeNode);
            this.checkAndRemoveNullNode(parentNode, devId);
        }
    }

    private boolean checkIfExistOltDeviceUnderNode(DeviceInfo[] deviceInfos, int devId) {
        boolean isExistDev;
        block2: {
            DeviceInfo devInfo;
            int devTypeVerId;
            int devTypeId;
            block3: {
                isExistDev = false;
                devTypeId = -1;
                devTypeVerId = -1;
                devInfo = null;
                if (!(this.m_oTreeDescriptor instanceof DeviceTypeTreeDescriptor)) break block3;
                DeviceTypeTreeDescriptor treeDescriptor = (DeviceTypeTreeDescriptor)this.m_oTreeDescriptor;
                devTypeId = treeDescriptor.getDeviceTypeID();
                devTypeVerId = treeDescriptor.getDeviceVersionID();
                for (int i = 0; i < deviceInfos.length; ++i) {
                    devInfo = deviceInfos[i];
                    if (null == devInfo || devId == devInfo.getDevId() || devTypeId != devInfo.getDeviceTypeInfo().getDevTypeID() || devTypeVerId != devInfo.getDeviceTypeInfo().getDevTypeVersionId()) continue;
                    isExistDev = true;
                    break block2;
                }
                break block2;
            }
            if (!(this.m_oTreeDescriptor instanceof DeviceVersionTreeDescriptor)) break block2;
            DeviceVersionTreeDescriptor treeDescriptor = (DeviceVersionTreeDescriptor)this.m_oTreeDescriptor;
            devTypeId = treeDescriptor.getDeviceTypeInfo().getDevTypeID();
            devTypeVerId = treeDescriptor.getDeviceTypeInfo().getDevTypeVersionId();
            String devVersion = treeDescriptor.getDeviceVersion();
            for (int i = 0; i < deviceInfos.length; ++i) {
                devInfo = deviceInfos[i];
                if (null == devInfo || devId == devInfo.getDevId() || devTypeId != devInfo.getDeviceTypeInfo().getDevTypeID() || devTypeVerId != devInfo.getDeviceTypeInfo().getDevTypeVersionId() || !devVersion.equalsIgnoreCase(devInfo.getDevVersion().getDevVersion())) continue;
                isExistDev = true;
                break;
            }
        }
        return isExistDev;
    }

    private DefaultMutableTreeNode constructParentSubmapNode(String submapID, String submapName) {
        String curSubmapID = submapID;
        String curSubmapName = submapName;
        DefaultMutableTreeNode parentNode = null;
        parentNode = DeviceTreeUtil.findNodeForSubmap(this, submapID);
        if (null == parentNode) {
            SubMapNodeInfo submapNodeInfo = new SubMapNodeInfo();
            submapNodeInfo.m_submapId = curSubmapID;
            submapNodeInfo.m_submapName = curSubmapName;
            parentNode = new DefaultMutableTreeNode(new TreeNodeInfo(submapNodeInfo));
        }
        SubMapInfo subInfo = this.m_oDeviceInfoManager.getSubmapForID(curSubmapID, this.m_oDeviceInfoManager.getMxuSubMapInfo());
        SubMapInfo parentSubmapInfo = this.m_oDeviceInfoManager.getParentSubmap(this.m_oDeviceInfoManager.getMxuSubMapInfo(), subInfo);
        if (null == parentSubmapInfo) {
            return parentNode;
        }
        String pSubmapID = parentSubmapInfo.m_strSubMapID;
        String pSubmapName = parentSubmapInfo.m_strSubMapName;
        if ("HWMAP_PHY_SUBMAP".equals(curSubmapID)) {
            return parentNode;
        }
        DefaultMutableTreeNode pNode = this.constructParentSubmapNode(pSubmapID, pSubmapName);
        if (null != pNode) {
            pNode.add(parentNode);
        }
        return pNode;
    }
}

